/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.builder.model.BaseArtifact;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.android.CompileOptionsModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.model.java.JavaModel;
import com.android.tools.idea.gradle.facet.JavaGradleFacet;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.testing.TestArtifactSearchScopes;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModifier;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class AndroidGradleJavaProjectModelModifier
extends JavaProjectModelModifier {
    @NotNull
    private Project myProject;
    private static Map<String, String> externalLibraryVersions = ImmutableMap.of((Object)"net.jcip:jcip-annotations", (Object)"1.0", (Object)"org.jetbrains:annotations-java5", (Object)"15.0", (Object)"org.jetbrains:annotations", (Object)"15.0", (Object)"junit:junit", (Object)"4.12", (Object)"org.testng:testng", (Object)"6.9.6");

    public AndroidGradleJavaProjectModelModifier(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "<init>"));
        }
        this.myProject = project;
    }

    @Nullable
    public Promise<Void> addModuleDependency(@NotNull Module from, @NotNull Module to, @NotNull DependencyScope scope) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "addModuleDependency"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "addModuleDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "addModuleDependency"));
        }
        VirtualFile openedFile = FileEditorManagerEx.getInstanceEx((Project)from.getProject()).getCurrentFile();
        String gradlePath = GradleUtil.getGradlePath(to);
        final GradleBuildModel buildModel = GradleBuildModel.get(from);
        if (buildModel != null && gradlePath != null) {
            DependenciesModel dependencies = buildModel.dependencies();
            String configurationName = AndroidGradleJavaProjectModelModifier.getConfigurationName(from, scope, openedFile);
            dependencies.addModule(configurationName, gradlePath, null);
            new WriteCommandAction(this.myProject, "Add Gradle Module Dependency", new PsiFile[0]){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier$1", "run"));
                    }
                    buildModel.applyChanges();
                    AndroidGradleJavaProjectModelModifier.registerUndoAction(AndroidGradleJavaProjectModelModifier.this.myProject);
                }
            }.execute();
            return AndroidGradleJavaProjectModelModifier.requestProjectSync(this.myProject);
        }
        if (buildModel == null ^ gradlePath == null) {
            return Promise.REJECTED;
        }
        return null;
    }

    @Nullable
    public Promise<Void> addExternalLibraryDependency(@NotNull Collection<Module> modules, @NotNull ExternalLibraryDescriptor descriptor, @NotNull DependencyScope scope) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "addExternalLibraryDependency"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "addExternalLibraryDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "addExternalLibraryDependency"));
        }
        ArtifactDependencySpec dependencySpec = new ArtifactDependencySpec(descriptor.getLibraryArtifactId(), descriptor.getLibraryGroupId(), AndroidGradleJavaProjectModelModifier.selectVersion(descriptor));
        return this.addExternalLibraryDependency(modules, dependencySpec, scope);
    }

    @Nullable
    public Promise<Void> addLibraryDependency(@NotNull Module from, @NotNull Library library, @NotNull DependencyScope scope) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "addLibraryDependency"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "addLibraryDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "addLibraryDependency"));
        }
        if (!Projects.isBuildWithGradle(from)) {
            return null;
        }
        ArtifactDependencySpec dependencySpec = this.findNewExternalDependency(library);
        if (dependencySpec == null) {
            return Promise.REJECTED;
        }
        return this.addExternalLibraryDependency((Collection<Module>)ImmutableList.of((Object)from), dependencySpec, scope);
    }

    @Nullable
    private Promise<Void> addExternalLibraryDependency(@NotNull Collection<Module> modules, @NotNull ArtifactDependencySpec dependencySpec, @NotNull DependencyScope scope) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "addExternalLibraryDependency"));
        }
        if (dependencySpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencySpec", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "addExternalLibraryDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "addExternalLibraryDependency"));
        }
        Module firstModule = (Module)Iterables.getFirst(modules, null);
        if (firstModule == null) {
            return null;
        }
        VirtualFile openedFile = FileEditorManagerEx.getInstanceEx((Project)firstModule.getProject()).getCurrentFile();
        final ArrayList buildModelsToUpdate = Lists.newArrayList();
        for (Module module : modules) {
            GradleBuildModel buildModel = GradleBuildModel.get(module);
            if (buildModel == null) {
                return null;
            }
            String configurationName = AndroidGradleJavaProjectModelModifier.getConfigurationName(module, scope, openedFile);
            DependenciesModel dependencies = buildModel.dependencies();
            dependencies.addArtifact(configurationName, dependencySpec);
            buildModelsToUpdate.add(buildModel);
        }
        new WriteCommandAction(this.myProject, "Add Gradle Library Dependency", new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier$2", "run"));
                }
                for (GradleBuildModel buildModel : buildModelsToUpdate) {
                    buildModel.applyChanges();
                }
                AndroidGradleJavaProjectModelModifier.registerUndoAction(AndroidGradleJavaProjectModelModifier.this.myProject);
            }
        }.execute();
        return AndroidGradleJavaProjectModelModifier.requestProjectSync(this.myProject);
    }

    @Nullable
    public Promise<Void> changeLanguageLevel(@NotNull Module module, @NotNull LanguageLevel level) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "changeLanguageLevel"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "changeLanguageLevel"));
        }
        if (!Projects.isBuildWithGradle(module)) {
            return null;
        }
        final GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (buildModel == null) {
            return null;
        }
        if (Projects.getAndroidModel(module) != null) {
            CompileOptionsModel compileOptions = buildModel.android().compileOptions();
            compileOptions.setSourceCompatibility(level);
            compileOptions.setTargetCompatibility(level);
        } else {
            JavaGradleFacet javaGradleFacet = JavaGradleFacet.getInstance(module);
            if (javaGradleFacet == null || javaGradleFacet.getJavaModel() == null) {
                return null;
            }
            JavaModel javaModel = buildModel.java();
            javaModel.setSourceCompatibility(level);
            javaModel.setTargetCompatibility(level);
        }
        new WriteCommandAction(this.myProject, "Change Gradle Language Level", new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier$3", "run"));
                }
                buildModel.applyChanges();
                AndroidGradleJavaProjectModelModifier.registerUndoAction(AndroidGradleJavaProjectModelModifier.this.myProject);
            }
        }.execute();
        return AndroidGradleJavaProjectModelModifier.requestProjectSync(this.myProject);
    }

    @NotNull
    private static String getConfigurationName(@NotNull Module module, @NotNull DependencyScope scope, @Nullable VirtualFile openedFile) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "getConfigurationName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "getConfigurationName"));
        }
        if (!scope.isForProductionCompile()) {
            AndroidGradleModel androidModel;
            if (GradleExperimentalSettings.getInstance().LOAD_ALL_TEST_ARTIFACTS) {
                TestArtifactSearchScopes testScopes = TestArtifactSearchScopes.get(module);
                if (testScopes != null && openedFile != null) {
                    if (testScopes.isAndroidTestSource(openedFile)) {
                        if ("androidTestCompile" == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "getConfigurationName"));
                        }
                        return "androidTestCompile";
                    }
                    if ("testCompile" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "getConfigurationName"));
                    }
                    return "testCompile";
                }
                if ("compile" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "getConfigurationName"));
                }
                return "compile";
            }
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            if (androidFacet != null && (androidModel = AndroidGradleModel.get(androidFacet)) != null && "_android_test_".equals(androidModel.getSelectedTestArtifactName())) {
                if ("androidTestCompile" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "getConfigurationName"));
                }
                return "androidTestCompile";
            }
            if ("testCompile" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "getConfigurationName"));
            }
            return "testCompile";
        }
        if ("compile" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "getConfigurationName"));
        }
        return "compile";
    }

    @Nullable
    private static String selectVersion(@NotNull ExternalLibraryDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "selectVersion"));
        }
        String groupAndId = descriptor.getLibraryGroupId() + ":" + descriptor.getLibraryArtifactId();
        return externalLibraryVersions.get(groupAndId);
    }

    private static Promise<Void> requestProjectSync(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "requestProjectSync"));
        }
        final AsyncPromise promise = new AsyncPromise();
        GradleProjectImporter.getInstance().requestProjectSync(project, false, new GradleSyncListener.Adapter(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier$4", "syncSucceeded"));
                }
                promise.setResult(null);
            }

            @Override
            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier$4", "syncFailed"));
                }
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier$4", "syncFailed"));
                }
                promise.setError(errorMessage);
            }
        });
        return promise;
    }

    private static void registerUndoAction(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "registerUndoAction"));
        }
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

            public void undo() throws UnexpectedUndoException {
                AndroidGradleJavaProjectModelModifier.requestProjectSync(project);
            }

            public void redo() throws UnexpectedUndoException {
                AndroidGradleJavaProjectModelModifier.requestProjectSync(project);
            }
        });
    }

    @Nullable
    private ArtifactDependencySpec findNewExternalDependency(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "findNewExternalDependency"));
        }
        if (library.getName() == null) {
            return null;
        }
        ArtifactDependencySpec result = null;
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AndroidGradleModel androidGradleModel = AndroidGradleModel.get(module);
            if (androidGradleModel == null || LibraryUtil.findLibrary((Module)module, (String)library.getName()) == null) continue;
            result = AndroidGradleJavaProjectModelModifier.findNewExternalDependency(library, androidGradleModel);
            break;
        }
        if (result == null) {
            result = AndroidGradleJavaProjectModelModifier.findNewExternalDependencyByExaminingPath(library);
        }
        return result;
    }

    @Nullable
    private static ArtifactDependencySpec findNewExternalDependency(@NotNull Library library, @NotNull AndroidGradleModel androidModel) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "findNewExternalDependency"));
        }
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "findNewExternalDependency"));
        }
        BaseArtifact testArtifact = androidModel.findSelectedTestArtifactInSelectedVariant();
        com.android.builder.model.Library matchedLibrary = null;
        if (testArtifact != null) {
            matchedLibrary = AndroidGradleJavaProjectModelModifier.findMatchedLibrary(library, testArtifact);
        }
        if (matchedLibrary == null) {
            Variant selectedVariant = androidModel.getSelectedVariant();
            matchedLibrary = AndroidGradleJavaProjectModelModifier.findMatchedLibrary(library, (BaseArtifact)selectedVariant.getMainArtifact());
        }
        if (matchedLibrary == null) {
            return null;
        }
        MavenCoordinates coordinates = matchedLibrary.getResolvedCoordinates();
        if (coordinates == null) {
            return null;
        }
        return new ArtifactDependencySpec(coordinates.getArtifactId(), coordinates.getGroupId(), coordinates.getVersion());
    }

    @Nullable
    private static com.android.builder.model.Library findMatchedLibrary(@NotNull Library library, @NotNull BaseArtifact artifact) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "findMatchedLibrary"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "findMatchedLibrary"));
        }
        for (JavaLibrary gradleLibrary : artifact.getDependencies().getJavaLibraries()) {
            String libraryName = FileUtil.getNameWithoutExtension((File)gradleLibrary.getJarFile());
            if (!libraryName.equals(library.getName())) continue;
            return gradleLibrary;
        }
        return null;
    }

    @Nullable
    private static ArtifactDependencySpec findNewExternalDependencyByExaminingPath(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier", "findNewExternalDependencyByExaminingPath"));
        }
        VirtualFile[] files = library.getFiles(OrderRootType.CLASSES);
        if (files.length == 0) {
            return null;
        }
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)files[0]);
        String libraryName = library.getName();
        if (libraryName == null) {
            return null;
        }
        List pathSegments = FileUtil.splitPath((String)file.getPath());
        for (int i = 1; i < pathSegments.size() - 2; ++i) {
            if (!libraryName.startsWith((String)pathSegments.get(i))) continue;
            String groupId = (String)pathSegments.get(i - 1);
            String artifactId = (String)pathSegments.get(i);
            String version = (String)pathSegments.get(i + 1);
            if (!libraryName.endsWith(version)) continue;
            return new ArtifactDependencySpec(artifactId, groupId, version);
        }
        return null;
    }
}

