/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.java;

import com.android.tools.idea.gradle.JavaModel;
import com.android.tools.idea.gradle.JavaProject;
import com.android.tools.idea.gradle.customizer.AbstractDependenciesModuleCustomizer;
import com.android.tools.idea.gradle.customizer.dependency.DependencySetupErrors;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.JavaGradleFacet;
import com.android.tools.idea.gradle.facet.JavaGradleFacetConfiguration;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.model.java.JavaModuleDependency;
import com.android.tools.idea.gradle.util.Facets;
import com.google.common.collect.Lists;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependenciesModuleCustomizer
extends AbstractDependenciesModuleCustomizer<JavaProject> {
    private static final DependencyScope DEFAULT_DEPENDENCY_SCOPE = DependencyScope.COMPILE;

    @Override
    protected void setUpDependencies(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull JavaProject javaProject) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "setUpDependencies"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "setUpDependencies"));
        }
        if (javaProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaProject", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "setUpDependencies"));
        }
        ModifiableRootModel moduleModel = modelsProvider.getModifiableRootModel(module);
        ArrayList unresolved = Lists.newArrayList();
        for (JavaModuleDependency javaModuleDependency : javaProject.getJavaModuleDependencies()) {
            this.updateDependency(module, modelsProvider, javaModuleDependency);
        }
        for (JarLibraryDependency jarLibraryDependency : javaProject.getJarLibraryDependencies()) {
            if (jarLibraryDependency.isResolved()) {
                this.updateDependency(module, modelsProvider, jarLibraryDependency);
                continue;
            }
            unresolved.add(jarLibraryDependency.getName());
        }
        ProjectSyncMessages messages = ProjectSyncMessages.getInstance(moduleModel.getProject());
        messages.reportUnresolvedDependencies(unresolved, module);
        JavaGradleFacet javaGradleFacet = DependenciesModuleCustomizer.setAndGetJavaGradleFacet(module, modelsProvider);
        File buildFolderPath = javaProject.getBuildFolderPath();
        AndroidGradleFacet gradleFacet = Facets.findFacet(module, modelsProvider, AndroidGradleFacet.TYPE_ID);
        if (gradleFacet != null) {
            JavaModel javaModel = new JavaModel(unresolved, buildFolderPath);
            javaGradleFacet.setJavaModel(javaModel);
        }
        JavaGradleFacetConfiguration facetProperties = (JavaGradleFacetConfiguration)javaGradleFacet.getConfiguration();
        facetProperties.BUILD_FOLDER_PATH = buildFolderPath != null ? FileUtil.toSystemIndependentName((String)buildFolderPath.getPath()) : "";
        facetProperties.BUILDABLE = javaProject.isBuildable();
    }

    private void updateDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull JavaModuleDependency dependency) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "updateDependency"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "updateDependency"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "updateDependency"));
        }
        DependencySetupErrors setupErrors = this.getSetupErrors(module.getProject());
        String moduleName = dependency.getModuleName();
        Module found = null;
        for (Module m : modelsProvider.getModules()) {
            if (!moduleName.equals(m.getName())) continue;
            found = m;
        }
        ModifiableRootModel moduleModel = modelsProvider.getModifiableRootModel(module);
        if (found != null) {
            AndroidFacet androidFacet = Facets.findFacet(found, modelsProvider, AndroidFacet.ID);
            if (androidFacet == null) {
                ModuleOrderEntry orderEntry = moduleModel.addModuleOrderEntry(found);
                orderEntry.setExported(true);
            } else {
                setupErrors.addInvalidModuleDependency(moduleModel.getModule(), found.getName(), "Java modules cannot depend on Android modules");
            }
            return;
        }
        setupErrors.addMissingModule(moduleName, module.getName(), null);
    }

    private void updateDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull JarLibraryDependency dependency) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "updateDependency"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "updateDependency"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "updateDependency"));
        }
        DependencyScope scope = DependenciesModuleCustomizer.parseScope(dependency.getScope());
        File binaryPath = dependency.getBinaryPath();
        if (binaryPath == null) {
            DependencySetupErrors setupErrors = this.getSetupErrors(module.getProject());
            setupErrors.addMissingBinaryPath(module.getName());
            return;
        }
        String path = binaryPath.getPath();
        String name = binaryPath.isFile() ? FileUtil.getNameWithoutExtension((File)binaryPath) : FileUtil.sanitizeFileName((String)path);
        DependenciesModuleCustomizer.setUpLibraryDependency(module, modelsProvider, name, scope, Collections.singletonList(path), DependenciesModuleCustomizer.asPaths(dependency.getSourcePath()), DependenciesModuleCustomizer.asPaths(dependency.getJavadocPath()));
    }

    @NotNull
    private static List<String> asPaths(@Nullable File file) {
        List<String> list = file == null ? Collections.emptyList() : Collections.singletonList(file.getPath());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "asPaths"));
        }
        return list;
    }

    @NotNull
    private static DependencyScope parseScope(@Nullable String scope) {
        if (scope == null) {
            DependencyScope dependencyScope = DEFAULT_DEPENDENCY_SCOPE;
            if (dependencyScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "parseScope"));
            }
            return dependencyScope;
        }
        for (DependencyScope dependencyScope : DependencyScope.values()) {
            if (!scope.equalsIgnoreCase(dependencyScope.toString())) continue;
            DependencyScope dependencyScope2 = dependencyScope;
            if (dependencyScope2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "parseScope"));
            }
            return dependencyScope2;
        }
        DependencyScope dependencyScope = DEFAULT_DEPENDENCY_SCOPE;
        if (dependencyScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "parseScope"));
        }
        return dependencyScope;
    }

    @NotNull
    private static JavaGradleFacet setAndGetJavaGradleFacet(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "setAndGetJavaGradleFacet"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "setAndGetJavaGradleFacet"));
        }
        JavaGradleFacet facet = Facets.findFacet(module, modelsProvider, JavaGradleFacet.TYPE_ID);
        if (facet != null) {
            JavaGradleFacet javaGradleFacet = facet;
            if (javaGradleFacet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "setAndGetJavaGradleFacet"));
            }
            return javaGradleFacet;
        }
        FacetManager facetManager = FacetManager.getInstance((Module)module);
        ModifiableFacetModel model = modelsProvider.getModifiableFacetModel(module);
        facet = (JavaGradleFacet)facetManager.createFacet((FacetType)JavaGradleFacet.getFacetType(), "Java-Gradle", null);
        model.addFacet((Facet)facet);
        JavaGradleFacet javaGradleFacet = facet;
        if (javaGradleFacet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "setAndGetJavaGradleFacet"));
        }
        return javaGradleFacet;
    }
}

