/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.testing;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.JavaArtifact;
import com.android.builder.model.SourceProvider;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.customizer.dependency.Dependency;
import com.android.tools.idea.gradle.customizer.dependency.DependencySet;
import com.android.tools.idea.gradle.customizer.dependency.LibraryDependency;
import com.android.tools.idea.gradle.customizer.dependency.ModuleDependency;
import com.android.tools.idea.gradle.testing.FileRootSearchScope;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.utils.FileUtils;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.HashSet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestArtifactSearchScopes {
    private static final Key<TestArtifactSearchScopes> SEARCH_SCOPES_KEY = Key.create((String)"TEST_ARTIFACT_SEARCH_SCOPES");
    @NotNull
    private final Module myModule;
    @NotNull
    private final AndroidGradleModel myAndroidModel;
    private FileRootSearchScope myAndroidTestSourceScope;
    private FileRootSearchScope myUnitTestSourceScope;
    private FileRootSearchScope myAndroidTestExcludeScope;
    private FileRootSearchScope myUnitTestExcludeScope;
    private FileRootSearchScope myAndroidTestDependencyExcludeScope;
    private FileRootSearchScope mySharedTestsExcludeScope;
    private FileRootSearchScope myUnitTestDependencyExcludeScope;

    @Nullable
    public static TestArtifactSearchScopes get(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "get"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "get"));
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        Module module = projectFileIndex.getModuleForFile(file);
        return module != null ? TestArtifactSearchScopes.get(module) : null;
    }

    @Nullable
    public static TestArtifactSearchScopes get(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "get"));
        }
        return (TestArtifactSearchScopes)module.getUserData(SEARCH_SCOPES_KEY);
    }

    public static void initializeScopes(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "initializeScopes"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidGradleModel androidModel = AndroidGradleModel.get(module);
            TestArtifactSearchScopes scopes = androidModel != null ? new TestArtifactSearchScopes(module, androidModel) : null;
            module.putUserData(SEARCH_SCOPES_KEY, (Object)scopes);
        }
    }

    private TestArtifactSearchScopes(@NotNull Module module, @NotNull AndroidGradleModel androidModel) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "<init>"));
        }
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "<init>"));
        }
        this.myModule = module;
        this.myAndroidModel = androidModel;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getModule"));
        }
        return module;
    }

    public boolean isAndroidTestSource(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "isAndroidTestSource"));
        }
        return this.getAndroidTestSourceScope().accept(file);
    }

    public boolean isUnitTestSource(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "isUnitTestSource"));
        }
        return this.getUnitTestSourceScope().accept(vFile);
    }

    @NotNull
    public FileRootSearchScope getAndroidTestSourceScope() {
        if (this.myAndroidTestSourceScope == null) {
            this.myAndroidTestSourceScope = this.getSourceScope("_android_test_");
        }
        FileRootSearchScope fileRootSearchScope = this.myAndroidTestSourceScope;
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getAndroidTestSourceScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getUnitTestSourceScope() {
        if (this.myUnitTestSourceScope == null) {
            this.myUnitTestSourceScope = this.getSourceScope("_unit_test_");
        }
        FileRootSearchScope fileRootSearchScope = this.myUnitTestSourceScope;
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getUnitTestSourceScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    private FileRootSearchScope getSourceScope(@NotNull String artifactName) {
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getSourceScope"));
        }
        HashSet roots = Sets.newHashSet();
        for (SourceProvider sourceProvider : this.myAndroidModel.getTestSourceProviders(artifactName)) {
            roots.addAll(IdeaSourceProvider.getAllSourceFolders(sourceProvider));
        }
        FileRootSearchScope fileRootSearchScope = new FileRootSearchScope(this.myModule.getProject(), roots);
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getSourceScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getAndroidTestExcludeScope() {
        if (this.myAndroidTestExcludeScope == null) {
            this.myAndroidTestExcludeScope = this.getUnitTestSourceScope().exclude(this.getAndroidTestSourceScope()).merge(this.getAndroidTestDependencyExcludeScope());
        }
        FileRootSearchScope fileRootSearchScope = this.myAndroidTestExcludeScope;
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getAndroidTestExcludeScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getUnitTestExcludeScope() {
        if (this.myUnitTestExcludeScope == null) {
            this.myUnitTestExcludeScope = this.getAndroidTestSourceScope().exclude(this.getUnitTestSourceScope()).merge(this.getUnitTestDependencyExcludeScope());
        }
        FileRootSearchScope fileRootSearchScope = this.myUnitTestExcludeScope;
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getUnitTestExcludeScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getSharedTestsExcludeScope() {
        if (this.mySharedTestsExcludeScope == null) {
            this.mySharedTestsExcludeScope = this.getAndroidTestDependencyExcludeScope().merge(this.getUnitTestDependencyExcludeScope());
        }
        FileRootSearchScope fileRootSearchScope = this.mySharedTestsExcludeScope;
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getSharedTestsExcludeScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getAndroidTestDependencyExcludeScope() {
        if (this.myAndroidTestDependencyExcludeScope == null) {
            this.myAndroidTestDependencyExcludeScope = this.getExcludedDependenciesScope("_android_test_");
        }
        FileRootSearchScope fileRootSearchScope = this.myAndroidTestDependencyExcludeScope;
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getAndroidTestDependencyExcludeScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getUnitTestDependencyExcludeScope() {
        if (this.myUnitTestDependencyExcludeScope == null) {
            this.myUnitTestDependencyExcludeScope = this.getExcludedDependenciesScope("_unit_test_");
        }
        FileRootSearchScope fileRootSearchScope = this.myUnitTestDependencyExcludeScope;
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getUnitTestDependencyExcludeScope"));
        }
        return fileRootSearchScope;
    }

    @NotNull
    private FileRootSearchScope getExcludedDependenciesScope(@NotNull String artifactName) {
        Module dependencyModule;
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getExcludedDependenciesScope"));
        }
        JavaArtifact unitTestArtifact = this.myAndroidModel.getUnitTestArtifactInSelectedVariant();
        AndroidArtifact androidTestArtifact = this.myAndroidModel.getAndroidTestArtifactInSelectedVariant();
        boolean isAndroidTestArtifact = "_android_test_".equals(artifactName);
        JavaArtifact excludeArtifact = isAndroidTestArtifact ? unitTestArtifact : androidTestArtifact;
        DependencySet androidTestDependencies = null;
        DependencySet unitTestDependencies = null;
        DependencyScope scope = DependencyScope.TEST;
        if (unitTestArtifact != null) {
            unitTestDependencies = Dependency.extractFrom((BaseArtifact)unitTestArtifact, scope);
        }
        if (androidTestArtifact != null) {
            androidTestDependencies = Dependency.extractFrom((BaseArtifact)androidTestArtifact, scope);
        }
        DependencySet mainDependencies = Dependency.extractFrom((BaseArtifact)this.myAndroidModel.getMainArtifact(), DependencyScope.COMPILE);
        DependencySet dependenciesToInclude = isAndroidTestArtifact ? androidTestDependencies : unitTestDependencies;
        DependencySet dependenciesToExclude = isAndroidTestArtifact ? unitTestDependencies : androidTestDependencies;
        Project project = this.myModule.getProject();
        HashSet excludedModules = Sets.newHashSet();
        if (dependenciesToExclude != null) {
            for (ModuleDependency dependency : dependenciesToExclude.onModules()) {
                dependencyModule = dependency.getModule(project);
                if (dependencyModule == null) continue;
                excludedModules.add(dependencyModule);
            }
        }
        if (dependenciesToInclude != null) {
            for (ModuleDependency dependency : dependenciesToInclude.onModules()) {
                dependencyModule = dependency.getModule(project);
                if (dependencyModule == null) continue;
                excludedModules.remove(dependencyModule);
            }
        }
        for (ModuleDependency dependency : mainDependencies.onModules()) {
            dependencyModule = dependency.getModule(project);
            if (dependencyModule == null) continue;
            excludedModules.remove(dependencyModule);
        }
        HashSet excludedRoots = Sets.newHashSet();
        if (excludeArtifact != null) {
            excludedRoots.add(excludeArtifact.getClassesFolder());
        }
        if (dependenciesToExclude != null) {
            for (LibraryDependency dependency : dependenciesToExclude.onLibraries()) {
                for (String string : dependency.getPaths(LibraryDependency.PathType.BINARY)) {
                    excludedRoots.add(new File(string));
                }
            }
        }
        for (Module excludedModule : excludedModules) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)excludedModule);
            for (ContentEntry entry : rootManager.getContentEntries()) {
                for (SourceFolder sourceFolder : entry.getSourceFolders()) {
                    excludedRoots.add(TestArtifactSearchScopes.urlToFilePath(sourceFolder.getUrl()));
                }
                CompilerModuleExtension compiler = (CompilerModuleExtension)rootManager.getModuleExtension(CompilerModuleExtension.class);
                String url = compiler.getCompilerOutputUrl();
                if (!StringUtil.isNotEmpty((String)url)) continue;
                excludedRoots.add(TestArtifactSearchScopes.urlToFilePath(url));
            }
            AndroidGradleModel androidGradleModel = AndroidGradleModel.get(excludedModule);
            if (androidGradleModel == null) continue;
            excludedRoots.add(androidGradleModel.getMainArtifact().getJavaResourcesFolder());
        }
        if (dependenciesToInclude != null) {
            for (LibraryDependency dependency : dependenciesToInclude.onLibraries()) {
                for (String string : dependency.getPaths(LibraryDependency.PathType.BINARY)) {
                    excludedRoots.remove(new File(string));
                }
            }
        }
        for (LibraryDependency dependency : mainDependencies.onLibraries()) {
            for (String string : dependency.getPaths(LibraryDependency.PathType.BINARY)) {
                excludedRoots.remove(new File(string));
            }
        }
        FileRootSearchScope fileRootSearchScope = new FileRootSearchScope(project, excludedRoots);
        if (fileRootSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "getExcludedDependenciesScope"));
        }
        return fileRootSearchScope;
    }

    @Nullable
    private static File urlToFilePath(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/gradle/testing/TestArtifactSearchScopes", "urlToFilePath"));
        }
        if (url.startsWith("jar://")) {
            return FilePaths.getJarFromJarUrl(url);
        }
        String path = VfsUtilCore.urlToPath((String)url);
        return new File(FileUtils.toSystemDependentPath((String)path));
    }
}

