/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.util;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.ManifestInfo;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Service;
import org.jetbrains.android.dom.manifest.UsesFeature;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchUtils {
    public static boolean canDebugAppOnDevice(@NotNull AndroidFacet facet, @NotNull IDevice device) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/util/LaunchUtils", "canDebugAppOnDevice"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/util/LaunchUtils", "canDebugAppOnDevice"));
        }
        if (device.isEmulator()) {
            return true;
        }
        Boolean isDebuggable = AndroidModuleInfo.get(facet).isDebuggable();
        if (isDebuggable != null && isDebuggable.booleanValue()) {
            return true;
        }
        String buildType = device.getProperty("ro.build.type");
        return "userdebug".equals(buildType) || "eng".equals(buildType);
    }

    public static boolean isWatchFaceApp(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/util/LaunchUtils", "isWatchFaceApp"));
        }
        ManifestInfo info = ManifestInfo.get(facet, true);
        if (!info.getActivities().isEmpty()) {
            return false;
        }
        final List<Service> services = info.getServices();
        if (services.size() != 1) {
            return false;
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                List<IntentFilter> filters = ((Service)services.get(0)).getIntentFilters();
                return filters.size() == 1 && AndroidDomUtil.containsAction(filters.get(0), "android.service.wallpaper.WallpaperService") && AndroidDomUtil.containsCategory(filters.get(0), "com.google.android.wearable.watchface.category.WATCH_FACE");
            }
        });
    }

    public static boolean isWatchFeatureRequired(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/util/LaunchUtils", "isWatchFeatureRequired"));
        }
        List<UsesFeature> usedFeatures = ManifestInfo.get(facet.getModule(), true).getUsedFeatures();
        for (UsesFeature feature : usedFeatures) {
            AndroidAttributeValue<String> name = feature.getName();
            if (name == null || !"android.hardware.type.watch".equals(name.getStringValue())) continue;
            return LaunchUtils.isRequired(feature.getRequired());
        }
        return false;
    }

    private static boolean isRequired(@Nullable AndroidAttributeValue<Boolean> required) {
        if (required == null) {
            return true;
        }
        Boolean value = (Boolean)required.getValue();
        return value == null || value != false;
    }

    public static void showNotification(final @NotNull Project project, final @NotNull Executor executor, final @NotNull String sessionName, final @NotNull String message, final @NotNull NotificationType type) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/util/LaunchUtils", "showNotification"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/run/util/LaunchUtils", "showNotification"));
        }
        if (sessionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionName", "com/android/tools/idea/run/util/LaunchUtils", "showNotification"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/run/util/LaunchUtils", "showNotification"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/run/util/LaunchUtils", "showNotification"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                String toolWindowId = executor.getToolWindowId();
                final ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(toolWindowId);
                if (toolWindow.isVisible()) {
                    return;
                }
                String notificationMessage = "Session <a href=''>'" + sessionName + "'</a>: " + message;
                NotificationGroup group = this.getNotificationGroup(toolWindowId);
                group.createNotification("", notificationMessage, type, new NotificationListener(){

                    public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                        if (notification == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/run/util/LaunchUtils$2$1", "hyperlinkUpdate"));
                        }
                        if (event == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/run/util/LaunchUtils$2$1", "hyperlinkUpdate"));
                        }
                        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            RunContentManager contentManager = ExecutionManager.getInstance((Project)project).getContentManager();
                            for (RunContentDescriptor d : contentManager.getAllDescriptors()) {
                                if (!sessionName.equals(d.getDisplayName())) continue;
                                Content content = d.getAttachedContent();
                                if (content != null) {
                                    content.getManager().setSelectedContent(content);
                                }
                                toolWindow.activate(null, true, true);
                                break;
                            }
                        }
                    }
                }).notify(project);
            }

            @NotNull
            private NotificationGroup getNotificationGroup(@NotNull String toolWindowId) {
                if (toolWindowId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowId", "com/android/tools/idea/run/util/LaunchUtils$2", "getNotificationGroup"));
                }
                String displayId = "Launch Notifications for " + toolWindowId;
                NotificationGroup group = NotificationGroup.findRegisteredGroup((String)displayId);
                if (group == null) {
                    group = NotificationGroup.toolWindowGroup((String)displayId, (String)toolWindowId);
                }
                NotificationGroup notificationGroup = group;
                if (notificationGroup == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/util/LaunchUtils$2", "getNotificationGroup"));
                }
                return notificationGroup;
            }
        });
    }

    public static void initiateDismissKeyguard(final @NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/util/LaunchUtils", "initiateDismissKeyguard"));
        }
        AndroidVersion canDismissKeyguard = new AndroidVersion(23, null);
        if (canDismissKeyguard.compareTo(device.getVersion()) <= 0) {
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        device.executeShellCommand("wm dismiss-keyguard", (IShellOutputReceiver)new NullOutputReceiver(), 10L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        Logger.getInstance(LaunchUtils.class).warn("Unable to dismiss keyguard before launching activity");
                    }
                }
            });
        }
    }
}

