/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.find.FindManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.AutoScrollToSourceOptionProvider;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.OccurenceNavigatorSupport;
import com.intellij.ide.TextCopyProvider;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.ide.actions.exclusion.ExclusionHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageContextPanel;
import com.intellij.usages.UsageDataUtil;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageModelTracker;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.ExporterToTextFile;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.NullUsage;
import com.intellij.usages.impl.PreviewUsageAction;
import com.intellij.usages.impl.RuleAction;
import com.intellij.usages.impl.SortMembersAlphabeticallyAction;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageNodeTreeBuilder;
import com.intellij.usages.impl.UsageTargetNode;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.usages.impl.UsageViewTreeCellRenderer;
import com.intellij.usages.impl.UsageViewTreeModelBuilder;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.usages.rules.OrderableUsageGroupingRule;
import com.intellij.usages.rules.UsageFilteringRule;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageGroupingRuleProvider;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.usages.rules.UsageInFiles;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.enumeration.EmptyEnumeration;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageViewImpl
implements UsageView,
UsageModelTracker.UsageModelTrackerListener {
    @NonNls
    public static final String SHOW_RECENT_FIND_USAGES_ACTION_ID = "UsageView.ShowRecentFindUsages";
    private final UsageNodeTreeBuilder myBuilder;
    private final MyPanel myRootPanel;
    @NotNull
    private final JTree myTree;
    private Content myContent;
    private final UsageViewPresentation myPresentation;
    private final UsageTarget[] myTargets;
    private final Factory<UsageSearcher> myUsageSearcherFactory;
    private final Project myProject;
    private volatile boolean mySearchInProgress;
    private final ExporterToTextFile myTextFileExporter;
    private final Alarm myUpdateAlarm;
    private final ExclusionHandler<DefaultMutableTreeNode> myExclusionHandler;
    private final UsageModelTracker myModelTracker;
    private final Map<Usage, UsageNode> myUsageNodes;
    public static final UsageNode NULL_NODE = new UsageNode(NullUsage.INSTANCE, new UsageViewTreeModelBuilder(new UsageViewPresentation(), UsageTarget.EMPTY_ARRAY));
    private final ButtonPanel myButtonPanel;
    private final JComponent myAdditionalComponent;
    private volatile boolean isDisposed;
    private volatile boolean myChangesDetected;
    public static final Comparator<Usage> USAGE_COMPARATOR = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == NULL_NODE) {
            return -1;
        }
        if (o2 == NULL_NODE) {
            return 1;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            int selfcompared = ((Comparable)((Object)o1)).compareTo(o2);
            if (selfcompared != 0) {
                return selfcompared;
            }
            if (o1 instanceof UsageInFile && o2 instanceof UsageInFile) {
                UsageInFile u1 = (UsageInFile)o1;
                UsageInFile u2 = (UsageInFile)o2;
                VirtualFile f1 = u1.getFile();
                VirtualFile f2 = u2.getFile();
                if (f1 != null && f1.isValid() && f2 != null && f2.isValid()) {
                    return f1.getPresentableUrl().compareTo(f2.getPresentableUrl());
                }
            }
            return 0;
        }
        return o1.toString().compareTo(o2.toString());
    };
    @NonNls
    private static final String HELP_ID = "ideaInterface.find";
    private UsageContextPanel myCurrentUsageContextPanel;
    private List<UsageContextPanel.Provider> myUsageContextPanelProviders;
    private UsageContextPanel.Provider myCurrentUsageContextProvider;
    private JPanel myCentralPanel;
    private final GroupNode myRoot;
    private final UsageViewTreeModelBuilder myModel;
    private final Object lock;
    private Splitter myPreviewSplitter;
    private volatile ProgressIndicator associatedProgress;
    private boolean expandingAll;
    private final UsageViewTreeCellRenderer myUsageViewTreeCellRenderer;
    private final TransferToEDTQueue<Runnable> myTransferToEDTQueue;
    private final Consumer<Runnable> edtQueue;

    UsageViewImpl(@NotNull Project project, @NotNull UsageViewPresentation presentation, @NotNull UsageTarget[] targets, Factory<UsageSearcher> usageSearcherFactory) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/usages/impl/UsageViewImpl", "<init>"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/usages/impl/UsageViewImpl", "<init>"));
        }
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/usages/impl/UsageViewImpl", "<init>"));
        }
        this.mySearchInProgress = true;
        this.myTextFileExporter = new ExporterToTextFile(this);
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myUsageNodes = new ConcurrentHashMap<Usage, UsageNode>();
        this.myButtonPanel = new ButtonPanel();
        this.myAdditionalComponent = new JPanel(new BorderLayout());
        this.lock = new Object();
        this.edtQueue = new Consumer<Runnable>(){

            public void consume(Runnable runnable) {
                UsageViewImpl.this.myTransferToEDTQueue.offer((Object)runnable);
            }
        };
        this.myPresentation = presentation;
        this.myTargets = targets;
        this.myUsageSearcherFactory = usageSearcherFactory;
        this.myProject = project;
        this.myTree = new Tree(){
            {
                ToolTipManager.sharedInstance().registerComponent(this);
            }

            @Override
            public String getToolTipText(MouseEvent e) {
                TreePath path2 = this.getPathForLocation(e.getX(), e.getY());
                if (path2 != null && this.getCellRenderer() instanceof UsageViewTreeCellRenderer) {
                    return UsageViewTreeCellRenderer.getTooltipFromPresentation(path2.getLastPathComponent());
                }
                return null;
            }

            @Override
            public boolean isPathEditable(TreePath path2) {
                return path2.getLastPathComponent() instanceof UsageViewTreeModelBuilder.TargetsRootNode;
            }

            @Override
            public Enumeration<TreePath> getExpandedDescendants(TreePath parent) {
                return UsageViewImpl.this.expandingAll ? EmptyEnumeration.getInstance() : super.getExpandedDescendants(parent);
            }
        };
        this.myRootPanel = new MyPanel(this.myTree);
        Disposer.register((Disposable)this, (Disposable)this.myRootPanel);
        this.myModelTracker = new UsageModelTracker(project);
        Disposer.register((Disposable)this, (Disposable)this.myModelTracker);
        this.myModel = new UsageViewTreeModelBuilder(this.myPresentation, targets);
        this.myRoot = (GroupNode)this.myModel.getRoot();
        this.myBuilder = new UsageNodeTreeBuilder(this.myTargets, UsageViewImpl.getActiveGroupingRules(project), UsageViewImpl.getActiveFilteringRules(project), this.myRoot, this.myProject);
        MessageBusConnection messageBusConnection = this.myProject.getMessageBus().connect((Disposable)this);
        messageBusConnection.subscribe(UsageFilteringRuleProvider.RULES_CHANGED, () -> this.rulesChanged());
        this.myUsageViewTreeCellRenderer = new UsageViewTreeCellRenderer(this);
        if (!this.myPresentation.isDetachedMode()) {
            UIUtil.invokeLaterIfNeeded(() -> {
                Object object = this.lock;
                synchronized (object) {
                    if (this.isDisposed) {
                        return;
                    }
                    this.myTree.setModel(this.myModel);
                    this.myRootPanel.setLayout(new BorderLayout());
                    SimpleToolWindowPanel toolWindowPanel = new SimpleToolWindowPanel(false, true);
                    this.myRootPanel.add((Component)toolWindowPanel, "Center");
                    JPanel toolbarPanel = new JPanel(new BorderLayout());
                    toolbarPanel.add((Component)this.createActionsToolbar(), "West");
                    toolbarPanel.add((Component)this.createFiltersToolbar(), "Center");
                    toolWindowPanel.setToolbar(toolbarPanel);
                    this.myCentralPanel = new JPanel(new BorderLayout());
                    this.setupCentralPanel();
                    this.initTree();
                    toolWindowPanel.setContent(this.myCentralPanel);
                    this.myTree.setCellRenderer(this.myUsageViewTreeCellRenderer);
                    this.collapseAll();
                    this.myModelTracker.addListener(this);
                    if (this.myPresentation.isShowCancelButton()) {
                        this.addButtonToLowerPane(() -> this.close(), UsageViewBundle.message("usage.view.cancel.button", new Object[0]));
                    }
                    this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                        @Override
                        public void valueChanged(TreeSelectionEvent e) {
                            SwingUtilities.invokeLater(() -> {
                                if (UsageViewImpl.this.isDisposed || UsageViewImpl.this.myProject.isDisposed()) {
                                    return;
                                }
                                UsageViewImpl.this.updateOnSelectionChanged();
                            });
                        }
                    });
                }
            });
        }
        this.myTransferToEDTQueue = new TransferToEDTQueue("Insert usages", runnable -> {
            runnable.run();
            return true;
        }, o -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/usages/impl/UsageViewImpl", "lambda$new$5"));
            }
            return this.isDisposed || project.isDisposed();
        }, 200);
        this.myExclusionHandler = new ExclusionHandler<DefaultMutableTreeNode>(){

            @Override
            public boolean isNodeExclusionAvailable(@NotNull DefaultMutableTreeNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/usages/impl/UsageViewImpl$3", "isNodeExclusionAvailable"));
                }
                return node instanceof UsageNode;
            }

            @Override
            public boolean isNodeExcluded(@NotNull DefaultMutableTreeNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/usages/impl/UsageViewImpl$3", "isNodeExcluded"));
                }
                return ((UsageNode)node).isDataExcluded();
            }

            @Override
            public void excludeNode(@NotNull DefaultMutableTreeNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/usages/impl/UsageViewImpl$3", "excludeNode"));
                }
                HashSet usages = new HashSet();
                UsageViewImpl.collectUsages(node, usages);
                UsageViewImpl.this.excludeUsages(usages.toArray(new Usage[usages.size()]));
            }

            @Override
            public void includeNode(@NotNull DefaultMutableTreeNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/usages/impl/UsageViewImpl$3", "includeNode"));
                }
                HashSet usages = new HashSet();
                UsageViewImpl.collectUsages(node, usages);
                UsageViewImpl.this.includeUsages(usages.toArray(new Usage[usages.size()]));
            }

            @Override
            public boolean isActionEnabled(boolean isExcludeAction) {
                return UsageViewImpl.this.getPresentation().isExcludeAvailable();
            }

            @Override
            public void onDone(boolean isExcludeAction) {
            }
        };
    }

    protected boolean searchHasBeenCancelled() {
        ProgressIndicator progress = this.associatedProgress;
        return progress != null && progress.isCanceled();
    }

    protected void cancelCurrentSearch() {
        ProgressIndicator progress = this.associatedProgress;
        if (progress != null) {
            ProgressWrapper.unwrap((ProgressIndicator)progress).cancel();
        }
    }

    private void clearRendererCache() {
        TreeUI ui = this.myTree.getUI();
        if (ui instanceof BasicTreeUI) {
            AbstractLayoutCache treeState = (AbstractLayoutCache)ReflectionUtil.getField(BasicTreeUI.class, (Object)ui, AbstractLayoutCache.class, (String)"treeState");
            Rectangle visibleRect = this.myTree.getVisibleRect();
            int rowForLocation = this.myTree.getClosestRowForLocation(0, visibleRect.y);
            int visibleRowCount = this.getVisibleRowCount();
            for (int i = rowForLocation + visibleRowCount + 1; i >= rowForLocation; --i) {
                TreePath eachPath = this.myTree.getPathForRow(i);
                if (eachPath == null) continue;
                treeState.invalidatePathBounds(eachPath);
            }
            this.myTree.repaint(visibleRect);
        } else {
            this.myTree.setCellRenderer(this.myUsageViewTreeCellRenderer);
        }
    }

    private int getVisibleRowCount() {
        return TreeUtil.getVisibleRowCountForFixedRowHeight(this.myTree);
    }

    private void setupCentralPanel() {
        this.myCentralPanel.removeAll();
        this.disposeUsageContextPanels();
        JScrollPane treePane = ScrollPaneFactory.createScrollPane(this.myTree);
        treePane.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                UsageViewImpl.this.clearRendererCache();
            }
        });
        this.myTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                UsageViewImpl.this.clearRendererCache();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                UsageViewImpl.this.clearRendererCache();
            }
        });
        this.myPreviewSplitter = new Splitter(false, 0.5f, 0.1f, 0.9f);
        this.myPreviewSplitter.setFirstComponent((JComponent)treePane);
        this.myCentralPanel.add((Component)this.myPreviewSplitter, "Center");
        if (UsageViewSettings.getInstance().IS_PREVIEW_USAGES) {
            this.myPreviewSplitter.setProportion(UsageViewSettings.getInstance().PREVIEW_USAGES_SPLITTER_PROPORTIONS);
            treePane.putClientProperty(UIUtil.KEEP_BORDER_SIDES, 4);
            final JBTabbedPane tabbedPane = new JBTabbedPane(3){

                @Override
                @NotNull
                protected Insets getInsetsForTabComponent() {
                    Insets insets = new Insets(0, 0, 0, 0);
                    if (insets == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewImpl$6", "getInsetsForTabComponent"));
                    }
                    return insets;
                }
            };
            Object[] extensions = (UsageContextPanel.Provider[])Extensions.getExtensions(UsageContextPanel.Provider.EP_NAME, (AreaInstance)this.myProject);
            this.myUsageContextPanelProviders = ContainerUtil.filter((Object[])extensions, provider -> provider.isAvailableFor(this));
            for (UsageContextPanel.Provider provider2 : this.myUsageContextPanelProviders) {
                JComponent component;
                if (this.myCurrentUsageContextProvider == null || this.myCurrentUsageContextProvider == provider2) {
                    this.myCurrentUsageContextProvider = provider2;
                    this.myCurrentUsageContextPanel = provider2.create(this);
                    component = this.myCurrentUsageContextPanel.createComponent();
                } else {
                    component = new JLabel();
                }
                tabbedPane.addTab(provider2.getTabTitle(), component);
            }
            int index = this.myUsageContextPanelProviders.indexOf(this.myCurrentUsageContextProvider);
            tabbedPane.setSelectedIndex(index);
            tabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int currentIndex = tabbedPane.getSelectedIndex();
                    UsageContextPanel.Provider selectedProvider = (UsageContextPanel.Provider)UsageViewImpl.this.myUsageContextPanelProviders.get(currentIndex);
                    if (selectedProvider != UsageViewImpl.this.myCurrentUsageContextProvider) {
                        UsageViewImpl.this.tabSelected(selectedProvider);
                    }
                }
            });
            tabbedPane.setBorder(IdeBorderFactory.createBorder(1));
            this.myPreviewSplitter.setSecondComponent((JComponent)tabbedPane);
        } else {
            this.myPreviewSplitter.setProportion(1.0f);
        }
        this.myCentralPanel.add((Component)this.myAdditionalComponent, "South");
        this.myAdditionalComponent.add((Component)this.myButtonPanel, "South");
        this.myRootPanel.revalidate();
        this.myRootPanel.repaint();
    }

    private void tabSelected(@NotNull UsageContextPanel.Provider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/usages/impl/UsageViewImpl", "tabSelected"));
        }
        this.myCurrentUsageContextProvider = provider;
        this.setupCentralPanel();
        this.updateOnSelectionChanged();
    }

    private void disposeUsageContextPanels() {
        if (this.myCurrentUsageContextPanel != null) {
            this.saveSplitterProportions();
            Disposer.dispose((Disposable)this.myCurrentUsageContextPanel);
            this.myCurrentUsageContextPanel = null;
        }
    }

    private static UsageFilteringRule[] getActiveFilteringRules(Project project) {
        UsageFilteringRuleProvider[] providers = (UsageFilteringRuleProvider[])Extensions.getExtensions(UsageFilteringRuleProvider.EP_NAME);
        ArrayList list = new ArrayList(providers.length);
        for (UsageFilteringRuleProvider provider : providers) {
            ContainerUtil.addAll(list, (Object[])provider.getActiveRules(project));
        }
        return list.toArray(new UsageFilteringRule[list.size()]);
    }

    private static UsageGroupingRule[] getActiveGroupingRules(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/usages/impl/UsageViewImpl", "getActiveGroupingRules"));
        }
        UsageGroupingRuleProvider[] providers = (UsageGroupingRuleProvider[])Extensions.getExtensions(UsageGroupingRuleProvider.EP_NAME);
        ArrayList list = new ArrayList(providers.length);
        for (UsageGroupingRuleProvider provider : providers) {
            ContainerUtil.addAll(list, (Object[])provider.getActiveRules(project));
        }
        Collections.sort(list, new Comparator<UsageGroupingRule>(){

            @Override
            public int compare(UsageGroupingRule o1, UsageGroupingRule o2) {
                return this.getRank(o1) - this.getRank(o2);
            }

            private int getRank(UsageGroupingRule rule) {
                if (rule instanceof OrderableUsageGroupingRule) {
                    return ((OrderableUsageGroupingRule)rule).getRank();
                }
                return Integer.MAX_VALUE;
            }
        });
        return list.toArray(new UsageGroupingRule[list.size()]);
    }

    @Override
    public void modelChanged(boolean isPropertyChange) {
        if (!isPropertyChange) {
            this.myChangesDetected = true;
        }
        this.updateLater();
    }

    private void initTree() {
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        SmartExpander.installOn((JTree)this.myTree);
        TreeUtil.installActions(this.myTree);
        EditSourceOnDoubleClickHandler.install(this.myTree);
        this.myTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    Navigatable navigatable;
                    TreePath leadSelectionPath = UsageViewImpl.this.myTree.getLeadSelectionPath();
                    if (leadSelectionPath == null) {
                        return;
                    }
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)leadSelectionPath.getLastPathComponent();
                    if (node instanceof UsageNode) {
                        Usage usage = ((UsageNode)node).getUsage();
                        usage.navigate(false);
                        usage.highlightInEditor();
                    } else if (node.isLeaf() && (navigatable = UsageViewImpl.getNavigatableForNode(node)) != null && navigatable.canNavigate()) {
                        navigatable.navigate(false);
                    }
                }
            }
        });
        TreeUtil.selectFirstNode(this.myTree);
        PopupHandler.installPopupHandler(this.myTree, "UsageView.Popup", "UsageViewPopup");
        this.myTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path2 = event.getPath();
                Object component = path2.getLastPathComponent();
                if (!(component instanceof Node)) {
                    return;
                }
                Node node = (Node)component;
                if (!UsageViewImpl.this.expandingAll && node.needsUpdate()) {
                    UsageViewImpl.this.checkNodeValidity(node, path2);
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        TreeUIHelper.getInstance().installTreeSpeedSearch(this.myTree, new Convertor<TreePath, String>(){

            public String convert(TreePath o) {
                Object value = o.getLastPathComponent();
                TreeCellRenderer renderer = UsageViewImpl.this.myTree.getCellRenderer();
                if (renderer instanceof UsageViewTreeCellRenderer) {
                    UsageViewTreeCellRenderer coloredRenderer = (UsageViewTreeCellRenderer)renderer;
                    return coloredRenderer.getPlainTextForNode(value);
                }
                return value == null ? null : value.toString();
            }
        }, true);
    }

    @NotNull
    private JComponent createActionsToolbar() {
        AnAction[] actions;
        DefaultActionGroup group = new DefaultActionGroup(){

            @Override
            public void update(AnActionEvent e) {
                super.update(e);
                UsageViewImpl.this.myButtonPanel.update();
            }

            @Override
            public boolean isDumbAware() {
                return true;
            }
        };
        for (AnAction action : actions = this.createActions()) {
            if (action == null) continue;
            group.add(action);
        }
        JComponent jComponent = this.toUsageViewToolbar(group);
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewImpl", "createActionsToolbar"));
        }
        return jComponent;
    }

    @NotNull
    private JComponent toUsageViewToolbar(@NotNull DefaultActionGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/usages/impl/UsageViewImpl", "toUsageViewToolbar"));
        }
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("UsageViewToolbar", group, false);
        actionToolbar.setTargetComponent(this.myRootPanel);
        JComponent jComponent = actionToolbar.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewImpl", "toUsageViewToolbar"));
        }
        return jComponent;
    }

    @NotNull
    private JComponent createFiltersToolbar() {
        AnAction[] groupingActions;
        DefaultActionGroup group = new DefaultActionGroup();
        for (AnAction groupingAction : groupingActions = this.createGroupingActions()) {
            group.add(groupingAction);
        }
        this.addFilteringActions(group);
        group.add(new PreviewUsageAction(this));
        group.add(new SortMembersAlphabeticallyAction(this));
        JComponent jComponent = this.toUsageViewToolbar(group);
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewImpl", "createFiltersToolbar"));
        }
        return jComponent;
    }

    public void addFilteringActions(@NotNull DefaultActionGroup group) {
        UsageFilteringRuleProvider[] providers;
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/usages/impl/UsageViewImpl", "addFilteringActions"));
        }
        JComponent component = this.getComponent();
        if (this.getPresentation().isMergeDupLinesAvailable()) {
            MergeDupLines mergeDupLines = new MergeDupLines();
            mergeDupLines.registerCustomShortcutSet(mergeDupLines.getShortcutSet(), component, this);
            group.add(mergeDupLines);
        }
        for (UsageFilteringRuleProvider provider : providers = (UsageFilteringRuleProvider[])Extensions.getExtensions(UsageFilteringRuleProvider.EP_NAME)) {
            AnAction[] actions;
            for (AnAction action : actions = provider.createFilteringActions(this)) {
                group.add(action);
            }
        }
    }

    public void scheduleDisposeOnClose(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/usages/impl/UsageViewImpl", "scheduleDisposeOnClose"));
        }
        Disposer.register((Disposable)this, (Disposable)disposable);
    }

    @NotNull
    private AnAction[] createActions() {
        TreeExpander treeExpander = new TreeExpander(){

            @Override
            public void expandAll() {
                UsageViewImpl.this.expandAll();
                UsageViewSettings.getInstance().setExpanded(true);
            }

            @Override
            public boolean canExpand() {
                return true;
            }

            @Override
            public void collapseAll() {
                UsageViewImpl.this.collapseAll();
                UsageViewSettings.getInstance().setExpanded(false);
            }

            @Override
            public boolean canCollapse() {
                return true;
            }
        };
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        final JComponent component = this.getComponent();
        final AnAction expandAllAction = actionsManager.createExpandAllAction(treeExpander, component);
        final AnAction collapseAllAction = actionsManager.createCollapseAllAction(treeExpander, component);
        this.scheduleDisposeOnClose(new Disposable(){

            public void dispose() {
                expandAllAction.unregisterCustomShortcutSet(component);
                collapseAllAction.unregisterCustomShortcutSet(component);
            }
        });
        AnAction[] anActionArray = new AnAction[]{this.canShowSettings() ? this.showSettings() : null, ActionManager.getInstance().getAction("UsageView.Rerun"), new CloseAction(), ActionManager.getInstance().getAction("PinActiveTab"), this.createRecentFindUsagesAction(), expandAllAction, collapseAllAction, actionsManager.createPrevOccurenceAction(this.myRootPanel), actionsManager.createNextOccurenceAction(this.myRootPanel), actionsManager.installAutoscrollToSourceHandler(this.myProject, this.myTree, new MyAutoScrollToSourceOptionProvider()), actionsManager.createExportToTextFileAction(this.myTextFileExporter), actionsManager.createHelpAction(HELP_ID)};
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewImpl", "createActions"));
        }
        return anActionArray;
    }

    private boolean canShowSettings() {
        if (this.myTargets.length == 0) {
            return false;
        }
        UsageTarget target = this.myTargets[0];
        return target instanceof ConfigurableUsageTarget;
    }

    @NotNull
    private AnAction showSettings() {
        final ConfigurableUsageTarget configurableUsageTarget = UsageViewImpl.getConfigurableTarget(this.myTargets);
        String description = null;
        try {
            description = configurableUsageTarget == null ? null : "Show settings for " + configurableUsageTarget.getLongDescriptiveName();
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        if (description == null) {
            description = "Show find usages settings dialog";
        }
        AnAction anAction = new AnAction("Settings...", description, AllIcons.General.ProjectSettings){
            {
                KeyboardShortcut shortcut;
                super(arg0, arg1, arg2);
                KeyboardShortcut keyboardShortcut = shortcut = configurableUsageTarget == null ? UsageViewImpl.getShowUsagesWithSettingsShortcut() : configurableUsageTarget.getShortcut();
                if (shortcut != null) {
                    this.registerCustomShortcutSet(new CustomShortcutSet(shortcut), UsageViewImpl.this.getComponent());
                }
            }

            @Override
            public void actionPerformed(AnActionEvent e) {
                FindManager.getInstance(UsageViewImpl.this.getProject()).showSettingsAndFindUsages(UsageViewImpl.this.myTargets);
            }
        };
        if (anAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewImpl", "showSettings"));
        }
        return anAction;
    }

    private static ConfigurableUsageTarget getConfigurableTarget(@NotNull UsageTarget[] targets) {
        UsageTarget target;
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/usages/impl/UsageViewImpl", "getConfigurableTarget"));
        }
        ConfigurableUsageTarget configurableUsageTarget = null;
        if (targets.length != 0 && (target = targets[0]) instanceof ConfigurableUsageTarget) {
            configurableUsageTarget = (ConfigurableUsageTarget)target;
        }
        return configurableUsageTarget;
    }

    @NotNull
    private AnAction createRecentFindUsagesAction() {
        AnAction action = ActionManager.getInstance().getAction(SHOW_RECENT_FIND_USAGES_ACTION_ID);
        action.registerCustomShortcutSet(action.getShortcutSet(), this.getComponent());
        AnAction anAction = action;
        if (anAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewImpl", "createRecentFindUsagesAction"));
        }
        return anAction;
    }

    @NotNull
    private AnAction[] createGroupingActions() {
        UsageGroupingRuleProvider[] providers = (UsageGroupingRuleProvider[])Extensions.getExtensions(UsageGroupingRuleProvider.EP_NAME);
        ArrayList list = new ArrayList(providers.length);
        for (UsageGroupingRuleProvider provider : providers) {
            ContainerUtil.addAll(list, (Object[])provider.createGroupingActions(this));
        }
        AnAction[] anActionArray = list.toArray(new AnAction[list.size()]);
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewImpl", "createGroupingActions"));
        }
        return anActionArray;
    }

    private void rulesChanged() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<UsageState> states = new ArrayList<UsageState>();
        this.captureUsagesExpandState(new TreePath(this.myTree.getModel().getRoot()), states);
        ArrayList<Usage> allUsages = new ArrayList<Usage>(this.myUsageNodes.keySet());
        Collections.sort(allUsages, USAGE_COMPARATOR);
        Set<Usage> excludedUsages = this.getExcludedUsages();
        this.reset();
        this.myBuilder.setGroupingRules(UsageViewImpl.getActiveGroupingRules(this.myProject));
        this.myBuilder.setFilteringRules(UsageViewImpl.getActiveFilteringRules(this.myProject));
        ApplicationManager.getApplication().runReadAction(() -> {
            for (Usage usage : allUsages) {
                if (!usage.isValid()) continue;
                if (usage instanceof MergeableUsage) {
                    ((MergeableUsage)((Object)usage)).reset();
                }
                this.appendUsage(usage);
            }
        });
        this.excludeUsages(excludedUsages.toArray(new Usage[excludedUsages.size()]));
        if (this.myCentralPanel != null) {
            this.setupCentralPanel();
        }
        SwingUtilities.invokeLater(() -> {
            if (this.isDisposed) {
                return;
            }
            this.restoreUsageExpandState(states);
            this.updateImmediately();
        });
    }

    private void captureUsagesExpandState(TreePath pathFrom, Collection<UsageState> states) {
        if (!this.myTree.isExpanded(pathFrom)) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)pathFrom.getLastPathComponent();
        int childCount = node.getChildCount();
        for (int idx = 0; idx < childCount; ++idx) {
            TreeNode child = node.getChildAt(idx);
            if (child instanceof UsageNode) {
                Usage usage = ((UsageNode)child).getUsage();
                states.add(new UsageState(usage, this.myTree.getSelectionModel().isPathSelected(pathFrom.pathByAddingChild(child))));
                continue;
            }
            this.captureUsagesExpandState(pathFrom.pathByAddingChild(child), states);
        }
    }

    private void restoreUsageExpandState(@NotNull Collection<UsageState> states) {
        if (states == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "states", "com/intellij/usages/impl/UsageViewImpl", "restoreUsageExpandState"));
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myTree.getModel().getRoot();
        for (int i = root.getChildCount() - 1; i >= 0; --i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)root.getChildAt(i);
            if (!(child instanceof GroupNode)) continue;
            TreePath treePath = new TreePath(child.getPath());
            this.myTree.expandPath(treePath);
        }
        this.myTree.getSelectionModel().clearSelection();
        for (UsageState usageState : states) {
            usageState.restore();
        }
    }

    public void expandAll() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.expandingAll = true;
        try {
            TreeUtil.expandAll(this.myTree);
        }
        finally {
            this.expandingAll = false;
        }
    }

    private void collapseAll() {
        TreeUtil.collapseAll(this.myTree, 3);
        TreeUtil.expand(this.myTree, 2);
    }

    public DefaultMutableTreeNode getModelRoot() {
        return (DefaultMutableTreeNode)this.myTree.getModel().getRoot();
    }

    public void select() {
        if (this.myTree != null) {
            this.myTree.requestFocusInWindow();
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewImpl", "getProject"));
        }
        return project;
    }

    @Nullable
    public static KeyboardShortcut getShowUsagesWithSettingsShortcut() {
        return ActionManager.getInstance().getKeyboardShortcut("ShowSettingsAndFindUsages");
    }

    static KeyboardShortcut getShowUsagesWithSettingsShortcut(@NotNull UsageTarget[] targets) {
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/usages/impl/UsageViewImpl", "getShowUsagesWithSettingsShortcut"));
        }
        ConfigurableUsageTarget configurableTarget = UsageViewImpl.getConfigurableTarget(targets);
        return configurableTarget == null ? UsageViewImpl.getShowUsagesWithSettingsShortcut() : configurableTarget.getShortcut();
    }

    void associateProgress(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/usages/impl/UsageViewImpl", "associateProgress"));
        }
        this.associatedProgress = indicator;
    }

    public void refreshUsages() {
        this.reset();
        this.doReRun();
    }

    private void doReRun() {
        final AtomicInteger usageCountWithoutDefinition = new AtomicInteger(0);
        final Project project = this.myProject;
        Task.Backgroundable task = new Task.Backgroundable(project, UsageViewManagerImpl.getProgressTitle(this.myPresentation)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/usages/impl/UsageViewImpl$16", "run"));
                }
                TooManyUsagesStatus tooManyUsagesStatus = TooManyUsagesStatus.createFor((ProgressIndicator)indicator);
                UsageViewImpl.this.setSearchInProgress(true);
                UsageViewImpl.this.associateProgress(indicator);
                Processor processor = usage -> {
                    boolean incrementCounter;
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/usages/impl/UsageViewImpl$16", "lambda$run$1"));
                    }
                    if (UsageViewImpl.this.searchHasBeenCancelled()) {
                        return false;
                    }
                    TooManyUsagesStatus.getFrom((ProgressIndicator)indicator).pauseProcessingIfTooManyUsages();
                    boolean bl = incrementCounter = !UsageViewManager.isSelfUsage(usage, UsageViewImpl.this.myTargets);
                    if (incrementCounter) {
                        int usageCount = usageCountWithoutDefinition.incrementAndGet();
                        if (usageCount > 1000 && tooManyUsagesStatus.switchTooManyUsagesStatus()) {
                            UsageViewManagerImpl.showTooManyUsagesWarning(project, tooManyUsagesStatus, indicator, UsageViewImpl.this.getPresentation(), usageCountWithoutDefinition.get(), UsageViewImpl.this);
                        }
                        ApplicationManager.getApplication().runReadAction(() -> UsageViewImpl.this.appendUsage((Usage)usage));
                    }
                    return !indicator.isCanceled();
                };
                UsageViewImpl.this.myChangesDetected = false;
                PsiManager.getInstance(project).startBatchFilesProcessingMode();
                try {
                    ((UsageSearcher)UsageViewImpl.this.myUsageSearcherFactory.create()).generate((Processor<Usage>)processor);
                    UsageViewImpl.this.drainQueuedUsageNodes();
                }
                finally {
                    PsiManager.getInstance(project).finishBatchFilesProcessingMode();
                }
                UsageViewImpl.this.setSearchInProgress(false);
            }
        };
        ProgressManager.getInstance().run(task);
    }

    private void reset() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myUsageNodes.clear();
        this.myModel.reset();
        if (!this.myPresentation.isDetachedMode()) {
            SwingUtilities.invokeLater(() -> {
                if (this.isDisposed) {
                    return;
                }
                TreeUtil.expand(this.myTree, 2);
            });
        }
    }

    void drainQueuedUsageNodes() {
        assert (!ApplicationManager.getApplication().isDispatchThread()) : Thread.currentThread();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                UsageViewImpl.this.myTransferToEDTQueue.drain();
            }
        });
    }

    @Override
    public void appendUsage(@NotNull Usage usage) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/usages/impl/UsageViewImpl", "appendUsage"));
        }
        this.doAppendUsage(usage);
    }

    @Nullable
    public UsageNode doAppendUsage(@NotNull Usage usage) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/usages/impl/UsageViewImpl", "doAppendUsage"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!usage.isValid()) {
            return null;
        }
        UsageNode node = this.myBuilder.appendUsage(usage, this.edtQueue);
        if (node != null) {
            node.update(this, this.edtQueue);
        }
        this.myUsageNodes.put(usage, node == null ? NULL_NODE : node);
        return node;
    }

    @Override
    public void removeUsage(@NotNull Usage usage) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/usages/impl/UsageViewImpl", "removeUsage"));
        }
        UsageNode node = this.myUsageNodes.remove(usage);
        if (node != NULL_NODE && node != null && !this.myPresentation.isDetachedMode()) {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (this.isDisposed) {
                    return;
                }
                TreeModel treeModel = this.myTree.getModel();
                ((DefaultTreeModel)treeModel).removeNodeFromParent(node);
                ((GroupNode)this.myTree.getModel().getRoot()).removeUsage(node);
            });
        }
    }

    @Override
    public void removeUsagesBulk(@NotNull Collection<Usage> usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/usages/impl/UsageViewImpl", "removeUsagesBulk"));
        }
        THashSet nodes = new THashSet(usages.size());
        for (Usage usage : usages) {
            UsageNode node = this.myUsageNodes.remove(usage);
            if (node == null || node == NULL_NODE) continue;
            nodes.add(node);
        }
        if (!nodes.isEmpty() && !this.myPresentation.isDetachedMode()) {
            UIUtil.invokeLaterIfNeeded(() -> this.lambda$removeUsagesBulk$11((Set)nodes));
        }
    }

    @Override
    public void includeUsages(@NotNull Usage[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/usages/impl/UsageViewImpl", "includeUsages"));
        }
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(usages.length);
        for (Usage usage : usages) {
            UsageNode node = this.myUsageNodes.get(usage);
            if (node == NULL_NODE || node == null) continue;
            node.setUsageExcluded(false);
            nodes.add(node);
        }
        this.updateImmediatelyNodesUpToRoot(nodes);
    }

    @Override
    public void excludeUsages(@NotNull Usage[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/usages/impl/UsageViewImpl", "excludeUsages"));
        }
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(usages.length);
        for (Usage usage : usages) {
            UsageNode node = this.myUsageNodes.get(usage);
            if (node == NULL_NODE || node == null) continue;
            node.setUsageExcluded(true);
            nodes.add(node);
        }
        this.updateImmediatelyNodesUpToRoot(nodes);
    }

    @Override
    public void selectUsages(@NotNull Usage[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/usages/impl/UsageViewImpl", "selectUsages"));
        }
        LinkedList<TreePath> paths = new LinkedList<TreePath>();
        for (Usage usage : usages) {
            UsageNode node = this.myUsageNodes.get(usage);
            if (node == NULL_NODE || node == null) continue;
            paths.add(new TreePath(node.getPath()));
        }
        this.myTree.setSelectionPaths(paths.toArray(new TreePath[paths.size()]));
        if (!paths.isEmpty()) {
            this.myTree.scrollPathToVisible((TreePath)paths.get(0));
        }
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        MyPanel myPanel = this.myRootPanel;
        if (myPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewImpl", "getComponent"));
        }
        return myPanel;
    }

    @Override
    public int getUsagesCount() {
        return this.myUsageNodes.size();
    }

    void setContent(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/usages/impl/UsageViewImpl", "setContent"));
        }
        this.myContent = content;
        content.setDisposer(this);
    }

    private void updateImmediately() {
        if (this.myProject.isDisposed()) {
            return;
        }
        TreeNode root = (TreeNode)this.myTree.getModel().getRoot();
        this.checkNodeValidity(root, new TreePath(root));
        this.updateOnSelectionChanged();
    }

    private void updateImmediatelyNodesUpToRoot(@NotNull List<TreeNode> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/usages/impl/UsageViewImpl", "updateImmediatelyNodesUpToRoot"));
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        TreeNode root = (TreeNode)this.myTree.getModel().getRoot();
        for (int i = 0; i < nodes.size(); ++i) {
            TreeNode node = nodes.get(i);
            if (!(node instanceof Node)) continue;
            ((Node)node).update(this, this.edtQueue);
            TreeNode parent = node.getParent();
            if (parent == root || parent == null) continue;
            nodes.add(parent);
        }
        this.updateImmediately();
    }

    private void updateOnSelectionChanged() {
        if (this.myCurrentUsageContextPanel != null) {
            try {
                this.myCurrentUsageContextPanel.updateLayout(this.getSelectedUsageInfos());
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
    }

    private void checkNodeValidity(@NotNull TreeNode node, @NotNull TreePath path2) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/usages/impl/UsageViewImpl", "checkNodeValidity"));
        }
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/usages/impl/UsageViewImpl", "checkNodeValidity"));
        }
        boolean shouldCheckChildren = true;
        if (this.myTree.isCollapsed(path2)) {
            if (node instanceof Node) {
                ((Node)node).markNeedUpdate();
            }
            shouldCheckChildren = false;
        }
        UsageViewTreeCellRenderer.RowLocation isVisible = this.myUsageViewTreeCellRenderer.isRowVisible(this.myTree.getRowForPath(new TreePath(((DefaultMutableTreeNode)node).getPath())), this.myTree.getVisibleRect());
        if (shouldCheckChildren && isVisible != UsageViewTreeCellRenderer.RowLocation.AFTER_VISIBLE_RECT) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                TreeNode child = node.getChildAt(i);
                this.checkNodeValidity(child, path2.pathByAddingChild(child));
            }
        }
        if (node instanceof Node && node != this.getModelRoot() && isVisible == UsageViewTreeCellRenderer.RowLocation.INSIDE_VISIBLE_RECT) {
            try {
                ((Node)node).update(this, this.edtQueue);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
    }

    private void updateLater() {
        this.myUpdateAlarm.cancelAllRequests();
        this.myUpdateAlarm.addRequest(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myProject);
            documentManager.cancelAndRunWhenAllCommitted((Object)"UpdateUsageView", () -> this.updateImmediately());
        }, 300);
    }

    @Override
    public void close() {
        this.cancelCurrentSearch();
        com.intellij.usageView.UsageViewManager.getInstance(this.myProject).closeContent(this.myContent);
    }

    private void saveSplitterProportions() {
        UsageViewSettings.getInstance().PREVIEW_USAGES_SPLITTER_PROPORTIONS = this.myPreviewSplitter.getProportion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.disposeUsageContextPanels();
        Object object = this.lock;
        synchronized (object) {
            this.isDisposed = true;
            ToolTipManager.sharedInstance().unregisterComponent(this.myTree);
            this.myModelTracker.removeListener(this);
            this.myUpdateAlarm.cancelAllRequests();
        }
        this.disposeSmartPointers();
    }

    private void disposeSmartPointers() {
        SmartPointerManager pointerManager = SmartPointerManager.getInstance(this.getProject());
        for (Usage usage : this.myUsageNodes.keySet()) {
            if (!(usage instanceof UsageInfo2UsageAdapter)) continue;
            SmartPsiElementPointer<?> pointer = ((UsageInfo2UsageAdapter)usage).getUsageInfo().getSmartPointer();
            pointerManager.removePointer(pointer);
        }
    }

    @Override
    public boolean isSearchInProgress() {
        return this.mySearchInProgress;
    }

    public void setSearchInProgress(boolean searchInProgress) {
        this.mySearchInProgress = searchInProgress;
        if (!this.myPresentation.isDetachedMode()) {
            this.myTransferToEDTQueue.offer(() -> {
                if (this.isDisposed) {
                    return;
                }
                UsageNode firstUsageNode = this.myModel.getFirstUsageNode();
                if (firstUsageNode == null) {
                    return;
                }
                Node node = this.getSelectedNode();
                if (node != null && !Comparing.equal((Object)new TreePath(node.getPath()), (Object)TreeUtil.getFirstNodePath(this.myTree))) {
                    return;
                }
                this.showNode(firstUsageNode);
                if (UsageViewSettings.getInstance().isExpanded() && this.myUsageNodes.size() < 10000) {
                    this.expandAll();
                }
            });
        }
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    private void showNode(@NotNull UsageNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/usages/impl/UsageViewImpl", "showNode"));
        }
        if (!this.myPresentation.isDetachedMode()) {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/usages/impl/UsageViewImpl", "lambda$showNode$15"));
                }
                if (this.isDisposed) {
                    return;
                }
                TreePath usagePath = new TreePath(node.getPath());
                this.myTree.expandPath(usagePath.getParentPath());
                TreeUtil.selectPath(this.myTree, usagePath);
            });
        }
    }

    @Override
    public void addButtonToLowerPane(@NotNull Runnable runnable, @NotNull String text) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/usages/impl/UsageViewImpl", "addButtonToLowerPane"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/usages/impl/UsageViewImpl", "addButtonToLowerPane"));
        }
        int index = this.myButtonPanel.getComponentCount();
        if (!SystemInfo.isMac && index > 0 && this.myPresentation.isShowCancelButton()) {
            --index;
        }
        this.myButtonPanel.addButtonRunnable(index, runnable, text);
    }

    @Override
    public void setAdditionalComponent(@Nullable JComponent comp) {
        BorderLayout layout = (BorderLayout)this.myAdditionalComponent.getLayout();
        Component prev = layout.getLayoutComponent(this.myAdditionalComponent, "Center");
        if (prev == comp) {
            return;
        }
        if (prev != null) {
            this.myAdditionalComponent.remove(prev);
        }
        if (comp != null) {
            this.myAdditionalComponent.add((Component)comp, "Center");
        }
        this.myAdditionalComponent.revalidate();
    }

    @Override
    public void addButtonToLowerPane(@NotNull Runnable runnable, @NotNull String text, char mnemonic) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/usages/impl/UsageViewImpl", "addButtonToLowerPane"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/usages/impl/UsageViewImpl", "addButtonToLowerPane"));
        }
        this.addButtonToLowerPane(runnable, text);
    }

    @Override
    public void addPerformOperationAction(@NotNull Runnable processRunnable, String commandName, String cannotMakeString, @NotNull String shortDescription) {
        if (processRunnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processRunnable", "com/intellij/usages/impl/UsageViewImpl", "addPerformOperationAction"));
        }
        if (shortDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortDescription", "com/intellij/usages/impl/UsageViewImpl", "addPerformOperationAction"));
        }
        this.addPerformOperationAction(processRunnable, commandName, cannotMakeString, shortDescription, true);
    }

    @Override
    public void addPerformOperationAction(@NotNull Runnable processRunnable, String commandName, String cannotMakeString, @NotNull String shortDescription, boolean checkReadOnlyStatus) {
        if (processRunnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processRunnable", "com/intellij/usages/impl/UsageViewImpl", "addPerformOperationAction"));
        }
        if (shortDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortDescription", "com/intellij/usages/impl/UsageViewImpl", "addPerformOperationAction"));
        }
        this.addButtonToLowerPane(this.newPerformOperationRunnable(processRunnable, commandName, cannotMakeString, checkReadOnlyStatus), shortDescription);
    }

    public MyPerformOperationRunnable newPerformOperationRunnable(Runnable processRunnable, String commandName, String cannotMakeString, boolean checkReadOnlyStatus) {
        return new MyPerformOperationRunnable(cannotMakeString, processRunnable, commandName, checkReadOnlyStatus);
    }

    private boolean allTargetsAreValid() {
        for (UsageTarget target : this.myTargets) {
            if (target.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public UsageViewPresentation getPresentation() {
        UsageViewPresentation usageViewPresentation = this.myPresentation;
        if (usageViewPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewImpl", "getPresentation"));
        }
        return usageViewPresentation;
    }

    public boolean canPerformReRun() {
        return this.myUsageSearcherFactory != null && this.allTargetsAreValid();
    }

    private boolean checkReadonlyUsages() {
        Set<VirtualFile> readOnlyUsages = this.getReadOnlyUsagesFiles();
        return readOnlyUsages.isEmpty() || !ReadonlyStatusHandler.getInstance(this.myProject).ensureFilesWritable(VfsUtilCore.toVirtualFileArray(readOnlyUsages)).hasReadonlyFiles();
    }

    @NotNull
    private Set<Usage> getReadOnlyUsages() {
        THashSet result = new THashSet();
        Set<Map.Entry<Usage, UsageNode>> usages = this.myUsageNodes.entrySet();
        for (Map.Entry<Usage, UsageNode> entry : usages) {
            Usage usage = entry.getKey();
            UsageNode node = entry.getValue();
            if (node == null || node == NULL_NODE || node.isExcluded() || !usage.isReadOnly()) continue;
            result.add(usage);
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewImpl", "getReadOnlyUsages"));
        }
        return tHashSet;
    }

    @NotNull
    private Set<VirtualFile> getReadOnlyUsagesFiles() {
        Set<Usage> usages = this.getReadOnlyUsages();
        THashSet result = new THashSet();
        for (Usage usage : usages) {
            UsageInFile usageInFile;
            VirtualFile file;
            if (usage instanceof UsageInFile && (file = (usageInFile = (UsageInFile)usage).getFile()) != null && file.isValid()) {
                result.add(file);
            }
            if (!(usage instanceof UsageInFiles)) continue;
            UsageInFiles usageInFiles = (UsageInFiles)((Object)usage);
            ContainerUtil.addAll((Collection)result, (Object[])usageInFiles.getFiles());
        }
        for (UsageTarget target : this.myTargets) {
            Object[] files = target.getFiles();
            if (files == null) continue;
            ContainerUtil.addAll((Collection)result, (Object[])files);
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewImpl", "getReadOnlyUsagesFiles"));
        }
        return tHashSet;
    }

    @Override
    @NotNull
    public Set<Usage> getExcludedUsages() {
        THashSet result = new THashSet();
        for (Map.Entry<Usage, UsageNode> entry : this.myUsageNodes.entrySet()) {
            UsageNode node = entry.getValue();
            Usage usage = entry.getKey();
            if (node == NULL_NODE || node == null || !node.isExcluded()) continue;
            result.add(usage);
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewImpl", "getExcludedUsages"));
        }
        return tHashSet;
    }

    @Nullable
    private Node getSelectedNode() {
        TreePath leadSelectionPath = this.myTree.getLeadSelectionPath();
        if (leadSelectionPath == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)leadSelectionPath.getLastPathComponent();
        return node instanceof Node ? (Node)node : null;
    }

    @Nullable
    private Node[] getSelectedNodes() {
        TreePath[] leadSelectionPath = this.myTree.getSelectionPaths();
        if (leadSelectionPath == null || leadSelectionPath.length == 0) {
            return null;
        }
        ArrayList<Node> result = new ArrayList<Node>();
        for (TreePath comp : leadSelectionPath) {
            Object lastPathComponent = comp.getLastPathComponent();
            if (!(lastPathComponent instanceof Node)) continue;
            Node node = (Node)lastPathComponent;
            result.add(node);
        }
        return result.isEmpty() ? null : result.toArray(new Node[result.size()]);
    }

    @Override
    @Nullable
    public Set<Usage> getSelectedUsages() {
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        if (selectionPaths == null) {
            return null;
        }
        THashSet usages = new THashSet();
        for (TreePath selectionPath : selectionPaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
            UsageViewImpl.collectUsages(node, (Set<Usage>)usages);
        }
        return usages;
    }

    @Override
    @NotNull
    public Set<Usage> getUsages() {
        Set<Usage> set = this.myUsageNodes.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewImpl", "getUsages"));
        }
        return set;
    }

    @Override
    @NotNull
    public List<Usage> getSortedUsages() {
        ArrayList<Usage> usages = new ArrayList<Usage>(this.getUsages());
        Collections.sort(usages, USAGE_COMPARATOR);
        ArrayList<Usage> arrayList = usages;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewImpl", "getSortedUsages"));
        }
        return arrayList;
    }

    private static void collectUsages(@NotNull DefaultMutableTreeNode node, @NotNull Set<Usage> usages) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/usages/impl/UsageViewImpl", "collectUsages"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/usages/impl/UsageViewImpl", "collectUsages"));
        }
        if (node instanceof UsageNode) {
            UsageNode usageNode = (UsageNode)node;
            Usage usage = usageNode.getUsage();
            usages.add(usage);
        }
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)enumeration.nextElement();
            UsageViewImpl.collectUsages(child, usages);
        }
    }

    @Nullable
    private UsageTarget[] getSelectedUsageTargets() {
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        if (selectionPaths == null) {
            return null;
        }
        THashSet targets = new THashSet();
        for (TreePath selectionPath : selectionPaths) {
            UsageTargetNode usageTargetNode;
            UsageTarget target;
            Object lastPathComponent = selectionPath.getLastPathComponent();
            if (!(lastPathComponent instanceof UsageTargetNode) || !(target = (usageTargetNode = (UsageTargetNode)lastPathComponent).getTarget()).isValid()) continue;
            targets.add(target);
        }
        return targets.isEmpty() ? null : targets.toArray(new UsageTarget[targets.size()]);
    }

    @Nullable
    private static Navigatable getNavigatableForNode(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/usages/impl/UsageViewImpl", "getNavigatableForNode"));
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof Navigatable) {
            Navigatable navigatable = (Navigatable)userObject;
            return navigatable.canNavigate() ? navigatable : null;
        }
        return null;
    }

    private static Navigatable[] getNavigatablesForNodes(Node[] nodes) {
        if (nodes == null) {
            return null;
        }
        ArrayList<Navigatable> result = new ArrayList<Navigatable>();
        for (Node node : nodes) {
            Object userObject = node.getUserObject();
            if (!(userObject instanceof Navigatable)) continue;
            result.add((Navigatable)userObject);
        }
        return result.toArray(new Navigatable[result.size()]);
    }

    public boolean areTargetsValid() {
        return this.myModel.areTargetsValid();
    }

    private List<UsageInfo> getSelectedUsageInfos() {
        return (List)USAGE_INFO_LIST_KEY.getData(DataManager.getInstance().getDataContext(this.myRootPanel));
    }

    public GroupNode getRoot() {
        return this.myRoot;
    }

    public boolean isVisible(@NotNull Usage usage) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/usages/impl/UsageViewImpl", "isVisible"));
        }
        return this.myBuilder != null && this.myBuilder.isVisible(usage);
    }

    @NotNull
    public UsageTarget[] getTargets() {
        if (this.myTargets == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewImpl", "getTargets"));
        }
        return this.myTargets;
    }

    private /* synthetic */ void lambda$removeUsagesBulk$11(Set nodes) {
        if (this.isDisposed) {
            return;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)this.myTree.getModel();
        for (UsageNode node : nodes) {
            MutableTreeNode parent = (MutableTreeNode)node.getParent();
            int childIndex = parent.getIndex(node);
            if (childIndex == -1) continue;
            parent.remove(childIndex);
        }
        ((GroupNode)this.myTree.getModel().getRoot()).removeUsagesBulk(nodes);
        treeModel.reload();
    }

    private class MyPerformOperationRunnable
    implements Runnable {
        private final String myCannotMakeString;
        private final Runnable myProcessRunnable;
        private final String myCommandName;
        private final boolean myCheckReadOnlyStatus;

        private MyPerformOperationRunnable(String cannotMakeString, Runnable processRunnable, String commandName, boolean checkReadOnlyStatus) {
            this.myCannotMakeString = cannotMakeString;
            this.myProcessRunnable = processRunnable;
            this.myCommandName = commandName;
            this.myCheckReadOnlyStatus = checkReadOnlyStatus;
        }

        @Override
        public void run() {
            if (this.myCheckReadOnlyStatus && !UsageViewImpl.this.checkReadonlyUsages()) {
                return;
            }
            PsiDocumentManager.getInstance(UsageViewImpl.this.myProject).commitAllDocuments();
            if (this.myCannotMakeString != null && UsageViewImpl.this.myChangesDetected) {
                String title = UsageViewBundle.message("changes.detected.error.title", new Object[0]);
                if (UsageViewImpl.this.canPerformReRun()) {
                    String[] options = new String[]{UsageViewBundle.message("action.description.rerun", new Object[0]), UsageViewBundle.message("usage.view.cancel.button", new Object[0])};
                    String message = this.myCannotMakeString + "\n\n" + UsageViewBundle.message("dialog.rerun.search", new Object[0]);
                    int answer = Messages.showOkCancelDialog(UsageViewImpl.this.myProject, message, title, options[0], options[1], Messages.getErrorIcon());
                    if (answer == 0) {
                        UsageViewImpl.this.refreshUsages();
                    }
                } else {
                    Messages.showMessageDialog(UsageViewImpl.this.myProject, this.myCannotMakeString, title, Messages.getErrorIcon());
                }
                return;
            }
            UsageViewImpl.this.close();
            CommandProcessor.getInstance().executeCommand(UsageViewImpl.this.myProject, () -> this.myProcessRunnable.run(), this.myCommandName, null);
        }
    }

    private class UsageState {
        private final Usage myUsage;
        private final boolean mySelected;

        private UsageState(Usage usage, boolean isSelected) {
            if (usage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/usages/impl/UsageViewImpl$UsageState", "<init>"));
            }
            this.myUsage = usage;
            this.mySelected = isSelected;
        }

        public void restore() {
            UsageNode node = (UsageNode)UsageViewImpl.this.myUsageNodes.get(this.myUsage);
            if (node == NULL_NODE || node == null) {
                return;
            }
            DefaultMutableTreeNode parentGroupingNode = (DefaultMutableTreeNode)node.getParent();
            if (parentGroupingNode != null) {
                TreePath treePath = new TreePath(parentGroupingNode.getPath());
                UsageViewImpl.this.myTree.expandPath(treePath);
                if (this.mySelected) {
                    UsageViewImpl.this.myTree.addSelectionPath(treePath.pathByAddingChild(node));
                }
            }
        }
    }

    private final class ButtonPanel
    extends JPanel {
        private ButtonPanel() {
            this.setLayout(new FlowLayout(0, 8, 0));
        }

        private void addButtonRunnable(int index, final Runnable runnable, String text) {
            if (this.getBorder() == null) {
                this.setBorder(IdeBorderFactory.createBorder(2));
            }
            JButton button = new JButton(UIUtil.replaceMnemonicAmpersand((String)text));
            DialogUtil.registerMnemonic(button);
            DumbService.getInstance(UsageViewImpl.this.myProject).makeDumbAware(button, UsageViewImpl.this);
            button.setFocusable(false);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    runnable.run();
                }
            });
            this.add((Component)button, index);
            this.invalidate();
            if (this.getParent() != null) {
                this.getParent().validate();
            }
        }

        void update() {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof JButton)) continue;
                JButton button = (JButton)component;
                button.setEnabled(!UsageViewImpl.this.isSearchInProgress());
            }
        }
    }

    private static class MyAutoScrollToSourceOptionProvider
    implements AutoScrollToSourceOptionProvider {
        private MyAutoScrollToSourceOptionProvider() {
        }

        @Override
        public boolean isAutoScrollMode() {
            return UsageViewSettings.getInstance().IS_AUTOSCROLL_TO_SOURCE;
        }

        @Override
        public void setAutoScrollMode(boolean state) {
            UsageViewSettings.getInstance().IS_AUTOSCROLL_TO_SOURCE = state;
        }
    }

    private class MyPanel
    extends JPanel
    implements TypeSafeDataProvider,
    OccurenceNavigator,
    Disposable {
        @Nullable
        private OccurenceNavigatorSupport mySupport;
        private CopyProvider myCopyProvider;

        private MyPanel(JTree tree) {
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/usages/impl/UsageViewImpl$MyPanel", "<init>"));
            }
            this.mySupport = new OccurenceNavigatorSupport(tree){

                @Override
                protected Navigatable createDescriptorForNode(DefaultMutableTreeNode node) {
                    if (node.getChildCount() > 0) {
                        return null;
                    }
                    if (node instanceof Node && ((Node)node).isExcluded()) {
                        return null;
                    }
                    return UsageViewImpl.getNavigatableForNode(node);
                }

                @Override
                public String getNextOccurenceActionName() {
                    return UsageViewBundle.message("action.next.occurrence", new Object[0]);
                }

                @Override
                public String getPreviousOccurenceActionName() {
                    return UsageViewBundle.message("action.previous.occurrence", new Object[0]);
                }
            };
            this.myCopyProvider = new TextCopyProvider(){

                @Override
                @Nullable
                public Collection<String> getTextLinesToCopy() {
                    Node[] selectedNodes = UsageViewImpl.this.getSelectedNodes();
                    if (selectedNodes != null && selectedNodes.length > 0) {
                        ArrayList lines = ContainerUtil.newArrayList();
                        for (Node node : selectedNodes) {
                            lines.add(node.getText(UsageViewImpl.this));
                        }
                        return lines;
                    }
                    return null;
                }
            };
        }

        public void dispose() {
            this.mySupport = null;
        }

        @Override
        public boolean hasNextOccurence() {
            return this.mySupport != null && this.mySupport.hasNextOccurence();
        }

        @Override
        public boolean hasPreviousOccurence() {
            return this.mySupport != null && this.mySupport.hasPreviousOccurence();
        }

        @Override
        public OccurenceNavigator.OccurenceInfo goNextOccurence() {
            return this.mySupport != null ? this.mySupport.goNextOccurence() : null;
        }

        @Override
        public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
            return this.mySupport != null ? this.mySupport.goPreviousOccurence() : null;
        }

        @Override
        public String getNextOccurenceActionName() {
            return this.mySupport != null ? this.mySupport.getNextOccurenceActionName() : "";
        }

        @Override
        public String getPreviousOccurenceActionName() {
            return this.mySupport != null ? this.mySupport.getPreviousOccurenceActionName() : "";
        }

        @Override
        public void calcData(DataKey key, DataSink sink) {
            Node node = UsageViewImpl.this.getSelectedNode();
            if (key == CommonDataKeys.PROJECT) {
                sink.put(CommonDataKeys.PROJECT, UsageViewImpl.this.myProject);
            } else if (key == UsageView.USAGE_VIEW_KEY) {
                sink.put(UsageView.USAGE_VIEW_KEY, UsageViewImpl.this);
            } else if (key == ExclusionHandler.EXCLUSION_HANDLER) {
                sink.put(ExclusionHandler.EXCLUSION_HANDLER, UsageViewImpl.this.myExclusionHandler);
            } else if (key == CommonDataKeys.NAVIGATABLE_ARRAY) {
                sink.put(CommonDataKeys.NAVIGATABLE_ARRAY, UsageViewImpl.getNavigatablesForNodes(UsageViewImpl.this.getSelectedNodes()));
            } else if (key == PlatformDataKeys.EXPORTER_TO_TEXT_FILE) {
                sink.put(PlatformDataKeys.EXPORTER_TO_TEXT_FILE, UsageViewImpl.this.myTextFileExporter);
            } else if (key == UsageView.USAGES_KEY) {
                Set<Usage> selectedUsages = UsageViewImpl.this.getSelectedUsages();
                sink.put(UsageView.USAGES_KEY, selectedUsages != null ? selectedUsages.toArray(new Usage[selectedUsages.size()]) : null);
            } else if (key == UsageView.USAGE_TARGETS_KEY) {
                sink.put(UsageView.USAGE_TARGETS_KEY, UsageViewImpl.this.getSelectedUsageTargets());
            } else if (key == CommonDataKeys.VIRTUAL_FILE_ARRAY) {
                Set<Usage> usages = UsageViewImpl.this.getSelectedUsages();
                Usage[] ua = usages != null ? usages.toArray(new Usage[usages.size()]) : null;
                VirtualFile[] data = UsageDataUtil.provideVirtualFileArray(ua, UsageViewImpl.this.getSelectedUsageTargets());
                sink.put(CommonDataKeys.VIRTUAL_FILE_ARRAY, data);
            } else if (key == PlatformDataKeys.HELP_ID) {
                sink.put(PlatformDataKeys.HELP_ID, UsageViewImpl.HELP_ID);
            } else if (key == PlatformDataKeys.COPY_PROVIDER) {
                sink.put(PlatformDataKeys.COPY_PROVIDER, this.myCopyProvider);
            } else if (node != null) {
                DataProvider dataProvider;
                Object data;
                Object userObject = node.getUserObject();
                if (userObject instanceof TypeSafeDataProvider) {
                    ((TypeSafeDataProvider)userObject).calcData(key, sink);
                } else if (userObject instanceof DataProvider && (data = (dataProvider = (DataProvider)userObject).getData(key.getName())) != null) {
                    sink.put(key, data);
                }
            }
        }
    }

    private class MergeDupLines
    extends RuleAction {
        private MergeDupLines() {
            super(UsageViewImpl.this, UsageViewBundle.message("action.merge.same.line", new Object[0]), AllIcons.Toolbar.Filterdups);
            this.setShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(70, 128)));
        }

        @Override
        protected boolean getOptionValue() {
            return UsageViewSettings.getInstance().isFilterDuplicatedLine();
        }

        @Override
        protected void setOptionValue(boolean value) {
            UsageViewSettings.getInstance().setFilterDuplicatedLine(value);
        }
    }

    private class CloseAction
    extends CloseTabToolbarAction {
        private CloseAction() {
        }

        @Override
        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setVisible(UsageViewImpl.this.myContent != null);
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            UsageViewImpl.this.close();
        }
    }
}

