/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InitialPatternCondition<T> {
    private final Class<T> myAcceptedClass;

    protected InitialPatternCondition(@NotNull Class<T> aAcceptedClass) {
        if (aAcceptedClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aAcceptedClass", "com/intellij/patterns/InitialPatternCondition", "<init>"));
        }
        this.myAcceptedClass = aAcceptedClass;
    }

    @NotNull
    public Class<T> getAcceptedClass() {
        Class<T> clazz = this.myAcceptedClass;
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/InitialPatternCondition", "getAcceptedClass"));
        }
        return clazz;
    }

    public boolean accepts(@Nullable Object o, ProcessingContext context) {
        return this.myAcceptedClass.isInstance(o);
    }

    @NonNls
    public final String toString() {
        StringBuilder builder = new StringBuilder();
        this.append(builder, "");
        return builder.toString();
    }

    public void append(@NonNls @NotNull StringBuilder builder, String indent) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/InitialPatternCondition", "append"));
        }
        builder.append("instanceOf(").append(this.myAcceptedClass.getSimpleName()).append(")");
    }
}

