/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.testingUtils;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.incremental.testingUtils.IncrementalModificationUtilsKt;
import org.jetbrains.kotlin.incremental.testingUtils.Modification;
import org.jetbrains.kotlin.incremental.testingUtils.TouchFile;
import org.jetbrains.kotlin.incremental.testingUtils.TouchPolicy;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0002\u001a:\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00010\u00012\u0006\u0010\b\u001a\u00020\u00072\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"COMMANDS", "", "", "COMMANDS_AS_MESSAGE_PART", "COMMANDS_AS_REGEX_PART", "copyTestSources", "", "Ljava/io/File;", "testDataDir", "sourceDestinationDir", "filePrefix", "getModificationsToPerform", "Lorg/jetbrains/kotlin/incremental/testingUtils/Modification;", "moduleNames", "", "allowNoFilesWithSuffixInTestData", "", "touchPolicy", "Lorg/jetbrains/kotlin/incremental/testingUtils/TouchPolicy;", "kotlin-build-common"})
public final class IncrementalModificationUtilsKt {
    private static final List<String> COMMANDS = CollectionsKt.listOf((Object[])new String[]{"new", "touch", "delete"});
    private static final String COMMANDS_AS_REGEX_PART = CollectionsKt.joinToString$default((Iterable)COMMANDS, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null);
    private static final String COMMANDS_AS_MESSAGE_PART = CollectionsKt.joinToString$default((Iterable)COMMANDS, (CharSequence)"/", null, null, (int)0, null, (Function1)COMMANDS_AS_MESSAGE_PART.1.INSTANCE, (int)30, null);

    @NotNull
    public static final Map<File, File> copyTestSources(@NotNull File testDataDir, @NotNull File sourceDestinationDir, @NotNull String filePrefix) {
        if (testDataDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testDataDir", "org/jetbrains/kotlin/incremental/testingUtils/IncrementalModificationUtilsKt", "copyTestSources"));
        }
        if (sourceDestinationDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceDestinationDir", "org/jetbrains/kotlin/incremental/testingUtils/IncrementalModificationUtilsKt", "copyTestSources"));
        }
        if (filePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePrefix", "org/jetbrains/kotlin/incremental/testingUtils/IncrementalModificationUtilsKt", "copyTestSources"));
        }
        Intrinsics.checkParameterIsNotNull((Object)testDataDir, (String)"testDataDir");
        Intrinsics.checkParameterIsNotNull((Object)sourceDestinationDir, (String)"sourceDestinationDir");
        Intrinsics.checkParameterIsNotNull((Object)filePrefix, (String)"filePrefix");
        HashMap mapping = MapsKt.hashMapOf((Pair[])new Pair[0]);
        FileUtil.copyDir((File)testDataDir, (File)sourceDestinationDir, (FileFilter)new FileFilter(filePrefix){
            final /* synthetic */ String $filePrefix;

            public final boolean accept(File it) {
                return it.isDirectory() || StringsKt.startsWith$default((String)it.getName(), (String)this.$filePrefix, (boolean)false, (int)2, null) && (StringsKt.endsWith$default((String)it.getName(), (String)".kt", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it.getName(), (String)".java", (boolean)false, (int)2, null));
            }
            {
                this.$filePrefix = string;
            }
        });
        for (File file : FilesKt.walk$default((File)sourceDestinationDir, null, (int)1, null)) {
            File file2;
            if (!file.isFile()) continue;
            Object object = filePrefix;
            if (object.length() == 0) {
                file2 = file;
            } else {
                object = new File(sourceDestinationDir, StringsKt.removePrefix((String)file.getName(), (CharSequence)filePrefix));
                File $receiver = (File)object;
                file.renameTo($receiver);
                file2 = (File)object;
            }
            File renamedFile = file2;
            object = mapping;
            File file3 = new File(testDataDir, file.getName());
            object.put(renamedFile, file3);
        }
        Map map = mapping;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/incremental/testingUtils/IncrementalModificationUtilsKt", "copyTestSources"));
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<List<Modification>> getModificationsToPerform(@NotNull File testDataDir, @Nullable Collection<String> moduleNames, boolean allowNoFilesWithSuffixInTestData, @NotNull TouchPolicy touchPolicy) {
        Collection destination$iv$iv;
        Iterable $receiver$iv$iv;
        boolean haveFilesWithNumbers;
        Object element$iv3;
        Iterable $receiver$iv;
        boolean haveFilesWithoutNumbers;
        Iterator iterator;
        Object element$iv22;
        Function3<String, String, String, List<? extends Modification>> getModificationsForIteration$;
        block14: {
            boolean bl;
            boolean bl2;
            CharSequence charSequence;
            block13: {
                void $receiver$iv2;
                if (testDataDir == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testDataDir", "org/jetbrains/kotlin/incremental/testingUtils/IncrementalModificationUtilsKt", "getModificationsToPerform"));
                }
                if (touchPolicy == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "touchPolicy", "org/jetbrains/kotlin/incremental/testingUtils/IncrementalModificationUtilsKt", "getModificationsToPerform"));
                }
                Intrinsics.checkParameterIsNotNull((Object)testDataDir, (String)"testDataDir");
                Intrinsics.checkParameterIsNotNull((Object)((Object)touchPolicy), (String)"touchPolicy");
                getModificationsForIteration$ = new Function3<String, String, String, List<? extends Modification>>(moduleNames, touchPolicy, testDataDir){
                    final /* synthetic */ Collection $moduleNames;
                    final /* synthetic */ TouchPolicy $touchPolicy;
                    final /* synthetic */ File $testDataDir;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final List<Modification> invoke(@NotNull String newSuffix, @NotNull String touchSuffix, @NotNull String deleteSuffix) {
                        if (newSuffix == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSuffix", "org/jetbrains/kotlin/incremental/testingUtils/IncrementalModificationUtilsKt$getModificationsToPerform$1", "invoke"));
                        }
                        if (touchSuffix == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "touchSuffix", "org/jetbrains/kotlin/incremental/testingUtils/IncrementalModificationUtilsKt$getModificationsToPerform$1", "invoke"));
                        }
                        if (deleteSuffix == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deleteSuffix", "org/jetbrains/kotlin/incremental/testingUtils/IncrementalModificationUtilsKt$getModificationsToPerform$1", "invoke"));
                        }
                        Intrinsics.checkParameterIsNotNull((Object)newSuffix, (String)"newSuffix");
                        Intrinsics.checkParameterIsNotNull((Object)touchSuffix, (String)"touchSuffix");
                        Intrinsics.checkParameterIsNotNull((Object)deleteSuffix, (String)"deleteSuffix");
                        Function1<String, Pair<? extends String, ? extends String>> splitToModuleNameAndFileName$ = new Function1<String, Pair<? extends String, ? extends String>>(this){
                            final /* synthetic */ getModificationsToPerform.1 this$0;

                            @NotNull
                            public final Pair<String, String> invoke(@NotNull String fileName) {
                                Unit unit;
                                if (fileName == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/kotlin/incremental/testingUtils/IncrementalModificationUtilsKt$getModificationsToPerform$1$1", "invoke"));
                                }
                                Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
                                int underscore = StringsKt.indexOf$default((CharSequence)fileName, (String)"_", (int)0, (boolean)false, (int)6, null);
                                if (underscore != -1) {
                                    Pair pair;
                                    Unit unit2;
                                    Unit unit3;
                                    String string = fileName;
                                    int n = 0;
                                    String string2 = string;
                                    if (string2 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                    }
                                    String string3 = string2.substring(n, underscore);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                    String module = string3;
                                    boolean bl = this.this$0.$moduleNames != null;
                                    if (_Assertions.ENABLED) {
                                        if (!bl) {
                                            String string4 = "File name has module prefix, but multi-module environment is absent";
                                            throw (Throwable)((Object)new AssertionError((Object)string4));
                                        }
                                        unit3 = Unit.INSTANCE;
                                    } else {
                                        unit3 = Unit.INSTANCE;
                                    }
                                    Collection collection = this.this$0.$moduleNames;
                                    if (collection == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    bl = collection.contains(module);
                                    if (_Assertions.ENABLED) {
                                        if (!bl) {
                                            String string5 = "Module not found for file with prefix: " + fileName;
                                            throw (Throwable)((Object)new AssertionError((Object)string5));
                                        }
                                        unit2 = Unit.INSTANCE;
                                    } else {
                                        unit2 = Unit.INSTANCE;
                                    }
                                    String string6 = fileName;
                                    n = underscore + 1;
                                    String string7 = module;
                                    Pair pair2 = pair;
                                    Pair pair3 = pair;
                                    String string8 = string6;
                                    if (string8 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                    }
                                    String string9 = string8.substring(n);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
                                    String string10 = string9;
                                    Pair pair4 = pair3;
                                    pair2((Object)string7, (Object)string10);
                                    if (pair4 == null) {
                                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/incremental/testingUtils/IncrementalModificationUtilsKt$getModificationsToPerform$1$1", "invoke"));
                                    }
                                    return pair4;
                                }
                                boolean bl = this.this$0.$moduleNames == null;
                                if (_Assertions.ENABLED) {
                                    if (!bl) {
                                        String string = "Test is multi-module, but file has no module prefix: " + fileName;
                                        throw (Throwable)((Object)new AssertionError((Object)string));
                                    }
                                    unit = Unit.INSTANCE;
                                } else {
                                    unit = Unit.INSTANCE;
                                }
                                Pair pair = new Pair(null, (Object)fileName);
                                if (pair == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/incremental/testingUtils/IncrementalModificationUtilsKt$getModificationsToPerform$1$1", "invoke"));
                                }
                                return pair;
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        };
                        Map rules2 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)newSuffix, (Object)((Object)getModificationsToPerform.rules.1.INSTANCE)), TuplesKt.to((Object)touchSuffix, (Object)new Function2<String, File, TouchFile>(this){
                            final /* synthetic */ getModificationsToPerform.1 this$0;

                            @NotNull
                            public final TouchFile invoke(@NotNull String path, @NotNull File file) {
                                if (path == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/kotlin/incremental/testingUtils/IncrementalModificationUtilsKt$getModificationsToPerform$1$rules$2", "invoke"));
                                }
                                if (file == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/incremental/testingUtils/IncrementalModificationUtilsKt$getModificationsToPerform$1$rules$2", "invoke"));
                                }
                                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                                TouchFile touchFile = new TouchFile(path, this.this$0.$touchPolicy);
                                if (touchFile == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/incremental/testingUtils/IncrementalModificationUtilsKt$getModificationsToPerform$1$rules$2", "invoke"));
                                }
                                return touchFile;
                            }
                            {
                                this.this$0 = var1_1;
                                super(2);
                            }
                        }), TuplesKt.to((Object)deleteSuffix, (Object)((Object)getModificationsToPerform.rules.3.INSTANCE))});
                        ArrayList<Object> modifications = new ArrayList<Object>();
                        for (File file : FilesKt.walkTopDown((File)this.$testDataDir)) {
                            void suffix;
                            void fileName;
                            void createModification;
                            String string;
                            block12: {
                                block11: {
                                    void moduleName;
                                    Object object;
                                    Object v0;
                                    Object it;
                                    Iterator<T> iterator;
                                    Object $receiver$iv;
                                    String relativeFilePath;
                                    block10: {
                                        if (!file.isFile()) continue;
                                        relativeFilePath = FilesKt.toRelativeString((File)file, (File)this.$testDataDir);
                                        Iterable iterable = rules2.entrySet();
                                        iterator = $receiver$iv.iterator();
                                        while (iterator.hasNext()) {
                                            T element$iv = iterator.next();
                                            it = (Map.Entry)element$iv;
                                            if (!StringsKt.endsWith$default((String)file.getPath(), (String)((String)it.getKey()), (boolean)false, (int)2, null)) continue;
                                            v0 = element$iv;
                                            break block10;
                                        }
                                        v0 = null;
                                    }
                                    Map.Entry entry = v0;
                                    if (entry == null) {
                                        continue;
                                    }
                                    $receiver$iv = object = entry;
                                    String string2 = (String)$receiver$iv.getKey();
                                    $receiver$iv = object;
                                    Function2 function2 = (Function2)$receiver$iv.getValue();
                                    object = null;
                                    iterator = splitToModuleNameAndFileName$.invoke(relativeFilePath);
                                    object = (String)iterator.component1();
                                    $receiver$iv = (String)iterator.component2();
                                    iterator = null;
                                    string = moduleName;
                                    if (string == null) break block11;
                                    void var12_12 = string;
                                    it = (String)var12_12;
                                    string = (String)it + "/src";
                                    if (string != null) break block12;
                                }
                                string = "src";
                            }
                            String srcDir = string;
                            modifications.add(createModification.invoke((Object)(srcDir + "/" + StringsKt.removeSuffix((String)fileName, (CharSequence)((CharSequence)suffix))), (Object)file));
                        }
                        List list = modifications;
                        if (list == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/incremental/testingUtils/IncrementalModificationUtilsKt$getModificationsToPerform$1", "invoke"));
                        }
                        return list;
                    }
                    {
                        this.$moduleNames = collection;
                        this.$touchPolicy = touchPolicy;
                        this.$testDataDir = file;
                        super(3);
                    }
                };
                Sequence sequence = (Sequence)FilesKt.walkTopDown((File)testDataDir);
                for (Object element$iv22 : $receiver$iv2) {
                    File it = (File)element$iv22;
                    iterator = it.getName();
                    charSequence = ".+" + "\\" + ".(" + COMMANDS_AS_REGEX_PART + ")" + "$";
                    charSequence = new Regex((String)charSequence);
                    if (!charSequence.matches((CharSequence)((Object)iterator))) continue;
                    bl2 = true;
                    break block13;
                }
                bl2 = false;
            }
            haveFilesWithoutNumbers = bl2;
            Iterator iterator2 = (Sequence)FilesKt.walkTopDown((File)testDataDir);
            for (Object element$iv3 : $receiver$iv) {
                File it = (File)element$iv3;
                charSequence = it.getName();
                String $i$a$1$any = ".+" + "\\" + ".(" + COMMANDS_AS_REGEX_PART + ")" + "\\" + "." + "\\" + "d+" + "$";
                $i$a$1$any = new Regex($i$a$1$any);
                if (!$i$a$1$any.matches(charSequence)) continue;
                bl = true;
                break block14;
            }
            bl = haveFilesWithNumbers = false;
        }
        if (haveFilesWithoutNumbers && haveFilesWithNumbers) {
            throw (Throwable)new IllegalStateException("Bad test data format: files ending with both unnumbered and numbered " + COMMANDS_AS_MESSAGE_PART + " were found");
        }
        if (!haveFilesWithoutNumbers && !haveFilesWithNumbers) {
            if (allowNoFilesWithSuffixInTestData) {
                List list = CollectionsKt.listOf((Object)CollectionsKt.emptyList());
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/incremental/testingUtils/IncrementalModificationUtilsKt", "getModificationsToPerform"));
                }
                return list;
            }
            throw (Throwable)new IllegalStateException("Bad test data format: no files ending with " + COMMANDS_AS_MESSAGE_PART + " found");
        }
        if (haveFilesWithoutNumbers) {
            List list = CollectionsKt.listOf(getModificationsForIteration$.invoke(".new", ".touch", ".delete"));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/incremental/testingUtils/IncrementalModificationUtilsKt", "getModificationsToPerform"));
            }
            return list;
        }
        $receiver$iv = (Iterable)new IntRange(1, 10);
        element$iv22 = $receiver$iv;
        element$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int $i$a$1$any = item$iv$iv = ((IntIterator)iterator).nextInt();
            void var13_18 = destination$iv$iv;
            List<Modification> list = getModificationsForIteration$.invoke(".new." + (int)it, ".touch." + (int)it, ".delete." + (int)it);
            var13_18.add(list);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            List it = (List)element$iv$iv;
            Collection collection = it;
            if (!(!collection.isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/incremental/testingUtils/IncrementalModificationUtilsKt", "getModificationsToPerform"));
        }
        return list;
    }
}

