/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.module.impl;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementType;
import org.jetbrains.jps.model.JpsElementTypeWithDefaultProperties;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsUrlList;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.ex.JpsNamedCompositeElementBase;
import org.jetbrains.jps.model.impl.JpsUrlListRole;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryCollection;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.impl.JpsLibraryCollectionImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryRole;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependenciesList;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.module.JpsSdkReferencesTable;
import org.jetbrains.jps.model.module.JpsTypedModule;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.model.module.impl.JpsDependenciesListImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleReferenceImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleSourceRootImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleSourceRootRole;
import org.jetbrains.jps.model.module.impl.JpsSdkReferencesTableImpl;

public class JpsModuleImpl<P extends JpsElement>
extends JpsNamedCompositeElementBase<JpsModuleImpl<P>>
implements JpsTypedModule<P> {
    private static final JpsUrlListRole CONTENT_ROOTS_ROLE = new JpsUrlListRole("content roots");
    private static final JpsUrlListRole EXCLUDED_ROOTS_ROLE = new JpsUrlListRole("excluded roots");
    private static final JpsElementChildRole<JpsDependenciesListImpl> DEPENDENCIES_LIST_CHILD_ROLE = JpsElementChildRoleBase.create((String)"dependencies");
    private final JpsModuleType<P> myModuleType;
    private final JpsLibraryCollection myLibraryCollection;

    public JpsModuleImpl(JpsModuleType<P> type, @NotNull String name, @NotNull P properties) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "<init>"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "<init>"));
        }
        super(name);
        this.myModuleType = type;
        this.myContainer.setChild(this.myModuleType.getPropertiesRole(), properties);
        this.myContainer.setChild((JpsElementChildRole)CONTENT_ROOTS_ROLE);
        this.myContainer.setChild((JpsElementChildRole)EXCLUDED_ROOTS_ROLE);
        this.myContainer.setChild(DEPENDENCIES_LIST_CHILD_ROLE, (JpsElement)new JpsDependenciesListImpl());
        this.getDependenciesList().addModuleSourceDependency();
        this.myLibraryCollection = new JpsLibraryCollectionImpl((JpsElementCollection<JpsLibrary>)((JpsElementCollection)this.myContainer.setChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE)));
        this.myContainer.setChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE);
        this.myContainer.setChild((JpsElementChildRole)JpsSdkReferencesTableImpl.ROLE);
    }

    private JpsModuleImpl(JpsModuleImpl<P> original) {
        super(original);
        this.myModuleType = original.myModuleType;
        this.myLibraryCollection = new JpsLibraryCollectionImpl((JpsElementCollection<JpsLibrary>)((JpsElementCollection)this.myContainer.getChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE)));
    }

    @NotNull
    public JpsModuleImpl<P> createCopy() {
        JpsModuleImpl<P> jpsModuleImpl = new JpsModuleImpl<P>(this);
        if (jpsModuleImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "createCopy"));
        }
        return jpsModuleImpl;
    }

    public JpsElementType<P> getType() {
        return this.myModuleType;
    }

    @NotNull
    public P getProperties() {
        JpsElement jpsElement = this.myContainer.getChild(this.myModuleType.getPropertiesRole());
        if (jpsElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "getProperties"));
        }
        return (P)jpsElement;
    }

    public <P extends JpsElement> JpsTypedModule<P> asTyped(@NotNull JpsModuleType<P> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "asTyped"));
        }
        return this.myModuleType.equals(type) ? this : null;
    }

    @NotNull
    public JpsUrlList getContentRootsList() {
        JpsUrlList jpsUrlList = (JpsUrlList)this.myContainer.getChild((JpsElementChildRole)CONTENT_ROOTS_ROLE);
        if (jpsUrlList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "getContentRootsList"));
        }
        return jpsUrlList;
    }

    @NotNull
    public JpsUrlList getExcludeRootsList() {
        JpsUrlList jpsUrlList = (JpsUrlList)this.myContainer.getChild((JpsElementChildRole)EXCLUDED_ROOTS_ROLE);
        if (jpsUrlList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "getExcludeRootsList"));
        }
        return jpsUrlList;
    }

    @NotNull
    public List<JpsModuleSourceRoot> getSourceRoots() {
        List list = ((JpsElementCollection)this.myContainer.getChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE)).getElements();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "getSourceRoots"));
        }
        return list;
    }

    @NotNull
    public <P extends JpsElement> Iterable<JpsTypedModuleSourceRoot<P>> getSourceRoots(@NotNull JpsModuleSourceRootType<P> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "getSourceRoots"));
        }
        Iterable iterable = ((JpsElementCollection)this.myContainer.getChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE)).getElementsOfType(type);
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "getSourceRoots"));
        }
        return iterable;
    }

    @NotNull
    public <P extends JpsElement> JpsModuleSourceRoot addSourceRoot(@NotNull String url, @NotNull JpsModuleSourceRootType<P> rootType) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addSourceRoot"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addSourceRoot"));
        }
        JpsModuleSourceRoot jpsModuleSourceRoot = this.addSourceRoot(url, rootType, (JpsElement)rootType.createDefaultProperties());
        if (jpsModuleSourceRoot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addSourceRoot"));
        }
        return jpsModuleSourceRoot;
    }

    @NotNull
    public <P extends JpsElement> JpsModuleSourceRoot addSourceRoot(@NotNull String url, @NotNull JpsModuleSourceRootType<P> rootType, @NotNull P properties) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addSourceRoot"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addSourceRoot"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addSourceRoot"));
        }
        JpsModuleSourceRootImpl<P> root = new JpsModuleSourceRootImpl<P>(url, rootType, properties);
        this.addSourceRoot((JpsModuleSourceRoot)root);
        JpsModuleSourceRootImpl<P> jpsModuleSourceRootImpl = root;
        if (jpsModuleSourceRootImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addSourceRoot"));
        }
        return jpsModuleSourceRootImpl;
    }

    public void addSourceRoot(@NotNull JpsModuleSourceRoot root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addSourceRoot"));
        }
        ((JpsElementCollection)this.myContainer.getChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE)).addChild((JpsElement)root);
    }

    public void removeSourceRoot(@NotNull String url, @NotNull JpsModuleSourceRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "removeSourceRoot"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "removeSourceRoot"));
        }
        JpsElementCollection roots = (JpsElementCollection)this.myContainer.getChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE);
        for (JpsModuleSourceRoot root : roots.getElements()) {
            if (!root.getRootType().equals(rootType) || !root.getUrl().equals(url)) continue;
            roots.removeChild((JpsElement)root);
            break;
        }
    }

    @NotNull
    public JpsDependenciesList getDependenciesList() {
        JpsDependenciesList jpsDependenciesList = (JpsDependenciesList)this.myContainer.getChild(DEPENDENCIES_LIST_CHILD_ROLE);
        if (jpsDependenciesList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "getDependenciesList"));
        }
        return jpsDependenciesList;
    }

    @NotNull
    public JpsSdkReferencesTable getSdkReferencesTable() {
        JpsSdkReferencesTable jpsSdkReferencesTable = (JpsSdkReferencesTable)this.myContainer.getChild((JpsElementChildRole)JpsSdkReferencesTableImpl.ROLE);
        if (jpsSdkReferencesTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "getSdkReferencesTable"));
        }
        return jpsSdkReferencesTable;
    }

    public <P extends JpsElement> JpsSdkReference<P> getSdkReference(@NotNull JpsSdkType<P> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "getSdkReference"));
        }
        JpsSdkReference sdkReference = this.getSdkReferencesTable().getSdkReference(type);
        if (sdkReference != null) {
            return sdkReference;
        }
        JpsProject project = this.getProject();
        if (project != null) {
            return project.getSdkReferencesTable().getSdkReference(type);
        }
        return null;
    }

    public <P extends JpsElement> JpsSdk<P> getSdk(@NotNull JpsSdkType<P> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "getSdk"));
        }
        JpsSdkReference<P> reference = this.getSdkReference(type);
        if (reference == null) {
            return null;
        }
        JpsTypedLibrary library = (JpsTypedLibrary)reference.resolve();
        return library != null ? (JpsSdk)library.getProperties() : null;
    }

    public void delete() {
        ((JpsElementCollection)this.myParent).removeChild((JpsElement)this);
    }

    @NotNull
    public JpsModuleReference createReference() {
        JpsModuleReferenceImpl jpsModuleReferenceImpl = new JpsModuleReferenceImpl(this.getName());
        if (jpsModuleReferenceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "createReference"));
        }
        return jpsModuleReferenceImpl;
    }

    @NotNull
    public <P extends JpsElement, Type extends JpsLibraryType<P> & JpsElementTypeWithDefaultProperties<P>> JpsLibrary addModuleLibrary(@NotNull String name, @NotNull Type type) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addModuleLibrary"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addModuleLibrary"));
        }
        JpsLibrary jpsLibrary = this.myLibraryCollection.addLibrary(name, type);
        if (jpsLibrary == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addModuleLibrary"));
        }
        return jpsLibrary;
    }

    public void addModuleLibrary(@NotNull JpsLibrary library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addModuleLibrary"));
        }
        this.myLibraryCollection.addLibrary(library);
    }

    @NotNull
    public JpsLibraryCollection getLibraryCollection() {
        JpsLibraryCollection jpsLibraryCollection = this.myLibraryCollection;
        if (jpsLibraryCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "getLibraryCollection"));
        }
        return jpsLibraryCollection;
    }

    @Nullable
    public JpsProject getProject() {
        JpsModel model = this.getModel();
        return model != null ? model.getProject() : null;
    }

    @NotNull
    public JpsModuleType<P> getModuleType() {
        JpsModuleType<P> jpsModuleType = this.myModuleType;
        if (jpsModuleType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "getModuleType"));
        }
        return jpsModuleType;
    }
}

