/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.syntaxChecks;

import lombok.ast.Block;
import lombok.ast.Case;
import lombok.ast.Catch;
import lombok.ast.Default;
import lombok.ast.DoWhile;
import lombok.ast.For;
import lombok.ast.ForEach;
import lombok.ast.If;
import lombok.ast.Message;
import lombok.ast.Node;
import lombok.ast.Statement;
import lombok.ast.Switch;
import lombok.ast.Try;
import lombok.ast.TypeDeclaration;
import lombok.ast.VariableDeclaration;
import lombok.ast.While;
import lombok.ast.syntaxChecks.BasicChecks;
import lombok.ast.syntaxChecks.MessageKey;

public class StatementChecks {
    public void checkNotLoneTry(Try node) {
        if (node.rawCatches().size() == 0 && node.rawFinally() == null) {
            node.addMessage(Message.error(MessageKey.TRY_LONE_TRY, "try statement with no catches and no finally"));
        }
    }

    public void checkDeclarationsAsDirectChildWhile(While node) {
        this.checkDeclarationsAsDirectChild(node, node.rawStatement());
    }

    public void checkDeclarationsAsDirectChildDo(DoWhile node) {
        this.checkDeclarationsAsDirectChild(node, node.rawStatement());
    }

    public void checkDeclarationsAsDirectChildForEach(ForEach node) {
        this.checkDeclarationsAsDirectChild(node, node.rawStatement());
    }

    public void checkDeclarationsAsDirectChildIf(If node) {
        this.checkDeclarationsAsDirectChild(node, node.rawStatement());
        this.checkDeclarationsAsDirectChild(node, node.rawElseStatement());
    }

    public void checkDeclarationsAsDirectChildFor(For node) {
        this.checkDeclarationsAsDirectChild(node, node.rawStatement());
    }

    private void checkDeclarationsAsDirectChild(Node n, Node c) {
        if (c instanceof VariableDeclaration) {
            c.addMessage(Message.error(MessageKey.DECLARATION_NOT_ALLOWED, "Variable declarations only make sense in the context of a block."));
        }
        if (c instanceof TypeDeclaration) {
            c.addMessage(Message.error(MessageKey.DECLARATION_NOT_ALLOWED, "Type declarations only make sense in the context of a block or other type."));
        }
    }

    public void checkVarDefOfCatch(Catch node) {
        BasicChecks.checkVarDefIsSimple(node, node.rawExceptionDeclaration(), "catch blocks", "exception");
    }

    public void checkVarDefOfForEach(ForEach node) {
        BasicChecks.checkVarDefIsSimple(node, node.rawVariable(), "for-each statements", "loop");
    }

    public void checkCaseChildOfSwitch(Case node) {
        this.checkChildOfSwitch(node, "case");
    }

    public void checkDefaultChildOfSwitch(Default node) {
        this.checkChildOfSwitch(node, "default");
    }

    private void checkChildOfSwitch(Statement node, String desc) {
        if (node.getParent() == null) {
            return;
        }
        Block p = node.upToBlock();
        Switch gp = p == null ? null : p.upToSwitch();
        boolean genError = false;
        genError = p == null;
        if (genError |= gp == null && p.getParent() != null) {
            node.addMessage(Message.error(MessageKey.STATEMENT_ONLY_LEGAL_IN_SWITCH, desc + " statements are only legal directly inside switch statements."));
        }
    }

    public void checkSwitchStartsWithDefaultOrCase(Switch node) {
        Statement first;
        Block body = node.astBody();
        if (body != null && (first = body.astContents().first()) != null && !(first instanceof Case) && !(first instanceof Default)) {
            node.addMessage(Message.error(MessageKey.SWITCH_DOES_NOT_START_WITH_CASE, "switch statements should start with a default or case statement."));
        }
    }
}

