/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.inet;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.UUID;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.messaging.remote.internal.inet.MultiChoiceAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiChoiceAddressSerializer
implements Serializer<MultiChoiceAddress> {
    @Override
    public MultiChoiceAddress read(Decoder decoder) throws IOException {
        UUID canonicalAddress = new UUID(decoder.readLong(), decoder.readLong());
        int port = decoder.readInt();
        int addressCount = decoder.readSmallInt();
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>(addressCount);
        for (int i = 0; i < addressCount; ++i) {
            InetAddress address = InetAddress.getByAddress(decoder.readBinary());
            addresses.add(address);
        }
        return new MultiChoiceAddress(canonicalAddress, port, addresses);
    }

    @Override
    public void write(Encoder encoder, MultiChoiceAddress address) throws IOException {
        UUID canonicalAddress = address.getCanonicalAddress();
        encoder.writeLong(canonicalAddress.getMostSignificantBits());
        encoder.writeLong(canonicalAddress.getLeastSignificantBits());
        encoder.writeInt(address.getPort());
        encoder.writeSmallInt(address.getCandidates().size());
        for (InetAddress inetAddress : address.getCandidates()) {
            encoder.writeBinary(inetAddress.getAddress());
        }
    }
}

