/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import com.google.common.base.Objects;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.MethodCallData;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.OptionsData;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.BinaryTransformation;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ComparisonUtils;

class CompareToTransformation
extends BinaryTransformation {
    public CompareToTransformation() {
        super(null);
    }

    @Override
    protected GrExpression getExpandedElement(GrMethodCallExpression callExpression) {
        PsiElement parent = callExpression.getParent();
        return ComparisonUtils.isComparison(parent) ? (GrExpression)parent : super.getExpandedElement(callExpression);
    }

    @Override
    protected IElementType getOperator(MethodCallData methodInfo, OptionsData optionsData) {
        IElementType comparison = methodInfo.getComparison();
        if (CompareToTransformation.shouldChangeCompareToEqualityToEquals(optionsData, comparison)) {
            return (IElementType)Objects.firstNonNull((Object)comparison, (Object)GroovyTokenTypes.mCOMPARE_TO);
        }
        return null;
    }

    private static boolean shouldChangeCompareToEqualityToEquals(OptionsData optionsData, IElementType comparison) {
        return !CompareToTransformation.isEquality(comparison) || optionsData.shouldChangeCompareToEqualityToEquals();
    }

    private static boolean isEquality(IElementType comparison) {
        return comparison == GroovyTokenTypes.mNOT_EQUAL || comparison == GroovyTokenTypes.mEQUAL;
    }
}

