/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrDeclarationHolder;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GrRefactoringError;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.NameValidator;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrAbstractInplaceIntroducer;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContextImpl;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceDialog;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceSettings;
import org.jetbrains.plugins.groovy.refactoring.introduce.IntroduceOccurrencesChooser;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;

public abstract class GrIntroduceHandlerBase<Settings extends GrIntroduceSettings, Scope extends PsiElement>
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance(GrIntroduceHandlerBase.class);
    public static final Function<GrExpression, String> GR_EXPRESSION_RENDERER = expr -> expr.getText();

    public static GrExpression insertExplicitCastIfNeeded(GrVariable variable, GrExpression initializer) {
        PsiType ltype = GrIntroduceHandlerBase.findLValueType(initializer);
        PsiType rtype = initializer.getType();
        GrExpression rawExpr = (GrExpression)PsiUtil.skipParentheses(initializer, false);
        if (ltype == null || TypesUtil.isAssignableWithoutConversions(ltype, rtype, initializer) || !TypesUtil.isAssignable(ltype, rtype, initializer)) {
            return rawExpr;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(variable.getProject());
        GrSafeCastExpression cast = (GrSafeCastExpression)factory.createExpressionFromText("a as B");
        cast.getOperand().replaceWithExpression(rawExpr, false);
        cast.getCastTypeElement().replace(factory.createTypeElement(ltype));
        return cast;
    }

    @Nullable
    private static PsiType findLValueType(GrExpression initializer) {
        if (initializer.getParent() instanceof GrAssignmentExpression && ((GrAssignmentExpression)initializer.getParent()).getRValue() == initializer) {
            return ((GrAssignmentExpression)initializer.getParent()).getLValue().getNominalType();
        }
        if (initializer.getParent() instanceof GrVariable) {
            return ((GrVariable)initializer.getParent()).getDeclaredType();
        }
        return null;
    }

    @NotNull
    public static GrStatement getAnchor(@NotNull PsiElement[] occurrences, @NotNull PsiElement scope) {
        if (occurrences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "occurrences", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "getAnchor"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "getAnchor"));
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement[])occurrences);
        PsiElement container = GrIntroduceHandlerBase.getEnclosingContainer(parent);
        assert (container != null);
        PsiElement anchor = GrIntroduceHandlerBase.findAnchor(occurrences, container);
        GrIntroduceHandlerBase.assertStatement(anchor, scope);
        GrStatement grStatement = (GrStatement)anchor;
        if (grStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "getAnchor"));
        }
        return grStatement;
    }

    @Nullable
    public static PsiElement getEnclosingContainer(PsiElement place) {
        PsiElement parent = place;
        while (parent != null) {
            if (!(!(parent instanceof GrDeclarationHolder) || parent instanceof GrClosableBlock && parent.getParent() instanceof GrStringInjection)) {
                return parent;
            }
            if (parent instanceof GrLoopStatement) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @NotNull
    protected abstract String getRefactoringName();

    @NotNull
    protected abstract String getHelpID();

    @NotNull
    protected abstract Scope[] findPossibleScopes(GrExpression var1, GrVariable var2, StringPartInfo var3, Editor var4);

    protected abstract void checkExpression(@NotNull GrExpression var1) throws GrRefactoringError;

    protected abstract void checkVariable(@NotNull GrVariable var1) throws GrRefactoringError;

    protected abstract void checkStringLiteral(@NotNull StringPartInfo var1) throws GrRefactoringError;

    protected abstract void checkOccurrences(@NotNull PsiElement[] var1);

    @NotNull
    protected abstract GrIntroduceDialog<Settings> getDialog(@NotNull GrIntroduceContext var1);

    @Nullable
    public abstract GrVariable runRefactoring(@NotNull GrIntroduceContext var1, @NotNull Settings var2);

    protected abstract GrAbstractInplaceIntroducer<Settings> getIntroducer(@NotNull GrIntroduceContext var1, OccurrencesChooser.ReplaceChoice var2);

    public static Map<OccurrencesChooser.ReplaceChoice, List<Object>> fillChoice(GrIntroduceContext context) {
        LinkedHashMap map = ContainerUtil.newLinkedHashMap();
        if (context.getExpression() != null) {
            map.put(OccurrencesChooser.ReplaceChoice.NO, Collections.singletonList(context.getExpression()));
        } else {
            if (context.getStringPart() != null) {
                map.put(OccurrencesChooser.ReplaceChoice.NO, Collections.singletonList(context.getStringPart()));
                return map;
            }
            if (context.getVar() != null) {
                map.put(OccurrencesChooser.ReplaceChoice.ALL, Collections.singletonList(context.getVar()));
                return map;
            }
        }
        PsiElement[] occurrences = context.getOccurrences();
        if (occurrences.length > 1) {
            map.put(OccurrencesChooser.ReplaceChoice.ALL, Arrays.asList(occurrences));
        }
        return map;
    }

    @NotNull
    public static List<GrExpression> collectExpressions(PsiFile file, Editor editor, int offset, boolean acceptVoidCalls) {
        int correctedOffset = GrIntroduceHandlerBase.correctOffset(editor, offset);
        PsiElement elementAtCaret = file.findElementAt(correctedOffset);
        List<GrExpression> list = GrIntroduceHandlerBase.collectExpressions(elementAtCaret, acceptVoidCalls);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "collectExpressions"));
        }
        return list;
    }

    @NotNull
    public static List<GrExpression> collectExpressions(PsiElement elementAtCaret, boolean acceptVoidCalls) {
        ArrayList<GrExpression> expressions = new ArrayList<GrExpression>();
        GrExpression expression = (GrExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, GrExpression.class);
        while (expression != null) {
            if (!expressions.contains(expression)) {
                if (expression instanceof GrParenthesizedExpression && !expressions.contains(((GrParenthesizedExpression)expression).getOperand())) {
                    expressions.add(((GrParenthesizedExpression)expression).getOperand());
                }
                if (!(expression.getParent() instanceof GrReferenceExpression && expression instanceof GrReferenceExpression && ((GrReferenceExpression)expression).resolve() instanceof PsiClass || GrIntroduceHandlerBase.expressionIsIncorrect(expression, acceptVoidCalls))) {
                    expressions.add(expression);
                }
            }
            expression = (GrExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, GrExpression.class);
        }
        ArrayList<GrExpression> arrayList = expressions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "collectExpressions"));
        }
        return arrayList;
    }

    public static boolean expressionIsIncorrect(@Nullable GrExpression expression, boolean acceptVoidCalls) {
        if (expression instanceof GrParenthesizedExpression) {
            return true;
        }
        if (PsiUtil.isSuperReference(expression)) {
            return true;
        }
        if (expression instanceof GrAssignmentExpression) {
            return true;
        }
        if (expression instanceof GrReferenceExpression && expression.getParent() instanceof GrCall) {
            GroovyResolveResult resolveResult = ((GrReferenceExpression)expression).advancedResolve();
            PsiElement resolved = resolveResult.getElement();
            return resolved instanceof PsiMethod && !resolveResult.isInvokedOnProperty() || resolved instanceof PsiClass;
        }
        if (expression instanceof GrClosableBlock && expression.getParent() instanceof GrStringInjection) {
            return true;
        }
        return !acceptVoidCalls && expression instanceof GrMethodCall && PsiType.VOID.equals((Object)expression.getType());
    }

    public static int correctOffset(Editor editor, int offset) {
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        int correctedOffset = offset;
        int textLength = document.getTextLength();
        if (offset >= textLength) {
            correctedOffset = textLength - 1;
        } else if (!Character.isJavaIdentifierPart(text.charAt(offset))) {
            --correctedOffset;
        }
        if (correctedOffset < 0) {
            correctedOffset = offset;
        } else {
            char c = text.charAt(correctedOffset);
            if (c == ';' && correctedOffset != 0) {
                --correctedOffset;
            } else if (!Character.isJavaIdentifierPart(c) && c != ')' && c != ']' && c != '}' && c != '\'' && c != '\"' && c != '/') {
                correctedOffset = offset;
            }
        }
        return correctedOffset;
    }

    @Nullable
    public static GrVariable findVariableAtCaret(PsiFile file, Editor editor, int offset) {
        int correctOffset = GrIntroduceHandlerBase.correctOffset(editor, offset);
        PsiElement elementAtCaret = file.findElementAt(correctOffset);
        GrVariable variable = (GrVariable)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, GrVariable.class);
        if (variable != null && variable.getNameIdentifierGroovy().getTextRange().contains(correctOffset)) {
            return variable;
        }
        return null;
    }

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file, @Nullable DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "invoke"));
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            int offset = editor.getCaretModel().getOffset();
            List<GrExpression> expressions = GrIntroduceHandlerBase.collectExpressions(file, editor, offset, false);
            if (expressions.isEmpty()) {
                GrIntroduceHandlerBase.updateSelectionForVariable(editor, file, selectionModel, offset);
            } else if (expressions.size() == 1) {
                TextRange textRange = expressions.get(0).getTextRange();
                selectionModel.setSelection(textRange.getStartOffset(), textRange.getEndOffset());
            } else {
                IntroduceTargetChooser.showChooser((Editor)editor, expressions, (Pass)new Pass<GrExpression>(){

                    public void pass(GrExpression selectedValue) {
                        GrIntroduceHandlerBase.this.invoke(project, editor, file, selectedValue.getTextRange().getStartOffset(), selectedValue.getTextRange().getEndOffset());
                    }
                }, GR_EXPRESSION_RENDERER);
                return;
            }
        }
        this.invoke(project, editor, file, selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
    }

    public static void updateSelectionForVariable(Editor editor, PsiFile file, SelectionModel selectionModel, int offset) {
        GrVariable variable = GrIntroduceHandlerBase.findVariableAtCaret(file, editor, offset);
        if (variable == null || variable instanceof GrField || variable instanceof GrParameter) {
            selectionModel.selectLineAtCaret();
        } else {
            TextRange textRange = variable.getTextRange();
            selectionModel.setSelection(textRange.getStartOffset(), textRange.getEndOffset());
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "invoke"));
        }
    }

    public void getContextAndInvoke(final @NotNull Project project, final @NotNull Editor editor, final @Nullable GrExpression expression, final @Nullable GrVariable variable, final @Nullable StringPartInfo stringPart) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "getContextAndInvoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "getContextAndInvoke"));
        }
        PsiElement[] scopes = this.findPossibleScopes(expression, variable, stringPart, editor);
        Pass callback = new Pass<Scope>(){

            public void pass(Scope scope) {
                GrIntroduceContext context = GrIntroduceHandlerBase.this.getContext(project, editor, expression, variable, stringPart, (PsiElement)scope);
                GrIntroduceHandlerBase.this.invokeImpl(project, context, editor);
            }
        };
        if (scopes.length == 0) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)(this.getRefactoringName() + "is not available in current scope")), (String)this.getRefactoringName(), (String)this.getHelpID());
        } else if (scopes.length == 1) {
            callback.pass((Object)scopes[0]);
        } else {
            this.showScopeChooser(scopes, callback, editor);
        }
    }

    protected void extractStringPart(Ref<GrIntroduceContext> ref) {
        CommandProcessor.getInstance().executeCommand(((GrIntroduceContext)ref.get()).getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
            GrIntroduceContext context = (GrIntroduceContext)ref.get();
            StringPartInfo stringPart = context.getStringPart();
            assert (stringPart != null);
            GrExpression expression = stringPart.replaceLiteralWithConcatenation(null);
            ref.set((Object)new GrIntroduceContextImpl(context.getProject(), context.getEditor(), expression, null, null, new PsiElement[]{expression}, context.getScope()));
        }), this.getRefactoringName(), (Object)this.getRefactoringName());
    }

    protected void addBraces(@NotNull GrStatement anchor, @NotNull Ref<GrIntroduceContext> contextRef) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "addBraces"));
        }
        if (contextRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextRef", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "addBraces"));
        }
        CommandProcessor.getInstance().executeCommand(((GrIntroduceContext)contextRef.get()).getProject(), () -> {
            if (contextRef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextRef", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "lambda$addBraces$4"));
            }
            if (anchor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "lambda$addBraces$4"));
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                int start;
                if (contextRef == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextRef", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "lambda$null$3"));
                }
                if (anchor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "lambda$null$3"));
                }
                GrIntroduceContext context = (GrIntroduceContext)contextRef.get();
                SmartPointerManager pointManager = SmartPointerManager.getInstance((Project)context.getProject());
                SmartPsiElementPointer expressionRef = context.getExpression() != null ? pointManager.createSmartPsiElementPointer((PsiElement)context.getExpression()) : null;
                SmartPsiElementPointer varRef = context.getVar() != null ? pointManager.createSmartPsiElementPointer((PsiElement)context.getVar()) : null;
                SmartPsiElementPointer[] occurrencesRefs = new SmartPsiElementPointer[context.getOccurrences().length];
                PsiElement[] occurrences = context.getOccurrences();
                for (int i = 0; i < occurrences.length; ++i) {
                    occurrencesRefs[i] = pointManager.createSmartPsiElementPointer(occurrences[i]);
                }
                PsiFile file = anchor.getContainingFile();
                SmartPsiFileRange anchorPointer = pointManager.createSmartPsiFileRangePointer(file, anchor.getTextRange());
                Document document = context.getEditor().getDocument();
                CharSequence sequence = document.getCharsSequence();
                TextRange range = anchor.getTextRange();
                int end = range.getEndOffset();
                document.insertString(end, (CharSequence)"\n}");
                for (start = range.getStartOffset(); start > 0 && Character.isWhitespace(sequence.charAt(start - 1)); --start) {
                }
                document.insertString(start, (CharSequence)"{");
                PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(document);
                Segment anchorSegment = anchorPointer.getRange();
                PsiElement restoredAnchor = PsiImplUtil.findElementInRange(file, anchorSegment.getStartOffset(), anchorSegment.getEndOffset(), PsiElement.class);
                GrCodeBlock block = (GrCodeBlock)restoredAnchor.getParent();
                CodeStyleManager.getInstance((Project)context.getProject()).reformat(block.getRBrace());
                CodeStyleManager.getInstance((Project)context.getProject()).reformat(block.getLBrace());
                for (int i = 0; i < occurrencesRefs.length; ++i) {
                    occurrences[i] = occurrencesRefs[i].getElement();
                }
                contextRef.set((Object)new GrIntroduceContextImpl(context.getProject(), context.getEditor(), expressionRef != null ? (GrExpression)expressionRef.getElement() : null, varRef != null ? (GrVariable)varRef.getElement() : null, null, occurrences, context.getScope()));
            });
        }, this.getRefactoringName(), (Object)this.getRefactoringName());
    }

    @NotNull
    protected static GrStatement findAnchor(final @NotNull GrIntroduceContext context, final boolean replaceAll) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "findAnchor"));
        }
        GrStatement grStatement = (GrStatement)ApplicationManager.getApplication().runReadAction((Computable)new Computable<GrStatement>(){

            public GrStatement compute() {
                PsiElement[] psiElementArray;
                if (replaceAll) {
                    psiElementArray = context.getOccurrences();
                } else {
                    GrExpression[] grExpressionArray = new GrExpression[1];
                    psiElementArray = grExpressionArray;
                    grExpressionArray[0] = context.getExpression();
                }
                PsiElement[] occurrences = psiElementArray;
                return GrIntroduceHandlerBase.getAnchor(occurrences, context.getScope());
            }
        });
        if (grStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "findAnchor"));
        }
        return grStatement;
    }

    protected abstract void showScopeChooser(Scope[] var1, Pass<Scope> var2, Editor var3);

    public GrIntroduceContext getContext(@NotNull Project project, @NotNull Editor editor, @Nullable GrExpression expression, @Nullable GrVariable variable, @Nullable StringPartInfo stringPart, @NotNull PsiElement scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "getContext"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "getContext"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "getContext"));
        }
        if (variable != null) {
            PsiElement[] occurrences = GrIntroduceHandlerBase.collectVariableUsages(variable, scope);
            return new GrIntroduceContextImpl(project, editor, null, variable, stringPart, occurrences, scope);
        }
        if (expression != null) {
            PsiElement[] occurrences = this.findOccurrences(expression, scope);
            return new GrIntroduceContextImpl(project, editor, expression, variable, stringPart, occurrences, scope);
        }
        assert (stringPart != null);
        return new GrIntroduceContextImpl(project, editor, expression, variable, stringPart, new PsiElement[]{stringPart.getLiteral()}, scope);
    }

    public static PsiElement[] collectVariableUsages(GrVariable variable, PsiElement scope) {
        List list = Collections.synchronizedList(new ArrayList());
        if (scope instanceof GroovyScriptClass) {
            scope = scope.getContainingFile();
        }
        ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope(scope)).forEach(psiReference -> {
            PsiElement element = psiReference.getElement();
            if (element != null) {
                list.add(element);
            }
            return true;
        });
        return list.toArray(new PsiElement[list.size()]);
    }

    private boolean invokeImpl(Project project, final GrIntroduceContext context, Editor editor) {
        try {
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement[])context.getOccurrences())) {
                return false;
            }
            this.checkOccurrences(context.getOccurrences());
            if (GrIntroduceHandlerBase.isInplace(context.getEditor(), context.getPlace())) {
                Map<OccurrencesChooser.ReplaceChoice, List<Object>> occurrencesMap = this.getOccurrenceOptions(context);
                new IntroduceOccurrencesChooser(editor).showChooser((Pass)new Pass<OccurrencesChooser.ReplaceChoice>(){

                    public void pass(OccurrencesChooser.ReplaceChoice choice) {
                        GrIntroduceHandlerBase.this.getIntroducer(context, choice).startInplaceIntroduceTemplate();
                    }
                }, occurrencesMap);
            } else {
                Settings settings = this.showDialog(context);
                if (settings == null) {
                    return false;
                }
                CommandProcessor.getInstance().executeCommand(context.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> this.runRefactoring(context, settings)), this.getRefactoringName(), null);
            }
            return true;
        }
        catch (GrRefactoringError e) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)e.getMessage()), (String)this.getRefactoringName(), (String)this.getHelpID());
            return false;
        }
    }

    @NotNull
    protected Map<OccurrencesChooser.ReplaceChoice, List<Object>> getOccurrenceOptions(@NotNull GrIntroduceContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "getOccurrenceOptions"));
        }
        Map<OccurrencesChooser.ReplaceChoice, List<Object>> map = GrIntroduceHandlerBase.fillChoice(context);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "getOccurrenceOptions"));
        }
        return map;
    }

    @NotNull
    protected PsiElement[] findOccurrences(@NotNull GrExpression expression, @NotNull PsiElement scope) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "findOccurrences"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "findOccurrences"));
        }
        PsiElement[] occurrences = GroovyRefactoringUtil.getExpressionOccurrences(PsiUtil.skipParentheses(expression, false), scope);
        if (occurrences == null || occurrences.length == 0) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("no.occurrences.found", new Object[0]));
        }
        if (occurrences == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "findOccurrences"));
        }
        return occurrences;
    }

    private void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, int startOffset, int endOffset) throws GrRefactoringError {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "invoke"));
        }
        try {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            if (!(file instanceof GroovyFileBase)) {
                throw new GrRefactoringError(GroovyRefactoringBundle.message("only.in.groovy.files", new Object[0]));
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) {
                throw new GrRefactoringError(RefactoringBundle.message((String)"readonly.occurences.found"));
            }
            GrExpression selectedExpr = GrIntroduceHandlerBase.findExpression(file, startOffset, endOffset);
            GrVariable variable = GrIntroduceHandlerBase.findVariable(file, startOffset, endOffset);
            StringPartInfo stringPart = StringPartInfo.findStringPart(file, startOffset, endOffset);
            if (variable != null) {
                this.checkVariable(variable);
            } else if (selectedExpr != null) {
                this.checkExpression(selectedExpr);
            } else if (stringPart != null) {
                this.checkStringLiteral(stringPart);
            } else {
                throw new GrRefactoringError(null);
            }
            this.getContextAndInvoke(project, editor, selectedExpr, variable, stringPart);
        }
        catch (GrRefactoringError e) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)e.getMessage()), (String)this.getRefactoringName(), (String)this.getHelpID());
        }
    }

    public static RangeMarker createRange(Document document, StringPartInfo part) {
        if (part == null) {
            return null;
        }
        TextRange range = part.getRange().shiftRight(part.getLiteral().getTextRange().getStartOffset());
        return document.createRangeMarker(range.getStartOffset(), range.getEndOffset(), true);
    }

    @Nullable
    public static RangeMarker createRange(@NotNull Document document, @Nullable PsiElement expression) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "createRange"));
        }
        if (expression == null) {
            return null;
        }
        TextRange range = expression.getTextRange();
        return document.createRangeMarker(range.getStartOffset(), range.getEndOffset(), false);
    }

    public static boolean isInplace(@NotNull Editor editor, @NotNull PsiElement place) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "isInplace"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "isInplace"));
        }
        RefactoringSupportProvider supportProvider = (RefactoringSupportProvider)LanguageRefactoringSupport.INSTANCE.forLanguage(place.getLanguage());
        return supportProvider != null && (editor.getUserData(InplaceRefactoring.INTRODUCE_RESTART) == null || (Boolean)editor.getUserData(InplaceRefactoring.INTRODUCE_RESTART) == false) && editor.getUserData(AbstractInplaceIntroducer.ACTIVE_INTRODUCE) == null && editor.getSettings().isVariableInplaceRenameEnabled() && supportProvider.isInplaceIntroduceAvailable(place, place) && !ApplicationManager.getApplication().isUnitTestMode();
    }

    @Nullable
    public static GrVariable findVariable(@NotNull PsiFile file, int startOffset, int endOffset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "findVariable"));
        }
        GrVariable var = PsiImplUtil.findElementInRange(file, startOffset, endOffset, GrVariable.class);
        if (var == null) {
            GrVariableDeclaration variableDeclaration = PsiImplUtil.findElementInRange(file, startOffset, endOffset, GrVariableDeclaration.class);
            if (variableDeclaration == null) {
                return null;
            }
            GrVariable[] variables = variableDeclaration.getVariables();
            if (variables.length == 1) {
                var = variables[0];
            }
        }
        if (var instanceof GrParameter || var instanceof GrField) {
            return null;
        }
        return var;
    }

    @Nullable
    public static GrVariable findVariable(@NotNull GrStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "findVariable"));
        }
        if (!(statement instanceof GrVariableDeclaration)) {
            return null;
        }
        GrVariableDeclaration variableDeclaration = (GrVariableDeclaration)statement;
        GrVariable[] variables = variableDeclaration.getVariables();
        GrVariable var = null;
        if (variables.length == 1) {
            var = variables[0];
        }
        if (var instanceof GrParameter || var instanceof GrField) {
            return null;
        }
        return var;
    }

    @Nullable
    public static GrExpression findExpression(PsiFile file, int startOffset, int endOffset) {
        GrExpression selectedExpr = PsiImplUtil.findElementInRange(file, startOffset, endOffset, GrExpression.class);
        return GrIntroduceHandlerBase.findExpression(selectedExpr);
    }

    @Nullable
    public static GrExpression findExpression(GrStatement selectedExpr) {
        if (!(selectedExpr instanceof GrExpression)) {
            return null;
        }
        GrExpression selected = (GrExpression)selectedExpr;
        while (selected instanceof GrParenthesizedExpression) {
            selected = ((GrParenthesizedExpression)selected).getOperand();
        }
        return selected;
    }

    @Nullable
    private Settings showDialog(@NotNull GrIntroduceContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "showDialog"));
        }
        ArrayList highlighters = new ArrayList();
        HighlightManager highlightManager = null;
        if (context.getEditor() != null) {
            highlightManager = HighlightManager.getInstance((Project)context.getProject());
            EditorColorsManager colorsManager = EditorColorsManager.getInstance();
            TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            if (context.getOccurrences().length > 1) {
                highlightManager.addOccurrenceHighlights(context.getEditor(), context.getOccurrences(), attributes, true, highlighters);
            }
        }
        GrIntroduceDialog<Settings> dialog = this.getDialog(context);
        dialog.show();
        if (dialog.isOK()) {
            if (context.getEditor() != null) {
                for (RangeHighlighter highlighter : highlighters) {
                    highlightManager.removeSegmentHighlighter(context.getEditor(), highlighter);
                }
            }
            return dialog.getSettings();
        }
        if (context.getOccurrences().length > 1) {
            WindowManager.getInstance().getStatusBar(context.getProject()).setInfo(GroovyRefactoringBundle.message("press.escape.to.remove.the.highlighting", new Object[0]));
        }
        return null;
    }

    @Nullable
    public static PsiElement findAnchor(@NotNull PsiElement[] occurrences, @NotNull PsiElement container) {
        PsiElement candidate;
        if (occurrences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "occurrences", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "findAnchor"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "findAnchor"));
        }
        if (occurrences.length == 0) {
            return null;
        }
        if (occurrences.length == 1) {
            candidate = GrIntroduceHandlerBase.findContainingStatement(occurrences[0]);
        } else {
            for (candidate = occurrences[0]; candidate != null && candidate.getParent() != container; candidate = candidate.getParent()) {
            }
        }
        GrStringInjection injection = (GrStringInjection)PsiTreeUtil.getParentOfType((PsiElement)candidate, GrStringInjection.class);
        if (injection != null && !injection.getText().contains("\n")) {
            candidate = GrIntroduceHandlerBase.findContainingStatement(injection);
        }
        if (candidate == null) {
            return null;
        }
        if (container instanceof GrWhileStatement && candidate.equals(((GrWhileStatement)container).getCondition())) {
            return container;
        }
        if (container instanceof GrIfStatement && candidate.equals(((GrIfStatement)container).getCondition())) {
            return container;
        }
        if (container instanceof GrForStatement && candidate.equals(((GrForStatement)container).getClause())) {
            return container;
        }
        while (candidate instanceof GrIfStatement && candidate.getParent() instanceof GrIfStatement && ((GrIfStatement)candidate.getParent()).getElseBranch() == candidate) {
            candidate = candidate.getParent();
        }
        return candidate;
    }

    public static void assertStatement(@Nullable PsiElement anchor, @NotNull PsiElement scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "assertStatement"));
        }
        if (!(anchor instanceof GrStatement)) {
            LogMessageEx.error((Logger)LOG, (String)"cannot find anchor for variable", (String[])new String[]{scope.getText()});
        }
    }

    @Nullable
    private static PsiElement findContainingStatement(@Nullable PsiElement candidate) {
        while (candidate != null && (candidate.getParent() instanceof GrLabeledStatement || !PsiUtil.isExpressionStatement(candidate))) {
            if (!((candidate = candidate.getParent()) instanceof GrCaseLabel)) continue;
            candidate = candidate.getParent();
        }
        return candidate;
    }

    public static void deleteLocalVar(GrVariable var) {
        PsiElement parent = var.getParent();
        if (((GrVariableDeclaration)parent).getVariables().length == 1) {
            parent.delete();
        } else {
            GrExpression initializer = var.getInitializerGroovy();
            if (initializer != null) {
                initializer.delete();
            }
            var.delete();
        }
    }

    @Nullable
    public static GrVariable resolveLocalVar(@NotNull GrIntroduceContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "resolveLocalVar"));
        }
        GrVariable var = context.getVar();
        if (var != null) {
            return var;
        }
        return GrIntroduceHandlerBase.resolveLocalVar(context.getExpression());
    }

    @Nullable
    public static GrVariable resolveLocalVar(@Nullable GrExpression expression) {
        if (expression instanceof GrReferenceExpression) {
            GrReferenceExpression ref = (GrReferenceExpression)expression;
            PsiElement resolved = ref.resolve();
            if (PsiUtil.isLocalVariable(resolved)) {
                return (GrVariable)resolved;
            }
            return null;
        }
        return null;
    }

    public static boolean hasLhs(@NotNull PsiElement[] occurrences) {
        if (occurrences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "occurrences", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "hasLhs"));
        }
        for (PsiElement element : occurrences) {
            if (!(element instanceof GrReferenceExpression)) continue;
            if (PsiUtil.isLValue((GroovyPsiElement)element)) {
                return true;
            }
            if (!ControlFlowUtils.isIncOrDecOperand((GrReferenceExpression)element)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static PsiElement getCurrentPlace(@Nullable GrExpression expr, @Nullable GrVariable var, @Nullable StringPartInfo stringPartInfo) {
        if (var != null) {
            GrVariable grVariable = var;
            if (grVariable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "getCurrentPlace"));
            }
            return grVariable;
        }
        if (expr != null) {
            GrExpression grExpression = expr;
            if (grExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "getCurrentPlace"));
            }
            return grExpression;
        }
        if (stringPartInfo != null) {
            GrLiteral grLiteral = stringPartInfo.getLiteral();
            if (grLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/GrIntroduceHandlerBase", "getCurrentPlace"));
            }
            return grLiteral;
        }
        throw new IncorrectOperationException();
    }

    public static interface Validator
    extends NameValidator {
        public boolean isOK(GrIntroduceDialog var1);
    }
}

