/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.runner;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.util.ScriptFileUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.net.HttpConfigurable;
import java.nio.charset.Charset;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyFacetUtil;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class DefaultGroovyScriptRunner
extends GroovyScriptRunner {
    @Override
    public boolean isValidModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/runner/DefaultGroovyScriptRunner", "isValidModule"));
        }
        return LibrariesUtil.hasGroovySdk(module);
    }

    @Override
    public boolean ensureRunnerConfigured(@Nullable Module module, RunProfile profile, Executor executor, Project project) throws ExecutionException {
        if (module == null) {
            throw new ExecutionException("Module is not specified");
        }
        if (LibrariesUtil.getGroovyHomePath(module) == null) {
            ExecutionUtil.handleExecutionError((Project)project, (String)executor.getToolWindowId(), (RunProfile)profile, (ExecutionException)new ExecutionException("Groovy is not configured"));
            ModulesConfigurator.showDialog((Project)module.getProject(), (String)module.getName(), (String)ClasspathEditor.NAME);
            return false;
        }
        return true;
    }

    @Override
    public void configureCommandLine(JavaParameters params, @Nullable Module module, boolean tests, VirtualFile script, GroovyScriptRunConfiguration configuration) throws CantRunException {
        DefaultGroovyScriptRunner.configureGenericGroovyRunner(params, module, "groovy.ui.GroovyMain", false, tests);
        params.getVMParametersList().addParametersString(configuration.getVMParameters());
        DefaultGroovyScriptRunner.addScriptEncodingSettings(params, script, module);
        if (configuration.isDebugEnabled()) {
            params.getProgramParametersList().add("--debug");
        }
        String path = ScriptFileUtil.getLocalFilePath((String)StringUtil.notNullize((String)configuration.getScriptPath()));
        params.getProgramParametersList().add(FileUtil.toSystemDependentName((String)path));
        params.getProgramParametersList().addParametersString(configuration.getScriptParameters());
    }

    public static void configureGenericGroovyRunner(@NotNull JavaParameters params, @NotNull Module module, @NotNull String mainClass, boolean useBundled, boolean tests) throws CantRunException {
        String sysRoot;
        String groovyHomeDependentName;
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/plugins/groovy/runner/DefaultGroovyScriptRunner", "configureGenericGroovyRunner"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/runner/DefaultGroovyScriptRunner", "configureGenericGroovyRunner"));
        }
        if (mainClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainClass", "org/jetbrains/plugins/groovy/runner/DefaultGroovyScriptRunner", "configureGenericGroovyRunner"));
        }
        VirtualFile groovyJar = DefaultGroovyScriptRunner.findGroovyJar(module);
        if (useBundled) {
            params.getClassPath().add(GroovyFacetUtil.getBundledGroovyJar());
        } else if (groovyJar != null) {
            params.getClassPath().add(groovyJar);
        }
        DefaultGroovyScriptRunner.getClassPathFromRootModel(module, tests, params, true, params.getClassPath());
        DefaultGroovyScriptRunner.setToolsJar(params);
        String groovyHome = useBundled ? FileUtil.toCanonicalPath((String)GroovyFacetUtil.getBundledGroovyJar().getParentFile().getParent()) : LibrariesUtil.getGroovyHomePath(module);
        String string = groovyHomeDependentName = groovyHome != null ? FileUtil.toSystemDependentName((String)groovyHome) : null;
        if (groovyHomeDependentName != null) {
            DefaultGroovyScriptRunner.setGroovyHome(params, groovyHomeDependentName);
        }
        String confPath = DefaultGroovyScriptRunner.getConfPath(groovyHomeDependentName);
        params.getVMParametersList().add("-Dgroovy.starter.conf=" + confPath);
        params.getVMParametersList().addAll(HttpConfigurable.convertArguments((List)HttpConfigurable.getJvmPropertiesList((boolean)false, null)));
        params.setMainClass("org.codehaus.groovy.tools.GroovyStarter");
        params.getProgramParametersList().add("--conf");
        params.getProgramParametersList().add(confPath);
        params.getProgramParametersList().add("--main");
        params.getProgramParametersList().add(mainClass);
        if (!"org.jetbrains.plugins.groovy.grape.GrapeRunner".equals(mainClass)) {
            DefaultGroovyScriptRunner.addClasspathFromRootModel(module, tests, params, true);
        }
        if (params.getVMParametersList().getPropertyValue("grape.root") == null && (sysRoot = System.getProperty("grape.root")) != null) {
            params.getVMParametersList().defineProperty("grape.root", sysRoot);
        }
    }

    private static void addScriptEncodingSettings(JavaParameters params, VirtualFile scriptFile, Module module) {
        Charset charset = EncodingProjectManager.getInstance((Project)module.getProject()).getEncoding(scriptFile, true);
        if (charset == null) {
            charset = EncodingManager.getInstance().getDefaultCharset();
            if (!Comparing.equal((Object)CharsetToolkit.getDefaultSystemCharset(), (Object)charset)) {
                params.getProgramParametersList().add("--encoding=" + charset.displayName());
            }
        } else {
            params.getProgramParametersList().add("--encoding=" + charset.displayName());
        }
    }
}

