/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.classFile;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.compiled.ClsStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.util.indexing.FileContent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.IDEKotlinBinaryClassCache;
import org.jetbrains.kotlin.idea.decompiler.classFile.AnnotationLoaderForClassFileStubBuilder;
import org.jetbrains.kotlin.idea.decompiler.classFile.ClassFileDecompilerUtilKt;
import org.jetbrains.kotlin.idea.decompiler.classFile.DirectoryBasedClassFinder;
import org.jetbrains.kotlin.idea.decompiler.classFile.DirectoryBasedDataFinder;
import org.jetbrains.kotlin.idea.decompiler.classFile.KotlinClsStubBuilder$WhenMappings;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderComponents;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContext;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuildingKt;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.LoggingErrorReporter;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.PackageData;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.TypeTable;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBufUtil;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/classFile/KotlinClsStubBuilder;", "Lcom/intellij/psi/compiled/ClsStubBuilder;", "()V", "buildFileStub", "Lcom/intellij/psi/stubs/PsiFileStub;", "content", "Lcom/intellij/util/indexing/FileContent;", "createStubBuilderComponents", "Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/ClsStubBuilderComponents;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "doBuildFileStub", "Lorg/jetbrains/kotlin/psi/KtFile;", "getStubVersion", "", "Companion", "idea-analysis"})
public class KotlinClsStubBuilder
extends ClsStubBuilder {
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    public int getStubVersion() {
        return 14;
    }

    @Nullable
    public PsiFileStub<?> buildFileStub(@NotNull FileContent content2) {
        VirtualFile file;
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        VirtualFile virtualFile2 = file = content2.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
        if (ClassFileDecompilerUtilKt.isKotlinInternalCompiledFile(virtualFile2)) {
            return null;
        }
        VirtualFile virtualFile3 = file;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"file");
        return this.doBuildFileStub(virtualFile3);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final PsiFileStub<KtFile> doBuildFileStub(@NotNull VirtualFile file) {
        PsiFileStub psiFileStub;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        IDEKotlinBinaryClassCache.KotlinBinaryHeaderData kotlinBinaryHeaderData = IDEKotlinBinaryClassCache.getKotlinBinaryClassHeaderData$default(IDEKotlinBinaryClassCache.INSTANCE, file, null, 2, null);
        if (kotlinBinaryHeaderData == null) {
            Intrinsics.throwNpe();
        }
        IDEKotlinBinaryClassCache.KotlinBinaryHeaderData kotlinClassHeaderInfo = kotlinBinaryHeaderData;
        KotlinClassHeader header = kotlinClassHeaderInfo.getClassHeader();
        ClassId classId = kotlinClassHeaderInfo.getClassId();
        FqName packageFqName = classId.getPackageFqName();
        if (!header.getMetadataVersion().isCompatible()) {
            return ClsStubBuildingKt.createIncompatibleAbiVersionFileStub();
        }
        FqName fqName2 = packageFqName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFqName");
        ClsStubBuilderComponents components = this.createStubBuilderComponents(file, fqName2);
        if (Intrinsics.areEqual((Object)((Object)header.getKind()), (Object)((Object)KotlinClassHeader.Kind.MULTIFILE_CLASS))) {
            List<KotlinJvmBinaryClass> partFiles = ClassFileDecompilerUtilKt.findMultifileClassParts(file, classId, header);
            FqName fqName3 = classId.asSingleFqName();
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"classId.asSingleFqName()");
            return ClsStubBuildingKt.createMultifileClassStub(header, partFiles, fqName3, components);
        }
        String[] annotationData = header.getData();
        if (annotationData == null) {
            Companion.getLOG().error("Corrupted kotlin header for file " + file.getName());
            return null;
        }
        String[] strings = header.getStrings();
        if (strings == null) {
            Companion.getLOG().error("String table not found in file " + file.getName());
            return null;
        }
        switch (KotlinClsStubBuilder$WhenMappings.$EnumSwitchMapping$0[header.getKind().ordinal()]) {
            case 1: {
                void nameResolver;
                void classProto;
                if (classId.isLocal()) {
                    return null;
                }
                ClassData classData = JvmProtoBufUtil.readClassDataFrom(annotationData, strings);
                NameResolver nameResolver2 = classData.component1();
                ProtoBuf.Class clazz = classData.component2();
                classData = null;
                FqName fqName4 = packageFqName;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName4, (String)"packageFqName");
                ProtoBuf.TypeTable typeTable = classProto.getTypeTable();
                Intrinsics.checkExpressionValueIsNotNull((Object)typeTable, (String)"classProto.typeTable");
                ClsStubBuilderContext context = components.createContext((NameResolver)nameResolver, fqName4, new TypeTable(typeTable));
                psiFileStub = ClsStubBuildingKt.createTopLevelClassStub(classId, (ProtoBuf.Class)classProto, context);
                break;
            }
            case 2: {
                void packageProto;
                Object context = JvmProtoBufUtil.readPackageDataFrom(annotationData, strings);
                NameResolver nameResolver = ((PackageData)context).component1();
                ProtoBuf.Package classProto = ((PackageData)context).component2();
                context = null;
                FqName fqName5 = packageFqName;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName5, (String)"packageFqName");
                ProtoBuf.TypeTable typeTable = packageProto.getTypeTable();
                Intrinsics.checkExpressionValueIsNotNull((Object)typeTable, (String)"packageProto.typeTable");
                context = components.createContext(nameResolver, fqName5, new TypeTable(typeTable));
                FqName fqName6 = classId.asSingleFqName();
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName6, (String)"classId.asSingleFqName()");
                psiFileStub = ClsStubBuildingKt.createFileFacadeStub((ProtoBuf.Package)packageProto, fqName6, (ClsStubBuilderContext)context);
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Should have processed " + file.getPath() + (" with header " + header));
            }
        }
        return psiFileStub;
    }

    private final ClsStubBuilderComponents createStubBuilderComponents(VirtualFile file, FqName packageFqName) {
        VirtualFile virtualFile2 = file.getParent();
        if (virtualFile2 == null) {
            Intrinsics.throwNpe();
        }
        DirectoryBasedClassFinder classFinder = new DirectoryBasedClassFinder(virtualFile2, packageFqName);
        Logger logger = Companion.getLOG();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
        DirectoryBasedDataFinder classDataFinder2 = new DirectoryBasedDataFinder(classFinder, logger);
        KotlinClassFinder kotlinClassFinder = classFinder;
        Logger logger2 = Companion.getLOG();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"LOG");
        AnnotationLoaderForClassFileStubBuilder annotationLoader = new AnnotationLoaderForClassFileStubBuilder(kotlinClassFinder, new LoggingErrorReporter(logger2));
        return new ClsStubBuilderComponents(classDataFinder2, annotationLoader, file);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(KotlinClsStubBuilder.class);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/classFile/KotlinClsStubBuilder$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "idea-analysis"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

