/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.stubBuilder;

import com.google.protobuf.MessageLite;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.CallableClsStubBuilder;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClassIdWithTarget;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContext;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuildingKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.FlagsToModifiers;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.TypeClsStubBuilder;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFunctionStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinModifierListStubImpl;
import org.jetbrains.kotlin.serialization.Flags;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.AnnotatedCallableKind;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;
import org.jetbrains.kotlin.serialization.deserialization.ProtoTypeTableUtilKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J \u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/FunctionClsStubBuilder;", "Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/CallableClsStubBuilder;", "parent", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "outerContext", "Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/ClsStubBuilderContext;", "protoContainer", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer;", "functionProto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Function;", "(Lcom/intellij/psi/stubs/StubElement;Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/ClsStubBuilderContext;Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer;Lorg/jetbrains/kotlin/serialization/ProtoBuf$Function;)V", "receiverType", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Type;", "getReceiverType", "()Lorg/jetbrains/kotlin/serialization/ProtoBuf$Type;", "returnType", "getReturnType", "createModifierListStub", "", "createValueParameterList", "doCreateCallableStub", "idea-analysis"})
final class FunctionClsStubBuilder
extends CallableClsStubBuilder {
    private final ProtoBuf.Function functionProto;

    @Override
    @Nullable
    public ProtoBuf.Type getReceiverType() {
        return ProtoTypeTableUtilKt.receiverType(this.functionProto, this.getC().getTypeTable());
    }

    @Override
    @Nullable
    public ProtoBuf.Type getReturnType() {
        return ProtoTypeTableUtilKt.returnType(this.functionProto, this.getC().getTypeTable());
    }

    @Override
    public void createValueParameterList() {
        TypeClsStubBuilder typeClsStubBuilder = this.getTypeStubBuilder();
        StubElement<? extends PsiElement> stubElement = this.getCallableStub();
        MessageLite messageLite = (MessageLite)this.functionProto;
        List<ProtoBuf.ValueParameter> list2 = this.functionProto.getValueParameterList();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"functionProto.valueParameterList");
        typeClsStubBuilder.createValueParameterListStub(stubElement, messageLite, list2, this.getProtoContainer());
    }

    @Override
    public void createModifierListStub() {
        List<ClassIdWithTarget> annotationIds;
        List modalityModifier = this.isTopLevel() ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)((Object)FlagsToModifiers.MODALITY));
        KotlinModifierListStubImpl modifierListStubImpl = ClsStubBuildingKt.createModifierListStubForDeclaration$default(this.getCallableStub(), this.functionProto.getFlags(), CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])new FlagsToModifiers[]{FlagsToModifiers.VISIBILITY, FlagsToModifiers.OPERATOR, FlagsToModifiers.INFIX, FlagsToModifiers.EXTERNAL_FUN, FlagsToModifiers.INLINE, FlagsToModifiers.TAILREC}), (Iterable)modalityModifier), null, 8, null);
        List<ClassIdWithTarget> list2 = annotationIds = this.getC().getComponents().getAnnotationLoader().loadCallableAnnotations(this.getProtoContainer(), (MessageLite)this.functionProto, AnnotatedCallableKind.FUNCTION);
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"annotationIds");
        ClsStubBuildingKt.createTargetedAnnotationStubs(list2, modifierListStubImpl);
    }

    @Override
    @NotNull
    public StubElement<? extends PsiElement> doCreateCallableStub(@NotNull StubElement<? extends PsiElement> parent2) {
        KotlinFunctionStubImpl kotlinFunctionStubImpl;
        Intrinsics.checkParameterIsNotNull(parent2, (String)"parent");
        Name callableName = this.getC().getNameResolver().getName(this.functionProto.getName());
        Collection collection = this.functionProto.getTypeParameterList();
        boolean bl = Intrinsics.areEqual((Object)((Object)Flags.MODALITY.get(this.functionProto.getFlags())), (Object)((Object)ProtoBuf.Modality.ABSTRACT)) ^ true;
        boolean bl2 = true;
        boolean bl3 = ProtoTypeTableUtilKt.hasReceiver(this.functionProto);
        FqName fqName2 = this.getC().getContainerFqName().child(callableName);
        boolean bl4 = this.isTopLevel();
        StringRef stringRef = ClsStubBuildingKt.ref(callableName);
        StubElement<? extends PsiElement> stubElement = parent2;
        KotlinFunctionStubImpl kotlinFunctionStubImpl2 = kotlinFunctionStubImpl;
        KotlinFunctionStubImpl kotlinFunctionStubImpl3 = kotlinFunctionStubImpl;
        boolean bl5 = !collection.isEmpty();
        kotlinFunctionStubImpl2(stubElement, stringRef, bl4, fqName2, bl3, bl2, bl, bl5);
        return (StubElement)kotlinFunctionStubImpl3;
    }

    public FunctionClsStubBuilder(@NotNull StubElement<? extends PsiElement> parent2, @NotNull ClsStubBuilderContext outerContext, @NotNull ProtoContainer protoContainer, @NotNull ProtoBuf.Function functionProto) {
        Intrinsics.checkParameterIsNotNull(parent2, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)outerContext, (String)"outerContext");
        Intrinsics.checkParameterIsNotNull((Object)protoContainer, (String)"protoContainer");
        Intrinsics.checkParameterIsNotNull((Object)functionProto, (String)"functionProto");
        List<ProtoBuf.TypeParameter> list2 = functionProto.getTypeParameterList();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"functionProto.typeParameterList");
        super(parent2, outerContext, protoContainer, list2);
        this.functionProto = functionProto;
    }
}

