/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.NameHighlighter;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocLink;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/BeforeResolveHighlightingVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "visitArgument", "", "argument", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "visitElement", "element", "Lcom/intellij/psi/PsiElement;", "visitExpressionWithLabel", "expression", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "visitLambdaExpression", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "idea-analysis"})
public final class BeforeResolveHighlightingVisitor
extends KtVisitorVoid {
    private final AnnotationHolder holder;

    public void visitElement(@NotNull PsiElement element2) {
        TextAttributesKey textAttributesKey;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        IElementType elementType = element2.getNode().getElementType();
        if (element2 instanceof KDocLink) {
            textAttributesKey = KotlinHighlightingColors.KDOC_LINK;
        } else if (KtTokens.SOFT_KEYWORDS.contains(elementType)) {
            IElementType iElementType = elementType;
            textAttributesKey = KtTokens.MODIFIER_KEYWORDS.contains(iElementType) ? KotlinHighlightingColors.BUILTIN_ANNOTATION : KotlinHighlightingColors.KEYWORD;
        } else if (Intrinsics.areEqual((Object)elementType, (Object)((Object)KtTokens.SAFE_ACCESS))) {
            textAttributesKey = KotlinHighlightingColors.SAFE_ACCESS;
        } else {
            return;
        }
        TextAttributesKey attributes = textAttributesKey;
        this.holder.createInfoAnnotation(element2, (String)null).setTextAttributes(attributes);
    }

    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
        PsiElement arrow;
        Intrinsics.checkParameterIsNotNull((Object)lambdaExpression, (String)"lambdaExpression");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        KtFunctionLiteral functionLiteral = lambdaExpression.getFunctionLiteral();
        this.holder.createInfoAnnotation(functionLiteral.getLBrace(), (String)null).setTextAttributes(KotlinHighlightingColors.FUNCTION_LITERAL_BRACES_AND_ARROW);
        PsiElement closingBrace = functionLiteral.getRBrace();
        if (closingBrace != null) {
            this.holder.createInfoAnnotation(closingBrace, (String)null).setTextAttributes(KotlinHighlightingColors.FUNCTION_LITERAL_BRACES_AND_ARROW);
        }
        if ((arrow = functionLiteral.getArrow()) != null) {
            this.holder.createInfoAnnotation(arrow, (String)null).setTextAttributes(KotlinHighlightingColors.FUNCTION_LITERAL_BRACES_AND_ARROW);
        }
    }

    @Override
    public void visitArgument(@NotNull KtValueArgument argument2) {
        Intrinsics.checkParameterIsNotNull((Object)argument2, (String)"argument");
        KtValueArgumentName ktValueArgumentName = argument2.getArgumentName();
        if (ktValueArgumentName == null) {
            return;
        }
        KtValueArgumentName argumentName2 = ktValueArgumentName;
        PsiElement psiElement = argument2.getEqualsToken();
        if (psiElement == null) {
            return;
        }
        PsiElement eq = psiElement;
        this.holder.createInfoAnnotation(new TextRange(PsiUtilsKt.getStartOffset((PsiElement)argumentName2), PsiUtilsKt.getEndOffset(eq)), (String)null).setTextAttributes(KotlinHighlightingColors.NAMED_ARGUMENT);
    }

    @Override
    public void visitExpressionWithLabel(@NotNull KtExpressionWithLabel expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KtSimpleNameExpression targetLabel = expression2.getTargetLabel();
        if (targetLabel != null) {
            PsiElement psiElement = (PsiElement)targetLabel;
            TextAttributesKey textAttributesKey = KotlinHighlightingColors.LABEL;
            Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"KotlinHighlightingColors.LABEL");
            NameHighlighter.highlightName(this.holder, psiElement, textAttributesKey);
        }
    }

    public BeforeResolveHighlightingVisitor(@NotNull AnnotationHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        this.holder = holder;
    }
}

