/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.NameHighlighter;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;

class PropertiesHighlightingVisitor
extends AfterAnalysisHighlightingVisitor {
    PropertiesHighlightingVisitor(AnnotationHolder holder, BindingContext bindingContext2) {
        super(holder, bindingContext2);
    }

    @Override
    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/PropertiesHighlightingVisitor", "visitSimpleNameExpression"));
        }
        if (expression2.getParent() instanceof KtThisExpression) {
            return;
        }
        DeclarationDescriptor target = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
        if (target instanceof SyntheticFieldDescriptor) {
            NameHighlighter.highlightName(this.holder, (PsiElement)expression2, KotlinHighlightingColors.BACKING_FIELD_VARIABLE);
            return;
        }
        if (!(target instanceof PropertyDescriptor)) {
            return;
        }
        this.highlightProperty((PsiElement)expression2, (PropertyDescriptor)target, false);
    }

    @Override
    public void visitProperty(@NotNull KtProperty property2) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/idea/highlighter/PropertiesHighlightingVisitor", "visitProperty"));
        }
        PsiElement nameIdentifier = property2.getNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        VariableDescriptor propertyDescriptor = this.bindingContext.get(BindingContext.VARIABLE, property2);
        if (propertyDescriptor instanceof PropertyDescriptor) {
            Boolean backingFieldRequired = this.bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)propertyDescriptor);
            this.highlightProperty(nameIdentifier, (PropertyDescriptor)propertyDescriptor, Boolean.TRUE.equals(backingFieldRequired));
        }
        super.visitProperty(property2);
    }

    @Override
    public void visitParameter(@NotNull KtParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/highlighter/PropertiesHighlightingVisitor", "visitParameter"));
        }
        PsiElement nameIdentifier = parameter.getNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        PropertyDescriptor propertyDescriptor = this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
        if (propertyDescriptor != null) {
            Boolean backingFieldRequired = this.bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
            this.highlightProperty(nameIdentifier, propertyDescriptor, Boolean.TRUE.equals(backingFieldRequired));
        }
        super.visitParameter(parameter);
    }

    private void highlightProperty(@NotNull PsiElement elementToHighlight, @NotNull PropertyDescriptor descriptor2, boolean withBackingField) {
        if (elementToHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToHighlight", "org/jetbrains/kotlin/idea/highlighter/PropertiesHighlightingVisitor", "highlightProperty"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/highlighter/PropertiesHighlightingVisitor", "highlightProperty"));
        }
        if (DynamicCallsKt.isDynamic(descriptor2)) {
            NameHighlighter.highlightName(this.holder, elementToHighlight, KotlinHighlightingColors.DYNAMIC_PROPERTY_CALL);
            return;
        }
        boolean isStatic = DescriptorUtils.isStaticDeclaration(descriptor2);
        NameHighlighter.highlightName(this.holder, elementToHighlight, isStatic ? KotlinHighlightingColors.PACKAGE_PROPERTY : KotlinHighlightingColors.INSTANCE_PROPERTY);
        if (descriptor2.getExtensionReceiverParameter() != null) {
            NameHighlighter.highlightName(this.holder, elementToHighlight, KotlinHighlightingColors.EXTENSION_PROPERTY);
        }
        if (withBackingField) {
            this.holder.createInfoAnnotation(elementToHighlight, "This property has a backing field").setTextAttributes(KotlinHighlightingColors.PROPERTY_WITH_BACKING_FIELD);
        }
    }
}

