/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.ConflictingExtensionPropertyInspection;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.DeprecationUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.SyntheticScopes;
import org.jetbrains.kotlin.resolve.scopes.SyntheticScopesKt;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0002)*B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J+\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010 J\u0018\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0015H\u0002J\u0016\u0010$\u001a\u00020\t*\u0004\u0018\u00010%2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010&\u001a\u00020\t*\u0004\u0018\u00010%2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(H\u0002\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConflictingExtensionPropertyInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "checkGetterBodyIsGetMethodCall", "getter", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "getMethod", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkSetterBodyIsSetMethodCall", "setter", "setMethod", "conflictingSyntheticExtension", "Lorg/jetbrains/kotlin/synthetic/SyntheticJavaPropertyDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "scopes", "Lorg/jetbrains/kotlin/resolve/scopes/SyntheticScopes;", "createFixes", "", "Lcom/intellij/codeInspection/IntentionWrapper;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "conflictingExtension", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lorg/jetbrains/kotlin/synthetic/SyntheticJavaPropertyDescriptor;Z)[Lcom/intellij/codeInspection/IntentionWrapper;", "isSameAsSynthetic", "declaration", "syntheticProperty", "isGetMethodCall", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isSetMethodCall", "valueParameterName", "Lorg/jetbrains/kotlin/name/Name;", "DeleteRedundantExtensionAction", "MarkHiddenAndDeprecatedAction", "idea"})
public final class ConflictingExtensionPropertyInspection
extends AbstractKotlinInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        PsiFile psiFile = session.getFile();
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile = (KtFile)psiFile;
        if (ktFile == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElementVisitor, (String)"PsiElementVisitor.EMPTY_VISITOR");
            return psiElementVisitor;
        }
        KtFile file = ktFile;
        ResolutionFacade resolutionFacade2 = ResolutionUtils.getResolutionFacade(file);
        return new KtVisitorVoid(this, resolutionFacade2, isOnTheFly, holder){
            final /* synthetic */ ConflictingExtensionPropertyInspection this$0;
            final /* synthetic */ ResolutionFacade $resolutionFacade;
            final /* synthetic */ boolean $isOnTheFly;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitProperty(@NotNull KtProperty property2) {
                Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
                super.visitProperty(property2);
                if (property2.getReceiverTypeReference() != null) {
                    PsiElement psiElement = property2.getNameIdentifier();
                    if (psiElement == null) {
                        return;
                    }
                    PsiElement nameElement = psiElement;
                    DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptor(property2);
                    if (!(declarationDescriptor instanceof PropertyDescriptor)) {
                        declarationDescriptor = null;
                    }
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)declarationDescriptor;
                    if (propertyDescriptor == null) {
                        return;
                    }
                    PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
                    SyntheticScopes syntheticScopes = this.$resolutionFacade.getFrontendService(SyntheticScopes.class);
                    SyntheticJavaPropertyDescriptor syntheticJavaPropertyDescriptor = ConflictingExtensionPropertyInspection.access$conflictingSyntheticExtension(this.this$0, propertyDescriptor2, syntheticScopes);
                    if (syntheticJavaPropertyDescriptor == null) {
                        return;
                    }
                    SyntheticJavaPropertyDescriptor conflictingExtension = syntheticJavaPropertyDescriptor;
                    if (DeprecationUtilKt.isHiddenInResolution(propertyDescriptor2)) {
                        return;
                    }
                    IntentionWrapper[] fixes2 = ConflictingExtensionPropertyInspection.access$createFixes(this.this$0, property2, conflictingExtension, this.$isOnTheFly);
                    ProblemDescriptor problemDescriptor = this.$holder.getManager().createProblemDescriptor(nameElement, "This property conflicts with synthetic extension and should be removed or renamed to avoid breaking code by future changes in the compiler", true, (LocalQuickFix[])fixes2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                    this.$holder.registerProblem(problemDescriptor);
                }
            }
            {
                this.this$0 = $outer;
                this.$resolutionFacade = $captured_local_variable$1;
                this.$isOnTheFly = $captured_local_variable$2;
                this.$holder = $captured_local_variable$3;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final SyntheticJavaPropertyDescriptor conflictingSyntheticExtension(PropertyDescriptor descriptor2, SyntheticScopes scopes) {
        Object v3;
        block2: {
            void $receiver$iv;
            Annotated annotated = descriptor2.getExtensionReceiverParameter();
            if (annotated == null || (annotated = annotated.getType()) == null) {
                return null;
            }
            Annotated extensionReceiverType = annotated;
            Collection collection = CollectionsKt.listOf((Object)extensionReceiverType);
            Name name2 = descriptor2.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"descriptor.name");
            Iterable iterable = SyntheticScopesKt.collectSyntheticExtensionProperties(scopes, collection, name2, NoLookupLocation.FROM_IDE);
            for (Object element$iv : $receiver$iv) {
                if (!(element$iv instanceof SyntheticJavaPropertyDescriptor)) continue;
                v3 = element$iv;
                break block2;
            }
            v3 = null;
        }
        return v3;
    }

    private final boolean isSameAsSynthetic(KtProperty declaration, SyntheticJavaPropertyDescriptor syntheticProperty) {
        KtPropertyAccessor ktPropertyAccessor = declaration.getGetter();
        if (ktPropertyAccessor == null) {
            return false;
        }
        KtPropertyAccessor getter = ktPropertyAccessor;
        KtPropertyAccessor setter = declaration.getSetter();
        KtPropertyAccessor ktPropertyAccessor2 = getter;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktPropertyAccessor2, (String)"getter");
        if (!this.checkGetterBodyIsGetMethodCall(ktPropertyAccessor2, syntheticProperty.getGetMethod())) {
            return false;
        }
        if (setter != null) {
            FunctionDescriptor functionDescriptor = syntheticProperty.getSetMethod();
            if (functionDescriptor == null) {
                return false;
            }
            FunctionDescriptor setMethod = functionDescriptor;
            if (!this.checkSetterBodyIsSetMethodCall(setter, setMethod)) {
                return false;
            }
        }
        return true;
    }

    private final boolean checkGetterBodyIsGetMethodCall(KtPropertyAccessor getter, FunctionDescriptor getMethod) {
        if (getter.hasBlockBody()) {
            Object object;
            KtExpression ktExpression = getter.getBodyExpression();
            if (!(ktExpression instanceof KtBlockExpression)) {
                ktExpression = null;
            }
            if ((object = (KtBlockExpression)ktExpression) == null || (object = ((KtBlockExpression)object).getStatements()) == null || (object = (KtExpression)CollectionsKt.singleOrNull((List)object)) == null) {
                return false;
            }
            Object statement2 = object;
            Object object2 = statement2;
            if (!(object2 instanceof KtReturnExpression)) {
                object2 = null;
            }
            KtReturnExpression ktReturnExpression = (KtReturnExpression)object2;
            return this.isGetMethodCall(ktReturnExpression != null ? ktReturnExpression.getReturnedExpression() : null, getMethod);
        }
        return this.isGetMethodCall(getter.getBodyExpression(), getMethod);
    }

    private final boolean checkSetterBodyIsSetMethodCall(KtPropertyAccessor setter, FunctionDescriptor setMethod) {
        Object object = (KtParameter)CollectionsKt.singleOrNull(setter.getValueParameters());
        if (object == null || (object = ((KtParameter)object).getNameAsName()) == null) {
            return false;
        }
        Object valueParameterName = object;
        if (setter.hasBlockBody()) {
            Object object2;
            KtExpression ktExpression = setter.getBodyExpression();
            if (!(ktExpression instanceof KtBlockExpression)) {
                ktExpression = null;
            }
            if ((object2 = (KtBlockExpression)ktExpression) == null || (object2 = ((KtBlockExpression)object2).getStatements()) == null || (object2 = (KtExpression)CollectionsKt.singleOrNull((List)object2)) == null) {
                return false;
            }
            Object statement2 = object2;
            Object object3 = valueParameterName;
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"valueParameterName");
            return this.isSetMethodCall((KtExpression)statement2, setMethod, (Name)object3);
        }
        KtExpression ktExpression = setter.getBodyExpression();
        Object object4 = valueParameterName;
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"valueParameterName");
        return this.isSetMethodCall(ktExpression, setMethod, (Name)object4);
    }

    private final boolean isGetMethodCall(@Nullable KtExpression $receiver, FunctionDescriptor getMethod) {
        KtExpression ktExpression = $receiver;
        if (ktExpression instanceof KtCallExpression) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($receiver, ResolutionUtils.analyze$default($receiver, null, 1, null));
            return resolvedCall2 != null && ArgumentMappingKt.isReallySuccess(resolvedCall2) && Intrinsics.areEqual((Object)resolvedCall2.getResultingDescriptor().getOriginal(), (Object)getMethod.getOriginal());
        }
        if (ktExpression instanceof KtQualifiedExpression) {
            KtExpression receiver = ((KtQualifiedExpression)$receiver).getReceiverExpression();
            return receiver instanceof KtThisExpression && ((KtThisExpression)receiver).getLabelQualifier() == null && this.isGetMethodCall(((KtQualifiedExpression)$receiver).getSelectorExpression(), getMethod);
        }
        return false;
    }

    private final boolean isSetMethodCall(@Nullable KtExpression $receiver, FunctionDescriptor setMethod, Name valueParameterName) {
        KtExpression ktExpression = $receiver;
        if (ktExpression instanceof KtCallExpression) {
            KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull(((KtCallExpression)$receiver).getValueArguments());
            KtExpression ktExpression2 = ktValueArgument != null ? ktValueArgument.getArgumentExpression() : null;
            if (!(ktExpression2 instanceof KtSimpleNameExpression)) {
                ktExpression2 = null;
            }
            KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression2;
            if (Intrinsics.areEqual((Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedNameAsName() : null), (Object)valueParameterName) ^ true) {
                return false;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($receiver, ResolutionUtils.analyze$default($receiver, null, 1, null));
            return resolvedCall2 != null && ArgumentMappingKt.isReallySuccess(resolvedCall2) && Intrinsics.areEqual((Object)resolvedCall2.getResultingDescriptor().getOriginal(), (Object)setMethod.getOriginal());
        }
        if (ktExpression instanceof KtQualifiedExpression) {
            KtExpression receiver = ((KtQualifiedExpression)$receiver).getReceiverExpression();
            return receiver instanceof KtThisExpression && ((KtThisExpression)receiver).getLabelQualifier() == null && this.isSetMethodCall(((KtQualifiedExpression)$receiver).getSelectorExpression(), setMethod, valueParameterName);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final IntentionWrapper[] createFixes(KtProperty property2, SyntheticJavaPropertyDescriptor conflictingExtension, boolean isOnTheFly) {
        IntentionWrapper[] intentionWrapperArray;
        if (this.isSameAsSynthetic(property2, conflictingExtension)) {
            void $receiver$iv;
            IntentionWrapper fix1 = new IntentionWrapper((IntentionAction)new DeleteRedundantExtensionAction(property2), property2.getContainingFile());
            LowPriorityAction fix22 = isOnTheFly ? new LowPriorityAction(new MarkHiddenAndDeprecatedAction(property2), property2.getContainingFile()){} : null;
            Collection collection = CollectionsKt.listOfNotNull((Object[])new IntentionWrapper[]{fix1, (IntentionWrapper)fix22});
            void v0 = $receiver$iv;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = (Collection)v0;
            IntentionWrapper[] intentionWrapperArray2 = thisCollection$iv.toArray(new IntentionWrapper[thisCollection$iv.size()]);
            if (intentionWrapperArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            intentionWrapperArray = (IntentionWrapper[])((Object[])intentionWrapperArray2);
        } else {
            intentionWrapperArray = (IntentionWrapper[])((Object[])new IntentionWrapper[0]);
        }
        IntentionWrapper[] fixes2 = intentionWrapperArray;
        return fixes2;
    }

    @Nullable
    public static final /* synthetic */ SyntheticJavaPropertyDescriptor access$conflictingSyntheticExtension(ConflictingExtensionPropertyInspection $this, @NotNull PropertyDescriptor descriptor2, @NotNull SyntheticScopes scopes) {
        return $this.conflictingSyntheticExtension(descriptor2, scopes);
    }

    @NotNull
    public static final /* synthetic */ IntentionWrapper[] access$createFixes(ConflictingExtensionPropertyInspection $this, @NotNull KtProperty property2, @NotNull SyntheticJavaPropertyDescriptor conflictingExtension, boolean isOnTheFly) {
        return $this.createFixes(property2, conflictingExtension, isOnTheFly);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConflictingExtensionPropertyInspection$DeleteRedundantExtensionAction;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "property", "(Lorg/jetbrains/kotlin/psi/KtProperty;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "startInWriteAction", "", "idea"})
    private static final class DeleteRedundantExtensionAction
    extends KotlinQuickFixAction<KtProperty> {
        private final Logger LOG;

        @NotNull
        public String getFamilyName() {
            return "Delete redundant extension property";
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        @Override
        protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            KtProperty declaration = (KtProperty)this.getElement();
            FqName fqName2 = ImportsUtils.getImportableFqName(ResolutionUtils.resolveToDescriptor(declaration));
            if (fqName2 != null) {
                ProgressManager.getInstance().run((Task)new Task.Modal(this, project, declaration, project, "Searching for imports to delete", true){
                    final /* synthetic */ DeleteRedundantExtensionAction this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ KtProperty $declaration;

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                        List importsToDelete2 = (List)ApplicationUtilsKt.runReadAction((Function0)new Function0<List<? extends KtImportDirective>>(this){
                            final /* synthetic */ invoke.1 this$0;

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final List<KtImportDirective> invoke() {
                                void $receiver$iv$iv$iv;
                                Collection destination$iv$iv;
                                Object element$iv$iv2;
                                Iterable $receiver$iv$iv;
                                GlobalSearchScope searchScope2 = KotlinSourceFilterScope.sources(GlobalSearchScope.projectScope((Project)this.this$0.$project), this.this$0.$project);
                                Iterable $receiver$iv = (Iterable)ReferencesSearch.search((PsiElement)this.this$0.$declaration, (SearchScope)((SearchScope)searchScope2));
                                Iterable iterable = $receiver$iv;
                                Collection collection = new ArrayList<E>();
                                for (Object element$iv$iv2 : $receiver$iv$iv) {
                                    if (!(element$iv$iv2 instanceof KtSimpleNameReference)) continue;
                                    destination$iv$iv.add(element$iv$iv2);
                                }
                                $receiver$iv = (List)destination$iv$iv;
                                $receiver$iv$iv = $receiver$iv;
                                destination$iv$iv = new ArrayList<E>();
                                Iterator<T> iterator2 = $receiver$iv$iv;
                                element$iv$iv2 = $receiver$iv$iv$iv.iterator();
                                while (element$iv$iv2.hasNext()) {
                                    Boolean bl;
                                    void $receiver$iv2;
                                    E element$iv$iv$iv;
                                    E element$iv$iv3 = element$iv$iv$iv = element$iv$iv2.next();
                                    KtSimpleNameReference ref = (KtSimpleNameReference)element$iv$iv3;
                                    PsiElement psiElement = (PsiElement)ref.getExpression();
                                    if ((KtImportDirective)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtImportDirective.class, (boolean)true) != null) {
                                        KtImportDirective ktImportDirective;
                                        KtImportDirective it$iv$iv = ktImportDirective;
                                        bl = destination$iv$iv.add(it$iv$iv);
                                        continue;
                                    }
                                    bl = null;
                                }
                                $receiver$iv = (List)destination$iv$iv;
                                $receiver$iv$iv = $receiver$iv;
                                destination$iv$iv = new ArrayList<E>();
                                for (Object element$iv$iv2 : $receiver$iv$iv) {
                                    KtImportDirective ktImportDirective = (KtImportDirective)element$iv$iv2;
                                    if (!(!ktImportDirective.isAllUnder() && UtilsKt.targetDescriptors$default(ktImportDirective, null, 1, null).size() == 1)) continue;
                                    destination$iv$iv.add(element$iv$iv2);
                                }
                                return (List)destination$iv$iv;
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this, importsToDelete2){
                            final /* synthetic */ invoke.1 this$0;
                            final /* synthetic */ List $importsToDelete;

                            public final void run() {
                                ApplicationUtilsKt.executeWriteCommand(this.this$0.$project, this.this$0.this$0.getText(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                                    final /* synthetic */ invoke.run.1 this$0;

                                    public final void invoke() {
                                        Iterable $receiver$iv = this.this$0.$importsToDelete;
                                        for (T element$iv : $receiver$iv) {
                                            KtImportDirective ktImportDirective = (KtImportDirective)element$iv;
                                            try {
                                                ktImportDirective.delete();
                                            }
                                            catch (Exception e) {
                                                DeleteRedundantExtensionAction.access$getLOG$p(this.this$0.this$0.this$0).error((Throwable)e);
                                            }
                                        }
                                        this.this$0.this$0.$declaration.delete();
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(0);
                                    }
                                }));
                            }
                            {
                                this.this$0 = var1_1;
                                this.$importsToDelete = list2;
                            }
                        });
                    }
                    {
                        this.this$0 = $outer;
                        this.$project = $captured_local_variable$1;
                        this.$declaration = $captured_local_variable$2;
                        super($super_call_param$3, $super_call_param$4, $super_call_param$5);
                    }
                });
            } else {
                ApplicationUtilsKt.executeWriteCommand(project, this.getText(), (Function0<Unit>)((Function0)new Function0<Unit>(declaration){
                    final /* synthetic */ KtProperty $declaration;

                    public final void invoke() {
                        this.$declaration.delete();
                    }
                    {
                        this.$declaration = ktProperty;
                        super(0);
                    }
                }));
            }
        }

        public DeleteRedundantExtensionAction(@NotNull KtProperty property2) {
            Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
            super((PsiElement)property2);
            this.LOG = Logger.getInstance(DeleteRedundantExtensionAction.class);
        }

        @NotNull
        public static final /* synthetic */ Logger access$getLOG$p(DeleteRedundantExtensionAction $this) {
            return $this.LOG;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0011H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConflictingExtensionPropertyInspection$MarkHiddenAndDeprecatedAction;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "property", "(Lorg/jetbrains/kotlin/psi/KtProperty;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "addAnnotationWithLineBreak", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "annotationEntry", "idea"})
    private static final class MarkHiddenAndDeprecatedAction
    extends KotlinQuickFixAction<KtProperty> {
        @NotNull
        public String getFamilyName() {
            return "Mark as @Deprecated(..., level = DeprecationLevel.HIDDEN)";
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        @Override
        protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            KtPsiFactory factory2 = new KtPsiFactory(project);
            Name name2 = ((KtProperty)this.getElement()).getNameAsName();
            if (name2 == null) {
                Intrinsics.throwNpe();
            }
            String name3 = RenderingUtilsKt.render(name2);
            this.addAnnotationWithLineBreak((KtNamedDeclaration)this.getElement(), factory2.createAnnotationEntry("@Deprecated(" + "\"" + "Is replaced with automatic synthetic extension" + "\"" + ", ReplaceWith(" + "\"" + name3 + "\"" + "), level = DeprecationLevel.HIDDEN)"));
        }

        private final KtAnnotationEntry addAnnotationWithLineBreak(@NotNull KtNamedDeclaration $receiver, KtAnnotationEntry annotationEntry) {
            PsiElement newLine = KtPsiFactoryKt.KtPsiFactory($receiver).createNewLine();
            if ($receiver.getModifierList() != null) {
                KtAnnotationEntry result2 = $receiver.addAnnotationEntry(annotationEntry);
                KtModifierList ktModifierList = $receiver.getModifierList();
                if (ktModifierList == null) {
                    Intrinsics.throwNpe();
                }
                ktModifierList.addAfter(newLine, (PsiElement)result2);
                KtAnnotationEntry ktAnnotationEntry = result2;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktAnnotationEntry, (String)"result");
                return ktAnnotationEntry;
            }
            KtAnnotationEntry result3 = $receiver.addAnnotationEntry(annotationEntry);
            $receiver.addAfter(newLine, (PsiElement)$receiver.getModifierList());
            KtAnnotationEntry ktAnnotationEntry = result3;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktAnnotationEntry, (String)"result");
            return ktAnnotationEntry;
        }

        public MarkHiddenAndDeprecatedAction(@NotNull KtProperty property2) {
            Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
            super((PsiElement)property2);
        }
    }
}

