/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000p\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001a\f\u0010\u0018\u001a\u0004\u0018\u00010\n*\u00020\u0019\u001a\n\u0010\u001a\u001a\u00020\u0011*\u00020\u001b\u001a\n\u0010\u001c\u001a\u00020\u0011*\u00020\u0006\u001a\n\u0010\u001d\u001a\u00020\u001b*\u00020\u001b\u001a\u0012\u0010\u001e\u001a\u00020\u001f*\u00020 2\u0006\u0010!\u001a\u00020\"\u001a\u001c\u0010#\u001a\u00020\u001f*\u00020 2\u0006\u0010$\u001a\u00020\n2\b\b\u0002\u0010%\u001a\u00020\u0011\u001a\u001c\u0010#\u001a\u00020\u001f*\u00020 2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010%\u001a\u00020\u0011\u001a\u000e\u0010&\u001a\u0004\u0018\u00010\u001b*\u00020\u001bH\u0002\u001a\u001c\u0010'\u001a\f\u0012\u0006\b\u0001\u0012\u00020)\u0018\u00010(*\u00020\u00062\u0006\u0010*\u001a\u00020+\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0017\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006,"}, d2={"NEGATABLE_OPERATORS", "", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "getCallExpression", "(Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;)Lorg/jetbrains/kotlin/psi/KtCallExpression;", "calleeName", "", "getCalleeName", "(Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;)Ljava/lang/String;", "getNegatedOperatorText", "token", "Lcom/intellij/psi/tree/IElementType;", "isAutoCreatedItUsage", "", "expression", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "splitPropertyDeclaration", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "description", "Lorg/jetbrains/kotlin/psi/KtContainerNode;", "isExitStatement", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isReceiverExpressionWithValue", "negate", "setReceiverType", "", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "setType", "typeString", "shortenReferences", "specialNegation", "toResolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "bodyResolveMode", "Lorg/jetbrains/kotlin/resolve/lazy/BodyResolveMode;", "idea"})
public final class UtilsKt {
    private static final Set<KtSingleValueToken> NEGATABLE_OPERATORS = SetsKt.setOf((Object[])new KtSingleValueToken[]{KtTokens.EQEQ, KtTokens.EXCLEQ, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ, KtTokens.IS_KEYWORD, KtTokens.NOT_IS, KtTokens.IN_KEYWORD, KtTokens.NOT_IN, KtTokens.LT, KtTokens.LTEQ, KtTokens.GT, KtTokens.GTEQ});

    public static final void setType(@NotNull KtCallableDeclaration $receiver, @NotNull KotlinType type2, boolean shortenReferences) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        if (type2.isError()) {
            return;
        }
        UtilsKt.setType($receiver, IdeDescriptorRenderers.SOURCE_CODE.renderType(type2), shortenReferences);
    }

    public static /* bridge */ /* synthetic */ void setType$default(KtCallableDeclaration ktCallableDeclaration, KotlinType kotlinType, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setType");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        UtilsKt.setType(ktCallableDeclaration, kotlinType, bl);
    }

    public static final void setType(@NotNull KtCallableDeclaration $receiver, @NotNull String typeString, boolean shortenReferences) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)typeString, (String)"typeString");
        Project project = $receiver.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        KtTypeReference typeReference = new KtPsiFactory(project).createType(typeString);
        $receiver.setTypeReference(typeReference);
        if (shortenReferences) {
            KtTypeReference ktTypeReference = $receiver.getTypeReference();
            if (ktTypeReference == null) {
                Intrinsics.throwNpe();
            }
            KtElement ktElement = ktTypeReference;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"getTypeReference()!!");
            ShortenReferences.process$default(ShortenReferences.DEFAULT, ktElement, null, 2, null);
        }
    }

    public static /* bridge */ /* synthetic */ void setType$default(KtCallableDeclaration ktCallableDeclaration, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setType");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        UtilsKt.setType(ktCallableDeclaration, string, bl);
    }

    public static final void setReceiverType(@NotNull KtCallableDeclaration $receiver, @NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        if (type2.isError()) {
            return;
        }
        Project project = $receiver.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        KtTypeReference typeReference = new KtPsiFactory(project).createType(IdeDescriptorRenderers.SOURCE_CODE.renderType(type2));
        TypeRefHelpersKt.setReceiverTypeReference($receiver, typeReference);
        KtTypeReference ktTypeReference = $receiver.getReceiverTypeReference();
        if (ktTypeReference == null) {
            Intrinsics.throwNpe();
        }
        KtElement ktElement = ktTypeReference;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"receiverTypeReference!!");
        ShortenReferences.process$default(ShortenReferences.DEFAULT, ktElement, null, 2, null);
    }

    @Nullable
    public static final String description(@NotNull KtContainerNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        IElementType iElementType = $receiver.getNode().getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.THEN))) {
            return "if";
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.ELSE))) {
            return "else";
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.BODY))) {
            PsiElement psiElement = $receiver.getParent();
            if (psiElement instanceof KtWhileExpression) {
                return "while";
            }
            if (psiElement instanceof KtDoWhileExpression) {
                return "do...while";
            }
            if (psiElement instanceof KtForExpression) {
                return "for";
            }
        }
        return null;
    }

    public static final boolean isAutoCreatedItUsage(@NotNull KtNameReferenceExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        if (Intrinsics.areEqual((Object)expression2.getReferencedName(), (Object)"it") ^ true) {
            return false;
        }
        BindingContext context = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL);
        Object object = CollectionsKt.singleOrNull((Iterable)ReferenceUtilKt.getMainReference(expression2).resolveToDescriptors(context));
        if (!(object instanceof ValueParameterDescriptor)) {
            object = null;
        }
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)object;
        if (valueParameterDescriptor == null) {
            return false;
        }
        ValueParameterDescriptor target = valueParameterDescriptor;
        Object v = context.get(BindingContext.AUTO_CREATED_IT, target);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)v;
    }

    @NotNull
    public static final KtBinaryExpression splitPropertyDeclaration(@NotNull KtProperty property2) {
        Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
        PsiElement psiElement = property2.getParent();
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        PsiElement parent2 = psiElement;
        KtExpression ktExpression = property2.getInitializer();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression initializer2 = ktExpression;
        KotlinType explicitTypeToSet = property2.getTypeReference() != null ? (KotlinType)null : ResolutionUtils.analyze$default(initializer2, null, 1, null).getType(initializer2);
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory(property2);
        Object[] objectArray = new Object[2];
        Name name2 = property2.getNameAsName();
        if (name2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"property.nameAsName!!");
        objectArray[0] = name2;
        KtExpression ktExpression2 = initializer2;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"initializer");
        objectArray[1] = ktExpression2;
        KtExpression assignment = CreateByPatternKt.createExpressionByPattern(psiFactory, "$0 = $1", objectArray);
        PsiElement psiElement2 = parent2.addAfter((PsiElement)assignment, (PsiElement)property2);
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        }
        assignment = (KtBinaryExpression)psiElement2;
        parent2.addAfter(psiFactory.createNewLine(), (PsiElement)property2);
        property2.setInitializer(null);
        if (explicitTypeToSet != null) {
            UtilsKt.setType$default((KtCallableDeclaration)property2, explicitTypeToSet, false, 2, null);
        }
        return (KtBinaryExpression)assignment;
    }

    @Nullable
    public static final KtCallExpression getCallExpression(@NotNull KtQualifiedExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression ktExpression = $receiver.getSelectorExpression();
        if (!(ktExpression instanceof KtCallExpression)) {
            ktExpression = null;
        }
        return (KtCallExpression)ktExpression;
    }

    @Nullable
    public static final String getCalleeName(@NotNull KtQualifiedExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression($receiver);
        KtExpression ktExpression = ktCallExpression != null ? ktCallExpression.getCalleeExpression() : null;
        if (!(ktExpression instanceof KtNameReferenceExpression)) {
            ktExpression = null;
        }
        KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression;
        return ktNameReferenceExpression != null ? ktNameReferenceExpression.getText() : null;
    }

    @Nullable
    public static final ResolvedCall<? extends CallableDescriptor> toResolvedCall(@NotNull KtQualifiedExpression $receiver, @NotNull BodyResolveMode bodyResolveMode) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)((Object)bodyResolveMode), (String)"bodyResolveMode");
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression($receiver);
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression callExpression2 = ktCallExpression;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(callExpression2, ResolutionUtils.analyze(callExpression2, bodyResolveMode));
        if (resolvedCall2 == null) {
            return null;
        }
        return resolvedCall2;
    }

    public static final boolean isExitStatement(@NotNull KtExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression ktExpression = $receiver;
        return ktExpression instanceof KtContinueExpression || ktExpression instanceof KtBreakExpression || ktExpression instanceof KtThrowExpression || ktExpression instanceof KtReturnExpression;
    }

    public static final boolean isReceiverExpressionWithValue(@NotNull KtQualifiedExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression receiver = $receiver.getReceiverExpression();
        if (receiver instanceof KtSuperExpression) {
            return false;
        }
        return ResolutionUtils.analyze$default($receiver, null, 1, null).getType(receiver) != null;
    }

    @NotNull
    public static final KtExpression negate(@NotNull KtExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression specialNegation = UtilsKt.specialNegation($receiver);
        if (specialNegation != null) {
            return specialNegation;
        }
        return CreateByPatternKt.createExpressionByPattern(KtPsiFactoryKt.KtPsiFactory((PsiElement)$receiver), "!$0", $receiver);
    }

    /*
     * Unable to fully structure code
     */
    private static final KtExpression specialNegation(@NotNull KtExpression $receiver) {
        block10: {
            block13: {
                block11: {
                    block12: {
                        block9: {
                            factory = KtPsiFactoryKt.KtPsiFactory((PsiElement)$receiver);
                            var2_2 = $receiver;
                            if (!(var2_2 instanceof KtPrefixExpression)) break block9;
                            if (Intrinsics.areEqual((Object)((KtPrefixExpression)$receiver).getOperationReference().getReferencedName(), (Object)"!") && (baseExpression = ((KtPrefixExpression)$receiver).getBaseExpression()) != null && (type = (context = ResolutionUtils.analyzeAndGetResult(baseExpression).getBindingContext()).getType(baseExpression)) != null && KotlinBuiltIns.isBoolean(type)) {
                                return KtPsiUtil.safeDeparenthesize(baseExpression);
                            }
                            break block10;
                        }
                        if (var2_2 instanceof KtBinaryExpression) {
                            operator = ((KtBinaryExpression)$receiver).getOperationToken();
                            if (CollectionsKt.contains((Iterable)UtilsKt.NEGATABLE_OPERATORS, (Object)operator) ^ true) {
                                return null;
                            }
                            v0 = ((KtBinaryExpression)$receiver).getLeft();
                            if (v0 == null) {
                                return null;
                            }
                            left = v0;
                            v1 = ((KtBinaryExpression)$receiver).getRight();
                            if (v1 == null) {
                                return null;
                            }
                            right = v1;
                            v2 = new Object[3];
                            v3 = left;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"left");
                            v2[0] = v3;
                            v4 = operator;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"operator");
                            v2[1] = UtilsKt.getNegatedOperatorText(v4);
                            v5 = right;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"right");
                            v2[2] = v5;
                            return CreateByPatternKt.createExpressionByPattern(factory, "$0 $1 $2", v2);
                        }
                        if (!(var2_2 instanceof KtConstantExpression)) break block10;
                        v6 = var3_5 = ((KtConstantExpression)$receiver).getText();
                        if (v6 == null) break block11;
                        switch (v6.hashCode()) {
                            case 3569038: {
                                if (!var3_5.equals("true")) ** break;
                                break;
                            }
                            case 97196323: {
                                if (!var3_5.equals("false")) ** break;
                                break block12;
                            }
                        }
                        v7 = factory.createExpression("false");
                        break block13;
                    }
                    v7 = factory.createExpression("true");
                    break block13;
                }
                v7 = null;
            }
            return v7;
        }
        return null;
    }

    private static final String getNegatedOperatorText(IElementType token) {
        String string;
        IElementType iElementType = token;
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQ))) {
            String string2 = KtTokens.EXCLEQ.getValue();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"KtTokens.EXCLEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQ))) {
            String string3 = KtTokens.EQEQ.getValue();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"KtTokens.EQEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQEQ))) {
            String string4 = KtTokens.EXCLEQEQEQ.getValue();
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"KtTokens.EXCLEQEQEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQEQEQ))) {
            String string5 = KtTokens.EQEQEQ.getValue();
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"KtTokens.EQEQEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.IS_KEYWORD))) {
            String string6 = KtTokens.NOT_IS.getValue();
            string = string6;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"KtTokens.NOT_IS.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.NOT_IS))) {
            String string7 = KtTokens.IS_KEYWORD.getValue();
            string = string7;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"KtTokens.IS_KEYWORD.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.IN_KEYWORD))) {
            String string8 = KtTokens.NOT_IN.getValue();
            string = string8;
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"KtTokens.NOT_IN.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.NOT_IN))) {
            String string9 = KtTokens.IN_KEYWORD.getValue();
            string = string9;
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"KtTokens.IN_KEYWORD.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LT))) {
            String string10 = KtTokens.GTEQ.getValue();
            string = string10;
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"KtTokens.GTEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LTEQ))) {
            String string11 = KtTokens.GT.getValue();
            string = string11;
            Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"KtTokens.GT.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GT))) {
            String string12 = KtTokens.LTEQ.getValue();
            string = string12;
            Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"KtTokens.LTEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GTEQ))) {
            String string13 = KtTokens.LT.getValue();
            string = string13;
            Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"KtTokens.LT.value");
        } else {
            throw (Throwable)new IllegalArgumentException("The token " + token + " does not have a negated equivalent.");
        }
        return string;
    }
}

