/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.liveTemplates.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.ListResult;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/liveTemplates/macro/FunctionParametersMacro;", "Lcom/intellij/codeInsight/template/Macro;", "()V", "calculateResult", "Lcom/intellij/codeInsight/template/Result;", "params", "", "Lcom/intellij/codeInsight/template/Expression;", "context", "Lcom/intellij/codeInsight/template/ExpressionContext;", "([Lcom/intellij/codeInsight/template/Expression;Lcom/intellij/codeInsight/template/ExpressionContext;)Lcom/intellij/codeInsight/template/Result;", "getName", "", "getPresentableName", "isAcceptableInContext", "", "Lcom/intellij/codeInsight/template/TemplateContextType;", "idea-live-templates"})
public final class FunctionParametersMacro
extends Macro {
    @NotNull
    public String getName() {
        return "functionParameters";
    }

    @NotNull
    public String getPresentableName() {
        return "functionParameters()";
    }

    @Nullable
    public Result calculateResult(@NotNull Expression[] params2, @NotNull ExpressionContext context) {
        Intrinsics.checkParameterIsNotNull((Object)params2, (String)"params");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Project project = context.getProject();
        int templateStartOffset = context.getTemplateStartOffset();
        int offset2 = templateStartOffset > 0 ? context.getTemplateStartOffset() - 1 : context.getTemplateStartOffset();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        Editor editor = context.getEditor();
        if (editor == null) {
            Intrinsics.throwNpe();
        }
        PsiFile psiFile = psiDocumentManager.getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return null;
        }
        PsiFile file = psiFile;
        for (PsiElement place = file.findElementAt(offset2); place != null; place = place.getParent()) {
            if (!(place instanceof KtFunction)) continue;
            ArrayList<TextResult> result2 = new ArrayList<TextResult>();
            for (KtParameter param : ((KtFunction)place).getValueParameters()) {
                String string = param.getName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                result2.add(new TextResult(string));
            }
            return (Result)new ListResult((List)result2);
        }
        return null;
    }

    public boolean isAcceptableInContext(@Nullable TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }
}

