/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KtLightMethod;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.refactoring.ElementRenderingUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringBundle;
import org.jetbrains.kotlin.idea.refactoring.introduce.IntroduceUtilKt;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

public class KotlinRefactoringUtil {
    private KotlinRefactoringUtil() {
    }

    @NotNull
    public static String wrapOrSkip(@NotNull String s, boolean inCode) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "wrapOrSkip"));
        }
        String string = inCode ? "<code>" + s + "</code>" : s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "wrapOrSkip"));
        }
        return string;
    }

    @NotNull
    public static String formatClassDescriptor(@NotNull DeclarationDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "formatClassDescriptor"));
        }
        String string = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.render(classDescriptor);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "formatClassDescriptor"));
        }
        return string;
    }

    @NotNull
    public static String formatPsiClass(@NotNull PsiClass psiClass, boolean markAsJava, boolean inCode) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "formatPsiClass"));
        }
        String kind2 = psiClass.isInterface() ? "interface " : "class ";
        String description = kind2 + PsiFormatUtil.formatClass((PsiClass)psiClass, (int)4355);
        description = KotlinRefactoringUtil.wrapOrSkip(description, inCode);
        String string = markAsJava ? "[Java] " + description : description;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "formatPsiClass"));
        }
        return string;
    }

    @NotNull
    public static List<? extends PsiElement> checkSuperMethods(@NotNull KtDeclaration declaration, @Nullable Collection<PsiElement> ignore, @NotNull String actionStringKey) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "checkSuperMethods"));
        }
        if (actionStringKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionStringKey", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "checkSuperMethods"));
        }
        BindingContext bindingContext2 = ResolutionUtils.analyze(declaration, BodyResolveMode.FULL);
        CallableDescriptor declarationDescriptor = (CallableDescriptor)bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration);
        if (declarationDescriptor == null || declarationDescriptor instanceof LocalVariableDescriptor) {
            List<KtDeclaration> list2 = Collections.singletonList(declaration);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "checkSuperMethods"));
            }
            return list2;
        }
        Project project = declaration.getProject();
        HashMap<PsiElement, CallableDescriptor> overriddenElementsToDescriptor = new HashMap<PsiElement, CallableDescriptor>();
        for (CallableDescriptor overriddenDescriptor : DescriptorUtils.getAllOverriddenDescriptors(declarationDescriptor)) {
            PsiElement overriddenDeclaration = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project, overriddenDescriptor);
            if (!PsiTreeUtil.instanceOf((Object)overriddenDeclaration, (Class[])new Class[]{KtNamedFunction.class, KtProperty.class, PsiMethod.class})) continue;
            overriddenElementsToDescriptor.put(overriddenDeclaration, overriddenDescriptor);
        }
        if (ignore != null) {
            overriddenElementsToDescriptor.keySet().removeAll(ignore);
        }
        if (overriddenElementsToDescriptor.isEmpty()) {
            List<KtDeclaration> list3 = Collections.singletonList(declaration);
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "checkSuperMethods"));
            }
            return list3;
        }
        List<String> superClasses2 = KotlinRefactoringUtil.getClassDescriptions(overriddenElementsToDescriptor);
        List<? extends PsiElement> list4 = KotlinRefactoringUtil.askUserForMethodsToSearch(declaration, declarationDescriptor, overriddenElementsToDescriptor, superClasses2, actionStringKey);
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "checkSuperMethods"));
        }
        return list4;
    }

    @NotNull
    private static List<? extends PsiElement> askUserForMethodsToSearch(@NotNull KtDeclaration declaration, @NotNull CallableDescriptor declarationDescriptor, @NotNull Map<PsiElement, CallableDescriptor> overriddenElementsToDescriptor, @NotNull List<String> superClasses2, @NotNull String actionStringKey) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "askUserForMethodsToSearch"));
        }
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "askUserForMethodsToSearch"));
        }
        if (overriddenElementsToDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overriddenElementsToDescriptor", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "askUserForMethodsToSearch"));
        }
        if (superClasses2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClasses", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "askUserForMethodsToSearch"));
        }
        if (actionStringKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionStringKey", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "askUserForMethodsToSearch"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ArrayList arrayList = ContainerUtil.newArrayList(overriddenElementsToDescriptor.keySet());
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "askUserForMethodsToSearch"));
            }
            return arrayList;
        }
        String superClassesStr = "\n" + StringUtil.join(superClasses2, (String)"");
        String message2 = KotlinBundle.message("x.overrides.y.in.class.list", DescriptorRenderer.COMPACT_WITH_SHORT_TYPES.render(declarationDescriptor), IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.render(declarationDescriptor.getContainingDeclaration()), superClassesStr, KotlinBundle.message(actionStringKey, new Object[0]));
        int exitCode = Messages.showYesNoCancelDialog((Project)declaration.getProject(), (String)message2, (String)IdeBundle.message((String)"title.warning", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        switch (exitCode) {
            case 0: {
                ArrayList arrayList = ContainerUtil.newArrayList(overriddenElementsToDescriptor.keySet());
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "askUserForMethodsToSearch"));
                }
                return arrayList;
            }
            case 1: {
                List<KtDeclaration> list2 = Collections.singletonList(declaration);
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "askUserForMethodsToSearch"));
                }
                return list2;
            }
        }
        List list3 = Collections.emptyList();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "askUserForMethodsToSearch"));
        }
        return list3;
    }

    @NotNull
    private static List<String> getClassDescriptions(@NotNull Map<PsiElement, CallableDescriptor> overriddenElementsToDescriptor) {
        if (overriddenElementsToDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overriddenElementsToDescriptor", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "getClassDescriptions"));
        }
        List list2 = ContainerUtil.map(overriddenElementsToDescriptor.entrySet(), (Function)new Function<Map.Entry<PsiElement, CallableDescriptor>, String>(){

            public String fun(Map.Entry<PsiElement, CallableDescriptor> entry) {
                String description;
                PsiElement element2 = entry.getKey();
                CallableDescriptor descriptor2 = entry.getValue();
                if (element2 instanceof KtNamedFunction || element2 instanceof KtProperty) {
                    description = KotlinRefactoringUtil.formatClassDescriptor(descriptor2.getContainingDeclaration());
                } else {
                    assert (element2 instanceof PsiMethod) : "Invalid element: " + element2.getText();
                    PsiClass psiClass = ((PsiMethod)element2).getContainingClass();
                    assert (psiClass != null) : "Invalid element: " + element2.getText();
                    description = KotlinRefactoringUtil.formatPsiClass(psiClass, true, false);
                }
                return "    " + description + "\n";
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "getClassDescriptions"));
        }
        return list2;
    }

    @NotNull
    public static String formatClass(@NotNull DeclarationDescriptor classDescriptor, boolean inCode) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "formatClass"));
        }
        PsiElement element2 = DescriptorToSourceUtils.descriptorToDeclaration(classDescriptor);
        if (element2 instanceof PsiClass) {
            String string = KotlinRefactoringUtil.formatPsiClass((PsiClass)element2, false, inCode);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "formatClass"));
            }
            return string;
        }
        String string = KotlinRefactoringUtil.wrapOrSkip(KotlinRefactoringUtil.formatClassDescriptor(classDescriptor), inCode);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "formatClass"));
        }
        return string;
    }

    @NotNull
    public static String formatFunction(@NotNull DeclarationDescriptor functionDescriptor, boolean inCode) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "formatFunction"));
        }
        PsiElement element2 = DescriptorToSourceUtils.descriptorToDeclaration(functionDescriptor);
        if (element2 instanceof PsiMethod) {
            String string = KotlinRefactoringUtil.formatPsiMethod((PsiMethod)element2, false, inCode);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "formatFunction"));
            }
            return string;
        }
        String string = KotlinRefactoringUtil.wrapOrSkip(KotlinRefactoringUtil.formatFunctionDescriptor(functionDescriptor), inCode);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "formatFunction"));
        }
        return string;
    }

    @NotNull
    private static String formatFunctionDescriptor(@NotNull DeclarationDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "formatFunctionDescriptor"));
        }
        String string = DescriptorRenderer.COMPACT.render(functionDescriptor);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "formatFunctionDescriptor"));
        }
        return string;
    }

    @NotNull
    public static String formatPsiMethod(@NotNull PsiMethod psiMethod, boolean showContainingClass, boolean inCode) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "formatPsiMethod"));
        }
        int options = 259;
        if (showContainingClass) {
            options |= 0x1000;
        }
        String description = PsiFormatUtil.formatMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)options, (int)2);
        description = KotlinRefactoringUtil.wrapOrSkip(description, inCode);
        String string = "[Java] " + description;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "formatPsiMethod"));
        }
        return string;
    }

    @NotNull
    public static String formatJavaOrLightMethod(@NotNull PsiMethod method) {
        KtDeclaration ktDeclaration;
        BindingContext bindingContext2;
        DeclarationDescriptor descriptor2;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "formatJavaOrLightMethod"));
        }
        PsiElement originalDeclaration = LightClassUtilsKt.getUnwrapped((PsiElement)method);
        if (originalDeclaration instanceof KtDeclaration && (descriptor2 = (bindingContext2 = ResolutionUtils.analyze(ktDeclaration = (KtDeclaration)originalDeclaration, BodyResolveMode.FULL)).get(BindingContext.DECLARATION_TO_DESCRIPTOR, ktDeclaration)) != null) {
            String string = KotlinRefactoringUtil.formatFunctionDescriptor(descriptor2);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "formatJavaOrLightMethod"));
            }
            return string;
        }
        String string = KotlinRefactoringUtil.formatPsiMethod(method, false, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "formatJavaOrLightMethod"));
        }
        return string;
    }

    @NotNull
    public static String formatClass(@NotNull KtClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "formatClass"));
        }
        BindingContext bindingContext2 = ResolutionUtils.analyze(classOrObject, BodyResolveMode.FULL);
        DeclarationDescriptor descriptor2 = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, classOrObject);
        if (descriptor2 instanceof ClassDescriptor) {
            String string = KotlinRefactoringUtil.formatClassDescriptor(descriptor2);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "formatClass"));
            }
            return string;
        }
        String string = "class " + classOrObject.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "formatClass"));
        }
        return string;
    }

    @Nullable
    public static Collection<? extends PsiElement> checkParametersInMethodHierarchy(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "checkParametersInMethodHierarchy"));
        }
        PsiMethod method = (PsiMethod)parameter.getDeclarationScope();
        Set<PsiElement> parametersToDelete = KotlinRefactoringUtil.collectParametersHierarchy(method, parameter);
        if (parametersToDelete.size() > 1) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return parametersToDelete;
            }
            String message2 = KotlinBundle.message("delete.param.in.method.hierarchy", KotlinRefactoringUtil.formatJavaOrLightMethod(method));
            int exitCode = Messages.showOkCancelDialog((Project)parameter.getProject(), (String)message2, (String)IdeBundle.message((String)"title.warning", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (exitCode == 0) {
                return parametersToDelete;
            }
            return null;
        }
        return parametersToDelete;
    }

    @NotNull
    private static Set<PsiElement> collectParametersHierarchy(@NotNull PsiMethod method, @NotNull PsiParameter parameter) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "collectParametersHierarchy"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "collectParametersHierarchy"));
        }
        ArrayDeque<PsiMethod> queue = new ArrayDeque<PsiMethod>();
        HashSet<PsiMethod> visited2 = new HashSet<PsiMethod>();
        HashSet<PsiElement> parametersToDelete = new HashSet<PsiElement>();
        queue.add(method);
        while (!queue.isEmpty()) {
            PsiMethod currentMethod = (PsiMethod)queue.poll();
            visited2.add(currentMethod);
            KotlinRefactoringUtil.addParameter(currentMethod, parametersToDelete, parameter);
            for (PsiMethod superMethod : currentMethod.findSuperMethods(true)) {
                if (visited2.contains(superMethod)) continue;
                queue.offer(superMethod);
            }
            for (PsiMethod overrider : OverridingMethodsSearch.search((PsiMethod)currentMethod)) {
                if (visited2.contains(overrider)) continue;
                queue.offer(overrider);
            }
        }
        HashSet<PsiElement> hashSet = parametersToDelete;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "collectParametersHierarchy"));
        }
        return hashSet;
    }

    private static void addParameter(@NotNull PsiMethod method, @NotNull Set<PsiElement> result2, @NotNull PsiParameter parameter) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "addParameter"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "addParameter"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "addParameter"));
        }
        int parameterIndex2 = KtPsiUtilKt.parameterIndex(LightClassUtilsKt.getUnwrapped((PsiElement)parameter));
        if (method instanceof KtLightMethod) {
            KtDeclaration declaration = (KtDeclaration)((KtLightMethod)method).getKotlinOrigin();
            if (declaration instanceof KtFunction) {
                result2.add(((KtFunction)declaration).getValueParameters().get(parameterIndex2));
            }
        } else {
            result2.add((PsiElement)method.getParameterList().getParameters()[parameterIndex2]);
        }
    }

    public static void selectExpression(@NotNull Editor editor, @NotNull KtFile file, @NotNull SelectExpressionCallback callback2) throws IntroduceRefactoringException {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "selectExpression"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "selectExpression"));
        }
        if (callback2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "selectExpression"));
        }
        KotlinRefactoringUtil.selectExpression(editor, file, true, callback2);
    }

    public static void selectExpression(@NotNull Editor editor, @NotNull KtFile file, boolean failOnEmptySuggestion, @NotNull SelectExpressionCallback callback2) throws IntroduceRefactoringException {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "selectExpression"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "selectExpression"));
        }
        if (callback2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "selectExpression"));
        }
        if (editor.getSelectionModel().hasSelection()) {
            int selectionStart;
            int selectionEnd = editor.getSelectionModel().getSelectionEnd();
            String text2 = file.getText();
            for (selectionStart = editor.getSelectionModel().getSelectionStart(); selectionStart < selectionEnd && Character.isSpaceChar(text2.charAt(selectionStart)); ++selectionStart) {
            }
            while (selectionStart < selectionEnd && Character.isSpaceChar(text2.charAt(selectionEnd - 1))) {
                --selectionEnd;
            }
            callback2.run(KotlinRefactoringUtil.findExpression(file, selectionStart, selectionEnd, failOnEmptySuggestion));
        } else {
            int offset2 = editor.getCaretModel().getOffset();
            KotlinRefactoringUtil.smartSelectExpression(editor, (PsiFile)file, offset2, failOnEmptySuggestion, callback2);
        }
    }

    public static List<KtExpression> getSmartSelectSuggestions(@NotNull PsiFile file, int offset2) throws IntroduceRefactoringException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "getSmartSelectSuggestions"));
        }
        if (offset2 < 0) {
            return new ArrayList<KtExpression>();
        }
        PsiElement element2 = file.findElementAt(offset2);
        if (element2 == null) {
            return new ArrayList<KtExpression>();
        }
        if (element2 instanceof PsiWhiteSpace) {
            return KotlinRefactoringUtil.getSmartSelectSuggestions(file, offset2 - 1);
        }
        ArrayList<KtExpression> expressions = new ArrayList<KtExpression>();
        while (!(element2 == null || element2 instanceof KtBlockExpression && !(element2.getParent() instanceof KtFunctionLiteral) || element2 instanceof KtNamedFunction || element2 instanceof KtClassBody)) {
            if (element2 instanceof KtExpression && !(element2 instanceof KtStatementExpression)) {
                KtExpression expression2;
                BindingContext bindingContext2;
                KotlinType expressionType;
                KtOperationExpression operationExpression;
                boolean addExpression = true;
                if (element2 instanceof KtParenthesizedExpression) {
                    addExpression = false;
                } else if (KtPsiUtil.isLabelIdentifierExpression(element2)) {
                    addExpression = false;
                } else if (element2.getParent() instanceof KtQualifiedExpression) {
                    KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)element2.getParent();
                    if (qualifiedExpression.getReceiverExpression() != element2) {
                        addExpression = false;
                    }
                } else if (element2.getParent() instanceof KtCallElement || element2.getParent() instanceof KtThisExpression || PsiTreeUtil.getParentOfType((PsiElement)element2, KtSuperExpression.class) != null) {
                    addExpression = false;
                } else if (element2.getParent() instanceof KtOperationExpression && (operationExpression = (KtOperationExpression)element2.getParent()).getOperationReference() == element2) {
                    addExpression = false;
                }
                if (addExpression && ((expressionType = (bindingContext2 = ResolutionUtils.analyze(expression2 = (KtExpression)element2, BodyResolveMode.FULL)).getType(expression2)) == null || !KotlinBuiltIns.isUnit(expressionType))) {
                    expressions.add(expression2);
                }
            } else if (element2 instanceof KtTypeElement) {
                expressions.clear();
            }
            element2 = element2.getParent();
        }
        return expressions;
    }

    private static void smartSelectExpression(@NotNull Editor editor, @NotNull PsiFile file, int offset2, boolean failOnEmptySuggestion, final @NotNull SelectExpressionCallback callback2) throws IntroduceRefactoringException {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "smartSelectExpression"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "smartSelectExpression"));
        }
        if (callback2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "smartSelectExpression"));
        }
        List<KtExpression> expressions = KotlinRefactoringUtil.getSmartSelectSuggestions(file, offset2);
        if (expressions.size() == 0) {
            if (failOnEmptySuggestion) {
                throw new IntroduceRefactoringException(KotlinRefactoringBundle.message("cannot.refactor.not.expression", new Object[0]));
            }
            callback2.run(null);
            return;
        }
        if (expressions.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            callback2.run(expressions.get(0));
            return;
        }
        DefaultListModel<KtExpression> model = new DefaultListModel<KtExpression>();
        for (KtExpression expression2 : expressions) {
            model.addElement(expression2);
        }
        final ScopeHighlighter highlighter = new ScopeHighlighter(editor);
        JBList list2 = new JBList(model);
        list2.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(@NotNull JList list2, Object value2, int index2, boolean isSelected, boolean cellHasFocus) {
                if (list2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil$2", "getListCellRendererComponent"));
                }
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list2, value2, index2, isSelected, cellHasFocus);
                KtExpression element2 = (KtExpression)value2;
                if (element2.isValid()) {
                    this.setText(KotlinRefactoringUtil.getExpressionShortText(element2));
                }
                return rendererComponent;
            }
        });
        list2.addListSelectionListener(new ListSelectionListener((JList)list2, model){
            final /* synthetic */ JList val$list;
            final /* synthetic */ DefaultListModel val$model;
            {
                this.val$list = jList;
                this.val$model = defaultListModel;
            }

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil$3", "valueChanged"));
                }
                highlighter.dropHighlight();
                int selectedIndex = this.val$list.getSelectedIndex();
                if (selectedIndex < 0) {
                    return;
                }
                KtExpression expression2 = (KtExpression)this.val$model.get(selectedIndex);
                ArrayList<KtExpression> toExtract = new ArrayList<KtExpression>();
                toExtract.add(expression2);
                highlighter.highlight((PsiElement)expression2, toExtract);
            }
        });
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setTitle(KotlinRefactoringBundle.message("expressions.title", new Object[0])).setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(new Runnable((JList)list2){
            final /* synthetic */ JList val$list;
            {
                this.val$list = jList;
            }

            @Override
            public void run() {
                callback2.run((KtExpression)this.val$list.getSelectedValue());
            }
        }).addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                highlighter.dropHighlight();
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    public static String getExpressionShortText(@NotNull KtElement element2) {
        String text2;
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "getExpressionShortText"));
        }
        int firstNewLinePos = (text2 = ElementRenderingUtilsKt.renderTrimmed(element2)).indexOf(10);
        String trimmedText = text2.substring(0, firstNewLinePos != -1 ? firstNewLinePos : Math.min(100, text2.length()));
        if (trimmedText.length() != text2.length()) {
            trimmedText = trimmedText + " ...";
        }
        return trimmedText;
    }

    @Nullable
    private static KtExpression findExpression(@NotNull KtFile file, int startOffset, int endOffset, boolean failOnNoExpression) throws IntroduceRefactoringException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtil", "findExpression"));
        }
        KtExpression element2 = IntroduceUtilKt.findExpressionOrStringFragment(file, startOffset, endOffset);
        if (element2 == null) {
            if (failOnNoExpression) {
                throw new IntroduceRefactoringException(KotlinRefactoringBundle.message("cannot.refactor.not.expression", new Object[0]));
            }
            return null;
        }
        return element2;
    }

    public static class IntroduceRefactoringException
    extends Exception {
        private final String myMessage;

        public IntroduceRefactoringException(String message2) {
            this.myMessage = message2;
        }

        @Override
        public String getMessage() {
            return this.myMessage;
        }
    }

    public static interface SelectExpressionCallback {
        public void run(@Nullable KtExpression var1);
    }
}

