/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.ast;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.j2k.CodeBuilder;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.Operator;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/j2k/ast/PolyadicExpression;", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "expressions", "", "operators", "Lorg/jetbrains/kotlin/j2k/ast/Operator;", "(Ljava/util/List;Ljava/util/List;)V", "getExpressions", "()Ljava/util/List;", "getOperators", "generateCode", "", "builder", "Lorg/jetbrains/kotlin/j2k/CodeBuilder;", "j2k"})
public final class PolyadicExpression
extends Expression {
    @NotNull
    private final List<Expression> expressions;
    @NotNull
    private final List<Operator> operators;

    @Override
    public void generateCode(@NotNull CodeBuilder builder) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        boolean bl = this.expressions.size() == this.operators.size() + 1;
        if (_Assertions.ENABLED) {
            if (!bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)this.expressions)) {
            int i = indexedValue.component1();
            Expression expression2 = (Expression)indexedValue.component2();
            builder.append(expression2);
            if (i >= this.operators.size()) continue;
            builder.append(" ");
            builder.append(this.operators.get(i));
            builder.append(" ");
        }
    }

    @NotNull
    public final List<Expression> getExpressions() {
        return this.expressions;
    }

    @NotNull
    public final List<Operator> getOperators() {
        return this.operators;
    }

    public PolyadicExpression(@NotNull List<? extends Expression> expressions, @NotNull List<? extends Operator> operators) {
        Intrinsics.checkParameterIsNotNull(expressions, (String)"expressions");
        Intrinsics.checkParameterIsNotNull(operators, (String)"operators");
        this.expressions = expressions;
        this.operators = operators;
    }
}

