/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.expressions.CaptureKind;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CapturingInClosureChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "checkCapturingInClosure", "variable", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "isCapturedInInline", "", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "scopeContainer", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "variableParent", "isCapturedVariable", "frontend"})
public final class CapturingInClosureChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull BasicCallResolutionContext context) {
        VariableDescriptor variableDescriptor;
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ResolvedCall<?> variableResolvedCall = resolvedCall2 instanceof VariableAsFunctionResolvedCall ? ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall() : resolvedCall2;
        Object obj = variableResolvedCall.getResultingDescriptor();
        if (!(obj instanceof VariableDescriptor)) {
            obj = null;
        }
        if ((variableDescriptor = (VariableDescriptor)obj) != null) {
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
            LexicalScope lexicalScope = context.scope;
            Intrinsics.checkExpressionValueIsNotNull((Object)lexicalScope, (String)"context.scope");
            this.checkCapturingInClosure(variableDescriptor, bindingTrace, lexicalScope);
        }
    }

    private final void checkCapturingInClosure(VariableDescriptor variable2, BindingTrace trace, LexicalScope scope2) {
        DeclarationDescriptor variableParent = variable2.getContainingDeclaration();
        DeclarationDescriptor scopeContainer = scope2.getOwnerDescriptor();
        DeclarationDescriptor declarationDescriptor = variableParent;
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"variableParent");
        if (this.isCapturedVariable(declarationDescriptor, scopeContainer) && Intrinsics.areEqual((Object)((Object)((CaptureKind)((Object)trace.get(BindingContext.CAPTURED_IN_CLOSURE, variable2)))), (Object)((Object)CaptureKind.NOT_INLINE)) ^ true) {
            BindingContext bindingContext2 = trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
            DeclarationDescriptor declarationDescriptor2 = variableParent;
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor2, (String)"variableParent");
            boolean inline = this.isCapturedInInline(bindingContext2, scopeContainer, declarationDescriptor2);
            trace.record(BindingContext.CAPTURED_IN_CLOSURE, variable2, inline ? CaptureKind.INLINE_ONLY : CaptureKind.NOT_INLINE);
        }
    }

    private final boolean isCapturedVariable(DeclarationDescriptor variableParent, DeclarationDescriptor scopeContainer) {
        if (!(variableParent instanceof FunctionDescriptor) || Intrinsics.areEqual((Object)scopeContainer, (Object)variableParent)) {
            return false;
        }
        if (variableParent instanceof ConstructorDescriptor) {
            ClassDescriptor classDescriptor = ((ConstructorDescriptor)variableParent).getContainingDeclaration();
            if (Intrinsics.areEqual((Object)scopeContainer, (Object)classDescriptor)) {
                return false;
            }
            if (scopeContainer instanceof PropertyDescriptor && Intrinsics.areEqual((Object)((PropertyDescriptor)scopeContainer).getContainingDeclaration(), (Object)classDescriptor)) {
                return false;
            }
        }
        return true;
    }

    private final boolean isCapturedInInline(BindingContext context, DeclarationDescriptor scopeContainer, DeclarationDescriptor variableParent) {
        PsiElement scopeDeclaration = DescriptorToSourceUtils.descriptorToDeclaration(scopeContainer);
        if (!InlineUtil.canBeInlineArgument(scopeDeclaration)) {
            return false;
        }
        PsiElement psiElement = scopeDeclaration;
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
        }
        if (InlineUtil.isInlinedArgument((KtFunction)psiElement, context, false)) {
            Unit unit;
            DeclarationDescriptor scopeContainerParent = scopeContainer.getContainingDeclaration();
            boolean bl = scopeContainerParent != null;
            if (_Assertions.ENABLED) {
                if (!bl) {
                    String string = "parent is null for " + scopeContainer;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            DeclarationDescriptor declarationDescriptor = scopeContainerParent;
            if (declarationDescriptor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"scopeContainerParent!!");
            return !this.isCapturedVariable(variableParent, declarationDescriptor) || this.isCapturedInInline(context, scopeContainerParent, variableParent);
        }
        return false;
    }
}

