/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.synthetic.SamAdapterExtensionFunctionDescriptor;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/ProtectedSyntheticExtensionCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "frontend.java"})
public final class ProtectedSyntheticExtensionCallChecker
implements CallChecker {
    public static final ProtectedSyntheticExtensionCallChecker INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull BasicCallResolutionContext context) {
        boolean bl;
        DeclarationDescriptor from;
        Object descriptor2;
        block9: {
            void $receiver$iv;
            FunctionDescriptor functionDescriptor;
            Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object obj = descriptor2 = resolvedCall2.getResultingDescriptor();
            if (obj instanceof SyntheticJavaPropertyDescriptor) {
                functionDescriptor = ((SyntheticJavaPropertyDescriptor)descriptor2).getGetMethod();
            } else if (obj instanceof SamAdapterExtensionFunctionDescriptor) {
                functionDescriptor = ((SamAdapterExtensionFunctionDescriptor)descriptor2).getSourceFunction();
            } else {
                return;
            }
            FunctionDescriptor sourceFunction = functionDescriptor;
            from = context.scope.getOwnerDescriptor();
            if (!Visibilities.isVisibleIgnoringReceiver((DeclarationDescriptorWithVisibility)descriptor2, from)) {
                return;
            }
            if (resolvedCall2.getDispatchReceiver() != null && !(resolvedCall2.getExtensionReceiver() instanceof ReceiverValue)) {
                return;
            }
            Receiver receiver = resolvedCall2.getExtensionReceiver();
            if (receiver == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue");
            }
            ReceiverValue receiverValue = (ReceiverValue)receiver;
            Collection collection = CollectionsKt.listOf((Object)receiverValue.getType());
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiverValue, context);
            Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowValue, (String)"DataFlowValueFactory.cre\u2026e(receiverValue, context)");
            List receiverTypes = CollectionsKt.plus((Collection)collection, (Iterable)dataFlowInfo.getPredictableTypes(dataFlowValue));
            Iterable iterable = receiverTypes;
            for (Object element$iv : $receiver$iv) {
                KotlinType it = (KotlinType)element$iv;
                if (!Visibilities.isVisible(SmartCastUtilKt.getReceiverValueWithSmartCast(null, it), sourceFunction, from)) continue;
                bl = false;
                break block9;
            }
            bl = true;
        }
        if (bl) {
            context.trace.report(Errors.INVISIBLE_MEMBER.on((PsiElement)resolvedCall2.getCall().getCallElement(), (DeclarationDescriptor)descriptor2, descriptor2.getVisibility(), from));
        }
    }

    private ProtectedSyntheticExtensionCallChecker() {
        INSTANCE = this;
    }

    static {
        new ProtectedSyntheticExtensionCallChecker();
    }
}

