/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.ScriptNameUtil;
import org.jetbrains.kotlin.script.ScriptParameter;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/script/StandardScriptDefinition;", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "()V", "ARGS_NAME", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/annotations/NotNull;", "getScriptName", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "getScriptParameters", "", "Lorg/jetbrains/kotlin/script/ScriptParameter;", "scriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "isScript", "", "file", "Lcom/intellij/psi/PsiFile;", "frontend"})
public final class StandardScriptDefinition
implements KotlinScriptDefinition {
    private static final Name ARGS_NAME;
    public static final StandardScriptDefinition INSTANCE;

    @Override
    @NotNull
    public Name getScriptName(@NotNull KtScript script) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Name name2 = ScriptNameUtil.fileNameWithExtensionStripped(script, KotlinParserDefinition.STD_SCRIPT_EXT);
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"ScriptNameUtil.fileNameW\u2026efinition.STD_SCRIPT_EXT)");
        return name2;
    }

    @Override
    public boolean isScript(@NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)PathUtil.getFileExtension((String)file.getName()), (Object)KotlinParserDefinition.STD_SCRIPT_SUFFIX);
    }

    @Override
    @NotNull
    public List<ScriptParameter> getScriptParameters(@NotNull ScriptDescriptor scriptDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)scriptDescriptor, (String)"scriptDescriptor");
        KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns(scriptDescriptor);
        KotlinType arrayOfStrings = builtIns.getArrayType(Variance.INVARIANT, builtIns.getStringType());
        Name name2 = ARGS_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"ARGS_NAME");
        KotlinType kotlinType = arrayOfStrings;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"arrayOfStrings");
        return CollectionsKt.listOf((Object)new ScriptParameter(name2, kotlinType));
    }

    private StandardScriptDefinition() {
        INSTANCE = this;
        ARGS_NAME = Name.identifier("args");
    }

    static {
        new StandardScriptDefinition();
    }
}

