/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.resources.ResourceFolderType;
import com.android.tools.klint.checks.StringFormatDetector;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.LayoutDetector;
import com.android.tools.klint.detector.api.LintUtils;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import com.android.tools.klint.detector.api.XmlContext;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UQualifiedExpression;
import org.jetbrains.uast.USimpleReferenceExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RequiredAttributeDetector
extends LayoutDetector
implements UastScanner {
    public static final Issue ISSUE = Issue.create("RequiredSize", "Missing `layout_width` or `layout_height` attributes", "All views must specify an explicit `layout_width` and `layout_height` attribute. There is a runtime check for this, so if you fail to specify a size, an exception is thrown at runtime.\n\nIt's possible to specify these widths via styles as well. GridLayout, as a special case, does not require you to specify a size.", Category.CORRECTNESS, 4, Severity.ERROR, new Implementation(RequiredAttributeDetector.class, EnumSet.of(Scope.SOURCE_FILE, Scope.ALL_RESOURCE_FILES)));
    @Nullable
    private Map<String, String> mStyleParents;
    @Nullable
    private Set<String> mWidthStyles;
    @Nullable
    private Set<String> mHeightStyles;
    @Nullable
    private Set<String> mIncludedWidths;
    @Nullable
    private Set<String> mIncludedHeights;
    @Nullable
    private Set<String> mNotIncludedWidths;
    @Nullable
    private Set<String> mNotIncludedHeights;
    private boolean mSetWidthInTheme;
    private boolean mSetHeightInTheme;

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public boolean appliesTo(@NonNull ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.VALUES;
    }

    @Override
    public void afterCheckProject(@NonNull Context context) {
        if (context.getPhase() == 1) {
            this.checkSizeSetInTheme();
            context.requestRepeat(this, Scope.RESOURCE_FILE_SCOPE);
        }
    }

    private boolean isWidthStyle(String style) {
        return this.isSizeStyle(style, this.mWidthStyles);
    }

    private boolean isHeightStyle(String style) {
        return this.isSizeStyle(style, this.mHeightStyles);
    }

    private boolean isSizeStyle(String style, Set<String> sizeStyles) {
        if (RequiredAttributeDetector.isFrameworkSizeStyle(style)) {
            return true;
        }
        if (sizeStyles == null) {
            return false;
        }
        return this.isSizeStyle(RequiredAttributeDetector.stripStylePrefix(style), sizeStyles, 0);
    }

    private static boolean isFrameworkSizeStyle(String style) {
        if (style.equals("?android:attr/listSeparatorTextViewStyle") || style.equals("?android/listSeparatorTextViewStyle")) {
            return true;
        }
        return style.startsWith("?android:attr/quickContactBadgeStyle");
    }

    private boolean isSizeStyle(@NonNull String style, @NonNull Set<String> sizeStyles, int depth) {
        String parentStyle;
        if (depth == 30) {
            return false;
        }
        assert (!style.startsWith("@style/") && !style.startsWith("@android:style/"));
        if (sizeStyles.contains(style)) {
            return true;
        }
        if (this.mStyleParents != null && (parentStyle = this.mStyleParents.get(style)) != null && this.isSizeStyle(parentStyle = RequiredAttributeDetector.stripStylePrefix(parentStyle), sizeStyles, depth + 1)) {
            return true;
        }
        int index = style.lastIndexOf(46);
        if (index > 0) {
            return this.isSizeStyle(style.substring(0, index), sizeStyles, depth + 1);
        }
        return false;
    }

    private void checkSizeSetInTheme() {
        if (this.mStyleParents == null) {
            return;
        }
        HashMap isTheme = Maps.newHashMap();
        for (String style : this.mStyleParents.keySet()) {
            if (!this.isTheme(RequiredAttributeDetector.stripStylePrefix(style), isTheme, 0)) continue;
            this.mSetWidthInTheme = true;
            this.mSetHeightInTheme = true;
            break;
        }
    }

    private boolean isTheme(String style, Map<String, Boolean> isTheme, int depth) {
        String parentStyle;
        if (depth == 30) {
            return false;
        }
        assert (!style.startsWith("@style/") && !style.startsWith("@android:style/"));
        Boolean known = isTheme.get(style);
        if (known != null) {
            return known;
        }
        if (style.contains("Theme")) {
            isTheme.put(style, true);
            return true;
        }
        if (this.mStyleParents != null && (parentStyle = this.mStyleParents.get(style)) != null && this.isTheme(parentStyle = RequiredAttributeDetector.stripStylePrefix(parentStyle), isTheme, depth + 1)) {
            isTheme.put(style, true);
            return true;
        }
        int index = style.lastIndexOf(46);
        if (index > 0) {
            String parentStyle2 = style.substring(0, index);
            boolean result = this.isTheme(parentStyle2, isTheme, depth + 1);
            isTheme.put(style, result);
            return result;
        }
        return false;
    }

    static boolean hasLayoutVariations(File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            return false;
        }
        File res = parent.getParentFile();
        if (res == null) {
            return false;
        }
        String name2 = file.getName();
        File[] folders = res.listFiles();
        if (folders == null) {
            return false;
        }
        for (File folder : folders) {
            File other;
            if (!folder.getName().startsWith("layout") || folder.equals(parent) || !(other = new File(folder, name2)).exists()) continue;
            return true;
        }
        return false;
    }

    private static String stripStylePrefix(@NonNull String style) {
        if (style.startsWith("@style/")) {
            style = style.substring("@style/".length());
        } else if (style.startsWith("@android:style/")) {
            style = style.substring("@android:style/".length());
        }
        return style;
    }

    private static boolean isRootElement(@NonNull Node node) {
        return node == node.getOwnerDocument().getDocumentElement();
    }

    @Override
    public Collection<String> getApplicableElements() {
        return ALL;
    }

    @Override
    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        ResourceFolderType folderType = context.getResourceFolderType();
        int phase = context.getPhase();
        if (phase == 1 && folderType == ResourceFolderType.VALUES) {
            String tag = element.getTagName();
            if ("style".equals(tag)) {
                String name2;
                String parent = element.getAttribute("parent");
                if (parent != null && !parent.isEmpty() && (name2 = element.getAttribute("name")) != null && !name2.isEmpty()) {
                    if (this.mStyleParents == null) {
                        this.mStyleParents = Maps.newHashMap();
                    }
                    this.mStyleParents.put(name2, parent);
                }
            } else if ("item".equals(tag) && "style".equals(element.getParentNode().getNodeName())) {
                String styleName;
                String name3 = element.getAttribute("name");
                if (name3.endsWith("layout_width") && name3.equals("android:layout_width")) {
                    if (this.mWidthStyles == null) {
                        this.mWidthStyles = Sets.newHashSet();
                    }
                    styleName = ((Element)element.getParentNode()).getAttribute("name");
                    this.mWidthStyles.add(styleName);
                }
                if (name3.endsWith("layout_height") && name3.equals("android:layout_height")) {
                    if (this.mHeightStyles == null) {
                        this.mHeightStyles = Sets.newHashSet();
                    }
                    styleName = ((Element)element.getParentNode()).getAttribute("name");
                    this.mHeightStyles.add(styleName);
                }
            }
        } else if (folderType == ResourceFolderType.LAYOUT) {
            if (phase == 1) {
                String layout;
                if (element.getTagName().equals("include") && (layout = element.getAttribute("layout")) != null && !layout.isEmpty()) {
                    this.recordIncludeWidth(layout, element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_width"));
                    this.recordIncludeHeight(layout, element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_height"));
                }
            } else {
                String message2;
                String parentTag;
                assert (phase == 2);
                boolean hasWidth = element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_width");
                boolean hasHeight = element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_height");
                if (this.mSetWidthInTheme) {
                    hasWidth = true;
                }
                if (this.mSetHeightInTheme) {
                    hasHeight = true;
                }
                if (hasWidth && hasHeight) {
                    return;
                }
                String tag = element.getTagName();
                if ("merge".equals(tag) || "include".equals(tag) || "requestFocus".equals(tag)) {
                    return;
                }
                String string = parentTag = element.getParentNode() != null ? element.getParentNode().getNodeName() : "";
                if ("TableLayout".equals(parentTag) || "TableRow".equals(parentTag) || "GridLayout".equals(parentTag) || "android.support.v7.widget.GridLayout".equals(parentTag)) {
                    return;
                }
                if (!context.getProject().getReportIssues()) {
                    return;
                }
                boolean certain = true;
                boolean isRoot = RequiredAttributeDetector.isRootElement(element);
                if (isRoot || RequiredAttributeDetector.isRootElement(element.getParentNode()) && "merge".equals(parentTag)) {
                    String name4 = "@layout/" + LintUtils.getLayoutName(context.file);
                    if (!hasWidth && this.mIncludedWidths != null) {
                        hasWidth = this.mIncludedWidths.contains(name4);
                        if (this.mNotIncludedWidths != null && this.mNotIncludedWidths.contains(name4)) {
                            hasWidth = false;
                            boolean bl = certain = !RequiredAttributeDetector.hasLayoutVariations(context.file);
                        }
                    }
                    if (!hasHeight && this.mIncludedHeights != null) {
                        hasHeight = this.mIncludedHeights.contains(name4);
                        if (this.mNotIncludedHeights != null && this.mNotIncludedHeights.contains(name4)) {
                            hasHeight = false;
                            boolean bl = certain = !RequiredAttributeDetector.hasLayoutVariations(context.file);
                        }
                    }
                    if (hasWidth && hasHeight) {
                        return;
                    }
                }
                if (!hasWidth || !hasHeight) {
                    String style = element.getAttribute("style");
                    if (style != null && !style.isEmpty()) {
                        if (!hasWidth) {
                            hasWidth = this.isWidthStyle(style);
                        }
                        if (!hasHeight) {
                            hasHeight = this.isHeightStyle(style);
                        }
                    }
                    if (hasWidth && hasHeight) {
                        return;
                    }
                }
                if (!hasWidth && !hasHeight) {
                    message2 = certain ? "The required `layout_width` and `layout_height` attributes are missing" : "The required `layout_width` and `layout_height` attributes *may* be missing";
                } else {
                    String attribute = hasWidth ? "layout_height" : "layout_width";
                    message2 = certain ? String.format("The required `%1$s` attribute is missing", attribute) : String.format("The required `%1$s` attribute *may* be missing", attribute);
                }
                context.report(ISSUE, element, context.getLocation(element), message2);
            }
        }
    }

    private void recordIncludeWidth(String layout, boolean providesWidth) {
        if (providesWidth) {
            if (this.mIncludedWidths == null) {
                this.mIncludedWidths = Sets.newHashSet();
            }
            this.mIncludedWidths.add(layout);
        } else {
            if (this.mNotIncludedWidths == null) {
                this.mNotIncludedWidths = Sets.newHashSet();
            }
            this.mNotIncludedWidths.add(layout);
        }
    }

    private void recordIncludeHeight(String layout, boolean providesHeight) {
        if (providesHeight) {
            if (this.mIncludedHeights == null) {
                this.mIncludedHeights = Sets.newHashSet();
            }
            this.mIncludedHeights.add(layout);
        } else {
            if (this.mNotIncludedHeights == null) {
                this.mNotIncludedHeights = Sets.newHashSet();
            }
            this.mNotIncludedHeights.add(layout);
        }
    }

    @Override
    public List<String> getApplicableFunctionNames() {
        return Collections.singletonList("inflate");
    }

    @Override
    public void visitCall(UastAndroidContext context, UCallExpression node) {
        int viewRootPos;
        List<UExpression> args = node.getValueArguments();
        String layout = null;
        int index = 0;
        for (UExpression expression2 : args) {
            UQualifiedExpression outer;
            UExpression operand2;
            if (expression2 instanceof UQualifiedExpression && (operand2 = (outer = (UQualifiedExpression)expression2).getReceiver()) instanceof UQualifiedExpression) {
                UExpression reference;
                UQualifiedExpression inner = (UQualifiedExpression)operand2;
                if (inner.getReceiver() instanceof USimpleReferenceExpression) {
                    reference = (USimpleReferenceExpression)inner.getReceiver();
                    if ("R".equals(reference.getIdentifier()) && inner.selectorMatches("layout")) {
                        layout = "@layout/" + outer.getSelector().renderString();
                        break;
                    }
                } else if (inner.getReceiver() instanceof UQualifiedExpression && (reference = (UQualifiedExpression)inner.getReceiver()).selectorMatches("R") && inner.selectorMatches("layout")) {
                    layout = "@layout/" + outer.getSelector().renderString();
                    break;
                }
            }
            ++index;
        }
        if (layout == null) {
            UFunction containingFunction = UastUtils.getContainingFunction(node);
            if (containingFunction != null) {
                index = 0;
                String name2 = StringFormatDetector.getResourceArg(containingFunction, node, index);
                if (name2 == null) {
                    index = 1;
                    name2 = StringFormatDetector.getResourceArg(containingFunction, node, index);
                }
                if (name2 != null) {
                    layout = "@layout/" + name2;
                }
            }
            if (layout == null) {
                return;
            }
        }
        if ((viewRootPos = index + 1) < args.size()) {
            UExpression viewRoot;
            Iterator<UExpression> iterator = args.iterator();
            for (int i = 0; iterator.hasNext() && i < viewRootPos; ++i) {
                iterator.next();
            }
            if (iterator.hasNext() && (viewRoot = iterator.next()) instanceof ULiteralExpression && ((ULiteralExpression)viewRoot).isNull()) {
                this.recordIncludeWidth(layout, true);
                this.recordIncludeHeight(layout, true);
            }
        }
    }
}

