/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.codeInsight.daemon.impl.MarkerType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLineMarkerProvider
extends LineMarkerProviderDescriptor {
    protected final DaemonCodeAnalyzerSettings myDaemonSettings;
    protected final EditorColorsManager myColorsManager;
    private final GutterIconDescriptor.Option myLambdaOption = new GutterIconDescriptor.Option("java.lambda", "Lambda", AllIcons.Gutter.ImplementingFunctionalInterface);
    private final GutterIconDescriptor.Option myOverriddenOption = new GutterIconDescriptor.Option("java.overridden", "Overridden method", AllIcons.Gutter.OverridenMethod);
    private final GutterIconDescriptor.Option myImplementedOption = new GutterIconDescriptor.Option("java.implemented", "Implemented method", AllIcons.Gutter.ImplementedMethod);
    private final GutterIconDescriptor.Option myOverridingOption = new GutterIconDescriptor.Option("java.overriding", "Overriding method", AllIcons.Gutter.OverridingMethod);
    private final GutterIconDescriptor.Option myImplementingOption = new GutterIconDescriptor.Option("java.implementing", "Implementing method", AllIcons.Gutter.ImplementingMethod);

    public JavaLineMarkerProvider(DaemonCodeAnalyzerSettings daemonSettings, EditorColorsManager colorsManager) {
        this.myDaemonSettings = daemonSettings;
        this.myColorsManager = colorsManager;
    }

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider", "getLineMarkerInfo"));
        }
        if (element instanceof PsiIdentifier && (parent = element.getParent()) instanceof PsiMethod) {
            if (!this.myOverridingOption.isEnabled() && !this.myImplementingOption.isEnabled()) {
                return null;
            }
            PsiMethod method = (PsiMethod)parent;
            MethodSignatureBackedByPsiMethod superSignature = (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst();
            if (superSignature != null) {
                Icon icon;
                boolean overrides;
                boolean bl = overrides = method.hasModifierProperty("abstract") == superSignature.getMethod().hasModifierProperty("abstract");
                if (overrides) {
                    if (!this.myOverridingOption.isEnabled()) {
                        return null;
                    }
                    icon = AllIcons.Gutter.OverridingMethod;
                } else {
                    if (!this.myImplementingOption.isEnabled()) {
                        return null;
                    }
                    icon = AllIcons.Gutter.ImplementingMethod;
                }
                return JavaLineMarkerProvider.createSuperMethodLineMarkerInfo(element, icon, 4);
            }
        }
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)element);
        PsiElement firstChild = element.getFirstChild();
        if (interfaceMethod != null && firstChild != null && this.myLambdaOption.isEnabled()) {
            return JavaLineMarkerProvider.createSuperMethodLineMarkerInfo(firstChild, AllIcons.Gutter.ImplementingFunctionalInterface, 4);
        }
        if (this.myDaemonSettings.SHOW_METHOD_SEPARATORS && firstChild == null) {
            PsiElement element1 = element;
            boolean isMember = false;
            while (element1 != null && !(element1 instanceof PsiFile) && element1.getPrevSibling() == null) {
                if (!((element1 = element1.getParent()) instanceof PsiMember)) continue;
                isMember = true;
                break;
            }
            if (isMember && !(element1 instanceof PsiAnonymousClass) && !(element1.getParent() instanceof PsiAnonymousClass)) {
                PsiFile file2 = element1.getContainingFile();
                Document document2 = file2 == null ? null : PsiDocumentManager.getInstance((Project)file2.getProject()).getLastCommittedDocument(file2);
                boolean drawSeparator = false;
                if (document2 != null) {
                    CharSequence documentChars = document2.getCharsSequence();
                    int category = JavaLineMarkerProvider.getCategory(element1, documentChars);
                    for (PsiElement child = element1.getPrevSibling(); child != null; child = child.getPrevSibling()) {
                        int category1 = JavaLineMarkerProvider.getCategory(child, documentChars);
                        if (category1 == 0) continue;
                        drawSeparator = category != 1 || category1 != 1;
                        break;
                    }
                }
                if (drawSeparator) {
                    LineMarkerInfo info = new LineMarkerInfo(element, element.getTextRange(), null, 4, (Function)FunctionUtil.nullConstant(), null, GutterIconRenderer.Alignment.RIGHT);
                    EditorColorsScheme scheme = this.myColorsManager.getGlobalScheme();
                    info.separatorColor = scheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
                    info.separatorPlacement = SeparatorPlacement.TOP;
                    return info;
                }
            }
        }
        return null;
    }

    @NotNull
    private static LineMarkerInfo createSuperMethodLineMarkerInfo(@NotNull PsiElement name, @NotNull Icon icon, int passId) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider", "createSuperMethodLineMarkerInfo"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider", "createSuperMethodLineMarkerInfo"));
        }
        ArrowUpLineMarkerInfo info = new ArrowUpLineMarkerInfo(name, icon, MarkerType.OVERRIDING_METHOD, passId);
        LineMarkerInfo lineMarkerInfo = NavigateAction.setNavigateAction((LineMarkerInfo)info, (String)"Go to super method", (String)"GotoSuperMethod");
        if (lineMarkerInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider", "createSuperMethodLineMarkerInfo"));
        }
        return lineMarkerInfo;
    }

    private static int getCategory(@NotNull PsiElement element, @NotNull CharSequence documentChars) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider", "getCategory"));
        }
        if (documentChars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentChars", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider", "getCategory"));
        }
        if (element instanceof PsiField || element instanceof PsiTypeParameter) {
            return 1;
        }
        if (element instanceof PsiClass || element instanceof PsiClassInitializer) {
            return 2;
        }
        if (element instanceof PsiMethod) {
            int end;
            if (((PsiMethod)element).hasModifierProperty("abstract")) {
                return 1;
            }
            TextRange textRange = element.getTextRange();
            int start = textRange.getStartOffset();
            int crlf = StringUtil.getLineBreakCount((CharSequence)documentChars.subSequence(start, end = Math.min(documentChars.length(), textRange.getEndOffset())));
            return crlf == 0 ? 1 : 2;
        }
        return 0;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result2) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider", "collectSlowLineMarkers"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        THashSet methods = new THashSet();
        for (int i = 0; i < elements.size(); ++i) {
            PsiElement element = elements.get(i);
            ProgressManager.checkCanceled();
            if (!(element instanceof PsiIdentifier)) continue;
            PsiElement parent = element.getParent();
            if (parent instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)parent;
                if (!PsiUtil.canBeOverriden((PsiMethod)method)) continue;
                methods.add(method);
                continue;
            }
            if (!(parent instanceof PsiClass) || parent instanceof PsiTypeParameter) continue;
            this.collectInheritingClasses((PsiClass)parent, result2);
        }
        if (!methods.isEmpty()) {
            JavaLineMarkerProvider.collectSiblingInheritedMethods((Collection<PsiMethod>)methods, result2);
            this.collectOverridingMethods((Collection<PsiMethod>)methods, result2);
        }
    }

    private static void collectSiblingInheritedMethods(@NotNull Collection<PsiMethod> methods, @NotNull Collection<LineMarkerInfo> result2) {
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider", "collectSiblingInheritedMethods"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider", "collectSiblingInheritedMethods"));
        }
        Map<PsiMethod, FindSuperElementsHelper.SiblingInfo> map = FindSuperElementsHelper.getSiblingInheritanceInfos(methods);
        for (PsiMethod method : map.keySet()) {
            PsiElement range = JavaLineMarkerProvider.getMethodRange(method);
            ArrowUpLineMarkerInfo upInfo = new ArrowUpLineMarkerInfo(range, AllIcons.Gutter.ImplementingMethod, MarkerType.SIBLING_OVERRIDING_METHOD, 6);
            LineMarkerInfo info = NavigateAction.setNavigateAction((LineMarkerInfo)upInfo, (String)"Go to super method", (String)"GotoSuperMethod");
            result2.add(info);
        }
    }

    @NotNull
    private static PsiElement getMethodRange(@NotNull PsiMethod method) {
        PsiIdentifier range;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider", "getMethodRange"));
        }
        if (method.isPhysical()) {
            range = method.getNameIdentifier();
        } else {
            PsiElement navigationElement = method.getNavigationElement();
            PsiElement psiElement = range = navigationElement instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)navigationElement).getNameIdentifier() : navigationElement;
        }
        if (range == null) {
            range = method;
        }
        PsiIdentifier psiIdentifier = range;
        if (psiIdentifier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider", "getMethodRange"));
        }
        return psiIdentifier;
    }

    protected void collectInheritingClasses(@NotNull PsiClass aClass, @NotNull Collection<LineMarkerInfo> result2) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider", "collectInheritingClasses"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider", "collectInheritingClasses"));
        }
        if (aClass.hasModifierProperty("final")) {
            return;
        }
        if ("java.lang.Object".equals(aClass.getQualifiedName())) {
            return;
        }
        PsiClass subClass = (PsiClass)DirectClassInheritorsSearch.search((PsiClass)aClass).findFirst();
        if (subClass != null || FunctionalExpressionSearch.search((PsiClass)aClass).findFirst() != null) {
            Icon icon;
            if (aClass.isInterface()) {
                if (!this.myImplementedOption.isEnabled()) {
                    return;
                }
                icon = AllIcons.Gutter.ImplementedMethod;
            } else {
                if (!this.myOverriddenOption.isEnabled()) {
                    return;
                }
                icon = AllIcons.Gutter.OverridenMethod;
            }
            PsiIdentifier range = aClass.getNameIdentifier();
            if (range == null) {
                range = aClass;
            }
            MarkerType type = MarkerType.SUBCLASSED_CLASS;
            LineMarkerInfo info = new LineMarkerInfo((PsiElement)range, range.getTextRange(), icon, 6, type.getTooltip(), type.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
            NavigateAction.setNavigateAction((LineMarkerInfo)info, (String)(aClass.isInterface() ? "Go to implementation(s)" : "Go to subclass(es)"), (String)"GotoImplementation");
            result2.add(info);
        }
    }

    private void collectOverridingMethods(@NotNull Collection<PsiMethod> methods, @NotNull Collection<LineMarkerInfo> result2) {
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider", "collectOverridingMethods"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider", "collectOverridingMethods"));
        }
        if (!this.myOverriddenOption.isEnabled() && !this.myImplementedOption.isEnabled()) {
            return;
        }
        HashSet overridden = new HashSet();
        THashSet methodContainingClasses = new THashSet();
        for (PsiMethod method : methods) {
            ProgressManager.checkCanceled();
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || "java.lang.Object".equals(containingClass.getQualifiedName())) continue;
            methodContainingClasses.add(containingClass);
        }
        for (PsiClass aClass : methodContainingClasses) {
            AllOverridingMethodsSearch.search((PsiClass)aClass).forEach(arg_0 -> JavaLineMarkerProvider.lambda$collectOverridingMethods$0(methods, (Set)overridden, arg_0));
        }
        if (!methods.isEmpty()) {
            for (PsiClass aClass : methodContainingClasses) {
                PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)aClass);
                if (interfaceMethod == null || FunctionalExpressionSearch.search((PsiClass)aClass).findFirst() == null) continue;
                overridden.add(interfaceMethod);
            }
        }
        for (PsiMethod method : overridden) {
            boolean overrides;
            ProgressManager.checkCanceled();
            boolean bl = overrides = !method.hasModifierProperty("abstract");
            if (overrides ? !this.myOverriddenOption.isEnabled() : !this.myImplementedOption.isEnabled()) {
                return;
            }
            PsiElement range = JavaLineMarkerProvider.getMethodRange(method);
            MarkerType type = MarkerType.OVERRIDDEN_METHOD;
            Icon icon = overrides ? AllIcons.Gutter.OverridenMethod : AllIcons.Gutter.ImplementedMethod;
            LineMarkerInfo info = new LineMarkerInfo(range, range.getTextRange(), icon, 6, type.getTooltip(), type.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
            NavigateAction.setNavigateAction((LineMarkerInfo)info, (String)(overrides ? "Go to overriding methods" : "Go to implementation(s)"), (String)"GotoImplementation");
            result2.add(info);
        }
    }

    public String getName() {
        return "Java line markers";
    }

    public GutterIconDescriptor.Option[] getOptions() {
        return new GutterIconDescriptor.Option[]{this.myLambdaOption, this.myOverriddenOption, this.myImplementedOption, this.myOverridingOption, this.myImplementingOption};
    }

    private static /* synthetic */ boolean lambda$collectOverridingMethods$0(@NotNull Collection methods, Set overridden, Pair pair) {
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider", "lambda$collectOverridingMethods$0"));
        }
        ProgressManager.checkCanceled();
        PsiMethod superMethod = (PsiMethod)pair.getFirst();
        if (methods.remove(superMethod)) {
            overridden.add(superMethod);
        }
        return !methods.isEmpty();
    }

    private static class ArrowUpLineMarkerInfo
    extends MergeableLineMarkerInfo<PsiElement> {
        private ArrowUpLineMarkerInfo(@NotNull PsiElement element, @NotNull Icon icon, @NotNull MarkerType markerType, int passId) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider$ArrowUpLineMarkerInfo", "<init>"));
            }
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider$ArrowUpLineMarkerInfo", "<init>"));
            }
            if (markerType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markerType", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider$ArrowUpLineMarkerInfo", "<init>"));
            }
            super(element, element.getTextRange(), icon, passId, markerType.getTooltip(), markerType.getNavigationHandler(), GutterIconRenderer.Alignment.LEFT);
        }

        public boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider$ArrowUpLineMarkerInfo", "canMergeWith"));
            }
            if (!(info instanceof ArrowUpLineMarkerInfo)) {
                return false;
            }
            PsiElement otherElement = info.getElement();
            PsiElement myElement = this.getElement();
            return otherElement != null && myElement != null;
        }

        public Icon getCommonIcon(@NotNull List<MergeableLineMarkerInfo> infos) {
            if (infos == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider$ArrowUpLineMarkerInfo", "getCommonIcon"));
            }
            return this.myIcon;
        }

        @NotNull
        public Function<? super PsiElement, String> getCommonTooltip(@NotNull List<MergeableLineMarkerInfo> infos) {
            if (infos == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider$ArrowUpLineMarkerInfo", "getCommonTooltip"));
            }
            Function function = element -> "Multiple method overrides";
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider$ArrowUpLineMarkerInfo", "getCommonTooltip"));
            }
            return function;
        }

        public String getElementPresentation(PsiElement element) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiFunctionalExpression) {
                return PsiExpressionTrimRenderer.render((PsiExpression)((PsiExpression)parent));
            }
            return super.getElementPresentation(element);
        }
    }
}

