/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.SideEffectWarningDialog;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccessStaticViaInstanceFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AccessStaticViaInstanceFix");
    private final boolean myOnTheFly;
    private final String myText;

    public AccessStaticViaInstanceFix(@NotNull PsiReferenceExpression expression, @NotNull JavaResolveResult result2, boolean onTheFly) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/quickfix/AccessStaticViaInstanceFix", "<init>"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/quickfix/AccessStaticViaInstanceFix", "<init>"));
        }
        super((PsiElement)expression);
        this.myOnTheFly = onTheFly;
        PsiMember member = (PsiMember)result2.getElement();
        this.myText = AccessStaticViaInstanceFix.calcText(member, result2.getSubstitutor());
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AccessStaticViaInstanceFix", "getText"));
        }
        return string;
    }

    private static String calcText(PsiMember member, PsiSubstitutor substitutor) {
        PsiClass aClass = member.getContainingClass();
        if (aClass == null) {
            return "";
        }
        return QuickFixBundle.message("access.static.via.class.reference.text", HighlightMessageUtil.getSymbolName((PsiElement)member, substitutor), HighlightUtil.formatClass(aClass), HighlightUtil.formatClass(aClass, false));
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("access.static.via.class.reference.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AccessStaticViaInstanceFix", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AccessStaticViaInstanceFix", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/AccessStaticViaInstanceFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/AccessStaticViaInstanceFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/AccessStaticViaInstanceFix", "invoke"));
        }
        PsiReferenceExpression myExpression = (PsiReferenceExpression)startElement;
        if (!myExpression.isValid()) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(myExpression.getContainingFile())) {
            return;
        }
        PsiElement element = myExpression.resolve();
        if (!(element instanceof PsiMember)) {
            return;
        }
        PsiMember myMember = (PsiMember)element;
        if (!myMember.isValid()) {
            return;
        }
        PsiClass containingClass = myMember.getContainingClass();
        if (containingClass == null) {
            return;
        }
        try {
            PsiExpression qualifierExpression = myExpression.getQualifierExpression();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
            if (qualifierExpression != null) {
                if (!this.checkSideEffects(project2, containingClass, qualifierExpression, factory, (PsiElement)myExpression, editor)) {
                    return;
                }
                PsiElement newQualifier = qualifierExpression.replace((PsiElement)factory.createReferenceExpression(containingClass));
                PsiElement qualifiedWithClassName = myExpression.copy();
                if (myExpression.getTypeParameters().length == 0) {
                    newQualifier.delete();
                    if (myExpression.resolve() != myMember) {
                        myExpression.replace(qualifiedWithClassName);
                    }
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private boolean checkSideEffects(Project project2, PsiClass containingClass, final PsiExpression qualifierExpression, PsiElementFactory factory, final PsiElement myExpression, Editor editor) {
        ArrayList<PsiElement> sideEffects = new ArrayList<PsiElement>();
        boolean hasSideEffects = RemoveUnusedVariableUtil.checkSideEffects(qualifierExpression, null, sideEffects);
        if (hasSideEffects && !this.myOnTheFly) {
            return false;
        }
        if (!hasSideEffects || ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (editor == null) {
            return false;
        }
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        HighlightManager.getInstance((Project)project2).addOccurrenceHighlights(editor, PsiUtilCore.toPsiElementArray(sideEffects), attributes, true, null);
        try {
            hasSideEffects = PsiUtil.isStatement((PsiElement)factory.createStatementFromText(qualifierExpression.getText(), (PsiElement)qualifierExpression));
        }
        catch (IncorrectOperationException e) {
            hasSideEffects = false;
        }
        final PsiReferenceExpression qualifiedWithClassName = (PsiReferenceExpression)myExpression.copy();
        qualifiedWithClassName.setQualifierExpression((PsiExpression)factory.createReferenceExpression(containingClass));
        PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)myExpression, PsiStatement.class);
        final boolean canCopeWithSideEffects = hasSideEffects && statement2 != null;
        SideEffectWarningDialog dialog = new SideEffectWarningDialog(project2, false, null, ((PsiElement)sideEffects.get(0)).getText(), PsiExpressionTrimRenderer.render((PsiExpression)qualifierExpression), canCopeWithSideEffects){

            @Override
            protected String sideEffectsDescription() {
                if (canCopeWithSideEffects) {
                    return "<html><body>  There are possible side effects found in expression '" + qualifierExpression.getText() + "'<br>" + "  You can:<ul><li><b>Remove</b> class reference along with whole expressions involved, or</li>" + "  <li><b>Transform</b> qualified expression into the statement on its own.<br>" + "  That is,<br>" + "  <table border=1><tr><td><code>" + myExpression.getText() + "</code></td></tr></table><br> becomes: <br>" + "  <table border=1><tr><td><code>" + qualifierExpression.getText() + ";<br>" + qualifiedWithClassName.getText() + "       </code></td></tr></table></li>" + "  </body></html>";
                }
                return "<html><body>  There are possible side effects found in expression '" + qualifierExpression.getText() + "'<br>" + "You can:<ul><li><b>Remove</b> class reference along with whole expressions involved, or</li></body></html>";
            }
        };
        dialog.show();
        int res = dialog.getExitCode();
        if (res == RemoveUnusedVariableUtil.RemoveMode.CANCEL.ordinal()) {
            return false;
        }
        try {
            if (res == RemoveUnusedVariableUtil.RemoveMode.MAKE_STATEMENT.ordinal()) {
                PsiStatement statementFromText = factory.createStatementFromText(qualifierExpression.getText() + ";", null);
                LOG.assertTrue(statement2 != null);
                statement2.getParent().addBefore((PsiElement)statementFromText, (PsiElement)statement2);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return true;
    }
}

