/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionBean;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionActionWrapper;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInsight.intention.impl.config.LazyEditor;
import com.intellij.codeInsight.intention.impl.config.PlainTextDescriptor;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.actions.CleanupInspectionIntention;
import com.intellij.codeInspection.actions.RunInspectionIntention;
import com.intellij.codeInspection.ex.DisableInspectionToolAction;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsInSuppressedPlaceIntention;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionManagerImpl
extends IntentionManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.config.IntentionManagerImpl");
    private final List<IntentionAction> myActions = ContainerUtil.createLockFreeCopyOnWriteList();
    private final IntentionManagerSettings mySettings;
    private final Alarm myInitActionsAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);

    public IntentionManagerImpl(IntentionManagerSettings intentionManagerSettings) {
        this.mySettings = intentionManagerSettings;
        this.addAction(new EditInspectionToolsSettingsInSuppressedPlaceIntention());
        ExtensionPoint point = Extensions.getArea(null).getExtensionPoint(EP_INTENTION_ACTIONS);
        point.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<IntentionActionBean>(){

            public void extensionAdded(@NotNull IntentionActionBean extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl$1", "extensionAdded"));
                }
                IntentionManagerImpl.this.registerIntentionFromBean(extension);
            }

            public void extensionRemoved(@NotNull IntentionActionBean extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl$1", "extensionRemoved"));
                }
            }
        });
    }

    private void registerIntentionFromBean(@NotNull IntentionActionBean extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "registerIntentionFromBean"));
        }
        Runnable runnable2 = () -> {
            if (extension == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "lambda$registerIntentionFromBean$0"));
            }
            String descriptionDirectoryName = extension.getDescriptionDirectoryName();
            String[] categories = extension.getCategories();
            IntentionAction instance = IntentionManagerImpl.createIntentionActionWrapper(extension, categories);
            if (categories == null) {
                this.addAction(instance);
            } else if (descriptionDirectoryName != null) {
                this.addAction(instance);
                this.mySettings.registerIntentionMetaData(instance, categories, descriptionDirectoryName, extension.getMetadataClassLoader());
            } else {
                this.registerIntentionAndMetaData(instance, categories);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable2.run();
        } else {
            this.myInitActionsAlarm.addRequest(runnable2, 300);
        }
    }

    private static IntentionAction createIntentionActionWrapper(@NotNull IntentionActionBean intentionActionBean, String[] categories) {
        if (intentionActionBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentionActionBean", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "createIntentionActionWrapper"));
        }
        return new IntentionActionWrapper(intentionActionBean, categories);
    }

    public void registerIntentionAndMetaData(@NotNull IntentionAction action, String ... category) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "registerIntentionAndMetaData"));
        }
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "registerIntentionAndMetaData"));
        }
        this.registerIntentionAndMetaData(action, category, IntentionManagerImpl.getDescriptionDirectoryName(action));
    }

    @NotNull
    private static String getDescriptionDirectoryName(IntentionAction action) {
        if (action instanceof IntentionActionWrapper) {
            IntentionActionWrapper wrapper = (IntentionActionWrapper)action;
            String string = IntentionManagerImpl.getDescriptionDirectoryName(wrapper.getImplementationClassName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "getDescriptionDirectoryName"));
            }
            return string;
        }
        String string = IntentionManagerImpl.getDescriptionDirectoryName(action.getClass().getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "getDescriptionDirectoryName"));
        }
        return string;
    }

    private static String getDescriptionDirectoryName(String fqn) {
        return fqn.substring(fqn.lastIndexOf(46) + 1).replaceAll("\\$", "");
    }

    public void registerIntentionAndMetaData(@NotNull IntentionAction action, @NotNull String[] category, @NotNull @NonNls String descriptionDirectoryName) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "registerIntentionAndMetaData"));
        }
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "registerIntentionAndMetaData"));
        }
        if (descriptionDirectoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptionDirectoryName", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "registerIntentionAndMetaData"));
        }
        this.addAction(action);
        this.mySettings.registerIntentionMetaData(action, category, descriptionDirectoryName);
    }

    public void registerIntentionAndMetaData(@NotNull IntentionAction action, @NotNull String[] category, @NotNull String description, @NotNull String exampleFileExtension, @NotNull String[] exampleTextBefore, @NotNull String[] exampleTextAfter) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "registerIntentionAndMetaData"));
        }
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "registerIntentionAndMetaData"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "registerIntentionAndMetaData"));
        }
        if (exampleFileExtension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exampleFileExtension", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "registerIntentionAndMetaData"));
        }
        if (exampleTextBefore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exampleTextBefore", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "registerIntentionAndMetaData"));
        }
        if (exampleTextAfter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exampleTextAfter", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "registerIntentionAndMetaData"));
        }
        this.addAction(action);
        IntentionActionMetaData metaData = new IntentionActionMetaData(action, category, new PlainTextDescriptor(description, "description.html"), IntentionManagerImpl.mapToDescriptors(exampleTextBefore, "before." + exampleFileExtension), IntentionManagerImpl.mapToDescriptors(exampleTextAfter, "after." + exampleFileExtension));
        this.mySettings.registerMetaData(metaData);
    }

    public void unregisterIntention(@NotNull IntentionAction intentionAction) {
        if (intentionAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentionAction", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "unregisterIntention"));
        }
        this.myActions.remove(intentionAction);
        this.mySettings.unregisterMetaData(intentionAction);
    }

    private static TextDescriptor[] mapToDescriptors(String[] texts, @NonNls String fileName) {
        TextDescriptor[] result2 = new TextDescriptor[texts.length];
        for (int i = 0; i < texts.length; ++i) {
            result2[i] = new PlainTextDescriptor(texts[i], fileName);
        }
        return result2;
    }

    @NotNull
    public List<IntentionAction> getStandardIntentionOptions(@NotNull HighlightDisplayKey displayKey, @NotNull PsiElement context) {
        if (displayKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayKey", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "getStandardIntentionOptions"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "getStandardIntentionOptions"));
        }
        ArrayList<IntentionAction> options = new ArrayList<IntentionAction>(9);
        options.add(new EditInspectionToolsSettingsAction(displayKey));
        options.add(new RunInspectionIntention(displayKey));
        options.add((IntentionAction)new DisableInspectionToolAction(displayKey));
        ArrayList<IntentionAction> arrayList = options;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "getStandardIntentionOptions"));
        }
        return arrayList;
    }

    @Nullable
    public IntentionAction createFixAllIntention(InspectionToolWrapper toolWrapper, IntentionAction action) {
        if (toolWrapper instanceof LocalInspectionToolWrapper) {
            Class<?> aClass = action.getClass();
            if (action instanceof QuickFixWrapper) {
                aClass = ((QuickFixWrapper)action).getFix().getClass();
            }
            return new CleanupInspectionIntention(toolWrapper, aClass, action.getText());
        }
        if (toolWrapper instanceof GlobalInspectionToolWrapper) {
            GlobalInspectionTool wrappedTool = (GlobalInspectionTool)((GlobalInspectionToolWrapper)toolWrapper).getTool();
            if (wrappedTool instanceof GlobalSimpleInspectionTool && (action instanceof LocalQuickFix || action instanceof QuickFixWrapper)) {
                Class<?> aClass = action.getClass();
                if (action instanceof QuickFixWrapper) {
                    aClass = ((QuickFixWrapper)action).getFix().getClass();
                }
                return new CleanupInspectionIntention(toolWrapper, aClass, action.getText());
            }
        } else {
            throw new AssertionError((Object)("unknown tool: " + toolWrapper));
        }
        return null;
    }

    @NotNull
    public LocalQuickFix convertToFix(final @NotNull IntentionAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "convertToFix"));
        }
        if (action instanceof LocalQuickFix) {
            LocalQuickFix localQuickFix = (LocalQuickFix)action;
            if (localQuickFix == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "convertToFix"));
            }
            return localQuickFix;
        }
        LocalQuickFix localQuickFix = new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = action.getText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl$2", "getName"));
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = action.getFamilyName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl$2", "getFamilyName"));
                }
                return string;
            }

            public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl$2", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl$2", "applyFix"));
                }
                PsiFile psiFile = descriptor.getPsiElement().getContainingFile();
                try {
                    action.invoke(project2, (Editor)new LazyEditor(psiFile), psiFile);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        };
        if (localQuickFix == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "convertToFix"));
        }
        return localQuickFix;
    }

    public void addAction(@NotNull IntentionAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "addAction"));
        }
        this.myActions.add(action);
    }

    @NotNull
    public IntentionAction[] getIntentionActions() {
        IntentionAction[] intentionActionArray = (IntentionAction[])ArrayUtil.stripTrailingNulls((Object[])this.myActions.toArray(new IntentionAction[this.myActions.size()]));
        if (intentionActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "getIntentionActions"));
        }
        return intentionActionArray;
    }

    @NotNull
    public IntentionAction[] getAvailableIntentionActions() {
        ArrayList<IntentionAction> list = new ArrayList<IntentionAction>(this.myActions.size());
        for (IntentionAction action : this.myActions) {
            if (!this.mySettings.isEnabled(action)) continue;
            list.add(action);
        }
        IntentionAction[] intentionActionArray = list.toArray(new IntentionAction[list.size()]);
        if (intentionActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "getAvailableIntentionActions"));
        }
        return intentionActionArray;
    }

    public boolean hasActiveRequests() {
        return !this.myInitActionsAlarm.isEmpty();
    }
}

