/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.template.EverywhereContextType;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.EditVariableDialog;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateImplUtil;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class LiveTemplateSettingsEditor
extends JPanel {
    private final TemplateImpl myTemplate;
    private final Runnable myNodeChanged;
    private final JTextField myKeyField;
    private final JTextField myDescription;
    private final Editor myTemplateEditor;
    private JComboBox myExpandByCombo;
    private final String myDefaultShortcutItem;
    private JCheckBox myCbReformat;
    private JButton myEditVariablesButton;
    private static final String SPACE = CodeInsightBundle.message((String)"template.shortcut.space", (Object[])new Object[0]);
    private static final String TAB = CodeInsightBundle.message((String)"template.shortcut.tab", (Object[])new Object[0]);
    private static final String ENTER = CodeInsightBundle.message((String)"template.shortcut.enter", (Object[])new Object[0]);
    private final Map<TemplateOptionalProcessor, Boolean> myOptions;
    private final TemplateContext myContext;
    private JBPopup myContextPopup;
    private Dimension myLastSize;
    private JPanel myTemplateOptionsPanel;

    public LiveTemplateSettingsEditor(TemplateImpl template, String defaultShortcut, Map<TemplateOptionalProcessor, Boolean> options, TemplateContext context, Runnable nodeChanged, boolean allowNoContext) {
        super(new BorderLayout());
        this.myOptions = options;
        this.myContext = context;
        this.myTemplate = template;
        this.myNodeChanged = nodeChanged;
        this.myDefaultShortcutItem = CodeInsightBundle.message((String)"dialog.edit.template.shortcut.default", (Object[])new Object[]{defaultShortcut});
        this.myKeyField = new JTextField();
        this.myDescription = new JTextField();
        this.myTemplateEditor = TemplateEditorUtil.createEditor(false, this.myTemplate.getString(), context);
        this.myTemplate.setId(null);
        this.createComponents(allowNoContext);
        this.myKeyField.getDocument().addDocumentListener((javax.swing.event.DocumentListener)new com.intellij.ui.DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                LiveTemplateSettingsEditor.this.myTemplate.setKey(StringUtil.notNullize((String)LiveTemplateSettingsEditor.this.myKeyField.getText()).trim());
                LiveTemplateSettingsEditor.this.myNodeChanged.run();
            }
        });
        this.myDescription.getDocument().addDocumentListener((javax.swing.event.DocumentListener)new com.intellij.ui.DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                LiveTemplateSettingsEditor.this.myTemplate.setDescription(StringUtil.notNullize((String)LiveTemplateSettingsEditor.this.myDescription.getText()).trim());
                LiveTemplateSettingsEditor.this.myNodeChanged.run();
            }
        });
        new UiNotifyConnector((Component)this, (Activatable)new Activatable.Adapter(){

            public void hideNotify() {
                LiveTemplateSettingsEditor.this.disposeContextPopup();
            }
        });
    }

    public TemplateImpl getTemplate() {
        return this.myTemplate;
    }

    void dispose() {
        if (!this.myTemplateEditor.isDisposed()) {
            PsiFile psiFile;
            Project project2 = this.myTemplateEditor.getProject();
            if (project2 != null && !project2.isDisposed() && (psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(this.myTemplateEditor.getDocument())) != null) {
                DaemonCodeAnalyzer.getInstance((Project)project2).setHighlightingEnabled(psiFile, true);
            }
            EditorFactory.getInstance().releaseEditor(this.myTemplateEditor);
        }
    }

    private void createComponents(boolean allowNoContexts) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBag gb = new GridBag().setDefaultInsets(4, 4, 4, 4).setDefaultWeightY(1.0).setDefaultFill(1);
        JPanel editorPanel = new JPanel(new BorderLayout(4, 4));
        editorPanel.setPreferredSize((Dimension)JBUI.size((int)250, (int)100));
        editorPanel.setMinimumSize(editorPanel.getPreferredSize());
        editorPanel.add((Component)this.myTemplateEditor.getComponent(), "Center");
        JLabel templateTextLabel = new JLabel(CodeInsightBundle.message((String)"dialog.edit.template.template.text.title", (Object[])new Object[0]));
        templateTextLabel.setLabelFor(this.myTemplateEditor.getContentComponent());
        editorPanel.add((Component)templateTextLabel, "North");
        editorPanel.setFocusable(false);
        panel.add((Component)editorPanel, gb.nextLine().next().weighty(1.0).weightx(1.0).coverColumn(2));
        this.myEditVariablesButton = new JButton(CodeInsightBundle.message((String)"dialog.edit.template.button.edit.variables", (Object[])new Object[0]));
        this.myEditVariablesButton.setDefaultCapable(false);
        this.myEditVariablesButton.setMaximumSize(this.myEditVariablesButton.getPreferredSize());
        panel.add((Component)this.myEditVariablesButton, gb.next().weighty(0.0));
        this.myTemplateOptionsPanel = new JPanel(new BorderLayout());
        this.myTemplateOptionsPanel.add(this.createTemplateOptionsPanel());
        panel.add((Component)this.myTemplateOptionsPanel, gb.nextLine().next().next().coverColumn(2).weighty(1.0));
        panel.add((Component)this.createShortContextPanel(allowNoContexts), gb.nextLine().next().weighty(0.0).fillCellNone().anchor(17));
        this.myTemplateEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(com.intellij.openapi.editor.event.DocumentEvent e) {
                LiveTemplateSettingsEditor.this.validateEditVariablesButton();
                LiveTemplateSettingsEditor.this.myTemplate.setString(LiveTemplateSettingsEditor.this.myTemplateEditor.getDocument().getText());
                LiveTemplateSettingsEditor.this.applyVariables(LiveTemplateSettingsEditor.this.updateVariablesByTemplateText());
                LiveTemplateSettingsEditor.this.myNodeChanged.run();
            }
        });
        this.myEditVariablesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/LiveTemplateSettingsEditor$5", "actionPerformed"));
                }
                LiveTemplateSettingsEditor.this.editVariables();
            }
        });
        this.add((Component)this.createNorthPanel(), "North");
        this.add((Component)panel, "Center");
    }

    private void applyVariables(List<Variable> variables) {
        this.myTemplate.removeAllParsed();
        for (Variable variable : variables) {
            this.myTemplate.addVariable(variable.getName(), variable.getExpressionString(), variable.getDefaultValueString(), variable.isAlwaysStopAt());
        }
        this.myTemplate.parseSegments();
    }

    @NotNull
    private JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBag gb = new GridBag().setDefaultInsets(4, 4, 4, 4).setDefaultWeightY(1.0).setDefaultFill(1);
        JLabel keyPrompt = new JLabel(CodeInsightBundle.message((String)"dialog.edit.template.label.abbreviation", (Object[])new Object[0]));
        keyPrompt.setLabelFor(this.myKeyField);
        panel.add((Component)keyPrompt, gb.nextLine().next());
        panel.add((Component)this.myKeyField, gb.next().weightx(1.0));
        JLabel descriptionPrompt = new JLabel(CodeInsightBundle.message((String)"dialog.edit.template.label.description", (Object[])new Object[0]));
        descriptionPrompt.setLabelFor(this.myDescription);
        panel.add((Component)descriptionPrompt, gb.next());
        panel.add((Component)this.myDescription, gb.next().weightx(3.0));
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/LiveTemplateSettingsEditor", "createNorthPanel"));
        }
        return jPanel;
    }

    private JPanel createTemplateOptionsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)CodeInsightBundle.message((String)"dialog.edit.template.options.title", (Object[])new Object[0]), (boolean)true));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 1;
        gbConstraints.weighty = 0.0;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridy = 0;
        JLabel expandWithLabel = new JLabel(CodeInsightBundle.message((String)"dialog.edit.template.label.expand.with", (Object[])new Object[0]));
        panel.add((Component)expandWithLabel, gbConstraints);
        gbConstraints.gridx = 1;
        gbConstraints.insets = new Insets(0, 4, 0, 0);
        this.myExpandByCombo = new ComboBox((Object[])new String[]{this.myDefaultShortcutItem, SPACE, TAB, ENTER});
        this.myExpandByCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(@NotNull ItemEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/LiveTemplateSettingsEditor$6", "itemStateChanged"));
                }
                Object selectedItem = LiveTemplateSettingsEditor.this.myExpandByCombo.getSelectedItem();
                if (LiveTemplateSettingsEditor.this.myDefaultShortcutItem.equals(selectedItem)) {
                    LiveTemplateSettingsEditor.this.myTemplate.setShortcutChar('D');
                } else if (TAB.equals(selectedItem)) {
                    LiveTemplateSettingsEditor.this.myTemplate.setShortcutChar('\t');
                } else if (ENTER.equals(selectedItem)) {
                    LiveTemplateSettingsEditor.this.myTemplate.setShortcutChar('\n');
                } else {
                    LiveTemplateSettingsEditor.this.myTemplate.setShortcutChar(' ');
                }
            }
        });
        expandWithLabel.setLabelFor(this.myExpandByCombo);
        panel.add((Component)this.myExpandByCombo, gbConstraints);
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 2;
        panel.add((Component)new JPanel(), gbConstraints);
        gbConstraints.gridx = 0;
        ++gbConstraints.gridy;
        gbConstraints.gridwidth = 3;
        this.myCbReformat = new JCheckBox(CodeInsightBundle.message((String)"dialog.edit.template.checkbox.reformat.according.to.style", (Object[])new Object[0]));
        panel.add((Component)this.myCbReformat, gbConstraints);
        for (TemplateOptionalProcessor processor2 : this.myOptions.keySet()) {
            if (!processor2.isVisible(this.myTemplate, this.myContext)) continue;
            ++gbConstraints.gridy;
            JCheckBox cb = new JCheckBox(processor2.getOptionName());
            panel.add((Component)cb, gbConstraints);
            cb.setSelected(this.myOptions.get(processor2));
            cb.addActionListener(e -> this.myOptions.put(processor2, cb.isSelected()));
        }
        gbConstraints.weighty = 1.0;
        ++gbConstraints.gridy;
        panel.add((Component)new JPanel(), gbConstraints);
        return panel;
    }

    private List<TemplateContextType> getApplicableContexts() {
        ArrayList<TemplateContextType> result2 = new ArrayList<TemplateContextType>();
        for (TemplateContextType type : TemplateManagerImpl.getAllContextTypes()) {
            if (!this.myContext.isEnabled(type)) continue;
            result2.add(type);
        }
        return result2;
    }

    private JPanel createShortContextPanel(boolean allowNoContexts) {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel ctxLabel = new JLabel();
        final JLabel change = new JLabel();
        change.setForeground(PlatformColors.BLUE);
        change.setCursor(Cursor.getPredefinedCursor(12));
        panel.add((Component)ctxLabel, "Center");
        panel.add((Component)change, "East");
        final Runnable updateLabel = () -> {
            this.myExpandByCombo.setEnabled(this.isExpandableFromEditor());
            this.updateHighlighter();
            StringBuilder sb = new StringBuilder();
            String oldPrefix = "";
            for (TemplateContextType type : this.getApplicableContexts()) {
                TemplateContextType base = type.getBaseContextType();
                String ownName = UIUtil.removeMnemonic((String)type.getPresentableName());
                String prefix = "";
                if (base != null && !(base instanceof EverywhereContextType)) {
                    prefix = UIUtil.removeMnemonic((String)base.getPresentableName()) + ": ";
                    ownName = StringUtil.decapitalize((String)ownName);
                }
                if (type instanceof EverywhereContextType) {
                    ownName = "Other";
                }
                if (sb.length() > 0) {
                    sb.append(oldPrefix.equals(prefix) ? ", " : "; ");
                }
                if (!oldPrefix.equals(prefix)) {
                    sb.append(prefix);
                    oldPrefix = prefix;
                }
                sb.append(ownName);
            }
            boolean noContexts = sb.length() == 0;
            String contexts = (noContexts ? "No applicable contexts" + (allowNoContexts ? "" : " yet") : "Applicable in " + sb.toString()) + ".  ";
            ctxLabel.setText(StringUtil.first((String)contexts, (int)100, (boolean)true));
            ctxLabel.setForeground((Color)(noContexts ? (allowNoContexts ? JBColor.GRAY : JBColor.RED) : UIUtil.getLabelForeground()));
            change.setText(noContexts ? "Define" : "Change");
            this.myTemplateOptionsPanel.removeAll();
            this.myTemplateOptionsPanel.add(this.createTemplateOptionsPanel());
        };
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/LiveTemplateSettingsEditor$7", "onClick"));
                }
                if (LiveTemplateSettingsEditor.this.disposeContextPopup()) {
                    return false;
                }
                final JPanel content = LiveTemplateSettingsEditor.createPopupContextPanel(updateLabel, LiveTemplateSettingsEditor.this.myContext);
                Dimension prefSize = content.getPreferredSize();
                if (LiveTemplateSettingsEditor.this.myLastSize != null && (((LiveTemplateSettingsEditor)LiveTemplateSettingsEditor.this).myLastSize.width > prefSize.width || ((LiveTemplateSettingsEditor)LiveTemplateSettingsEditor.this).myLastSize.height > prefSize.height)) {
                    content.setPreferredSize(new Dimension(Math.max(prefSize.width, ((LiveTemplateSettingsEditor)LiveTemplateSettingsEditor.this).myLastSize.width), Math.max(prefSize.height, ((LiveTemplateSettingsEditor)LiveTemplateSettingsEditor.this).myLastSize.height)));
                }
                LiveTemplateSettingsEditor.this.myContextPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)content, null).setResizable(true).createPopup();
                LiveTemplateSettingsEditor.this.myContextPopup.show(new RelativePoint((Component)change, new Point(change.getWidth(), -content.getPreferredSize().height - 10)));
                LiveTemplateSettingsEditor.this.myContextPopup.addListener((JBPopupListener)new JBPopupAdapter(){

                    public void onClosed(LightweightWindowEvent event) {
                        LiveTemplateSettingsEditor.this.myLastSize = content.getSize();
                    }
                });
                return true;
            }
        }.installOn((Component)change);
        updateLabel.run();
        return panel;
    }

    private boolean disposeContextPopup() {
        if (this.myContextPopup != null && this.myContextPopup.isVisible()) {
            this.myContextPopup.cancel();
            this.myContextPopup = null;
            return true;
        }
        return false;
    }

    static JPanel createPopupContextPanel(final Runnable onChange, final TemplateContext context) {
        JPanel panel = new JPanel(new BorderLayout());
        MultiMap hierarchy = MultiMap.createLinked();
        for (TemplateContextType type : TemplateManagerImpl.getAllContextTypes()) {
            hierarchy.putValue((Object)type.getBaseContextType(), (Object)type);
        }
        CheckedTreeNode root = new CheckedTreeNode((Object)Pair.create(null, (Object)"Hi"));
        final CheckboxTree checkboxTree = new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Object o = ((DefaultMutableTreeNode)value).getUserObject();
                if (o instanceof Pair) {
                    this.getTextRenderer().append((String)((Pair)o).second);
                }
            }
        }, root){

            protected void onNodeStateChanged(CheckedTreeNode node) {
                TemplateContextType type = (TemplateContextType)((Pair)node.getUserObject()).first;
                if (type != null) {
                    context.setEnabled(type, node.isChecked());
                }
                onChange.run();
            }
        };
        for (TemplateContextType type : hierarchy.get(null)) {
            LiveTemplateSettingsEditor.addContextNode((MultiMap<TemplateContextType, TemplateContextType>)hierarchy, root, type, context);
        }
        ((DefaultTreeModel)checkboxTree.getModel()).nodeStructureChanged((TreeNode)root);
        TreeUtil.traverse((TreeNode)root, (TreeUtil.Traverse)new TreeUtil.Traverse(){

            public boolean accept(Object _node) {
                Object[] path;
                CheckedTreeNode node = (CheckedTreeNode)_node;
                if (node.isChecked() && (path = node.getPath()) != null) {
                    checkboxTree.expandPath(new TreePath(path).getParentPath());
                }
                return true;
            }
        });
        panel.add(ScrollPaneFactory.createScrollPane((Component)((Object)checkboxTree)));
        Dimension size = checkboxTree.getPreferredSize();
        panel.setPreferredSize(new Dimension(size.width + 30, Math.min(size.height + 10, 500)));
        return panel;
    }

    private static void addContextNode(MultiMap<TemplateContextType, TemplateContextType> hierarchy, CheckedTreeNode parent, TemplateContextType type, TemplateContext context) {
        Collection children2 = hierarchy.get((Object)type);
        String name = UIUtil.removeMnemonic((String)type.getPresentableName());
        CheckedTreeNode node = new CheckedTreeNode((Object)Pair.create((Object)(children2.isEmpty() ? type : null), (Object)name));
        parent.add((MutableTreeNode)node);
        if (children2.isEmpty()) {
            node.setChecked(context.isEnabled(type));
        } else {
            for (TemplateContextType child : children2) {
                LiveTemplateSettingsEditor.addContextNode(hierarchy, node, child, context);
            }
            CheckedTreeNode other = new CheckedTreeNode((Object)Pair.create((Object)type, (Object)"Other"));
            other.setChecked(context.isEnabled(type));
            node.add((MutableTreeNode)other);
        }
    }

    private boolean isExpandableFromEditor() {
        boolean hasNonExpandable = false;
        for (TemplateContextType type : this.getApplicableContexts()) {
            if (type.isExpandableFromEditor()) {
                return true;
            }
            hasNonExpandable = true;
        }
        return !hasNonExpandable;
    }

    private void updateHighlighter() {
        TemplateEditorUtil.setHighlighter(this.myTemplateEditor, (TemplateContextType)ContainerUtil.getFirstItem(this.getApplicableContexts()));
    }

    private void validateEditVariablesButton() {
        this.myEditVariablesButton.setEnabled(!this.parseVariables().isEmpty());
    }

    void resetUi() {
        this.myKeyField.setText(this.myTemplate.getKey());
        this.myDescription.setText(this.myTemplate.getDescription());
        if (this.myTemplate.getShortcutChar() == 'D') {
            this.myExpandByCombo.setSelectedItem(this.myDefaultShortcutItem);
        } else if (this.myTemplate.getShortcutChar() == '\t') {
            this.myExpandByCombo.setSelectedItem(TAB);
        } else if (this.myTemplate.getShortcutChar() == '\n') {
            this.myExpandByCombo.setSelectedItem(ENTER);
        } else {
            this.myExpandByCombo.setSelectedItem(SPACE);
        }
        CommandProcessor.getInstance().executeCommand(null, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            Document document2 = this.myTemplateEditor.getDocument();
            document2.replaceString(0, document2.getTextLength(), (CharSequence)this.myTemplate.getString());
        }), "", null);
        this.myCbReformat.setSelected(this.myTemplate.isToReformat());
        this.myCbReformat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/LiveTemplateSettingsEditor$11", "actionPerformed"));
                }
                LiveTemplateSettingsEditor.this.myTemplate.setToReformat(LiveTemplateSettingsEditor.this.myCbReformat.isSelected());
            }
        });
        this.myExpandByCombo.setEnabled(this.isExpandableFromEditor());
        this.updateHighlighter();
        this.validateEditVariablesButton();
    }

    private void editVariables() {
        ArrayList<Variable> newVariables = this.updateVariablesByTemplateText();
        EditVariableDialog editVariableDialog = new EditVariableDialog(this.myTemplateEditor, this.myEditVariablesButton, newVariables, this.getApplicableContexts());
        if (editVariableDialog.showAndGet()) {
            this.applyVariables(newVariables);
        }
    }

    private ArrayList<Variable> updateVariablesByTemplateText() {
        List<Variable> oldVariables = this.getCurrentVariables();
        Set oldVariableNames = ContainerUtil.map2Set(oldVariables, variable -> variable.getName());
        Map<String, Variable> newVariableNames = this.parseVariables();
        int oldVariableNumber = 0;
        for (Map.Entry<String, Variable> entry : newVariableNames.entrySet()) {
            if (!oldVariableNames.contains(entry.getKey())) continue;
            Variable oldVariable = null;
            while (oldVariableNumber < oldVariables.size() && newVariableNames.get((oldVariable = oldVariables.get(oldVariableNumber)).getName()) == null) {
                oldVariable = null;
                ++oldVariableNumber;
            }
            ++oldVariableNumber;
            if (oldVariable == null) continue;
            entry.setValue(oldVariable);
        }
        return new ArrayList<Variable>(newVariableNames.values());
    }

    private List<Variable> getCurrentVariables() {
        ArrayList<Variable> myVariables = new ArrayList<Variable>();
        for (int i = 0; i < this.myTemplate.getVariableCount(); ++i) {
            myVariables.add(new Variable(this.myTemplate.getVariableNameAt(i), this.myTemplate.getExpressionStringAt(i), this.myTemplate.getDefaultValueStringAt(i), this.myTemplate.isAlwaysStopAt(i)));
        }
        return myVariables;
    }

    public JTextField getKeyField() {
        return this.myKeyField;
    }

    public void focusKey() {
        this.myKeyField.selectAll();
        IdeFocusManager.findInstanceByComponent((Component)this.myKeyField).requestFocus((Component)this.myKeyField, true);
        ModalityState modalityState = ModalityState.stateForComponent((Component)this.myKeyField);
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.findInstanceByComponent((Component)this.myKeyField).requestFocus((Component)this.myKeyField, true), modalityState), modalityState), modalityState);
    }

    private Map<String, Variable> parseVariables() {
        LinkedHashMap<String, Variable> map = TemplateImplUtil.parseVariables(this.myTemplateEditor.getDocument().getCharsSequence());
        map.keySet().removeAll(TemplateImpl.INTERNAL_VARS_SET);
        return map;
    }
}

