/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PostfixTemplatesUtils {
    private PostfixTemplatesUtils() {
    }

    @Nullable
    public static TextRange surround(@NotNull Surrounder surrounder, @NotNull Editor editor, @NotNull PsiElement expr) {
        if (surrounder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surrounder", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplatesUtils", "surround"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplatesUtils", "surround"));
        }
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplatesUtils", "surround"));
        }
        Project project2 = expr.getProject();
        PsiElement[] elements = new PsiElement[]{expr};
        if (surrounder.isApplicable(elements)) {
            return surrounder.surroundElements(project2, editor, elements);
        }
        PostfixTemplatesUtils.showErrorHint(project2, editor);
        return null;
    }

    public static void showErrorHint(@NotNull Project project2, @NotNull Editor editor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplatesUtils", "showErrorHint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplatesUtils", "showErrorHint"));
        }
        CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)"Can't expand postfix template", (String)"Can't expand postfix template", (String)"");
    }

    @NotNull
    public static String getLangForProvider(@NotNull PostfixTemplateProvider provider) {
        LanguageExtensionPoint[] extensions;
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplatesUtils", "getLangForProvider"));
        }
        for (LanguageExtensionPoint extension : extensions = (LanguageExtensionPoint[])new ExtensionPointName("com.intellij.codeInsight.template.postfixTemplateProvider").getExtensions()) {
            if (!provider.equals(extension.getInstance())) continue;
            String string = extension.getKey();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplatesUtils", "getLangForProvider"));
            }
            return string;
        }
        String string = Language.ANY.getID();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplatesUtils", "getLangForProvider"));
        }
        return string;
    }
}

