/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.unwrap.JavaAnonymousUnwrapper;
import com.intellij.codeInsight.unwrap.JavaUnwrapper;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import java.util.List;

public class JavaLambdaUnwrapper
extends JavaUnwrapper {
    public JavaLambdaUnwrapper() {
        super(CodeInsightBundle.message((String)"unwrap.lambda", (Object[])new Object[0]));
    }

    @Override
    public boolean isApplicableTo(PsiElement e) {
        return e instanceof PsiLambdaExpression;
    }

    @Override
    public PsiElement collectAffectedElements(PsiElement e, List<PsiElement> toExtract) {
        super.collectAffectedElements(e, toExtract);
        return JavaAnonymousUnwrapper.findElementToExtractFrom(e);
    }

    @Override
    protected void doUnwrap(PsiElement element, JavaUnwrapper.Context context) throws IncorrectOperationException {
        List returnExpressions;
        PsiElement from = JavaAnonymousUnwrapper.findElementToExtractFrom(element);
        PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)element;
        PsiElement body = lambdaExpression.getBody();
        if ((body instanceof PsiExpression || body instanceof PsiCodeBlock && ((PsiCodeBlock)body).getStatements().length == 1) && (returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)lambdaExpression)).size() == 1 && !PsiType.VOID.equals((Object)((PsiExpression)returnExpressions.get(0)).getType()) && JavaAnonymousUnwrapper.toAssignment(context, from, (PsiExpression)returnExpressions.get(0))) {
            return;
        }
        if (body instanceof PsiCodeBlock) {
            context.extractFromCodeBlock((PsiCodeBlock)body, from);
        } else {
            context.extractElement(body, from);
            if (context.myIsEffective) {
                PsiStatement emptyStatement = JavaPsiFacade.getElementFactory((Project)from.getProject()).createStatementFromText(";", from);
                from.getParent().addBefore((PsiElement)emptyStatement, from);
            }
        }
        context.deleteExactly(from);
    }
}

