/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.quickfix.SimplifyBooleanExpressionFix;
import com.intellij.codeInsight.intention.impl.AddNullableAnnotationFix;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ReplaceWithTernaryOperatorFix;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaOptionalSupport;
import com.intellij.codeInspection.dataFlow.NullabilityProblem;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BranchingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.nullable.NullableStuffInspectionBase;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.extractMethod.ExtractMethodUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataFlowInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.DataFlowInspection");
    @NonNls
    private static final String SHORT_NAME = "ConstantConditions";
    public boolean SUGGEST_NULLABLE_ANNOTATIONS;
    public boolean DONT_REPORT_TRUE_ASSERT_STATEMENTS;
    public boolean TREAT_UNKNOWN_MEMBERS_AS_NULLABLE;
    public boolean IGNORE_ASSERT_STATEMENTS;
    public boolean REPORT_CONSTANT_REFERENCE_VALUES = true;

    public JComponent createOptionsPanel() {
        throw new RuntimeException("no UI in headless mode");
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase", "writeSettings"));
        }
        node.addContent(new Element("option").setAttribute("name", "SUGGEST_NULLABLE_ANNOTATIONS").setAttribute("value", String.valueOf(this.SUGGEST_NULLABLE_ANNOTATIONS)));
        node.addContent(new Element("option").setAttribute("name", "DONT_REPORT_TRUE_ASSERT_STATEMENTS").setAttribute("value", String.valueOf(this.DONT_REPORT_TRUE_ASSERT_STATEMENTS)));
        if (this.IGNORE_ASSERT_STATEMENTS) {
            node.addContent(new Element("option").setAttribute("name", "IGNORE_ASSERT_STATEMENTS").setAttribute("value", "true"));
        }
        if (!this.REPORT_CONSTANT_REFERENCE_VALUES) {
            node.addContent(new Element("option").setAttribute("name", "REPORT_CONSTANT_REFERENCE_VALUES").setAttribute("value", "false"));
        }
        if (this.TREAT_UNKNOWN_MEMBERS_AS_NULLABLE) {
            node.addContent(new Element("option").setAttribute("name", "TREAT_UNKNOWN_MEMBERS_AS_NULLABLE").setAttribute("value", "true"));
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitField(PsiField field) {
                DataFlowInspectionBase.this.analyzeCodeBlock((PsiElement)field, holder, isOnTheFly);
            }

            public void visitMethod(PsiMethod method) {
                DataFlowInspectionBase.this.analyzeCodeBlock((PsiElement)method.getBody(), holder, isOnTheFly);
            }

            public void visitClassInitializer(PsiClassInitializer initializer) {
                DataFlowInspectionBase.this.analyzeCodeBlock((PsiElement)initializer.getBody(), holder, isOnTheFly);
            }

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                PsiType returnType;
                PsiType methodReturnType;
                super.visitMethodReferenceExpression(expression);
                PsiElement resolve2 = expression.resolve();
                if (resolve2 instanceof PsiMethod && TypeConversionUtil.isPrimitiveWrapper((PsiType)(methodReturnType = ((PsiMethod)resolve2).getReturnType())) && NullableNotNullManager.isNullable((PsiModifierListOwner)((PsiMethod)resolve2)) && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)(returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)expression)))) {
                    holder.registerProblem((PsiElement)expression, InspectionsBundle.message((String)"dataflow.message.unboxing.method.reference", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }

            public void visitIfStatement(PsiIfStatement statement2) {
                PsiExpression condition = statement2.getCondition();
                if (BranchingInstruction.isBoolConst((PsiElement)condition)) {
                    LocalQuickFix fix = DataFlowInspectionBase.createSimplifyBooleanExpressionFix((PsiElement)condition, condition.textMatches((CharSequence)"true"));
                    holder.registerProblem((PsiElement)condition, "Condition is always " + condition.getText(), new LocalQuickFix[]{fix});
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private void analyzeCodeBlock(@Nullable PsiElement scope, ProblemsHolder holder, final boolean onTheFly) {
        if (scope == null) {
            return;
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)scope, PsiClass.class);
        if (containingClass != null && PsiUtil.isLocalOrAnonymousClass((PsiClass)containingClass) && !(containingClass instanceof PsiEnumConstantInitializer)) {
            return;
        }
        StandardDataFlowRunner dfaRunner = new StandardDataFlowRunner(this.TREAT_UNKNOWN_MEMBERS_AS_NULLABLE, !DataFlowInspectionBase.isInsideConstructorOrInitializer(scope)){

            @Override
            protected boolean shouldCheckTimeLimit() {
                if (!onTheFly) {
                    return false;
                }
                return super.shouldCheckTimeLimit();
            }
        };
        this.analyzeDfaWithNestedClosures(scope, holder, dfaRunner, Arrays.asList(dfaRunner.createMemoryState()), onTheFly);
    }

    private static boolean isInsideConstructorOrInitializer(PsiElement element) {
        while (element != null) {
            if ((element = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiClassInitializer.class})) instanceof PsiClassInitializer) {
                return true;
            }
            if (!(element instanceof PsiMethod)) continue;
            if (((PsiMethod)element).isConstructor()) {
                return true;
            }
            PsiClass containingClass = ((PsiMethod)element).getContainingClass();
            return !InheritanceUtil.processSupers((PsiClass)containingClass, (boolean)true, psiClass -> !DataFlowInspectionBase.canCallMethodsInConstructors(psiClass, psiClass != containingClass));
        }
        return false;
    }

    private static boolean canCallMethodsInConstructors(PsiClass aClass, boolean virtual) {
        for (PsiMethod constructor : aClass.getConstructors()) {
            if (!constructor.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
                return true;
            }
            PsiCodeBlock body = constructor.getBody();
            if (body == null) continue;
            for (PsiMethodCallExpression call : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)body)).filter(PsiMethodCallExpression.class)) {
                PsiReferenceExpression methodExpression = call.getMethodExpression();
                if (methodExpression.textMatches((CharSequence)"this") || methodExpression.textMatches((CharSequence)"super")) continue;
                if (!virtual) {
                    return true;
                }
                PsiMethod target = call.resolveMethod();
                if (target == null || !PsiUtil.canBeOverriden((PsiMethod)target)) continue;
                return true;
            }
        }
        return false;
    }

    private void analyzeDfaWithNestedClosures(PsiElement scope, ProblemsHolder holder, StandardDataFlowRunner dfaRunner, Collection<DfaMemoryState> initialStates, boolean onTheFly) {
        PsiMethod method;
        PsiIdentifier name;
        DataFlowInstructionVisitor visitor = new DataFlowInstructionVisitor();
        RunnerResult rc = dfaRunner.analyzeMethod(scope, visitor, this.IGNORE_ASSERT_STATEMENTS, initialStates);
        if (rc == RunnerResult.OK) {
            this.createDescription(dfaRunner, holder, visitor, onTheFly, scope);
            MultiMap<PsiElement, DfaMemoryState> nestedClosures = dfaRunner.getNestedClosures();
            for (PsiElement closure : nestedClosures.keySet()) {
                this.analyzeDfaWithNestedClosures(closure, holder, dfaRunner, nestedClosures.get((Object)closure), onTheFly);
            }
        } else if (rc == RunnerResult.TOO_COMPLEX && scope.getParent() instanceof PsiMethod && (name = (method = (PsiMethod)scope.getParent()).getNameIdentifier()) != null) {
            holder.registerProblem((PsiElement)name, InspectionsBundle.message((String)"dataflow.too.complex", (Object[])new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
        }
    }

    @Nullable
    private LocalQuickFix[] createNPEFixes(PsiExpression qualifier, PsiExpression expression, boolean onTheFly) {
        if (qualifier == null || expression == null) {
            return null;
        }
        if (qualifier instanceof PsiMethodCallExpression) {
            return null;
        }
        try {
            SmartList fixes = new SmartList();
            if (DataFlowInspectionBase.isVolatileFieldReference(qualifier)) {
                ContainerUtil.addIfNotNull((Collection)fixes, (Object)this.createIntroduceVariableFix(qualifier));
            } else if (!(qualifier instanceof PsiLiteralExpression) || ((PsiLiteralExpression)qualifier).getValue() != null) {
                if (PsiUtil.getLanguageLevel((PsiElement)qualifier).isAtLeast(LanguageLevel.JDK_1_4)) {
                    Project project2 = qualifier.getProject();
                    PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
                    PsiBinaryExpression binary = (PsiBinaryExpression)elementFactory.createExpressionFromText("a != null", null);
                    binary.getLOperand().replace((PsiElement)qualifier);
                    ContainerUtil.addIfNotNull((Collection)fixes, (Object)this.createAssertFix(binary, expression));
                }
                this.addSurroundWithIfFix(qualifier, (List<LocalQuickFix>)fixes, onTheFly);
                if (ReplaceWithTernaryOperatorFix.isAvailable(qualifier, expression)) {
                    fixes.add(new ReplaceWithTernaryOperatorFix(qualifier));
                }
            }
            ContainerUtil.addIfNotNull((Collection)fixes, (Object)DfaOptionalSupport.registerReplaceOptionalOfWithOfNullableFix(qualifier));
            return fixes.isEmpty() ? null : fixes.toArray(new LocalQuickFix[fixes.size()]);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    protected LocalQuickFix createIntroduceVariableFix(PsiExpression expression) {
        return null;
    }

    private static boolean isVolatileFieldReference(PsiExpression qualifier) {
        PsiElement target = qualifier instanceof PsiReferenceExpression ? ((PsiReferenceExpression)qualifier).resolve() : null;
        return target instanceof PsiField && ((PsiField)target).hasModifierProperty("volatile");
    }

    protected LocalQuickFix createAssertFix(PsiBinaryExpression binary, PsiExpression expression) {
        return null;
    }

    protected void addSurroundWithIfFix(PsiExpression qualifier, List<LocalQuickFix> fixes, boolean onTheFly) {
    }

    private void createDescription(StandardDataFlowRunner runner, ProblemsHolder holder, DataFlowInstructionVisitor visitor, boolean onTheFly, PsiElement scope) {
        Pair<Set<Instruction>, Set<Instruction>> constConditions = runner.getConstConditionalExpressions();
        Set trueSet = (Set)constConditions.getFirst();
        Set falseSet = (Set)constConditions.getSecond();
        ArrayList allProblems = new ArrayList();
        allProblems.addAll(trueSet);
        allProblems.addAll(falseSet);
        allProblems.addAll(visitor.myCCEInstructions);
        allProblems.addAll(ContainerUtil.filter((Object[])runner.getInstructions(), instruction1 -> instruction1 instanceof InstanceofInstruction && visitor.isInstanceofRedundant((InstanceofInstruction)instruction1)));
        HashSet<PsiElement> reportedAnchors = new HashSet<PsiElement>();
        for (PsiElement element : visitor.getProblems(NullabilityProblem.callNPE)) {
            if (!reportedAnchors.add(element)) continue;
            this.reportCallMayProduceNpe(holder, (PsiMethodCallExpression)element, holder.isOnTheFly());
        }
        for (PsiElement element : visitor.getProblems(NullabilityProblem.fieldAccessNPE)) {
            if (!reportedAnchors.add(element)) continue;
            PsiElement parent = element.getParent();
            PsiElement fieldAccess = parent instanceof PsiArrayAccessExpression || parent instanceof PsiReferenceExpression ? parent : element;
            this.reportFieldAccessMayProduceNpe(holder, element, (PsiExpression)fieldAccess);
        }
        for (Instruction instruction : allProblems) {
            if (instruction instanceof TypeCastInstruction && reportedAnchors.add((PsiElement)((TypeCastInstruction)instruction).getCastExpression().getCastType())) {
                DataFlowInspectionBase.reportCastMayFail(holder, (TypeCastInstruction)instruction);
                continue;
            }
            if (!(instruction instanceof BranchingInstruction)) continue;
            this.handleBranchingInstruction(holder, visitor, trueSet, falseSet, reportedAnchors, (BranchingInstruction)instruction, onTheFly);
        }
        this.reportNullableArguments(visitor, holder, reportedAnchors);
        DataFlowInspectionBase.reportNullableAssignments(visitor, holder, reportedAnchors);
        DataFlowInspectionBase.reportUnboxedNullables(visitor, holder, reportedAnchors);
        this.reportNullableReturns(visitor, holder, reportedAnchors, scope);
        if (this.SUGGEST_NULLABLE_ANNOTATIONS) {
            this.reportNullableArgumentsPassedToNonAnnotated(visitor, holder, reportedAnchors);
        }
        DataFlowInspectionBase.reportOptionalOfNullableImprovements(holder, reportedAnchors, runner.getInstructions());
        if (this.REPORT_CONSTANT_REFERENCE_VALUES) {
            DataFlowInspectionBase.reportConstantReferenceValues(holder, visitor, reportedAnchors);
        }
    }

    private static void reportOptionalOfNullableImprovements(ProblemsHolder holder, Set<PsiElement> reportedAnchors, Instruction[] instructions) {
        for (Instruction instruction : instructions) {
            PsiExpression[] args;
            if (!(instruction instanceof MethodCallInstruction) || (args = ((MethodCallInstruction)instruction).getArgs()).length != 1) continue;
            PsiExpression expr = args[0];
            if (((MethodCallInstruction)instruction).isOptionalAlwaysNullProblem()) {
                if (!reportedAnchors.add((PsiElement)expr)) continue;
                holder.registerProblem((PsiElement)expr, "Passing <code>null</code> argument to <code>Optional</code>", new LocalQuickFix[]{DfaOptionalSupport.createReplaceOptionalOfNullableWithEmptyFix((PsiElement)expr)});
                continue;
            }
            if (!((MethodCallInstruction)instruction).isOptionalAlwaysNotNullProblem() || !reportedAnchors.add((PsiElement)expr)) continue;
            holder.registerProblem((PsiElement)expr, "Passing a non-null argument to <code>Optional</code>", new LocalQuickFix[]{DfaOptionalSupport.createReplaceOptionalOfNullableWithOfFix()});
        }
    }

    private static void reportConstantReferenceValues(ProblemsHolder holder, StandardInstructionVisitor visitor, Set<PsiElement> reportedAnchors) {
        for (Pair<PsiReferenceExpression, DfaConstValue> pair : visitor.getConstantReferenceValues()) {
            PsiReferenceExpression ref = (PsiReferenceExpression)pair.first;
            if (ref.getParent() instanceof PsiReferenceExpression || !reportedAnchors.add((PsiElement)ref)) continue;
            Object value = ((DfaConstValue)pair.second).getValue();
            PsiVariable constant = ((DfaConstValue)pair.second).getConstant();
            final String presentableName = constant != null ? constant.getName() : String.valueOf(value);
            final String exprText = String.valueOf(value);
            if (presentableName == null || exprText == null) continue;
            holder.registerProblem((PsiElement)ref, "Value <code>#ref</code> #loc is always '" + presentableName + "'", new LocalQuickFix[]{new LocalQuickFix(){

                @NotNull
                public String getName() {
                    String string = "Replace with '" + presentableName + "'";
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$3", "getName"));
                    }
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    if ("Replace with constant value" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$3", "getFamilyName"));
                    }
                    return "Replace with constant value";
                }

                public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$3", "applyFix"));
                    }
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$3", "applyFix"));
                    }
                    if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{descriptor.getPsiElement()})) {
                        return;
                    }
                    PsiElement problemElement = descriptor.getPsiElement();
                    if (problemElement == null) {
                        return;
                    }
                    PsiMethodCallExpression call = problemElement.getParent() instanceof PsiExpressionList && problemElement.getParent().getParent() instanceof PsiMethodCallExpression ? (PsiMethodCallExpression)problemElement.getParent().getParent() : null;
                    PsiMethod targetMethod = call == null ? null : call.resolveMethod();
                    JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
                    problemElement.replace((PsiElement)facade.getElementFactory().createExpressionFromText(exprText, null));
                    if (targetMethod != null) {
                        ExtractMethodUtil.addCastsToEnsureResolveTarget(targetMethod, call);
                    }
                }
            }});
        }
    }

    private void reportNullableArgumentsPassedToNonAnnotated(DataFlowInstructionVisitor visitor, ProblemsHolder holder, Set<PsiElement> reportedAnchors) {
        for (PsiElement expr : visitor.getProblems(NullabilityProblem.passingNullableArgumentToNonAnnotatedParameter)) {
            LocalQuickFix[] localQuickFixArray;
            PsiParameter[] parameters;
            PsiMethod psiMethod;
            PsiElement gParent;
            int idx;
            if (reportedAnchors.contains(expr)) continue;
            String text = DataFlowInspectionBase.isNullLiteralExpression(expr) ? "Passing <code>null</code> argument to non annotated parameter" : "Argument <code>#ref</code> #loc might be null but passed to non annotated parameter";
            Object[] fixes = this.createNPEFixes((PsiExpression)expr, (PsiExpression)expr, holder.isOnTheFly());
            PsiElement parent = expr.getParent();
            if (!(parent instanceof PsiExpressionList) || (idx = ArrayUtilRt.find((Object[])((PsiExpressionList)parent).getExpressions(), (Object)expr)) <= -1 || !((gParent = parent.getParent()) instanceof PsiCallExpression) || (psiMethod = ((PsiCallExpression)gParent).resolveMethod()) == null || !psiMethod.getManager().isInProject((PsiElement)psiMethod) || !AnnotationUtil.isAnnotatingApplicable((PsiElement)psiMethod) || idx >= (parameters = psiMethod.getParameterList().getParameters()).length) continue;
            AddNullableAnnotationFix addNullableAnnotationFix = new AddNullableAnnotationFix((PsiModifierListOwner)parameters[idx]);
            if (fixes == null) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = addNullableAnnotationFix;
            } else {
                localQuickFixArray = (LocalQuickFix[])ArrayUtil.append((Object[])fixes, (Object)((Object)addNullableAnnotationFix));
            }
            fixes = localQuickFixArray;
            holder.registerProblem(expr, text, (LocalQuickFix[])fixes);
            reportedAnchors.add(expr);
        }
    }

    private void reportCallMayProduceNpe(ProblemsHolder holder, PsiMethodCallExpression callExpression, boolean onTheFly) {
        PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
        LocalQuickFix[] fix = this.createNPEFixes(methodExpression.getQualifierExpression(), (PsiExpression)callExpression, onTheFly);
        PsiElement toHighlight = methodExpression.getReferenceNameElement();
        if (toHighlight == null) {
            toHighlight = methodExpression;
        }
        holder.registerProblem(toHighlight, InspectionsBundle.message((String)"dataflow.message.npe.method.invocation", (Object[])new Object[0]), fix);
    }

    private void reportFieldAccessMayProduceNpe(ProblemsHolder holder, PsiElement elementToAssert, PsiExpression expression) {
        if (expression instanceof PsiArrayAccessExpression) {
            LocalQuickFix[] fix = this.createNPEFixes((PsiExpression)elementToAssert, expression, holder.isOnTheFly());
            holder.registerProblem((PsiElement)expression, InspectionsBundle.message((String)"dataflow.message.npe.array.access", (Object[])new Object[0]), fix);
        } else {
            LocalQuickFix[] fix = this.createNPEFixes((PsiExpression)elementToAssert, expression, holder.isOnTheFly());
            assert (elementToAssert != null);
            holder.registerProblem(elementToAssert, InspectionsBundle.message((String)"dataflow.message.npe.field.access", (Object[])new Object[0]), fix);
        }
    }

    private static void reportCastMayFail(ProblemsHolder holder, TypeCastInstruction instruction) {
        PsiTypeCastExpression typeCast = instruction.getCastExpression();
        PsiExpression operand = typeCast.getOperand();
        PsiTypeElement castType = typeCast.getCastType();
        assert (castType != null);
        assert (operand != null);
        holder.registerProblem((PsiElement)castType, InspectionsBundle.message((String)"dataflow.message.cce", (Object[])new Object[]{operand.getText()}), new LocalQuickFix[0]);
    }

    private void handleBranchingInstruction(ProblemsHolder holder, StandardInstructionVisitor visitor, Set<Instruction> trueSet, Set<Instruction> falseSet, HashSet<PsiElement> reportedAnchors, BranchingInstruction instruction, boolean onTheFly) {
        PsiElement psiAnchor = instruction.getPsiAnchor();
        boolean underBinary = DataFlowInspectionBase.isAtRHSOfBooleanAnd(psiAnchor);
        if (instruction instanceof InstanceofInstruction && visitor.isInstanceofRedundant((InstanceofInstruction)instruction)) {
            if (visitor.canBeNull((BinopInstruction)instruction)) {
                holder.registerProblem(psiAnchor, InspectionsBundle.message((String)"dataflow.message.redundant.instanceof", (Object[])new Object[0]), new LocalQuickFix[]{new RedundantInstanceofFix()});
            } else {
                LocalQuickFix[] localQuickFixArray;
                LocalQuickFix localQuickFix = DataFlowInspectionBase.createSimplifyBooleanExpressionFix(psiAnchor, true);
                String string = InspectionsBundle.message((String)(underBinary ? "dataflow.message.constant.condition.when.reached" : "dataflow.message.constant.condition"), (Object[])new Object[]{Boolean.toString(true)});
                if (localQuickFix == null) {
                    localQuickFixArray = null;
                } else {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = localQuickFix;
                }
                holder.registerProblem(psiAnchor, string, localQuickFixArray);
            }
        } else if (psiAnchor instanceof PsiSwitchLabelStatement) {
            if (falseSet.contains(instruction)) {
                holder.registerProblem(psiAnchor, InspectionsBundle.message((String)"dataflow.message.unreachable.switch.label", (Object[])new Object[0]), new LocalQuickFix[0]);
            }
        } else if (psiAnchor != null && !reportedAnchors.contains(psiAnchor) && !DataFlowInspectionBase.isFlagCheck(psiAnchor)) {
            boolean evaluatesToTrue = trueSet.contains(instruction);
            PsiElement parent = psiAnchor.getParent();
            if (parent instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent).getLExpression() == psiAnchor) {
                holder.registerProblem(psiAnchor, InspectionsBundle.message((String)"dataflow.message.pointless.assignment.expression", (Object[])new Object[]{Boolean.toString(evaluatesToTrue)}), this.createConditionalAssignmentFixes(evaluatesToTrue, (PsiAssignmentExpression)parent, onTheFly));
            } else if (!this.skipReportingConstantCondition(visitor, psiAnchor, evaluatesToTrue)) {
                LocalQuickFix[] localQuickFixArray;
                LocalQuickFix fix = DataFlowInspectionBase.createSimplifyBooleanExpressionFix(psiAnchor, evaluatesToTrue);
                String message = InspectionsBundle.message((String)(underBinary ? "dataflow.message.constant.condition.when.reached" : "dataflow.message.constant.condition"), (Object[])new Object[]{Boolean.toString(evaluatesToTrue)});
                if (fix == null) {
                    localQuickFixArray = null;
                } else {
                    LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray3;
                    localQuickFixArray3[0] = fix;
                }
                holder.registerProblem(psiAnchor, message, localQuickFixArray);
            }
            reportedAnchors.add(psiAnchor);
        }
    }

    protected LocalQuickFix[] createConditionalAssignmentFixes(boolean evaluatesToTrue, PsiAssignmentExpression parent, boolean onTheFly) {
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private boolean skipReportingConstantCondition(StandardInstructionVisitor visitor, PsiElement psiAnchor, boolean evaluatesToTrue) {
        return this.DONT_REPORT_TRUE_ASSERT_STATEMENTS && DataFlowInspectionBase.isAssertionEffectively(psiAnchor, evaluatesToTrue) || visitor.silenceConstantCondition(psiAnchor);
    }

    private void reportNullableArguments(DataFlowInstructionVisitor visitor, ProblemsHolder holder, Set<PsiElement> reportedAnchors) {
        for (PsiElement expr : visitor.getProblems(NullabilityProblem.passingNullableToNotNullParameter)) {
            if (!reportedAnchors.add(expr)) continue;
            String text = DataFlowInspectionBase.isNullLiteralExpression(expr) ? InspectionsBundle.message((String)"dataflow.message.passing.null.argument", (Object[])new Object[0]) : InspectionsBundle.message((String)"dataflow.message.passing.nullable.argument", (Object[])new Object[0]);
            LocalQuickFix[] fixes = this.createNPEFixes((PsiExpression)expr, (PsiExpression)expr, holder.isOnTheFly());
            holder.registerProblem(expr, text, fixes);
        }
    }

    private static void reportNullableAssignments(DataFlowInstructionVisitor visitor, ProblemsHolder holder, Set<PsiElement> reportedAnchors) {
        for (PsiElement expr : visitor.getProblems(NullabilityProblem.assigningToNotNull)) {
            if (!reportedAnchors.add(expr)) continue;
            String text = DataFlowInspectionBase.isNullLiteralExpression(expr) ? InspectionsBundle.message((String)"dataflow.message.assigning.null", (Object[])new Object[0]) : InspectionsBundle.message((String)"dataflow.message.assigning.nullable", (Object[])new Object[0]);
            holder.registerProblem(expr, text, new LocalQuickFix[0]);
        }
    }

    private static void reportUnboxedNullables(DataFlowInstructionVisitor visitor, ProblemsHolder holder, Set<PsiElement> reportedAnchors) {
        for (PsiElement expr : visitor.getProblems(NullabilityProblem.unboxingNullable)) {
            if (!reportedAnchors.add(expr)) continue;
            holder.registerProblem(expr, InspectionsBundle.message((String)"dataflow.message.unboxing", (Object[])new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Nullable
    private static PsiMethod getScopeMethod(PsiElement block) {
        PsiElement parent = block.getParent();
        if (parent instanceof PsiMethod) {
            return (PsiMethod)parent;
        }
        if (parent instanceof PsiLambdaExpression) {
            return LambdaUtil.getFunctionalInterfaceMethod((PsiType)((PsiLambdaExpression)parent).getFunctionalInterfaceType());
        }
        return null;
    }

    private void reportNullableReturns(DataFlowInstructionVisitor visitor, ProblemsHolder holder, Set<PsiElement> reportedAnchors, @NotNull PsiElement block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase", "reportNullableReturns"));
        }
        PsiMethod method = DataFlowInspectionBase.getScopeMethod(block);
        if (method == null || NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)method, true)) {
            return;
        }
        boolean notNullRequired = NullableNotNullManager.isNotNull((PsiModifierListOwner)method);
        if (!notNullRequired && !this.SUGGEST_NULLABLE_ANNOTATIONS) {
            return;
        }
        PsiType returnType = method.getReturnType();
        if (block instanceof PsiExpression && block.getParent() instanceof PsiLambdaExpression && PsiType.VOID.equals((Object)returnType)) {
            return;
        }
        if (returnType == null || returnType.equalsToText("java.lang.Void")) {
            return;
        }
        for (PsiElement statement2 : visitor.getProblems(NullabilityProblem.nullableReturn)) {
            LocalQuickFix[] localQuickFixArray;
            String text;
            assert (statement2 instanceof PsiExpression);
            PsiExpression expr = (PsiExpression)statement2;
            if (!reportedAnchors.add((PsiElement)expr)) continue;
            if (notNullRequired) {
                String text2 = DataFlowInspectionBase.isNullLiteralExpression((PsiElement)expr) ? InspectionsBundle.message((String)"dataflow.message.return.null.from.notnull", (Object[])new Object[0]) : InspectionsBundle.message((String)"dataflow.message.return.nullable.from.notnull", (Object[])new Object[0]);
                holder.registerProblem((PsiElement)expr, text2, new LocalQuickFix[0]);
                continue;
            }
            if (!AnnotationUtil.isAnnotatingApplicable((PsiElement)statement2)) continue;
            NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)expr.getProject());
            String defaultNullable = manager.getDefaultNullable();
            String presentableNullable = StringUtil.getShortName((String)defaultNullable);
            String string = text = DataFlowInspectionBase.isNullLiteralExpression((PsiElement)expr) ? InspectionsBundle.message((String)"dataflow.message.return.null.from.notnullable", (Object[])new Object[]{presentableNullable}) : InspectionsBundle.message((String)"dataflow.message.return.nullable.from.notnullable", (Object[])new Object[]{presentableNullable});
            if (PsiTreeUtil.getParentOfType((PsiElement)expr, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class}) instanceof PsiLambdaExpression) {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            } else {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = new AnnotateMethodFix(defaultNullable, ArrayUtil.toStringArray((Collection)manager.getNotNulls())){

                    @Override
                    public int shouldAnnotateBaseMethod(PsiMethod method, PsiMethod superMethod, Project project2) {
                        return 1;
                    }
                };
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            holder.registerProblem((PsiElement)expr, text, fixes);
        }
    }

    private static boolean isAssertionEffectively(PsiElement psiAnchor, boolean evaluatesToTrue) {
        PsiElement parent = psiAnchor.getParent();
        if (parent instanceof PsiAssertStatement) {
            return evaluatesToTrue;
        }
        if (parent instanceof PsiIfStatement && psiAnchor == ((PsiIfStatement)parent).getCondition()) {
            PsiStatement[] statements;
            PsiStatement thenBranch = ((PsiIfStatement)parent).getThenBranch();
            if (thenBranch instanceof PsiThrowStatement) {
                return !evaluatesToTrue;
            }
            if (thenBranch instanceof PsiBlockStatement && (statements = ((PsiBlockStatement)thenBranch).getCodeBlock().getStatements()).length == 1 && statements[0] instanceof PsiThrowStatement) {
                return !evaluatesToTrue;
            }
        }
        return false;
    }

    private static boolean isAtRHSOfBooleanAnd(PsiElement expr) {
        PsiElement cur = expr;
        while (cur != null && !(cur instanceof PsiMember)) {
            PsiElement parent = cur.getParent();
            if (parent instanceof PsiBinaryExpression && cur == ((PsiBinaryExpression)parent).getROperand()) {
                return true;
            }
            cur = parent;
        }
        return false;
    }

    private static boolean isFlagCheck(PsiElement element) {
        PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
        if (!(statement2 instanceof PsiIfStatement)) {
            return false;
        }
        PsiExpression condition = ((PsiIfStatement)statement2).getCondition();
        if (!PsiTreeUtil.isAncestor((PsiElement)condition, (PsiElement)element, (boolean)false)) {
            return false;
        }
        if (DataFlowInspectionBase.isCompileTimeFlagReference((PsiElement)condition)) {
            return true;
        }
        Collection refs = PsiTreeUtil.findChildrenOfType((PsiElement)condition, PsiReferenceExpression.class);
        return ContainerUtil.or((Iterable)refs, ref -> DataFlowInspectionBase.isCompileTimeFlagReference((PsiElement)ref));
    }

    private static boolean isCompileTimeFlagReference(PsiElement element) {
        PsiElement resolved;
        PsiElement psiElement = resolved = element instanceof PsiReferenceExpression ? ((PsiReferenceExpression)element).resolve() : null;
        if (!(resolved instanceof PsiField)) {
            return false;
        }
        PsiField field = (PsiField)resolved;
        return field.hasModifierProperty("final") && field.hasModifierProperty("static") && PsiType.BOOLEAN.equals((Object)field.getType());
    }

    private static boolean isNullLiteralExpression(PsiElement expr) {
        if (expr instanceof PsiLiteralExpression) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)expr;
            return PsiType.NULL.equals((Object)literalExpression.getType());
        }
        return false;
    }

    @Nullable
    private static LocalQuickFix createSimplifyBooleanExpressionFix(PsiElement element, final boolean value) {
        SimplifyBooleanExpressionFix fix = DataFlowInspectionBase.createIntention(element, value);
        if (fix == null) {
            return null;
        }
        final String text = fix.getText();
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = text;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$5", "getName"));
                }
                return string;
            }

            public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$5", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$5", "applyFix"));
                }
                PsiElement psiElement = descriptor.getPsiElement();
                if (psiElement == null) {
                    return;
                }
                SimplifyBooleanExpressionFix fix = DataFlowInspectionBase.createIntention(psiElement, value);
                if (fix == null) {
                    return;
                }
                try {
                    LOG.assertTrue(psiElement.isValid());
                    fix.applyFix();
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }

            @NotNull
            public String getFamilyName() {
                String string = InspectionsBundle.message((String)"inspection.data.flow.simplify.boolean.expression.quickfix", (Object[])new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$5", "getFamilyName"));
                }
                return string;
            }
        };
    }

    @NotNull
    protected static LocalQuickFix createSimplifyToAssignmentFix() {
        LocalQuickFix localQuickFix = new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = InspectionsBundle.message((String)"inspection.data.flow.simplify.to.assignment.quickfix.name", (Object[])new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$6", "getName"));
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = InspectionsBundle.message((String)"inspection.data.flow.simplify.boolean.expression.quickfix", (Object[])new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$6", "getFamilyName"));
                }
                return string;
            }

            public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$6", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$6", "applyFix"));
                }
                PsiElement psiElement = descriptor.getPsiElement();
                if (psiElement == null) {
                    return;
                }
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiAssignmentExpression.class);
                if (assignmentExpression == null) {
                    return;
                }
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
                String lExpressionText = assignmentExpression.getLExpression().getText();
                PsiExpression rExpression = assignmentExpression.getRExpression();
                String rExpressionText = rExpression != null ? rExpression.getText() : "";
                assignmentExpression.replace((PsiElement)factory.createExpressionFromText(lExpressionText + " = " + rExpressionText, psiElement));
            }
        };
        if (localQuickFix == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase", "createSimplifyToAssignmentFix"));
        }
        return localQuickFix;
    }

    private static SimplifyBooleanExpressionFix createIntention(PsiElement element, boolean value) {
        if (!(element instanceof PsiExpression)) {
            return null;
        }
        if (PsiTreeUtil.findChildOfType((PsiElement)element, PsiAssignmentExpression.class) != null) {
            return null;
        }
        PsiExpression expression = (PsiExpression)element;
        while (element.getParent() instanceof PsiExpression) {
            element = element.getParent();
        }
        SimplifyBooleanExpressionFix fix = new SimplifyBooleanExpressionFix(expression, value);
        if (!fix.isAvailable() || SimplifyBooleanExpressionFix.canBeSimplified((PsiExpression)element)) {
            return null;
        }
        return fix;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.data.flow.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase", "getShortName"));
        }
        return SHORT_NAME;
    }

    private static class DataFlowInstructionVisitor
    extends StandardInstructionVisitor {
        private final MultiMap<NullabilityProblem, PsiElement> myProblems = new MultiMap();
        private final Map<Pair<NullabilityProblem, PsiElement>, StateInfo> myStateInfos = ContainerUtil.newHashMap();
        private final Set<Instruction> myCCEInstructions = ContainerUtil.newHashSet();

        private DataFlowInstructionVisitor() {
        }

        @Override
        protected void onInstructionProducesCCE(TypeCastInstruction instruction) {
            this.myCCEInstructions.add(instruction);
        }

        Collection<PsiElement> getProblems(NullabilityProblem kind) {
            return ContainerUtil.filter((Collection)this.myProblems.get((Object)kind), psiElement -> {
                StateInfo info = this.myStateInfos.get(Pair.create((Object)((Object)kind), (Object)psiElement));
                return info.normalNpe || info.ephemeralNpe && !info.normalOk;
            });
        }

        @Override
        protected boolean checkNotNullable(DfaMemoryState state, DfaValue value, NullabilityProblem problem, PsiElement anchor) {
            Pair key2;
            StateInfo info;
            boolean ok = super.checkNotNullable(state, value, problem, anchor);
            if (!ok && anchor != null) {
                this.myProblems.putValue((Object)problem, (Object)anchor);
            }
            if ((info = this.myStateInfos.get(key2 = Pair.create((Object)((Object)problem), (Object)anchor))) == null) {
                info = new StateInfo();
                this.myStateInfos.put((Pair<NullabilityProblem, PsiElement>)key2, info);
            }
            if (state.isEphemeral() && !ok) {
                info.ephemeralNpe = true;
            } else if (!state.isEphemeral()) {
                if (ok) {
                    info.normalOk = true;
                } else {
                    info.normalNpe = true;
                }
            }
            return ok;
        }

        private static class StateInfo {
            boolean ephemeralNpe;
            boolean normalNpe;
            boolean normalOk;

            private StateInfo() {
            }
        }
    }

    private static class RedundantInstanceofFix
    implements LocalQuickFix {
        private RedundantInstanceofFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.data.flow.redundant.instanceof.quickfix", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$RedundantInstanceofFix", "getName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$RedundantInstanceofFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$RedundantInstanceofFix", "applyFix"));
            }
            if (!FileModificationService.getInstance().preparePsiElementForWrite(descriptor.getPsiElement())) {
                return;
            }
            PsiElement psiElement = descriptor.getPsiElement();
            if (psiElement instanceof PsiInstanceOfExpression) {
                try {
                    PsiExpression compareToNull = JavaPsiFacade.getInstance((Project)psiElement.getProject()).getElementFactory().createExpressionFromText(((PsiInstanceOfExpression)psiElement).getOperand().getText() + " != null", psiElement.getParent());
                    psiElement.replace((PsiElement)compareToNull);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$RedundantInstanceofFix", "getFamilyName"));
            }
            return string;
        }
    }
}

