/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.intellij.compiler.server.BuilderMessageHandler;
import com.intellij.compiler.server.DelegatingMessageHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.api.RequestFuture;

@ChannelHandler.Sharable
class BuildMessageDispatcher
extends SimpleChannelInboundHandlerAdapter<CmdlineRemoteProto.Message> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.server.BuildMessageDispatcher");
    private static final AttributeKey<SessionData> SESSION_DATA = AttributeKey.valueOf((String)"BuildMessageDispatcher.sessionData");
    private final Map<UUID, SessionData> mySessionDescriptors = new ConcurrentHashMap<UUID, SessionData>(16, 0.75f, 1);
    private final Set<UUID> myCanceledSessions = ContainerUtil.newConcurrentSet();

    BuildMessageDispatcher() {
    }

    public void registerBuildMessageHandler(final @NotNull RequestFuture<? extends BuilderMessageHandler> future2, @Nullable CmdlineRemoteProto.Message.ControllerMessage params) {
        if (future2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "future", "com/intellij/compiler/server/BuildMessageDispatcher", "registerBuildMessageHandler"));
        }
        DelegatingMessageHandler wrappedHandler = new DelegatingMessageHandler(){

            @Override
            protected BuilderMessageHandler getDelegateHandler() {
                return (BuilderMessageHandler)future2.getMessageHandler();
            }

            @Override
            public void sessionTerminated(UUID sessionId) {
                try {
                    super.sessionTerminated(sessionId);
                }
                finally {
                    future2.setDone();
                }
            }
        };
        UUID sessionId = future2.getRequestID();
        this.mySessionDescriptors.put(sessionId, new SessionData(sessionId, wrappedHandler, params));
    }

    @Nullable
    public BuilderMessageHandler unregisterBuildMessageHandler(UUID sessionId) {
        this.myCanceledSessions.remove(sessionId);
        SessionData data = this.mySessionDescriptors.remove(sessionId);
        return data != null ? data.handler : null;
    }

    public void cancelSession(UUID sessionId) {
        Channel channel;
        if (this.myCanceledSessions.add(sessionId) && (channel = this.getConnectedChannel(sessionId)) != null) {
            channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)sessionId, (CmdlineRemoteProto.Message.ControllerMessage)CmdlineProtoUtil.createCancelCommand()));
        }
    }

    @Nullable
    public Channel getConnectedChannel(UUID sessionId) {
        Channel channel = this.getAssociatedChannel(sessionId);
        return channel != null && channel.isActive() ? channel : null;
    }

    @Nullable
    public Channel getAssociatedChannel(UUID sessionId) {
        SessionData data = this.mySessionDescriptors.get(sessionId);
        return data != null ? data.channel : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendBuildParameters(@NotNull UUID preloadedSessionId, @NotNull CmdlineRemoteProto.Message.ControllerMessage params) {
        if (preloadedSessionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preloadedSessionId", "com/intellij/compiler/server/BuildMessageDispatcher", "sendBuildParameters"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/compiler/server/BuildMessageDispatcher", "sendBuildParameters"));
        }
        boolean succeeded = false;
        SessionData sessionData = this.mySessionDescriptors.get(preloadedSessionId);
        if (sessionData != null) {
            SessionData sessionData2 = sessionData;
            synchronized (sessionData2) {
                if (sessionData.state == SessionData.State.WAITING_PARAMS) {
                    sessionData.state = SessionData.State.RUNNING;
                    Channel channel = sessionData.channel;
                    if (channel != null && channel.isActive()) {
                        sessionData.handler.buildStarted(preloadedSessionId);
                        channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)preloadedSessionId, (CmdlineRemoteProto.Message.ControllerMessage)params));
                        succeeded = true;
                    }
                } else if (sessionData.state == SessionData.State.INITIAL) {
                    sessionData.params = params;
                    succeeded = true;
                }
            }
        }
        return succeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void messageReceived(ChannelHandlerContext context, CmdlineRemoteProto.Message message) throws Exception {
        BuilderMessageHandler handler2;
        UUID sessionId;
        SessionData sessionData = (SessionData)context.channel().attr(SESSION_DATA).get();
        if (sessionData == null) {
            CmdlineRemoteProto.Message.UUID id = message.getSessionId();
            sessionId = new UUID(id.getMostSigBits(), id.getLeastSigBits());
            sessionData = this.mySessionDescriptors.get(sessionId);
            if (sessionData != null) {
                sessionData.channel = context.channel();
                context.channel().attr(SESSION_DATA).set((Object)sessionData);
            }
            if (this.myCanceledSessions.contains(sessionId)) {
                context.channel().writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)sessionId, (CmdlineRemoteProto.Message.ControllerMessage)CmdlineProtoUtil.createCancelCommand()));
            }
        } else {
            sessionId = sessionData.sessionId;
        }
        BuilderMessageHandler builderMessageHandler = handler2 = sessionData != null ? sessionData.handler : null;
        if (handler2 == null) {
            LOG.info("No message handler registered for session " + sessionId);
            return;
        }
        CmdlineRemoteProto.Message.Type messageType = message.getType();
        switch (messageType) {
            case FAILURE: {
                handler2.handleFailure(sessionId, message.getFailure());
                break;
            }
            case BUILDER_MESSAGE: {
                CmdlineRemoteProto.Message.BuilderMessage builderMessage = message.getBuilderMessage();
                CmdlineRemoteProto.Message.BuilderMessage.Type msgType = builderMessage.getType();
                if (msgType == CmdlineRemoteProto.Message.BuilderMessage.Type.PARAM_REQUEST) {
                    SessionData sessionData2 = sessionData;
                    synchronized (sessionData2) {
                        CmdlineRemoteProto.Message.ControllerMessage params = sessionData.params;
                        if (params != null) {
                            sessionData.state = SessionData.State.RUNNING;
                            handler2.buildStarted(sessionId);
                            sessionData.params = null;
                            context.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)sessionId, (CmdlineRemoteProto.Message.ControllerMessage)params));
                        } else if (sessionData.state == SessionData.State.INITIAL) {
                            sessionData.state = SessionData.State.WAITING_PARAMS;
                        } else {
                            this.cancelSession(sessionId);
                        }
                        break;
                    }
                }
                handler2.handleBuildMessage(context.channel(), sessionId, builderMessage);
                break;
            }
            default: {
                LOG.info("Unsupported message type " + messageType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext context) throws Exception {
        BuilderMessageHandler handler2;
        try {
            super.channelInactive(context);
        }
        catch (Throwable throwable) {
            BuilderMessageHandler handler3;
            SessionData sessionData = (SessionData)context.channel().attr(SESSION_DATA).get();
            if (sessionData != null && (handler3 = this.unregisterBuildMessageHandler(sessionData.sessionId)) != null) {
                handler3.sessionTerminated(sessionData.sessionId);
            }
            throw throwable;
        }
        SessionData sessionData = (SessionData)context.channel().attr(SESSION_DATA).get();
        if (sessionData != null && (handler2 = this.unregisterBuildMessageHandler(sessionData.sessionId)) != null) {
            handler2.sessionTerminated(sessionData.sessionId);
        }
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
        if (cause != null) {
            LOG.info(cause);
        }
    }

    private static final class SessionData {
        @NotNull
        final UUID sessionId;
        @NotNull
        final BuilderMessageHandler handler;
        volatile CmdlineRemoteProto.Message.ControllerMessage params;
        volatile Channel channel;
        State state;

        private SessionData(@NotNull UUID sessionId, @NotNull BuilderMessageHandler handler2, CmdlineRemoteProto.Message.ControllerMessage params) {
            if (sessionId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionId", "com/intellij/compiler/server/BuildMessageDispatcher$SessionData", "<init>"));
            }
            if (handler2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/compiler/server/BuildMessageDispatcher$SessionData", "<init>"));
            }
            this.state = State.INITIAL;
            this.sessionId = sessionId;
            this.handler = handler2;
            this.params = params;
        }

        static enum State {
            INITIAL,
            WAITING_PARAMS,
            RUNNING;

        }
    }
}

