/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.StateMapKt;
import com.intellij.openapi.util.JDOMUtil;
import gnu.trove.THashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B%\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rJ$\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00002\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\u0004J(\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\u00042\u0016\b\u0002\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r\u0018\u00010\u0015J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u0004J\u0006\u0010\u0019\u001a\u00020\u0017J\u0006\u0010\u001a\u001a\u00020\u0017J\u0011\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u001cJ\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u001eJ\b\u0010\u001f\u001a\u00020\u0004H\u0016R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/configurationStore/StateMap;", "", "names", "", "", "states", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "([Ljava/lang/String;Ljava/util/concurrent/atomic/AtomicReferenceArray;)V", "[Ljava/lang/String;", "archive", "", "key", "state", "Lorg/jdom/Element;", "compare", "newStates", "diffs", "", "get", "getElement", "newLiveStates", "", "getState", "", "hasState", "hasStates", "isEmpty", "keys", "()[Ljava/lang/String;", "toMutableMap", "", "toString", "Companion", "configuration-store-impl"})
public final class StateMap {
    private final String[] names;
    private final AtomicReferenceArray<Object> states;
    @NotNull
    private static final StateMap EMPTY;
    public static final Companion Companion;

    @NotNull
    public String toString() {
        String string;
        if (Intrinsics.areEqual((Object)this, (Object)Companion.getEMPTY())) {
            string = "EMPTY";
        } else {
            String string2 = this.states.toString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"states.toString()");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> toMutableMap() {
        int n;
        THashMap map = new THashMap(((Object[])this.names).length);
        IntRange intRange = ArraysKt.getIndices((Object[])this.names);
        int n2 = intRange.getFirst();
        if (n2 <= (n = intRange.getLast())) {
            while (true) {
                void i;
                map.put((Object)this.names[i], this.states.get((int)i));
                if (i == n) break;
                ++i;
            }
        }
        return (Map)map;
    }

    @NotNull
    public final String[] keys() {
        return this.names;
    }

    @Nullable
    public final Object get(@NotNull String key2) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        int index = Arrays.binarySearch(this.names, key2);
        return index < 0 ? null : this.states.get(index);
    }

    @Nullable
    public final Element getElement(@NotNull String key2, @Nullable Map<String, ? extends Element> newLiveStates) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        return StateMapKt.stateToElement(key2, this.get(key2), newLiveStates);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Element getElement$default(StateMap stateMap, String string, Map map, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getElement");
        }
        if ((n & 2) != 0) {
            map = null;
        }
        return stateMap.getElement(string, map);
    }

    public final boolean isEmpty() {
        Object[] objectArray = this.names;
        return objectArray.length == 0;
    }

    public final boolean hasState(@NotNull String key2) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        return this.get(key2) instanceof Element;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasStates() {
        int n;
        if (this.isEmpty()) {
            return false;
        }
        IntRange intRange = ArraysKt.getIndices((Object[])this.names);
        int n2 = intRange.getFirst();
        if (n2 <= (n = intRange.getLast())) {
            while (true) {
                void i;
                if (this.states.get((int)i) instanceof Element) {
                    return true;
                }
                if (i == n) break;
                ++i;
            }
        }
        return false;
    }

    public final void compare(@NotNull String key2, @NotNull StateMap newStates, @NotNull Set<String> diffs) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)newStates, (String)"newStates");
        Intrinsics.checkParameterIsNotNull(diffs, (String)"diffs");
        Object oldState = this.get(key2);
        Object newState = newStates.get(key2);
        if (oldState instanceof Element) {
            if (!JDOMUtil.areElementsEqual((Element)((Element)oldState), (Element)((Element)newState))) {
                diffs.add(key2);
            }
        } else {
            Object object = newState;
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Object object2 = oldState;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
            }
            if (StateMapKt.getNewByteIfDiffers(key2, object, (byte[])object2) != null) {
                diffs.add(key2);
            }
        }
    }

    @Nullable
    public final Element getState(@NotNull String key2, boolean archive) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        int index = Arrays.binarySearch(this.names, key2);
        if (index < 0) {
            return null;
        }
        Object object = this.states.get(index);
        if (!(object instanceof Element)) {
            object = null;
        }
        Element element = (Element)object;
        if (element == null) {
            return null;
        }
        Element state = element;
        if (!archive) {
            return state;
        }
        return this.states.compareAndSet(index, state, StateMapKt.archiveState(state).toByteArray()) ? state : this.getState(key2, true);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Element getState$default(StateMap stateMap, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getState");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return stateMap.getState(string, bl);
    }

    public final void archive(@NotNull String key2, @Nullable Element state) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        int index = Arrays.binarySearch(this.names, key2);
        if (index < 0) {
            return;
        }
        AtomicReferenceArray<Object> atomicReferenceArray = this.states;
        int n = index;
        Element element = state;
        if (element != null) {
            Element element2 = element;
            int n2 = n;
            AtomicReferenceArray<Object> atomicReferenceArray2 = atomicReferenceArray;
            Element it = element2;
            byte[] byArray2 = StateMapKt.archiveState(state).toByteArray();
            atomicReferenceArray = atomicReferenceArray2;
            n = n2;
            byArray = byArray2;
        } else {
            byArray = null;
        }
        atomicReferenceArray.set(n, byArray);
    }

    private StateMap(String[] names, AtomicReferenceArray<Object> states) {
        this.names = names;
        this.states = states;
    }

    static {
        StateMap stateMap;
        Companion = new Companion(null);
        StateMap stateMap2 = stateMap;
        StateMap stateMap3 = stateMap;
        Object[] objectArray = new String[0];
        stateMap2((String[])objectArray, new AtomicReferenceArray<Object>(0));
        EMPTY = stateMap3;
    }

    public /* synthetic */ StateMap(@NotNull String[] names, @NotNull AtomicReferenceArray states, DefaultConstructorMarker $constructor_marker) {
        this(names, states);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/configurationStore/StateMap$Companion;", "", "()V", "EMPTY", "Lcom/intellij/configurationStore/StateMap;", "getEMPTY", "()Lcom/intellij/configurationStore/StateMap;", "fromMap", "map", "", "", "configuration-store-impl"})
    public static final class Companion {
        @NotNull
        public final StateMap getEMPTY() {
            return EMPTY;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final StateMap fromMap(@NotNull Map<String, ? extends Object> map) {
            int n;
            Intrinsics.checkParameterIsNotNull(map, (String)"map");
            if (map.isEmpty()) {
                return this.getEMPTY();
            }
            Collection $receiver$iv = map.keySet();
            Collection collection = $receiver$iv;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv22 = collection;
            String[] stringArray = thisCollection$iv22.toArray(new String[thisCollection$iv22.size()]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] names = (String[])((Object[])stringArray);
            if (!(map instanceof TreeMap)) {
                Arrays.sort(names);
            }
            AtomicReferenceArray<Object> states = new AtomicReferenceArray<Object>(((Object[])names).length);
            IntRange intRange = ArraysKt.getIndices((Object[])names);
            int thisCollection$iv22 = intRange.getFirst();
            if (thisCollection$iv22 <= (n = intRange.getLast())) {
                while (true) {
                    void i;
                    states.set((int)i, map.get(names[i]));
                    if (i == n) break;
                    ++i;
                }
            }
            return new StateMap(names, states, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

