/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.codeinsight.RuntimeTypeEvaluator;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.DebuggerExpressionComboBox;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.util.concurrency.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultCodeFragmentFactory
extends CodeFragmentFactory {
    public static final Key<String> KEY = Key.create((String)"DefaultCodeFragmentFactory.KEY");

    public static DefaultCodeFragmentFactory getInstance() {
        return SingletonHolder.ourInstance;
    }

    public JavaCodeFragment createPresentationCodeFragment(TextWithImports item, PsiElement context, Project project2) {
        return this.createCodeFragment(item, context, project2);
    }

    public JavaCodeFragment createCodeFragment(TextWithImports item, PsiElement context, Project project2) {
        JavaCodeFragment fragment;
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)project2);
        String text = item.getText();
        if (CodeFragmentKind.EXPRESSION == item.getKind()) {
            String expressionText = StringUtil.endsWithChar((CharSequence)text, (char)';') ? text.substring(0, text.length() - 1) : text;
            fragment = factory.createExpressionCodeFragment(expressionText, context, null, true);
        } else {
            fragment = factory.createCodeBlockCodeFragment(text, context, true);
        }
        if (item.getImports().length() > 0) {
            fragment.addImportsFromString(item.getImports());
        }
        fragment.setVisibilityChecker(JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
        fragment.putUserData(KEY, (Object)"DebuggerComboBoxEditor.IS_DEBUGGER_EDITOR");
        fragment.putCopyableUserData(JavaCompletionUtil.DYNAMIC_TYPE_EVALUATOR, (expression, parameters) -> {
            if (!RuntimeTypeEvaluator.isSubtypeable(expression)) {
                return null;
            }
            if (parameters.getInvocationCount() <= 1 && JavaCompletionUtil.mayHaveSideEffects((PsiElement)expression)) {
                CompletionService service = CompletionService.getCompletionService();
                if (parameters.getInvocationCount() < 2) {
                    service.setAdvertisementText("Invoke completion once more to see runtime type variants");
                }
                return null;
            }
            DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(project2).getContext();
            DebuggerSession debuggerSession = debuggerContext.getDebuggerSession();
            if (debuggerSession != null && debuggerContext.getSuspendContext() != null) {
                final Semaphore semaphore = new Semaphore();
                semaphore.down();
                final AtomicReference nameRef = new AtomicReference();
                RuntimeTypeEvaluator worker = new RuntimeTypeEvaluator(null, (PsiElement)expression, debuggerContext, ProgressManager.getInstance().getProgressIndicator()){

                    @Override
                    protected void typeCalculationFinished(@Nullable PsiType type) {
                        nameRef.set(type);
                        semaphore.up();
                    }
                };
                debuggerSession.getProcess().getManagerThread().invoke(worker);
                for (int i = 0; i < 50; ++i) {
                    ProgressManager.checkCanceled();
                    if (semaphore.waitFor(20L)) break;
                }
                return (PsiType)nameRef.get();
            }
            return null;
        });
        return fragment;
    }

    public boolean isContextAccepted(PsiElement contextElement) {
        return true;
    }

    @NotNull
    public LanguageFileType getFileType() {
        LanguageFileType languageFileType = StdFileTypes.JAVA;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/evaluation/DefaultCodeFragmentFactory", "getFileType"));
        }
        return languageFileType;
    }

    public EvaluatorBuilder getEvaluatorBuilder() {
        return EvaluatorBuilderImpl.getInstance();
    }

    public static boolean isDebuggerFile(PsiFile file2) {
        return file2.getUserData(KEY) != null || file2.getUserData(DebuggerExpressionComboBox.KEY) != null;
    }

    private static final class SingletonHolder {
        public static final DefaultCodeFragmentFactory ourInstance = new DefaultCodeFragmentFactory();

        private SingletonHolder() {
        }
    }
}

