/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.debugger.ui.tree.render.PrimitiveRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.ByteType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharType;
import com.sun.jdi.CharValue;
import com.sun.jdi.IntegerType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongType;
import com.sun.jdi.LongValue;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HexRenderer
extends NodeRendererImpl {
    @NonNls
    public static final String UNIQUE_ID = "HexRenderer";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.HexRenderer");

    public HexRenderer() {
        this.setEnabled(false);
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    @NonNls
    public String getName() {
        return "Hex";
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public HexRenderer clone() {
        return (HexRenderer)super.clone();
    }

    @Override
    public String calcLabel(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener labelListener) {
        Value value = valueDescriptor.getValue();
        StringBuilder buf = new StringBuilder();
        if (value == null) {
            return "null";
        }
        if (value instanceof CharValue) {
            PrimitiveRenderer.appendCharValue((CharValue)value, buf);
            buf.append(' ');
            HexRenderer.appendHexValue((PrimitiveValue)value, buf);
            return buf.toString();
        }
        HexRenderer.appendHexValue((PrimitiveValue)value, buf);
        return buf.toString();
    }

    static void appendHexValue(@NotNull PrimitiveValue value, StringBuilder buf) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/debugger/ui/tree/render/HexRenderer", "appendHexValue"));
        }
        if (value instanceof CharValue) {
            long longValue = value.longValue();
            buf.append("0x").append(Long.toHexString(longValue).toUpperCase());
        } else if (value instanceof ByteValue) {
            String strValue = Integer.toHexString(value.byteValue()).toUpperCase();
            if (strValue.length() > 2) {
                strValue = strValue.substring(strValue.length() - 2);
            }
            buf.append("0x").append(strValue);
        } else if (value instanceof ShortValue) {
            String strValue = Integer.toHexString(value.shortValue()).toUpperCase();
            if (strValue.length() > 4) {
                strValue = strValue.substring(strValue.length() - 4);
            }
            buf.append("0x").append(strValue);
        } else if (value instanceof IntegerValue) {
            buf.append("0x").append(Integer.toHexString(value.intValue()).toUpperCase());
        } else if (value instanceof LongValue) {
            buf.append("0x").append(Long.toHexString(value.longValue()).toUpperCase());
        } else {
            LOG.assertTrue(false);
        }
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
    }

    @Override
    public boolean isApplicable(Type t) {
        if (t == null) {
            return false;
        }
        return t instanceof CharType || t instanceof ByteType || t instanceof ShortType || t instanceof IntegerType || t instanceof LongType;
    }

    public PsiExpression getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) {
        LOG.assertTrue(false);
        return null;
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        return false;
    }
}

