/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.model;

import com.intellij.designer.designSurface.ScalableComponent;
import com.intellij.designer.model.RadComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class RadVisualComponent
extends RadComponent {
    private Component myNativeComponent;
    private final Rectangle myBounds = new Rectangle();

    @Override
    public Rectangle getBounds() {
        return this.myBounds;
    }

    @Override
    public Rectangle getBounds(Component relativeTo) {
        return this.fromModel(relativeTo, this.getBounds());
    }

    @Override
    public Rectangle fromModel(@NotNull Component target, @NotNull Rectangle bounds) {
        ScalableComponent scalableComponent;
        double zoom;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/designer/model/RadVisualComponent", "fromModel"));
        }
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/designer/model/RadVisualComponent", "fromModel"));
        }
        if (target != this.myNativeComponent && this.myNativeComponent instanceof ScalableComponent && (zoom = (scalableComponent = (ScalableComponent)((Object)this.myNativeComponent)).getScale()) != 1.0) {
            bounds = new Rectangle(bounds);
            bounds.x = (int)((double)bounds.x * zoom);
            bounds.y = (int)((double)bounds.y * zoom);
            bounds.width = (int)((double)bounds.width * zoom);
            bounds.height = (int)((double)bounds.height * zoom);
        }
        return this.myNativeComponent == target ? new Rectangle(bounds) : SwingUtilities.convertRectangle(this.myNativeComponent, bounds, target);
    }

    @Override
    public Rectangle toModel(@NotNull Component source, @NotNull Rectangle rectangle) {
        ScalableComponent scalableComponent;
        double zoom;
        Rectangle bounds;
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/designer/model/RadVisualComponent", "toModel"));
        }
        if (rectangle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rectangle", "com/intellij/designer/model/RadVisualComponent", "toModel"));
        }
        Rectangle rectangle2 = bounds = this.myNativeComponent == source ? new Rectangle(rectangle) : SwingUtilities.convertRectangle(source, rectangle, this.myNativeComponent);
        if (this.myNativeComponent != source && this.myNativeComponent instanceof ScalableComponent && (zoom = (scalableComponent = (ScalableComponent)((Object)this.myNativeComponent)).getScale()) != 1.0) {
            bounds = new Rectangle(bounds);
            bounds.x = (int)((double)bounds.x / zoom);
            bounds.y = (int)((double)bounds.y / zoom);
            bounds.width = (int)((double)bounds.width / zoom);
            bounds.height = (int)((double)bounds.height / zoom);
        }
        return bounds;
    }

    @Override
    public Point fromModel(@NotNull Component target, @NotNull Point point) {
        ScalableComponent scalableComponent;
        double zoom;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/designer/model/RadVisualComponent", "fromModel"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/designer/model/RadVisualComponent", "fromModel"));
        }
        if (target != this.myNativeComponent && this.myNativeComponent instanceof ScalableComponent && (zoom = (scalableComponent = (ScalableComponent)((Object)this.myNativeComponent)).getScale()) != 1.0) {
            point = new Point(point);
            point.x = (int)((double)point.x * zoom);
            point.y = (int)((double)point.y * zoom);
        }
        return this.myNativeComponent == target ? new Point(point) : SwingUtilities.convertPoint(this.myNativeComponent, point, target);
    }

    @Override
    public Point toModel(@NotNull Component source, @NotNull Point point) {
        ScalableComponent scalableComponent;
        double zoom;
        Point p;
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/designer/model/RadVisualComponent", "toModel"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/designer/model/RadVisualComponent", "toModel"));
        }
        Point point2 = p = this.myNativeComponent == source ? new Point(point) : SwingUtilities.convertPoint(source, point, this.myNativeComponent);
        if (this.myNativeComponent != source && this.myNativeComponent instanceof ScalableComponent && (zoom = (scalableComponent = (ScalableComponent)((Object)this.myNativeComponent)).getScale()) != 1.0) {
            p = new Point(p);
            p.x = (int)((double)p.x / zoom);
            p.y = (int)((double)p.y / zoom);
        }
        return p;
    }

    @Override
    public Dimension fromModel(@NotNull Component target, @NotNull Dimension size) {
        ScalableComponent scalableComponent;
        double zoom;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/designer/model/RadVisualComponent", "fromModel"));
        }
        if (size == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "size", "com/intellij/designer/model/RadVisualComponent", "fromModel"));
        }
        size = new Dimension(size);
        if (target != this.myNativeComponent && this.myNativeComponent instanceof ScalableComponent && (zoom = (scalableComponent = (ScalableComponent)((Object)this.myNativeComponent)).getScale()) != 1.0) {
            size.width = (int)((double)size.width * zoom);
            size.height = (int)((double)size.height * zoom);
        }
        return size;
    }

    @Override
    public Dimension toModel(@NotNull Component source, @NotNull Dimension size) {
        ScalableComponent scalableComponent;
        double zoom;
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/designer/model/RadVisualComponent", "toModel"));
        }
        if (size == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "size", "com/intellij/designer/model/RadVisualComponent", "toModel"));
        }
        size = new Dimension(size);
        if (this.myNativeComponent != source && this.myNativeComponent instanceof ScalableComponent && (zoom = (scalableComponent = (ScalableComponent)((Object)this.myNativeComponent)).getScale()) != 1.0) {
            size.width = (int)((double)size.width / zoom);
            size.height = (int)((double)size.height / zoom);
        }
        return size;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.myBounds.setBounds(x, y, width, height);
    }

    @Override
    public Point convertPoint(Component relativeFrom, int x, int y) {
        ScalableComponent scalableComponent;
        double zoom;
        Point p;
        Point point = p = this.myNativeComponent == relativeFrom ? new Point(x, y) : SwingUtilities.convertPoint(relativeFrom, x, y, this.myNativeComponent);
        if (this.myNativeComponent != relativeFrom && this.myNativeComponent instanceof ScalableComponent && (zoom = (scalableComponent = (ScalableComponent)((Object)this.myNativeComponent)).getScale()) != 1.0) {
            p.x = (int)((double)p.x / zoom);
            p.y = (int)((double)p.y / zoom);
        }
        return p;
    }

    public Component getNativeComponent() {
        return this.myNativeComponent;
    }

    public void setNativeComponent(Component nativeComponent) {
        this.myNativeComponent = nativeComponent;
    }
}

