/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.testDiscovery.TestDiscoveryConfigurable;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestDiscoveryConfiguration
extends JavaTestConfigurationBase {
    private String myChangeList;
    private Pair<String, String> myPosition;
    protected JavaTestConfigurationBase myDelegate;

    public TestDiscoveryConfiguration(String name, @NotNull JavaRunConfigurationModule configurationModule, @NotNull ConfigurationFactory factory, JavaTestConfigurationBase delegate) {
        if (configurationModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationModule", "com/intellij/execution/testDiscovery/TestDiscoveryConfiguration", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/execution/testDiscovery/TestDiscoveryConfiguration", "<init>"));
        }
        super(name, configurationModule, factory);
        this.myDelegate = delegate;
    }

    @Override
    public void setVMParameters(String value) {
        this.myDelegate.setVMParameters(value);
    }

    @Override
    public String getVMParameters() {
        return this.myDelegate.getVMParameters();
    }

    @Override
    public boolean isAlternativeJrePathEnabled() {
        return this.myDelegate.isAlternativeJrePathEnabled();
    }

    @Override
    public void setAlternativeJrePathEnabled(boolean enabled) {
        this.myDelegate.setAlternativeJrePathEnabled(enabled);
    }

    @Override
    @Nullable
    public String getAlternativeJrePath() {
        return this.myDelegate.getAlternativeJrePath();
    }

    @Override
    public void setAlternativeJrePath(String path) {
        this.myDelegate.setAlternativeJrePath(path);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.myPosition == null && this.myChangeList != null && ChangeListManager.getInstance((Project)this.getProject()).findChangeList(this.myChangeList) == null) {
            throw new RuntimeConfigurationException("Change list " + this.myChangeList + " doesn't exist");
        }
        if (this.myPosition != null) {
            if (StringUtil.isEmptyOrSpaces((String)((String)this.myPosition.first))) {
                throw new RuntimeConfigurationException("No class specified");
            }
            if (StringUtil.isEmptyOrSpaces((String)((String)this.myPosition.second))) {
                throw new RuntimeConfigurationException("No method specified");
            }
        }
        JavaRunConfigurationExtensionManager.checkConfigurationIsValid((RunConfigurationBase)this);
    }

    public Collection<Module> getValidModules() {
        return Arrays.asList(ModuleManager.getInstance((Project)this.getProject()).getModules());
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), new TestDiscoveryConfigurable(this.getProject()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testDiscovery/TestDiscoveryConfiguration", "getConfigurationEditor"));
        }
        return settingsEditorGroup;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myDelegate.readExternal(element);
        super.readExternal(element);
        this.readModule(element);
        String classQName = element.getAttributeValue("class");
        String methodName = element.getAttributeValue("method");
        this.myPosition = classQName != null && methodName != null ? Pair.create((Object)classQName, (Object)methodName) : null;
        this.myChangeList = element.getAttributeValue("changeList");
        if ("All".equals(this.myChangeList)) {
            this.myChangeList = null;
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.myDelegate.writeExternal(element);
        super.writeExternal(element);
        this.writeModule(element);
        if (this.myPosition != null) {
            element.setAttribute("class", (String)this.myPosition.first);
            element.setAttribute("method", (String)this.myPosition.second);
        }
        element.setAttribute("changeList", this.myChangeList == null ? "All" : this.myChangeList);
    }

    @Override
    @Nullable
    public String getRunClass() {
        return null;
    }

    @Override
    @Nullable
    public String getPackage() {
        return "";
    }

    @Override
    public void setProgramParameters(@Nullable String value) {
        this.myDelegate.setProgramParameters(value);
    }

    @Override
    @Nullable
    public String getProgramParameters() {
        return this.myDelegate.getProgramParameters();
    }

    @Override
    public void setWorkingDirectory(@Nullable String value) {
        this.myDelegate.setWorkingDirectory(value);
    }

    @Override
    @Nullable
    public String getWorkingDirectory() {
        return this.myDelegate.getWorkingDirectory();
    }

    @Override
    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "com/intellij/execution/testDiscovery/TestDiscoveryConfiguration", "setEnvs"));
        }
        this.myDelegate.setEnvs(envs);
    }

    @Override
    @NotNull
    public Map<String, String> getEnvs() {
        Map map = this.myDelegate.getEnvs();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testDiscovery/TestDiscoveryConfiguration", "getEnvs"));
        }
        return map;
    }

    @Override
    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myDelegate.setPassParentEnvs(passParentEnvs);
    }

    @Override
    public boolean isPassParentEnvs() {
        return this.myDelegate.isPassParentEnvs();
    }

    @Override
    public SMTRunnerConsoleProperties createTestConsoleProperties(Executor executor) {
        return this.myDelegate.createTestConsoleProperties(executor);
    }

    public void setPosition(Pair<String, String> position) {
        this.myPosition = position;
    }

    public void setChangeList(String changeList) {
        this.myChangeList = changeList;
    }

    public Pair<String, String> getPosition() {
        return this.myPosition;
    }

    public String getChangeList() {
        return this.myChangeList;
    }
}

