/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.BitUtil;
import java.io.File;
import javax.swing.Icon;

public class ReopenProjectAction
extends AnAction
implements DumbAware {
    private final String myProjectPath;
    private final String myProjectName;

    public ReopenProjectAction(String projectPath, String projectName, String displayName) {
        this.myProjectPath = projectPath;
        this.myProjectName = projectName;
        Presentation presentation = this.getTemplatePresentation();
        String text = projectPath.equals(displayName) ? FileUtil.getLocationRelativeToUserHome((String)projectPath) : displayName;
        presentation.setText(text, false);
        presentation.setDescription(projectPath);
    }

    public void actionPerformed(AnActionEvent e) {
        IdeEventQueue.getInstance().getPopupManager().closeAllPopups();
        int modifiers = e.getModifiers();
        boolean forceOpenInNewFrame = BitUtil.isSet((int)modifiers, (int)2) || BitUtil.isSet((int)modifiers, (int)1) || e.getPlace() == "WelcomeScreen";
        Project project2 = e.getProject();
        if (!new File(this.myProjectPath).exists()) {
            if (Messages.showDialog((Project)project2, (String)("The path " + FileUtil.toSystemDependentName((String)this.myProjectPath) + " does not exist.\n" + "If it is on a removable or network drive, please make sure that the drive is connected."), (String)"Reopen Project", (String[])new String[]{"OK", "&Remove From List"}, (int)0, (Icon)Messages.getErrorIcon()) == 1) {
                RecentProjectsManager.getInstance().removePath(this.myProjectPath);
            }
            return;
        }
        RecentProjectsManagerBase.getInstanceEx().doOpenProject(this.myProjectPath, project2, forceOpenInNewFrame);
    }

    public String getProjectPath() {
        return this.myProjectPath;
    }

    public String getProjectName() {
        return this.myProjectName;
    }
}

