/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.macro.PromptingMacro;
import com.intellij.ide.macro.SecondQueueExpandMacro;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;

public class FilePromptMacro
extends PromptingMacro
implements SecondQueueExpandMacro {
    @Override
    public String getName() {
        return "FilePrompt";
    }

    @Override
    public String getDescription() {
        return "Shows a file chooser dialog";
    }

    @Override
    protected String promptUser(DataContext dataContext) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
        VirtualFile[] result2 = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project2, null);
        return result2.length == 1 ? FileUtil.toSystemDependentName((String)result2[0].getPath()) : null;
    }

    @Override
    public void cachePreview(DataContext dataContext) {
        this.myCachedPreview = IdeBundle.message((String)"macro.fileprompt.preview", (Object[])new Object[0]);
    }
}

