/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryContentHandler;
import com.intellij.idea.IdeaApplication;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryHelper {
    private static final Logger LOG = Logger.getInstance(RepositoryHelper.class);
    private static final String PLUGIN_LIST_FILE = "availables.xml";

    @NotNull
    public static List<String> getPluginHosts() {
        ArrayList hosts = ContainerUtil.newArrayList(UpdateSettings.getInstance().getPluginHosts());
        ContainerUtil.addIfNotNull((Collection)hosts, (Object)ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl());
        hosts.add(null);
        ArrayList arrayList = hosts;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/RepositoryHelper", "getPluginHosts"));
        }
        return arrayList;
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPluginsFromAllRepositories(@Nullable ProgressIndicator indicator) throws IOException {
        ArrayList<IdeaPluginDescriptor> result2 = new ArrayList<IdeaPluginDescriptor>();
        HashSet<String> addedPluginIds = new HashSet<String>();
        for (String host : RepositoryHelper.getPluginHosts()) {
            List<IdeaPluginDescriptor> plugins2 = RepositoryHelper.loadPlugins(host, indicator);
            for (IdeaPluginDescriptor plugin : plugins2) {
                if (!addedPluginIds.add(plugin.getPluginId().getIdString())) continue;
                result2.add(plugin);
            }
        }
        ArrayList<IdeaPluginDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/RepositoryHelper", "loadPluginsFromAllRepositories"));
        }
        return arrayList;
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable ProgressIndicator indicator) throws IOException {
        List<IdeaPluginDescriptor> list = RepositoryHelper.loadPlugins(null, indicator);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/RepositoryHelper", "loadPlugins"));
        }
        return list;
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable String repositoryUrl, @Nullable ProgressIndicator indicator) throws IOException {
        boolean forceHttps = repositoryUrl == null && IdeaApplication.isLoaded() && UpdateSettings.getInstance().canUseSecureConnection();
        List<IdeaPluginDescriptor> list = RepositoryHelper.loadPlugins(repositoryUrl, null, forceHttps, indicator);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/RepositoryHelper", "loadPlugins"));
        }
        return list;
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable String repositoryUrl, @Nullable BuildNumber buildnumber, @Nullable ProgressIndicator indicator) throws IOException {
        boolean forceHttps = repositoryUrl == null && IdeaApplication.isLoaded() && UpdateSettings.getInstance().canUseSecureConnection();
        List<IdeaPluginDescriptor> list = RepositoryHelper.loadPlugins(repositoryUrl, buildnumber, forceHttps, indicator);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/RepositoryHelper", "loadPlugins"));
        }
        return list;
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable String repositoryUrl, @Nullable BuildNumber buildnumber, boolean forceHttps, @Nullable ProgressIndicator indicator) throws IOException {
        List<IdeaPluginDescriptor> list = RepositoryHelper.loadPlugins(repositoryUrl, buildnumber, null, forceHttps, indicator);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/RepositoryHelper", "loadPlugins"));
        }
        return list;
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable String repositoryUrl, @Nullable BuildNumber buildnumber, @Nullable String channel, boolean forceHttps, final @Nullable ProgressIndicator indicator) throws IOException {
        String url;
        String host;
        File pluginListFile;
        try {
            URIBuilder uriBuilder;
            if (repositoryUrl == null) {
                uriBuilder = new URIBuilder(ApplicationInfoImpl.getShadowInstance().getPluginsListUrl());
                pluginListFile = new File(PathManager.getPluginsPath(), channel == null ? PLUGIN_LIST_FILE : channel + "_" + PLUGIN_LIST_FILE);
                if (pluginListFile.length() > 0L) {
                    uriBuilder.addParameter("crc32", RepositoryHelper.crc32(pluginListFile));
                }
            } else {
                uriBuilder = new URIBuilder(repositoryUrl);
                pluginListFile = null;
            }
            if (!"file".equals(uriBuilder.getScheme())) {
                uriBuilder.addParameter("build", buildnumber != null ? buildnumber.asString() : ApplicationInfoImpl.getShadowInstance().getApiVersion());
                if (channel != null) {
                    uriBuilder.addParameter("channel", channel);
                }
            }
            host = uriBuilder.getHost();
            url = uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        if (indicator != null) {
            indicator.setText2(IdeBundle.message((String)"progress.connecting.to.plugin.manager", (Object[])new Object[]{host}));
        }
        RequestBuilder request = HttpRequests.request((String)url).forceHttps(forceHttps);
        List<IdeaPluginDescriptor> list = RepositoryHelper.process(repositoryUrl, (List)request.connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<List<IdeaPluginDescriptor>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<IdeaPluginDescriptor> process(@NotNull HttpRequests.Request request) throws IOException {
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/ide/plugins/RepositoryHelper$1", "process"));
                }
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                URLConnection connection = request.getConnection();
                if (pluginListFile != null && pluginListFile.length() > 0L && connection instanceof HttpURLConnection && ((HttpURLConnection)connection).getResponseCode() == 304) {
                    return RepositoryHelper.loadPluginList(pluginListFile);
                }
                if (indicator != null) {
                    indicator.checkCanceled();
                    indicator.setText2(IdeBundle.message((String)"progress.downloading.list.of.plugins", (Object[])new Object[]{host}));
                }
                if (pluginListFile != null) {
                    String string = RepositoryHelper.PLUGIN_LIST_FILE;
                    synchronized (RepositoryHelper.PLUGIN_LIST_FILE) {
                        FileUtil.ensureExists((File)pluginListFile.getParentFile());
                        request.saveToFile(pluginListFile, indicator);
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return RepositoryHelper.loadPluginList(pluginListFile);
                    }
                }
                return RepositoryHelper.parsePluginList(request.getReader());
            }
        }));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/RepositoryHelper", "loadPlugins"));
        }
        return list;
    }

    private static String crc32(File file2) throws IOException {
        CRC32 crc32 = new CRC32();
        crc32.update(FileUtil.loadFileBytes((File)file2));
        int hash = (int)crc32.getValue();
        byte[] bytes = new byte[]{(byte)hash, (byte)(hash >> 8), (byte)(hash >> 16), (byte)(hash >> 24)};
        return StringUtil.toHexString((byte[])bytes);
    }

    @Nullable
    public static List<IdeaPluginDescriptor> loadCachedPlugins() throws IOException {
        File file2 = new File(PathManager.getPluginsPath(), PLUGIN_LIST_FILE);
        return file2.length() == 0L ? null : RepositoryHelper.loadPluginList(file2);
    }

    private static List<IdeaPluginDescriptor> loadPluginList(@NotNull File file2) throws IOException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/plugins/RepositoryHelper", "loadPluginList"));
        }
        return RepositoryHelper.parsePluginList(new InputStreamReader((InputStream)new FileInputStream(file2), CharsetToolkit.UTF8_CHARSET));
    }

    private static List<IdeaPluginDescriptor> parsePluginList(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/ide/plugins/RepositoryHelper", "parsePluginList"));
        }
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            RepositoryContentHandler handler2 = new RepositoryContentHandler();
            parser.parse(new InputSource(reader), (DefaultHandler)handler2);
            List<IdeaPluginDescriptor> list = handler2.getPluginsList();
            return list;
        }
        catch (RuntimeException | ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
        finally {
            reader.close();
        }
    }

    private static List<IdeaPluginDescriptor> process(@Nullable String repositoryUrl, List<IdeaPluginDescriptor> list) {
        Iterator<IdeaPluginDescriptor> i = list.iterator();
        while (i.hasNext()) {
            PluginNode node = (PluginNode)i.next();
            if (node.getPluginId() == null || repositoryUrl != null && node.getDownloadUrl() == null) {
                LOG.warn("Malformed plugin record (id:" + node.getPluginId() + " repository:" + repositoryUrl + ")");
                i.remove();
                continue;
            }
            if (repositoryUrl != null) {
                node.setRepositoryName(repositoryUrl);
            }
            if (node.getName() != null) continue;
            String url = node.getDownloadUrl();
            String name = FileUtil.getNameWithoutExtension((String)url.substring(url.lastIndexOf(47) + 1));
            node.setName(name);
        }
        return list;
    }
}

