/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.java.ClassInitializerTreeElement;
import com.intellij.ide.structureView.impl.java.JavaClassTreeElementBase;
import com.intellij.ide.structureView.impl.java.PsiFieldTreeElement;
import com.intellij.ide.structureView.impl.java.PsiMethodTreeElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaClassTreeElement
extends JavaClassTreeElementBase<PsiClass> {
    private final Set<PsiClass> myParents;

    public JavaClassTreeElement(PsiClass cls, boolean inherited, Set<PsiClass> parents) {
        super(inherited, cls);
        this.myParents = parents;
        this.myParents.add(cls);
    }

    @Override
    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        Collection<StructureViewTreeElement> collection = this.getClassChildren();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/JavaClassTreeElement", "getChildrenBase"));
        }
        return collection;
    }

    private Collection<StructureViewTreeElement> getClassChildren() {
        PsiClass aClass = (PsiClass)this.getElement();
        if (aClass == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<PsiElement> members = JavaClassTreeElement.getOwnChildren(aClass);
        ArrayList<StructureViewTreeElement> children2 = new ArrayList<StructureViewTreeElement>(members.size());
        for (PsiElement child : members) {
            if (!child.isValid()) continue;
            if (child instanceof PsiClass && !this.myParents.contains((PsiClass)child)) {
                children2.add(new JavaClassTreeElement((PsiClass)child, false, this.myParents));
                continue;
            }
            if (child instanceof PsiField) {
                children2.add(new PsiFieldTreeElement((PsiField)child, false));
                continue;
            }
            if (child instanceof PsiMethod) {
                children2.add(new PsiMethodTreeElement((PsiMethod)child, false));
                continue;
            }
            if (!(child instanceof PsiClassInitializer)) continue;
            children2.add(new ClassInitializerTreeElement((PsiClassInitializer)child));
        }
        return children2;
    }

    static LinkedHashSet<PsiElement> getOwnChildren(PsiClass aClass) {
        LinkedHashSet<PsiElement> members = new LinkedHashSet<PsiElement>();
        JavaClassTreeElement.addPhysicalElements((PsiElement[])aClass.getFields(), members);
        JavaClassTreeElement.addPhysicalElements((PsiElement[])aClass.getMethods(), members);
        JavaClassTreeElement.addPhysicalElements((PsiElement[])aClass.getInnerClasses(), members);
        JavaClassTreeElement.addPhysicalElements((PsiElement[])aClass.getInitializers(), members);
        return members;
    }

    private static void addPhysicalElements(PsiElement[] elements, LinkedHashSet<PsiElement> to) {
        for (PsiElement element : elements) {
            PsiElement mirror = PsiImplUtil.handleMirror(element);
            if (mirror instanceof LightElement) continue;
            to.add(mirror);
        }
    }

    public Set<PsiClass> getParents() {
        return this.myParents;
    }

    public String getPresentableText() {
        return ((PsiClass)this.getElement()).getName();
    }

    @Override
    public boolean isPublic() {
        return ((PsiClass)this.getElement()).getParent() instanceof PsiFile || super.isPublic();
    }
}

