/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.highlighter;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorHighlighterFactoryImpl
extends EditorHighlighterFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.highlighter.EditorHighlighterFactoryImpl");

    @NotNull
    public EditorHighlighter createEditorHighlighter(SyntaxHighlighter highlighter, @NotNull EditorColorsScheme colors) {
        if (colors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colors", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        if (highlighter == null) {
            highlighter = new PlainSyntaxHighlighter();
        }
        LexerEditorHighlighter lexerEditorHighlighter = new LexerEditorHighlighter(highlighter, colors);
        if (lexerEditorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        return lexerEditorHighlighter;
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(@NotNull FileType fileType, @NotNull EditorColorsScheme settings, Project project2) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        if (fileType instanceof LanguageFileType) {
            EditorHighlighter editorHighlighter = ((EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(fileType)).getEditorHighlighter(project2, fileType, null, settings);
            if (editorHighlighter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
            }
            return editorHighlighter;
        }
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fileType, (Project)project2, null);
        EditorHighlighter editorHighlighter = this.createEditorHighlighter(highlighter, settings);
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        return editorHighlighter;
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(Project project2, @NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        EditorHighlighter editorHighlighter = this.createEditorHighlighter(fileType, EditorColorsManager.getInstance().getGlobalScheme(), project2);
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        return editorHighlighter;
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(@NotNull VirtualFile vFile, @NotNull EditorColorsScheme settings, @Nullable Project project2) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        FileType fileType = vFile.getFileType();
        if (fileType instanceof LanguageFileType) {
            EditorHighlighter editorHighlighter;
            LanguageFileType substFileType = EditorHighlighterFactoryImpl.substituteFileType(((LanguageFileType)fileType).getLanguage(), vFile, project2);
            if (substFileType != null) {
                boolean isPlain;
                EditorHighlighterProvider provider = (EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType((FileType)substFileType);
                EditorHighlighter editorHighlighter2 = provider.getEditorHighlighter(project2, (FileType)substFileType, vFile, settings);
                boolean bl = isPlain = editorHighlighter2.getClass() == LexerEditorHighlighter.class && ((LexerEditorHighlighter)editorHighlighter2).isPlain();
                if (!isPlain) {
                    EditorHighlighter editorHighlighter3 = editorHighlighter2;
                    if (editorHighlighter3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
                    }
                    return editorHighlighter3;
                }
            }
            try {
                editorHighlighter = ((EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(fileType)).getEditorHighlighter(project2, fileType, vFile, settings);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            if (editorHighlighter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
            }
            return editorHighlighter;
        }
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fileType, (Project)project2, (VirtualFile)vFile);
        EditorHighlighter editorHighlighter = this.createEditorHighlighter(highlighter, settings);
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        return editorHighlighter;
    }

    @Nullable
    private static LanguageFileType substituteFileType(Language language, VirtualFile vFile, Project project2) {
        Language substLanguage;
        LanguageFileType fileType = null;
        if (vFile != null && project2 != null && (substLanguage = LanguageSubstitutors.INSTANCE.substituteLanguage(language, vFile, project2)) != language) {
            fileType = substLanguage.getAssociatedFileType();
        }
        return fileType;
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        EditorHighlighter editorHighlighter = this.createEditorHighlighter(file2, EditorColorsManager.getInstance().getGlobalScheme(), project2);
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        return editorHighlighter;
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(Project project2, @NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        EditorHighlighter editorHighlighter = this.createEditorHighlighter(EditorColorsManager.getInstance().getGlobalScheme(), fileName, project2);
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        return editorHighlighter;
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(@NotNull EditorColorsScheme settings, @NotNull String fileName, @Nullable Project project2) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        EditorHighlighter editorHighlighter = this.createEditorHighlighter((VirtualFile)new LightVirtualFile(fileName), settings, project2);
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        return editorHighlighter;
    }
}

