/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.HierarchicalFilePathComparator;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BeforeAfter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListsIndexes {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangeListsIndexes");
    private final TreeMap<FilePath, FileStatus> myFileToStatus;
    private final Map<FilePath, Pair<VcsKey, VcsRevisionNumber>> myFileToVcs;

    ChangeListsIndexes() {
        this.myFileToStatus = new TreeMap(HierarchicalFilePathComparator.SYSTEM_CASE_SENSITIVE);
        this.myFileToVcs = new HashMap<FilePath, Pair<VcsKey, VcsRevisionNumber>>();
    }

    ChangeListsIndexes(ChangeListsIndexes idx) {
        this.myFileToStatus = new TreeMap<FilePath, FileStatus>((SortedMap<FilePath, FileStatus>)idx.myFileToStatus);
        this.myFileToVcs = new HashMap<FilePath, Pair<VcsKey, VcsRevisionNumber>>(idx.myFileToVcs);
    }

    void add(FilePath file2, FileStatus status2, VcsKey key2, VcsRevisionNumber number) {
        this.myFileToStatus.put(file2, status2);
        this.myFileToVcs.put(file2, (Pair<VcsKey, VcsRevisionNumber>)Pair.create((Object)key2, (Object)number));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set status " + status2 + " for " + file2);
        }
    }

    void remove(FilePath file2) {
        this.myFileToStatus.remove(file2);
        this.myFileToVcs.remove(file2);
    }

    public FileStatus getStatus(VirtualFile file2) {
        return this.myFileToStatus.get(VcsUtil.getFilePath((VirtualFile)file2));
    }

    public FileStatus getStatus(@NotNull FilePath file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangeListsIndexes", "getStatus"));
        }
        return this.myFileToStatus.get(file2);
    }

    public void changeAdded(Change change, VcsKey key2) {
        this.addChangeToIdx(change, key2);
    }

    public void changeRemoved(Change change) {
        ContentRevision afterRevision = change.getAfterRevision();
        ContentRevision beforeRevision = change.getBeforeRevision();
        if (afterRevision != null) {
            this.remove(afterRevision.getFile());
        }
        if (beforeRevision != null) {
            this.remove(beforeRevision.getFile());
        }
    }

    public VcsKey getVcsFor(Change change) {
        VcsKey key2 = this.getVcsForRevision(change.getAfterRevision());
        if (key2 != null) {
            return key2;
        }
        return this.getVcsForRevision(change.getBeforeRevision());
    }

    @Nullable
    private VcsKey getVcsForRevision(ContentRevision revision) {
        if (revision != null) {
            FilePath fileKey = revision.getFile();
            Pair<VcsKey, VcsRevisionNumber> pair = this.myFileToVcs.get(fileKey);
            return pair == null ? null : (VcsKey)pair.getFirst();
        }
        return null;
    }

    private void addChangeToIdx(Change change, VcsKey key2) {
        ContentRevision afterRevision = change.getAfterRevision();
        ContentRevision beforeRevision = change.getBeforeRevision();
        if (afterRevision != null) {
            this.add(afterRevision.getFile(), change.getFileStatus(), key2, beforeRevision == null ? VcsRevisionNumber.NULL : beforeRevision.getRevisionNumber());
        }
        if (beforeRevision != null) {
            if (afterRevision != null) {
                if (!Comparing.equal((Object)beforeRevision.getFile(), (Object)afterRevision.getFile())) {
                    this.add(beforeRevision.getFile(), FileStatus.DELETED, key2, beforeRevision.getRevisionNumber());
                }
            } else {
                this.add(beforeRevision.getFile(), change.getFileStatus(), key2, beforeRevision.getRevisionNumber());
            }
        }
    }

    public void getDelta(ChangeListsIndexes newIndexes, Set<BaseRevision> toRemove, Set<BaseRevision> toAdd, Set<BeforeAfter<BaseRevision>> toModify) {
        Pair<VcsKey, VcsRevisionNumber> pair;
        HashSet oldKeySet = ContainerUtil.newHashSet(this.myFileToVcs.keySet());
        HashSet toRemoveSet = ContainerUtil.newHashSet((Iterable)oldKeySet);
        Set<FilePath> newKeySet = newIndexes.myFileToVcs.keySet();
        HashSet toAddSet = ContainerUtil.newHashSet(newKeySet);
        toRemoveSet.removeAll(newKeySet);
        toAddSet.removeAll(oldKeySet);
        oldKeySet.removeAll(toRemoveSet);
        for (FilePath s : toRemoveSet) {
            pair = this.myFileToVcs.get(s);
            toRemove.add(ChangeListsIndexes.fromPairAndPath(s, pair));
        }
        for (FilePath s : toAddSet) {
            pair = newIndexes.myFileToVcs.get(s);
            toAdd.add(ChangeListsIndexes.fromPairAndPath(s, pair));
        }
        for (FilePath s : oldKeySet) {
            Pair<VcsKey, VcsRevisionNumber> old = this.myFileToVcs.get(s);
            Pair<VcsKey, VcsRevisionNumber> newOne = newIndexes.myFileToVcs.get(s);
            assert (old != null && newOne != null);
            if (old.equals(newOne)) continue;
            toModify.add((BeforeAfter<BaseRevision>)new BeforeAfter((Object)ChangeListsIndexes.fromPairAndPath(s, old), (Object)ChangeListsIndexes.fromPairAndPath(s, newOne)));
        }
    }

    private static BaseRevision fromPairAndPath(FilePath s, Pair<VcsKey, VcsRevisionNumber> pair) {
        return new BaseRevision((VcsKey)pair.getFirst(), (VcsRevisionNumber)pair.getSecond(), s);
    }

    public List<BaseRevision> getAffectedFilesUnderVcs() {
        ArrayList<BaseRevision> result2 = new ArrayList<BaseRevision>();
        for (Map.Entry<FilePath, Pair<VcsKey, VcsRevisionNumber>> entry : this.myFileToVcs.entrySet()) {
            Pair<VcsKey, VcsRevisionNumber> value = entry.getValue();
            result2.add(ChangeListsIndexes.fromPairAndPath(entry.getKey(), value));
        }
        return result2;
    }

    @NotNull
    public NavigableSet<FilePath> getAffectedPaths() {
        NavigableSet navigableSet = Sets.unmodifiableNavigableSet(this.myFileToStatus.navigableKeySet());
        if (navigableSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListsIndexes", "getAffectedPaths"));
        }
        return navigableSet;
    }
}

