/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.SelectedFilesHelper;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveChangesToAnotherListAction
extends AnAction
implements DumbAware {
    public MoveChangesToAnotherListAction() {
        super(ActionsBundle.actionText((String)"ChangesView.Move"), ActionsBundle.actionDescription((String)"ChangesView.Move"), AllIcons.Actions.MoveToAnotherChangelist);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction", "update"));
        }
        boolean isEnabled = this.isEnabled(e);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setEnabledAndVisible(isEnabled);
        } else {
            e.getPresentation().setEnabled(isEnabled);
        }
    }

    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction", "isEnabled"));
        }
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 == null || !ProjectLevelVcsManager.getInstance((Project)project2).hasActiveVcss()) {
            return false;
        }
        return !ContainerUtil.isEmpty((Collection)((Collection)e.getData(ChangesListView.UNVERSIONED_FILES_DATA_KEY))) || SelectedFilesHelper.hasChangedOrUnversionedFiles(project2, e) || !ArrayUtil.isEmpty((Object[])((Object[])e.getData(VcsDataKeys.CHANGES))) || !ArrayUtil.isEmpty((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)));
    }

    @NotNull
    private static List<Change> getChangesForSelectedFiles(@NotNull Project project2, @NotNull VirtualFile[] selectedFiles, @NotNull List<VirtualFile> unversionedFiles, @NotNull List<VirtualFile> changedFiles) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction", "getChangesForSelectedFiles"));
        }
        if (selectedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFiles", "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction", "getChangesForSelectedFiles"));
        }
        if (unversionedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unversionedFiles", "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction", "getChangesForSelectedFiles"));
        }
        if (changedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedFiles", "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction", "getChangesForSelectedFiles"));
        }
        ArrayList<Change> changes = new ArrayList<Change>();
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project2);
        for (VirtualFile vFile : selectedFiles) {
            Change change = changeListManager.getChange(vFile);
            if (change == null) {
                FileStatus status2 = changeListManager.getStatus(vFile);
                if (FileStatus.UNKNOWN.equals(status2)) {
                    unversionedFiles.add(vFile);
                    changedFiles.add(vFile);
                    continue;
                }
                if (!FileStatus.NOT_CHANGED.equals(status2) || !vFile.isDirectory()) continue;
                MoveChangesToAnotherListAction.addAllChangesUnderPath(changeListManager, VcsUtil.getFilePath((VirtualFile)vFile), changes, changedFiles);
                continue;
            }
            FilePath afterPath = ChangesUtil.getAfterPath((Change)change);
            if (afterPath != null && afterPath.isDirectory()) {
                MoveChangesToAnotherListAction.addAllChangesUnderPath(changeListManager, afterPath, changes, changedFiles);
                continue;
            }
            changes.add(change);
            changedFiles.add(vFile);
        }
        ArrayList<Change> arrayList = changes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction", "getChangesForSelectedFiles"));
        }
        return arrayList;
    }

    private static void addAllChangesUnderPath(@NotNull ChangeListManager changeListManager, @NotNull FilePath file2, @NotNull List<Change> changes, @NotNull List<VirtualFile> changedFiles) {
        if (changeListManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeListManager", "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction", "addAllChangesUnderPath"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction", "addAllChangesUnderPath"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction", "addAllChangesUnderPath"));
        }
        if (changedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedFiles", "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction", "addAllChangesUnderPath"));
        }
        for (Change change : changeListManager.getChangesIn(file2)) {
            changes.add(change);
            FilePath path = ChangesUtil.getAfterPath((Change)change);
            if (path == null || path.getVirtualFile() == null) continue;
            changedFiles.add(path.getVirtualFile());
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction", "actionPerformed"));
        }
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ArrayList changesList = ContainerUtil.newArrayList();
        Object[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        if (changes != null) {
            ContainerUtil.addAll((Collection)changesList, (Object[])changes);
        }
        ArrayList unversionedFiles = ContainerUtil.newArrayList();
        ArrayList changedFiles = ContainerUtil.newArrayList();
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files != null) {
            changesList.addAll(MoveChangesToAnotherListAction.getChangesForSelectedFiles(project2, files, unversionedFiles, changedFiles));
        }
        if (changesList.isEmpty() && unversionedFiles.isEmpty()) {
            VcsBalloonProblemNotifier.showOverChangesView(project2, "Nothing is selected that can be moved", MessageType.INFO, new NamedRunnable[0]);
            return;
        }
        if (!MoveChangesToAnotherListAction.askAndMove(project2, changesList, unversionedFiles)) {
            return;
        }
        if (!changedFiles.isEmpty()) {
            MoveChangesToAnotherListAction.selectAndShowFile(project2, (VirtualFile)changedFiles.get(0));
        }
    }

    private static void selectAndShowFile(final @NotNull Project project2, final @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction", "selectAndShowFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction", "selectAndShowFile"));
        }
        ToolWindow window = ToolWindowManager.getInstance((Project)project2).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
        if (!window.isVisible()) {
            window.activate(new Runnable(){

                @Override
                public void run() {
                    ChangesViewManager.getInstance(project2).selectFile(file2);
                }
            });
        }
    }

    public static boolean askAndMove(@NotNull Project project2, @NotNull Collection<Change> changes, @NotNull List<VirtualFile> unversionedFiles) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction", "askAndMove"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction", "askAndMove"));
        }
        if (unversionedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unversionedFiles", "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction", "askAndMove"));
        }
        if (changes.isEmpty() && unversionedFiles.isEmpty()) {
            return false;
        }
        LocalChangeList targetList = MoveChangesToAnotherListAction.askTargetList(project2, changes);
        if (targetList != null) {
            ChangeListManagerImpl listManager = ChangeListManagerImpl.getInstanceImpl(project2);
            listManager.moveChangesTo(targetList, (Change[])ArrayUtil.toObjectArray(changes, Change.class));
            if (!unversionedFiles.isEmpty()) {
                listManager.addUnversionedFiles(targetList, unversionedFiles);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static LocalChangeList askTargetList(@NotNull Project project2, @NotNull Collection<Change> changes) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction", "askTargetList"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction", "askTargetList"));
        }
        ChangeListManagerImpl listManager = ChangeListManagerImpl.getInstanceImpl(project2);
        List<LocalChangeList> preferredLists = MoveChangesToAnotherListAction.getPreferredLists(listManager.getChangeListsCopy(), changes);
        List<LocalChangeList> listsForChooser = preferredLists.isEmpty() ? Collections.singletonList(listManager.getDefaultChangeList()) : preferredLists;
        ChangeListChooser chooser = new ChangeListChooser(project2, listsForChooser, MoveChangesToAnotherListAction.guessPreferredList(preferredLists), ActionsBundle.message((String)"action.ChangesView.Move.text", (Object[])new Object[0]), null);
        chooser.show();
        return chooser.getSelectedList();
    }

    @Nullable
    private static ChangeList guessPreferredList(@NotNull List<LocalChangeList> lists) {
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction", "guessPreferredList"));
        }
        LocalChangeList activeChangeList = (LocalChangeList)ContainerUtil.find(lists, LocalChangeList::isDefault);
        if (activeChangeList != null) {
            return activeChangeList;
        }
        LocalChangeList emptyList = (LocalChangeList)ContainerUtil.find(lists, list -> list.getChanges().isEmpty());
        return (ChangeList)ObjectUtils.chooseNotNull((Object)emptyList, (Object)ContainerUtil.getFirstItem(lists));
    }

    @NotNull
    private static List<LocalChangeList> getPreferredLists(@NotNull List<LocalChangeList> lists, @NotNull Collection<Change> changes) {
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction", "getPreferredLists"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction", "getPreferredLists"));
        }
        final HashSet changesSet = ContainerUtil.newHashSet(changes);
        List list = ContainerUtil.findAll(lists, (Condition)new Condition<LocalChangeList>(){

            public boolean value(@NotNull LocalChangeList list) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction$2", "value"));
                }
                return !ContainerUtil.intersects((Collection)changesSet, (Collection)list.getChanges());
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction", "getPreferredLists"));
        }
        return list;
    }
}

