/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.vcsUtil.RollbackUtil;
import java.util.Arrays;

public class RollbackDialogAction
extends AnAction
implements DumbAware {
    public RollbackDialogAction() {
        ActionUtil.copyFrom((AnAction)this, (String)"ChangesView.Revert");
    }

    public void actionPerformed(AnActionEvent e) {
        FileDocumentManager.getInstance().saveAllDocuments();
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        final ChangesBrowserBase browser = (ChangesBrowserBase)e.getData(ChangesBrowserBase.DATA_KEY);
        if (browser != null) {
            browser.setDataIsDirty(true);
        }
        RollbackChangesDialog.rollbackChanges(project2, Arrays.asList(changes), true, new Runnable(){

            @Override
            public void run() {
                if (browser != null) {
                    browser.rebuildList();
                    browser.setDataIsDirty(false);
                }
            }
        });
    }

    public void update(AnActionEvent e) {
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        boolean enabled = changes != null && project2 != null;
        e.getPresentation().setEnabled(enabled);
        if (enabled) {
            String operationName = RollbackUtil.getRollbackOperationName(project2);
            e.getPresentation().setText(operationName);
            e.getPresentation().setDescription(operationName + " selected changes");
        }
    }
}

