/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeList;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.DefaultTreeModel;

public class MoveChangesDialog
extends DialogWrapper {
    private final ChangesTreeList<Change> myTreeList;

    public MoveChangesDialog(final Project project2, Collection<Change> selected, final Set<ChangeList> changeLists, String title) {
        super(project2, true);
        this.setTitle(title);
        this.myTreeList = new ChangesTreeList<Change>(project2, selected, true, false, null, null){

            @Override
            protected DefaultTreeModel buildTreeModel(List<Change> changes, ChangeNodeDecorator changeNodeDecorator) {
                TreeModelBuilder builder = new TreeModelBuilder(project2, this.isShowFlatten());
                return builder.buildModel(new ArrayList(changeLists));
            }

            @Override
            protected List<Change> getSelectedObjects(ChangesBrowserNode<Change> node) {
                return node.getAllChangesUnder();
            }

            @Override
            protected Change getLeadSelectedObject(ChangesBrowserNode node) {
                Object o = node.getUserObject();
                if (o instanceof Change) {
                    return (Change)o;
                }
                return null;
            }

            public Dimension getPreferredSize() {
                return new Dimension(400, 200);
            }
        };
        ArrayList changes = new ArrayList();
        for (ChangeList list : changeLists) {
            changes.addAll(list.getChanges());
        }
        this.myTreeList.setChangesToDisplay(changes);
        this.init();
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)ScrollPaneFactory.createScrollPane(this.myTreeList), "Center");
        DefaultActionGroup actionGroup = new DefaultActionGroup(this.myTreeList.getTreeActions());
        panel.add((Component)ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actionGroup, true).getComponent(), "North");
        this.myTreeList.expandAll();
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTreeList;
    }

    public Collection<Change> getIncludedChanges() {
        return this.myTreeList.getIncludedChanges();
    }

    public boolean isOKActionEnabled() {
        return !this.getIncludedChanges().isEmpty();
    }
}

