/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;

public class UpToDateLineNumberProviderImpl
implements UpToDateLineNumberProvider {
    private final Document myDocument;
    private final LineStatusTrackerManagerI myLineStatusTrackerManagerI;

    public UpToDateLineNumberProviderImpl(Document document2, Project project2) {
        this.myDocument = document2;
        this.myLineStatusTrackerManagerI = LineStatusTrackerManager.getInstance(project2);
    }

    public boolean isRangeChanged(int start, int end) {
        LineStatusTracker tracker = this.myLineStatusTrackerManagerI.getLineStatusTracker(this.myDocument);
        if (tracker == null || !tracker.isOperational()) {
            return false;
        }
        return tracker.isRangeModified(start, end);
    }

    public boolean isLineChanged(int currentNumber) {
        LineStatusTracker tracker = this.myLineStatusTrackerManagerI.getLineStatusTracker(this.myDocument);
        if (tracker == null || !tracker.isOperational()) {
            return false;
        }
        return tracker.isLineModified(currentNumber);
    }

    public int getLineNumber(int currentNumber) {
        LineStatusTracker tracker = this.myLineStatusTrackerManagerI.getLineStatusTracker(this.myDocument);
        if (tracker == null || !tracker.isOperational()) {
            return currentNumber;
        }
        return tracker.transferLineToVcs(currentNumber, false);
    }
}

