/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcses;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcsesI;
import com.intellij.openapi.vcs.impl.projectlevelman.FileWatchRequestsManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewMappings {
    public static Comparator<VcsDirectoryMapping> MAPPINGS_COMPARATOR = new Comparator<VcsDirectoryMapping>(){

        @Override
        public int compare(@NotNull VcsDirectoryMapping o1, @NotNull VcsDirectoryMapping o2) {
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings$1", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings$1", "compare"));
            }
            return o1.getDirectory().compareTo(o2.getDirectory());
        }
    };
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.projectlevelman.NewMappings");
    private final Object myLock;
    private final Map<String, List<VcsDirectoryMapping>> myVcsToPaths;
    private AbstractVcs[] myActiveVcses;
    private VcsDirectoryMapping[] mySortedMappings;
    private FileWatchRequestsManager myFileWatchRequestsManager;
    private final DefaultVcsRootPolicy myDefaultVcsRootPolicy;
    private final MessageBus myMessageBus;
    private final ProjectLevelVcsManager myVcsManager;
    private final FileStatusManager myFileStatusManager;
    private final Project myProject;
    private boolean myActivated;

    public NewMappings(Project project2, MessageBus messageBus, ProjectLevelVcsManagerImpl vcsManager, FileStatusManager fileStatusManager) {
        this.myProject = project2;
        this.myMessageBus = messageBus;
        this.myVcsManager = vcsManager;
        this.myFileStatusManager = fileStatusManager;
        this.myLock = new Object();
        this.myVcsToPaths = new HashMap<String, List<VcsDirectoryMapping>>();
        this.myFileWatchRequestsManager = new FileWatchRequestsManager(this.myProject, this, LocalFileSystem.getInstance());
        this.myDefaultVcsRootPolicy = DefaultVcsRootPolicy.getInstance(project2);
        this.myActiveVcses = new AbstractVcs[0];
        if (!this.myProject.isDefault()) {
            ArrayList<VcsDirectoryMapping> listStr = new ArrayList<VcsDirectoryMapping>();
            VcsDirectoryMapping mapping = new VcsDirectoryMapping("", "");
            listStr.add(mapping);
            this.myVcsToPaths.put("", listStr);
            this.mySortedMappings = new VcsDirectoryMapping[]{mapping};
        } else {
            this.mySortedMappings = VcsDirectoryMapping.EMPTY_ARRAY;
        }
        this.myActivated = false;
        vcsManager.addInitializationRequest(VcsInitObject.MAPPINGS, (Runnable)new DumbAwareRunnable(){

            public void run() {
                if (!NewMappings.this.myProject.isDisposed()) {
                    NewMappings.this.activateActiveVcses();
                }
            }
        });
    }

    public void setFileWatchRequestsManager(FileWatchRequestsManager fileWatchRequestsManager) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myFileWatchRequestsManager = fileWatchRequestsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractVcs[] getActiveVcses() {
        Object object = this.myLock;
        synchronized (object) {
            AbstractVcs[] result2 = new AbstractVcs[this.myActiveVcses.length];
            System.arraycopy(this.myActiveVcses, 0, result2, 0, this.myActiveVcses.length);
            return result2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasActiveVcss() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myActiveVcses.length > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateActiveVcses() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myActivated) {
                return;
            }
            this.myActivated = true;
        }
        this.keepActiveVcs(EmptyRunnable.getInstance());
        this.mappingsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Modification
    public void setMapping(final String path, final String activeVcsName) {
        LOG.debug("setMapping path = '" + path + "' vcs = " + activeVcsName);
        final VcsDirectoryMapping newMapping = new VcsDirectoryMapping(path, activeVcsName);
        Object object = this.myLock;
        synchronized (object) {
            List<VcsDirectoryMapping> vcsDirectoryMappings;
            if (this.myVcsToPaths.containsKey(activeVcsName) && (vcsDirectoryMappings = this.myVcsToPaths.get(activeVcsName)) != null && vcsDirectoryMappings.contains(newMapping)) {
                return;
            }
        }
        final Ref switched = new Ref((Object)Boolean.FALSE);
        this.keepActiveVcs(new Runnable(){

            @Override
            public void run() {
                switched.set((Object)NewMappings.this.trySwitchVcs(path, activeVcsName));
                if (!((Boolean)switched.get()).booleanValue()) {
                    List newList = NewMappings.this.listForVcsFromMap(newMapping.getVcs());
                    newList.add(newMapping);
                    NewMappings.this.sortedMappingsByMap();
                }
            }
        });
        this.mappingsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keepActiveVcs(@NotNull Runnable runnable2) {
        MyVcsActivator activator;
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings", "keepActiveVcs"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myActivated) {
                runnable2.run();
                return;
            }
            HashSet<String> old = new HashSet<String>();
            for (AbstractVcs activeVcs : this.myActiveVcses) {
                old.add(activeVcs.getName());
            }
            activator = new MyVcsActivator(old);
            runnable2.run();
            this.restoreActiveVcses();
        }
        activator.activate(this.myVcsToPaths.keySet(), AllVcses.getInstance(this.myProject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreActiveVcses() {
        Object object = this.myLock;
        synchronized (object) {
            Set<String> set = this.myVcsToPaths.keySet();
            ArrayList<AbstractVcs> list = new ArrayList<AbstractVcs>(set.size());
            for (String s : set) {
                AbstractVcs vcs;
                if (s.trim().length() == 0 || (vcs = AllVcses.getInstance(this.myProject).getByName(s)) == null) continue;
                list.add(vcs);
            }
            this.myActiveVcses = list.toArray(new AbstractVcs[list.size()]);
        }
    }

    public void mappingsChanged() {
        if (this.myProject.isDisposed()) {
            return;
        }
        ((VcsListener)this.myMessageBus.syncPublisher(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED)).directoryMappingChanged();
        this.myFileStatusManager.fileStatusesChanged();
        this.myFileWatchRequestsManager.ping();
    }

    @Modification
    public void setDirectoryMappings(List<VcsDirectoryMapping> items) {
        LOG.debug("setDirectoryMappings, size: " + items.size());
        MySetMappingsPreProcessor setMappingsPreProcessor = new MySetMappingsPreProcessor(items);
        setMappingsPreProcessor.invoke();
        final List<VcsDirectoryMapping> itemsCopy = items.isEmpty() ? Collections.singletonList(new VcsDirectoryMapping("", "")) : items;
        this.keepActiveVcs(new Runnable(){

            @Override
            public void run() {
                NewMappings.this.myVcsToPaths.clear();
                for (VcsDirectoryMapping mapping : itemsCopy) {
                    NewMappings.this.listForVcsFromMap(mapping.getVcs()).add(mapping);
                }
                NewMappings.this.sortedMappingsByMap();
            }
        });
        this.mappingsChanged();
    }

    @Nullable
    public VcsDirectoryMapping getMappingFor(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        if (!file2.isInLocalFileSystem()) {
            return null;
        }
        return this.getMappingFor(file2, this.myDefaultVcsRootPolicy.getMatchContext(file2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VcsDirectoryMapping getMappingFor(VirtualFile file2, Object parentModule) {
        VcsDirectoryMapping[] mappings;
        if (parentModule == null && this.myVcsManager.isIgnored(file2)) {
            return null;
        }
        String path = file2.getPath();
        String systemIndependentPath = FileUtil.toSystemIndependentName((String)(file2.isDirectory() && !path.endsWith("/") ? path + "/" : path));
        Object object = this.myLock;
        synchronized (object) {
            mappings = this.mySortedMappings;
        }
        for (int i = mappings.length - 1; i >= 0; --i) {
            VcsDirectoryMapping mapping = mappings[i];
            if (!this.fileMatchesMapping(file2, parentModule, systemIndependentPath, mapping)) continue;
            return mapping;
        }
        return null;
    }

    @Nullable
    public String getVcsFor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings", "getVcsFor"));
        }
        VcsDirectoryMapping mapping = this.getMappingFor(file2);
        if (mapping == null) {
            return null;
        }
        return mapping.getVcs();
    }

    private boolean fileMatchesMapping(VirtualFile file2, Object matchContext, String systemIndependentPath, VcsDirectoryMapping mapping) {
        if (mapping.getDirectory().length() == 0) {
            return this.myDefaultVcsRootPolicy.matchesDefaultMapping(file2, matchContext);
        }
        return FileUtil.startsWith((String)systemIndependentPath, (String)mapping.systemIndependentPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<VirtualFile> getMappingsAsFilesUnderVcs(@NotNull AbstractVcs vcs) {
        ArrayList<VcsDirectoryMapping> mappings;
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings", "getMappingsAsFilesUnderVcs"));
        }
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        String vcsName = vcs.getName();
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            List<VcsDirectoryMapping> vcsMappings = this.myVcsToPaths.get(vcsName);
            if (vcsMappings == null) {
                ArrayList<VirtualFile> arrayList = result2;
                // MONITOREXIT @DISABLED, blocks:[2, 7] lbl10 : MonitorExitStatement: MONITOREXIT : var5_4
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings", "getMappingsAsFilesUnderVcs"));
                }
                return arrayList;
            }
            mappings = new ArrayList<VcsDirectoryMapping>(vcsMappings);
        }
        for (VcsDirectoryMapping mapping : mappings) {
            if (mapping.isDefaultMapping()) {
                this.myDefaultVcsRootPolicy.addDefaultVcsRoots(this, vcsName, result2);
                continue;
            }
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(mapping.getDirectory());
            if (file2 == null) continue;
            result2.add(file2);
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings", "getMappingsAsFilesUnderVcs"));
        }
        return arrayList;
    }

    @Modification
    public void disposeMe() {
        LOG.debug("dispose me");
        this.clearImpl();
    }

    @Modification
    public void clear() {
        LOG.debug("clear");
        this.clearImpl();
        this.mappingsChanged();
    }

    private void clearImpl() {
        if (this.myActiveVcses == null || this.myActiveVcses.length == 0) {
            return;
        }
        this.keepActiveVcs(new Runnable(){

            @Override
            public void run() {
                NewMappings.this.myVcsToPaths.clear();
                NewMappings.access$502(NewMappings.this, new AbstractVcs[0]);
                NewMappings.access$602(NewMappings.this, VcsDirectoryMapping.EMPTY_ARRAY);
            }
        });
        this.myFileWatchRequestsManager.ping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VcsDirectoryMapping> getDirectoryMappings() {
        Object object = this.myLock;
        synchronized (object) {
            return Arrays.asList(this.mySortedMappings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VcsDirectoryMapping> getDirectoryMappings(String vcsName) {
        Object object = this.myLock;
        synchronized (object) {
            List<VcsDirectoryMapping> mappings = this.myVcsToPaths.get(vcsName);
            return mappings == null ? new ArrayList<VcsDirectoryMapping>() : new ArrayList<VcsDirectoryMapping>(mappings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupMappings() {
        Object object = this.myLock;
        synchronized (object) {
            this.removeRedundantMappings();
        }
        this.myFileWatchRequestsManager.ping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String haveDefaultMapping() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.mySortedMappings.length == 0) {
                return null;
            }
            return this.mySortedMappings[0].isDefaultMapping() ? this.mySortedMappings[0].getVcs() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            return this.mySortedMappings.length == 0 || ContainerUtil.and((Object[])this.mySortedMappings, mapping -> mapping.getVcs().isEmpty());
        }
    }

    @Modification
    public void removeDirectoryMapping(final VcsDirectoryMapping mapping) {
        LOG.debug("remove mapping: " + mapping.getDirectory());
        this.keepActiveVcs(new Runnable(){

            @Override
            public void run() {
                if (NewMappings.this.removeVcsFromMap(mapping, mapping.getVcs())) {
                    NewMappings.this.sortedMappingsByMap();
                }
            }
        });
        this.mappingsChanged();
    }

    private void removeRedundantMappings() {
        final LocalFileSystem lfs = LocalFileSystem.getInstance();
        AllVcsesI allVcses = AllVcses.getInstance(this.myProject);
        Iterator<String> iterator = this.myVcsToPaths.keySet().iterator();
        while (iterator.hasNext()) {
            List filteredFiles;
            String vcsName = iterator.next();
            List<VcsDirectoryMapping> mappings = this.myVcsToPaths.get(vcsName);
            List<Pair<VirtualFile, VcsDirectoryMapping>> objects = ObjectsConvertor.convert(mappings, new Convertor<VcsDirectoryMapping, Pair<VirtualFile, VcsDirectoryMapping>>(){

                public Pair<VirtualFile, VcsDirectoryMapping> convert(VcsDirectoryMapping dm) {
                    VirtualFile vf = lfs.findFileByPath(dm.getDirectory());
                    if (vf == null) {
                        vf = lfs.refreshAndFindFileByPath(dm.getDirectory());
                    }
                    return vf == null ? null : Pair.create((Object)vf, (Object)dm);
                }
            }, ObjectsConvertor.NOT_NULL);
            Convertor<Pair<VirtualFile, VcsDirectoryMapping>, VirtualFile> fileConvertor = new Convertor<Pair<VirtualFile, VcsDirectoryMapping>, VirtualFile>(){

                public VirtualFile convert(Pair<VirtualFile, VcsDirectoryMapping> o) {
                    return (VirtualFile)o.getFirst();
                }
            };
            if (StringUtil.isEmptyOrSpaces((String)vcsName)) {
                filteredFiles = AbstractVcs.filterUniqueRootsDefault(objects, (Convertor)fileConvertor);
            } else {
                AbstractVcs vcs = allVcses.getByName(vcsName);
                if (vcs == null) {
                    VcsBalloonProblemNotifier.showOverChangesView(this.myProject, "VCS plugin not found for mapping to : '" + vcsName + "'", MessageType.ERROR, new NamedRunnable[0]);
                    continue;
                }
                filteredFiles = vcs.filterUniqueRoots(objects, (Convertor)fileConvertor);
            }
            List<VcsDirectoryMapping> filteredMappings = ObjectsConvertor.convert(filteredFiles, new Convertor<Pair<VirtualFile, VcsDirectoryMapping>, VcsDirectoryMapping>(){

                public VcsDirectoryMapping convert(Pair<VirtualFile, VcsDirectoryMapping> o) {
                    return (VcsDirectoryMapping)o.getSecond();
                }
            });
            mappings.removeAll(filteredMappings);
            if (filteredMappings.isEmpty()) {
                iterator.remove();
                continue;
            }
            mappings.clear();
            mappings.addAll(filteredMappings);
        }
        this.sortedMappingsByMap();
    }

    private boolean trySwitchVcs(String path, String activeVcsName) {
        String fixedPath = FileUtil.toSystemIndependentName((String)path);
        for (VcsDirectoryMapping mapping : this.mySortedMappings) {
            if (!mapping.systemIndependentPath().equals(fixedPath)) continue;
            String oldVcs = mapping.getVcs();
            if (!oldVcs.equals(activeVcsName)) {
                this.migrateVcs(activeVcsName, mapping, oldVcs);
            }
            return true;
        }
        return false;
    }

    private void sortedMappingsByMap() {
        ArrayList<VcsDirectoryMapping> list = new ArrayList<VcsDirectoryMapping>();
        for (List<VcsDirectoryMapping> mappingList : this.myVcsToPaths.values()) {
            list.addAll(mappingList);
        }
        this.mySortedMappings = list.toArray(new VcsDirectoryMapping[list.size()]);
        Arrays.sort(this.mySortedMappings, MAPPINGS_COMPARATOR);
    }

    private void migrateVcs(String activeVcsName, VcsDirectoryMapping mapping, String oldVcs) {
        mapping.setVcs(activeVcsName);
        this.removeVcsFromMap(mapping, oldVcs);
        List<VcsDirectoryMapping> newList = this.listForVcsFromMap(activeVcsName);
        newList.add(mapping);
    }

    private boolean removeVcsFromMap(VcsDirectoryMapping mapping, String oldVcs) {
        List<VcsDirectoryMapping> oldList = this.myVcsToPaths.get(oldVcs);
        if (oldList == null) {
            return false;
        }
        boolean result2 = oldList.remove(mapping);
        if (oldList.isEmpty()) {
            this.myVcsToPaths.remove(oldVcs);
        }
        return result2;
    }

    private List<VcsDirectoryMapping> listForVcsFromMap(String activeVcsName) {
        List<VcsDirectoryMapping> newList = this.myVcsToPaths.get(activeVcsName);
        if (newList == null) {
            newList = new ArrayList<VcsDirectoryMapping>();
            this.myVcsToPaths.put(activeVcsName, newList);
        }
        return newList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean haveActiveVcs(String name) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myVcsToPaths.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Modification
    public void beingUnregistered(final String name) {
        Object object = this.myLock;
        synchronized (object) {
            this.keepActiveVcs(new Runnable(){

                @Override
                public void run() {
                    NewMappings.this.myVcsToPaths.remove(name);
                    NewMappings.this.sortedMappingsByMap();
                }
            });
        }
        this.mappingsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VirtualFile> getDefaultRoots() {
        Object object = this.myLock;
        synchronized (object) {
            String defaultVcs = this.haveDefaultMapping();
            if (defaultVcs == null) {
                return Collections.emptyList();
            }
            ArrayList<VirtualFile> list = new ArrayList<VirtualFile>();
            this.myDefaultVcsRootPolicy.addDefaultVcsRoots(this, defaultVcs, list);
            if (StringUtil.isEmptyOrSpaces((String)defaultVcs)) {
                return AbstractVcs.filterUniqueRootsDefault(list, (Convertor)Convertor.SELF);
            }
            AbstractVcs vcs = AllVcses.getInstance(this.myProject).getByName(defaultVcs);
            if (vcs == null) {
                return AbstractVcs.filterUniqueRootsDefault(list, (Convertor)Convertor.SELF);
            }
            return vcs.filterUniqueRoots(list, (Convertor)Convertor.SELF);
        }
    }

    static /* synthetic */ AbstractVcs[] access$502(NewMappings x0, AbstractVcs[] x1) {
        x0.myActiveVcses = x1;
        return x1;
    }

    static /* synthetic */ VcsDirectoryMapping[] access$602(NewMappings x0, VcsDirectoryMapping[] x1) {
        x0.mySortedMappings = x1;
        return x1;
    }

    private static @interface Modification {
    }

    private static class MySetMappingsPreProcessor {
        private final List<VcsDirectoryMapping> myItems;
        private List<VcsDirectoryMapping> myItemsCopy;

        public MySetMappingsPreProcessor(List<VcsDirectoryMapping> items) {
            this.myItems = items;
        }

        public List<VcsDirectoryMapping> getItemsCopy() {
            return this.myItemsCopy;
        }

        public void invoke() {
            this.myItemsCopy = this.myItems.isEmpty() ? Collections.singletonList(new VcsDirectoryMapping("", "")) : this.myItems;
        }
    }

    private static class MyVcsActivator {
        private final Set<String> myOld;

        public MyVcsActivator(Set<String> old) {
            this.myOld = old;
        }

        public void activate(Set<String> newOne, AllVcsesI vcsesI) {
            AbstractVcs vcs;
            Set<String> toAdd = MyVcsActivator.notInBottom(newOne, this.myOld);
            Set<String> toRemove = MyVcsActivator.notInBottom(this.myOld, newOne);
            if (toAdd != null) {
                for (String s : toAdd) {
                    vcs = vcsesI.getByName(s);
                    if (vcs != null) {
                        try {
                            vcs.doActivate();
                        }
                        catch (VcsException vcsException) {}
                        continue;
                    }
                    LOG.info("Error: activating non existing vcs: " + s);
                }
            }
            if (toRemove != null) {
                for (String s : toRemove) {
                    vcs = vcsesI.getByName(s);
                    if (vcs != null) {
                        try {
                            vcs.doDeactivate();
                        }
                        catch (VcsException vcsException) {}
                        continue;
                    }
                    LOG.info("Error: removing non existing vcs: " + s);
                }
            }
        }

        @Nullable
        private static Set<String> notInBottom(Set<String> top, Set<String> bottom) {
            HashSet<String> notInBottom = null;
            for (String topItem : top) {
                if (topItem.trim().length() == 0 || bottom.contains(topItem)) continue;
                if (notInBottom == null) {
                    notInBottom = new HashSet<String>();
                }
                notInBottom.add(topItem);
            }
            return notInBottom;
        }
    }
}

